/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.weaving.jpa;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Path;
import org.eclipse.persistence.exceptions.StaticWeaveException;
import org.eclipse.persistence.logging.AbstractSessionLog;
import org.eclipse.persistence.tools.weaving.jpa.StaticWeaveProcessor;

public class StaticWeaveAntTask
extends Task {
    private String source;
    private String persistenceinfo;
    private String target;
    private Vector classPaths = new Vector();
    private int logLevel = 8;
    private Writer logWriter;

    public void setSource(String string) {
        this.source = string;
    }

    public void setTarget(String string) {
        this.target = string;
    }

    public void setLog(String string) throws IOException {
        try {
            this.logWriter = new FileWriter(string);
        }
        catch (Exception exception) {
            throw StaticWeaveException.openLoggingFileException(string, exception);
        }
    }

    public void setLogLevel(String string) {
        if (!(string.equalsIgnoreCase("OFF") || string.equalsIgnoreCase("SEVERE") || string.equalsIgnoreCase("WARNING") || string.equalsIgnoreCase("INFO") || string.equalsIgnoreCase("CONFIG") || string.equalsIgnoreCase("FINE") || string.equalsIgnoreCase("FINER") || string.equalsIgnoreCase("FINEST") || string.equalsIgnoreCase("ALL"))) {
            throw StaticWeaveException.illegalLoggingLevel(string);
        }
        this.logLevel = AbstractSessionLog.translateStringToLoggingLevel(string.toUpperCase());
    }

    public void setPersistenceinfo(String string) {
        this.persistenceinfo = string;
    }

    public void addClasspath(Path path) {
        this.classPaths.add(path);
    }

    private Vector getPathElement() {
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < this.classPaths.size(); ++i) {
            String[] stringArray;
            String string = ((Path)this.classPaths.get(i)).toString();
            if (string == null || (stringArray = string.split(File.pathSeparator)) == null) continue;
            for (int j = 0; j < stringArray.length; ++j) {
                vector.add(stringArray[j]);
            }
        }
        return vector;
    }

    private URL[] getURLs() {
        Vector vector = this.getPathElement();
        URL[] uRLArray = new URL[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            try {
                uRLArray[i] = new File((String)vector.get(i)).toURI().toURL();
                continue;
            }
            catch (MalformedURLException malformedURLException) {
                throw StaticWeaveException.exceptionPerformWeaving(malformedURLException, vector.get(i));
            }
        }
        return uRLArray;
    }

    public void execute() {
        this.verifyOptions();
        this.start();
    }

    private void verifyOptions() throws BuildException {
        if (this.source == null) {
            throw StaticWeaveException.missingSource();
        }
        if (this.target == null) {
            throw StaticWeaveException.missingTarget();
        }
    }

    private void start() {
        try {
            StaticWeaveProcessor staticWeaveProcessor = new StaticWeaveProcessor(this.source, this.target);
            URL[] uRLArray = this.getURLs();
            if (uRLArray != null) {
                URLClassLoader uRLClassLoader = new URLClassLoader(this.getURLs(), Thread.currentThread().getContextClassLoader());
                staticWeaveProcessor.setClassLoader(uRLClassLoader);
            }
            if (this.persistenceinfo != null) {
                staticWeaveProcessor.setPersistenceInfo(this.persistenceinfo);
            }
            if (this.logWriter != null) {
                staticWeaveProcessor.setLog(this.logWriter);
            }
            staticWeaveProcessor.setLogLevel(this.logLevel);
            staticWeaveProcessor.performWeaving();
        }
        catch (Exception exception) {
            AbstractSessionLog.getLog().logThrowable(7, exception);
            throw StaticWeaveException.exceptionPerformWeaving(exception, this.source);
        }
    }
}

