/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.internal.identitymaps.FullIdentityMap;
import org.eclipse.persistence.internal.identitymaps.HardCacheWeakIdentityMap;
import org.eclipse.persistence.internal.identitymaps.NoIdentityMap;
import org.eclipse.persistence.internal.identitymaps.SoftCacheWeakIdentityMap;
import org.eclipse.persistence.internal.identitymaps.SoftIdentityMap;
import org.eclipse.persistence.internal.identitymaps.WeakIdentityMap;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.converters.Converter;
import org.eclipse.persistence.mappings.converters.ObjectTypeConverter;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.mappings.XMLCompositeObjectMapping;
import org.eclipse.persistence.oxm.mappings.XMLDirectMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWModel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.TopLinkOptionSet;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWCacheExpiry;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWCachingPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWDescriptorCacheExpiry;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWMappingDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWProjectDefaultCacheExpiry;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWTransactionalPolicy;
import org.eclipse.persistence.tools.workbench.utility.ClassTools;
import org.eclipse.persistence.tools.workbench.utility.node.Node;

public final class MWDescriptorCachingPolicy
extends MWModel
implements MWCachingPolicy {
    private volatile MWCachingPolicy.CacheCoordinationOption cacheCoordination;
    private static TopLinkOptionSet cacheCoordinationOptions;
    private volatile MWCachingPolicy.CacheIsolationOption cacheIsolation;
    private static TopLinkOptionSet cacheIsolationOptions;
    private volatile CacheTypeHolder cacheTypeHolder;
    public static final String CACHE_TYPE_HOLDER_PROPERTY = "cacheTypeHolder";
    private static TopLinkOptionSet cacheTypeOptions;
    public static final String DESCRIPTOR_INHERITANCE_PROPERTY = "descriptorInheritance";
    private volatile MWCachingPolicy.ExistenceCheckingOption existenceChecking;
    private static TopLinkOptionSet existenceCheckingOptions;
    private volatile CacheSizeHolder cacheSizeHolder;
    public static final String CACHE_SIZE_HOLDER_PROPERTY = "cacheSizeHolder";
    public static final String USE_PROJECT_DEFAULT_CACHE_SIZE_PROPERTY = "useProjectDefaultCacheSize";
    private volatile MWCacheExpiry cacheExpiry;
    public static final String CACHE_EXPIRY_PROPERTY = "cacheExpiry";
    public static final MWCachingPolicy.CacheTypeOption PROJECT_DEFAULT_CACHE_TYPE;

    public static synchronized TopLinkOptionSet cacheTypeOptions() {
        if (cacheTypeOptions == null) {
            ArrayList<MWCachingPolicy.CacheTypeOption> arrayList = new ArrayList<MWCachingPolicy.CacheTypeOption>();
            arrayList.add(PROJECT_DEFAULT_CACHE_TYPE);
            arrayList.add(new MWCachingPolicy.CacheTypeOption("Weak with Soft subcache", "CACHING_POLICY_CACHE_TYPE_WEAK_WITH_SOFT_SUBCACHE", SoftCacheWeakIdentityMap.class.getName()));
            arrayList.add(new MWCachingPolicy.CacheTypeOption("Weak with Hard Subcache", "CACHING_POLICY_CACHE_TYPE_WEAK_WITH_HARD_SUBCACHE", HardCacheWeakIdentityMap.class.getName()));
            arrayList.add(new MWCachingPolicy.CacheTypeOption("Weak", "CACHING_POLICY_CACHE_TYPE_WEAK", WeakIdentityMap.class.getName()));
            arrayList.add(new MWCachingPolicy.CacheTypeOption("Soft", "CACHING_POLICY_CACHE_TYPE_SOFT", SoftIdentityMap.class.getName()));
            arrayList.add(new MWCachingPolicy.CacheTypeOption("Full", "CACHING_POLICY_CACHE_TYPE_FULL", FullIdentityMap.class.getName()));
            arrayList.add(new MWCachingPolicy.CacheTypeOption("None", "CACHING_POLICY_CACHE_TYPE_NONE", NoIdentityMap.class.getName()));
            cacheTypeOptions = new TopLinkOptionSet(arrayList);
        }
        return cacheTypeOptions;
    }

    public static synchronized TopLinkOptionSet existenceCheckingOptions() {
        if (existenceCheckingOptions == null) {
            ArrayList<MWCachingPolicy.ExistenceCheckingOption> arrayList = new ArrayList<MWCachingPolicy.ExistenceCheckingOption>();
            arrayList.add(new MWCachingPolicy.ExistenceCheckingOption("DEFAULT", "CACHING_POLICY_DEFAULT_VALUE", 0));
            arrayList.add(new MWCachingPolicy.ExistenceCheckingOption("Check cache", "CACHING_POLICY_EXISTENCE_CHECKING_CHECK_CACHE", 3));
            arrayList.add(new MWCachingPolicy.ExistenceCheckingOption("Check database", "CACHING_POLICY_EXISTENCE_CHECKING_CHECK_DATABASE", 4));
            arrayList.add(new MWCachingPolicy.ExistenceCheckingOption("Assume existence", "CACHING_POLICY_EXISTENCE_CHECKING_ASSUME_EXISTENCE", 2));
            arrayList.add(new MWCachingPolicy.ExistenceCheckingOption("Assume non-existence", "CACHING_POLICY_EXISTENCE_CHECKING_ASSUME_NON_EXISTENCE", 1));
            existenceCheckingOptions = new TopLinkOptionSet(arrayList);
        }
        return existenceCheckingOptions;
    }

    public static synchronized TopLinkOptionSet cacheCoordinationOptions() {
        if (cacheCoordinationOptions == null) {
            ArrayList<MWCachingPolicy.CacheCoordinationOption> arrayList = new ArrayList<MWCachingPolicy.CacheCoordinationOption>();
            arrayList.add(new MWCachingPolicy.CacheCoordinationOption("DEFAULT", "CACHING_POLICY_DEFAULT_VALUE", 0));
            arrayList.add(new MWCachingPolicy.CacheCoordinationOption("None", "CACHING_POLICY_CACHE_COORDINATION_NONE", 4));
            arrayList.add(new MWCachingPolicy.CacheCoordinationOption("Synchronize Changes", "CACHING_POLICY_CACHE_COORDINATION_SYNCHRONIZE_CHANGES", 1));
            arrayList.add(new MWCachingPolicy.CacheCoordinationOption("Synchronize Changes and New Objects", "CACHING_POLICY_CACHE_COORDINATION_SYNCHRONIZE_CHANGES_AND_NEW_OBJECTS", 3));
            arrayList.add(new MWCachingPolicy.CacheCoordinationOption("Invalidate Changed Objects", "CACHING_POLICY_CACHE_COORDINATION_INVALIDATE_CHANGED_OBJECTS", 2));
            cacheCoordinationOptions = new TopLinkOptionSet(arrayList);
        }
        return cacheCoordinationOptions;
    }

    public static synchronized TopLinkOptionSet cacheIsolationOptions() {
        if (cacheIsolationOptions == null) {
            ArrayList<MWCachingPolicy.CacheIsolationOption> arrayList = new ArrayList<MWCachingPolicy.CacheIsolationOption>();
            arrayList.add(new MWCachingPolicy.CacheIsolationOption("DEFAULT", "CACHING_POLICY_DEFAULT_VALUE"));
            arrayList.add(new MWCachingPolicy.CacheIsolationOption("Isolated", "CACHING_POLICY_CACHE_ISOLATION_ISOLATED"));
            arrayList.add(new MWCachingPolicy.CacheIsolationOption("Shared", "CACHING_POLICY_CACHE_ISOLATION_SHARED"));
            cacheIsolationOptions = new TopLinkOptionSet(arrayList);
        }
        return cacheIsolationOptions;
    }

    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor xMLDescriptor = new XMLDescriptor();
        xMLDescriptor.setJavaClass(MWDescriptorCachingPolicy.class);
        XMLDirectMapping xMLDirectMapping = new XMLDirectMapping();
        xMLDirectMapping.setAttributeName(CACHE_SIZE_HOLDER_PROPERTY);
        xMLDirectMapping.setGetMethodName("getCacheSizeForTopLink");
        xMLDirectMapping.setSetMethodName("setCacheSizeForTopLink");
        xMLDirectMapping.setXPath("cache-size/text()");
        xMLDirectMapping.setNullValue((Object)new Integer(-1));
        xMLDescriptor.addMapping((DatabaseMapping)xMLDirectMapping);
        XMLDirectMapping xMLDirectMapping2 = (XMLDirectMapping)xMLDescriptor.addDirectMapping(CACHE_TYPE_HOLDER_PROPERTY, "getCacheTypeForTopLink", "setCacheTypeForTopLink", "cache-type/text()");
        ObjectTypeConverter objectTypeConverter = new ObjectTypeConverter();
        MWDescriptorCachingPolicy.cacheTypeOptions().addConversionValuesForTopLinkTo(objectTypeConverter);
        xMLDirectMapping2.setConverter((Converter)objectTypeConverter);
        xMLDirectMapping2.setNullValue((Object)MWDescriptorCachingPolicy.cacheTypeOptions().topLinkOptionForMWModelOption("DEFAULT"));
        ObjectTypeConverter objectTypeConverter2 = new ObjectTypeConverter();
        MWDescriptorCachingPolicy.existenceCheckingOptions().addConversionValuesForTopLinkTo(objectTypeConverter2);
        XMLDirectMapping xMLDirectMapping3 = new XMLDirectMapping();
        xMLDirectMapping3.setAttributeName("existenceChecking");
        xMLDirectMapping3.setXPath("existence-checking/text()");
        xMLDirectMapping3.setNullValue((Object)MWDescriptorCachingPolicy.existenceCheckingOptions().topLinkOptionForMWModelOption("DEFAULT"));
        xMLDirectMapping3.setConverter((Converter)objectTypeConverter2);
        xMLDescriptor.addMapping((DatabaseMapping)xMLDirectMapping3);
        ObjectTypeConverter objectTypeConverter3 = new ObjectTypeConverter();
        MWDescriptorCachingPolicy.cacheCoordinationOptions().addConversionValuesForTopLinkTo(objectTypeConverter3);
        XMLDirectMapping xMLDirectMapping4 = new XMLDirectMapping();
        xMLDirectMapping4.setAttributeName("cacheCoordination");
        xMLDirectMapping4.setXPath("cache-coordination/text()");
        xMLDirectMapping4.setConverter((Converter)objectTypeConverter3);
        xMLDirectMapping4.setNullValue((Object)MWDescriptorCachingPolicy.cacheCoordinationOptions().topLinkOptionForMWModelOption("DEFAULT"));
        xMLDescriptor.addMapping((DatabaseMapping)xMLDirectMapping4);
        ObjectTypeConverter objectTypeConverter4 = new ObjectTypeConverter();
        MWDescriptorCachingPolicy.cacheIsolationOptions().addConversionValuesForTopLinkTo(objectTypeConverter4);
        XMLDirectMapping xMLDirectMapping5 = new XMLDirectMapping();
        xMLDirectMapping5.setAttributeName("cacheIsolation");
        xMLDirectMapping5.setXPath("cache-isolation/text()");
        xMLDirectMapping5.setConverter((Converter)objectTypeConverter4);
        xMLDirectMapping5.setNullValue((Object)MWDescriptorCachingPolicy.cacheIsolationOptions().topLinkOptionForMWModelOption("DEFAULT"));
        xMLDescriptor.addMapping((DatabaseMapping)xMLDirectMapping5);
        XMLCompositeObjectMapping xMLCompositeObjectMapping = new XMLCompositeObjectMapping();
        xMLCompositeObjectMapping.setAttributeName(CACHE_EXPIRY_PROPERTY);
        xMLCompositeObjectMapping.setReferenceClass(MWDescriptorCacheExpiry.class);
        xMLCompositeObjectMapping.setGetMethodName("getCacheExpiryForTopLink");
        xMLCompositeObjectMapping.setSetMethodName("setCacheExpiryForTopLink");
        xMLCompositeObjectMapping.setXPath("cache-expiry");
        xMLDescriptor.addMapping((DatabaseMapping)xMLCompositeObjectMapping);
        return xMLDescriptor;
    }

    private MWDescriptorCachingPolicy() {
    }

    public MWDescriptorCachingPolicy(MWTransactionalPolicy mWTransactionalPolicy) {
        super(mWTransactionalPolicy);
    }

    protected void initialize() {
        super.initialize();
        this.cacheSizeHolder = new CacheSizeHolderImpl();
        this.cacheTypeHolder = new CacheTypeHolderImpl();
    }

    protected void initialize(Node node) {
        super.initialize(node);
        this.cacheCoordination = (MWCachingPolicy.CacheCoordinationOption)MWDescriptorCachingPolicy.cacheCoordinationOptions().topLinkOptionForMWModelOption("DEFAULT");
        this.cacheIsolation = (MWCachingPolicy.CacheIsolationOption)MWDescriptorCachingPolicy.cacheIsolationOptions().topLinkOptionForMWModelOption("DEFAULT");
        this.existenceChecking = (MWCachingPolicy.ExistenceCheckingOption)MWDescriptorCachingPolicy.existenceCheckingOptions().topLinkOptionForMWModelOption("DEFAULT");
        this.cacheExpiry = new MWProjectDefaultCacheExpiry(this);
    }

    protected void addChildrenTo(List list) {
        super.addChildrenTo(list);
        list.add(this.cacheExpiry);
    }

    public void initializeFrom(MWCachingPolicy mWCachingPolicy) {
        this.setCacheCoordination(mWCachingPolicy.getCacheCoordination());
        this.setCacheIsolation(mWCachingPolicy.getCacheIsolation());
        this.setCacheSize(mWCachingPolicy.getCacheSize());
        this.setCacheType(mWCachingPolicy.getCacheType());
        this.setExistenceChecking(mWCachingPolicy.getExistenceChecking());
    }

    public MWMappingDescriptor getOwningDescriptor() {
        return (MWMappingDescriptor)((MWTransactionalPolicy)this.getParent()).getParent();
    }

    public MWCachingPolicy.ExistenceCheckingOption getExistenceChecking() {
        return this.existenceChecking;
    }

    public void setExistenceChecking(MWCachingPolicy.ExistenceCheckingOption existenceCheckingOption) {
        MWCachingPolicy.ExistenceCheckingOption existenceCheckingOption2 = this.existenceChecking;
        this.existenceChecking = existenceCheckingOption;
        this.firePropertyChanged("existenceChecking", existenceCheckingOption2, this.existenceChecking);
    }

    public void setExistenceChecking(String string) {
        this.setExistenceChecking((MWCachingPolicy.ExistenceCheckingOption)MWDescriptorCachingPolicy.existenceCheckingOptions().topLinkOptionForMWModelOption(string));
    }

    public MWCachingPolicy.CacheCoordinationOption getCacheCoordination() {
        return this.cacheCoordination;
    }

    public void setCacheCoordination(MWCachingPolicy.CacheCoordinationOption cacheCoordinationOption) {
        MWCachingPolicy.CacheCoordinationOption cacheCoordinationOption2 = this.cacheCoordination;
        this.cacheCoordination = cacheCoordinationOption;
        this.firePropertyChanged("cacheCoordination", cacheCoordinationOption2, cacheCoordinationOption);
    }

    public MWCachingPolicy.CacheIsolationOption getCacheIsolation() {
        return this.cacheIsolation;
    }

    public void setCacheIsolation(MWCachingPolicy.CacheIsolationOption cacheIsolationOption) {
        MWCachingPolicy.CacheIsolationOption cacheIsolationOption2 = this.cacheIsolation;
        this.cacheIsolation = cacheIsolationOption;
        this.firePropertyChanged("cacheIsolation", cacheIsolationOption2, cacheIsolationOption);
        if (cacheIsolationOption.getMWModelOption() == "Isolated") {
            this.setCacheCoordination((MWCachingPolicy.CacheCoordinationOption)MWDescriptorCachingPolicy.cacheCoordinationOptions().topLinkOptionForMWModelOption("None"));
        } else if (cacheIsolationOption.getMWModelOption() == "DEFAULT") {
            this.setCacheCoordination((MWCachingPolicy.CacheCoordinationOption)MWDescriptorCachingPolicy.cacheCoordinationOptions().topLinkOptionForMWModelOption("DEFAULT"));
        }
    }

    public CacheTypeHolder getCacheTypeHolder() {
        return this.cacheTypeHolder;
    }

    public MWCachingPolicy.CacheTypeOption getCacheType() {
        return this.cacheTypeHolder.getCacheType();
    }

    public void setCacheType(MWCachingPolicy.CacheTypeOption cacheTypeOption) {
        MWCachingPolicy.CacheTypeOption cacheTypeOption2 = this.cacheTypeHolder.getCacheType();
        this.cacheTypeHolder.setCacheType(cacheTypeOption);
        this.firePropertyChanged("cacheType", cacheTypeOption2, cacheTypeOption);
    }

    public void setCacheType(String string) {
        this.setCacheType((MWCachingPolicy.CacheTypeOption)MWDescriptorCachingPolicy.cacheTypeOptions().topLinkOptionForMWModelOption(string));
    }

    private void setCacheTypeHolder(CacheTypeHolder cacheTypeHolder) {
        CacheTypeHolder cacheTypeHolder2 = this.cacheTypeHolder;
        this.cacheTypeHolder = cacheTypeHolder;
        this.firePropertyChanged(CACHE_TYPE_HOLDER_PROPERTY, cacheTypeHolder2, this.cacheTypeHolder);
    }

    public boolean usesProjectDefaultCacheSize() {
        return this.cacheSizeHolder.usesProjectDefaultCacheSize();
    }

    public void setUseProjectDefaultCacheSize(boolean bl) {
        boolean bl2 = this.cacheSizeHolder.usesProjectDefaultCacheSize();
        this.cacheSizeHolder.setUseProjectDefaultCacheSize(bl);
        this.firePropertyChanged(USE_PROJECT_DEFAULT_CACHE_SIZE_PROPERTY, bl2, this.cacheSizeHolder.usesProjectDefaultCacheSize());
    }

    public void setDontUseProjectDefaultCacheSize(int n) {
        this.setCacheSize(n);
        this.firePropertyChanged(USE_PROJECT_DEFAULT_CACHE_SIZE_PROPERTY, true, false);
    }

    public CacheSizeHolder getCacheSizeHolder() {
        return this.cacheSizeHolder;
    }

    public int getCacheSize() {
        return this.cacheSizeHolder.getCacheSize();
    }

    public void setCacheSize(int n) {
        int n2 = this.cacheSizeHolder.getCacheSize();
        this.cacheSizeHolder.setCacheSize(n);
        this.firePropertyChanged("cacheSize", n2, n);
    }

    private void setCacheSizeHolder(CacheSizeHolder cacheSizeHolder) {
        CacheSizeHolder cacheSizeHolder2 = this.cacheSizeHolder;
        this.cacheSizeHolder = cacheSizeHolder;
        this.firePropertyChanged(CACHE_SIZE_HOLDER_PROPERTY, cacheSizeHolder2, this.cacheSizeHolder);
    }

    public MWCacheExpiry getCacheExpiry() {
        return this.cacheExpiry;
    }

    public void setCacheExpiry(MWCacheExpiry mWCacheExpiry) {
        MWCacheExpiry mWCacheExpiry2 = this.cacheExpiry;
        this.cacheExpiry = mWCacheExpiry;
        this.firePropertyChanged(CACHE_EXPIRY_PROPERTY, mWCacheExpiry2, this.cacheExpiry);
    }

    public void setUseProjectDefaultCacheExpiry(boolean bl) {
        if (bl) {
            this.setCacheExpiry(new MWProjectDefaultCacheExpiry(this));
        } else if (this.getCacheExpiry() instanceof MWProjectDefaultCacheExpiry) {
            this.setCacheExpiry(new MWDescriptorCacheExpiry(this));
        }
    }

    public void descriptorInheritanceChanged() {
        if (this.isRootDescriptor()) {
            if (this.cacheSizeHolder instanceof NullCacheSizeHolder) {
                this.setCacheSizeHolder(new CacheSizeHolderImpl());
            }
            if (this.cacheTypeHolder instanceof NullCacheTypeHolder) {
                this.setCacheTypeHolder(new CacheTypeHolderImpl());
            }
        } else {
            if (!(this.cacheSizeHolder instanceof NullCacheSizeHolder)) {
                this.setCacheSizeHolder(new NullCacheSizeHolder());
            }
            if (!(this.cacheTypeHolder instanceof NullCacheTypeHolder)) {
                this.setCacheTypeHolder(new NullCacheTypeHolder());
            }
        }
        this.firePropertyChanged(DESCRIPTOR_INHERITANCE_PROPERTY, null);
    }

    public boolean isRootDescriptor() {
        MWDescriptor mWDescriptor = null;
        Iterator iterator = this.getOwningDescriptor().inheritanceHierarchy();
        while (iterator.hasNext()) {
            mWDescriptor = (MWDescriptor)iterator.next();
        }
        return this.getOwningDescriptor() == mWDescriptor;
    }

    public void adjustRuntimeDescriptor(ClassDescriptor classDescriptor) {
        MWCachingPolicy mWCachingPolicy = this.getProject().getDefaultsPolicy().getCachingPolicy();
        if (this.existenceChecking.getMWModelOption() == "DEFAULT") {
            classDescriptor.getQueryManager().getDoesExistQuery().setExistencePolicy(((Integer)mWCachingPolicy.getExistenceChecking().getTopLinkModelOption()).intValue());
        } else {
            this.existenceChecking.setMWOptionOnTopLinkObject(classDescriptor);
        }
        this.cacheTypeHolder.adjustRuntimeDescriptor(classDescriptor);
        this.cacheSizeHolder.adjustRuntimeDescriptor(classDescriptor);
        if (this.cacheCoordination.getMWModelOption() == "DEFAULT") {
            classDescriptor.setCacheSynchronizationType(((Integer)mWCachingPolicy.getCacheCoordination().getTopLinkModelOption()).intValue());
        } else {
            this.cacheCoordination.setMWOptionOnTopLinkObject(classDescriptor);
        }
        if (this.cacheIsolation.getMWModelOption() == "DEFAULT") {
            classDescriptor.setIsIsolated(mWCachingPolicy.getCacheIsolation().getMWModelOption() == "Isolated");
        } else {
            this.cacheIsolation.setMWOptionOnTopLinkObject(classDescriptor);
        }
        this.cacheExpiry.adjustRuntimeDescriptor(classDescriptor);
    }

    private MWDescriptorCacheExpiry getCacheExpiryForTopLink() {
        return (MWDescriptorCacheExpiry)this.cacheExpiry.getPersistedPolicy();
    }

    private void setCacheExpiryForTopLink(MWDescriptorCacheExpiry mWDescriptorCacheExpiry) {
        this.cacheExpiry = mWDescriptorCacheExpiry != null ? mWDescriptorCacheExpiry : new MWProjectDefaultCacheExpiry(this);
    }

    public MWCachingPolicy getPersistedPolicy() {
        return this;
    }

    private int getCacheSizeForTopLink() {
        return this.cacheSizeHolder.getCacheSizeForTopLink();
    }

    private void setCacheSizeForTopLink(int n) {
        this.cacheSizeHolder = new CacheSizeHolderImpl();
        this.cacheSizeHolder.setCacheSizeForTopLink(n);
    }

    private MWCachingPolicy.CacheTypeOption getCacheTypeForTopLink() {
        return this.cacheTypeHolder.getCacheTypeForTopLink();
    }

    private void setCacheTypeForTopLink(MWCachingPolicy.CacheTypeOption cacheTypeOption) {
        this.cacheTypeHolder = new CacheTypeHolderImpl();
        this.cacheTypeHolder.setCacheTypeForTopLink(cacheTypeOption);
    }

    public void postProjectBuild() {
        super.postProjectBuild();
        if (!this.isRootDescriptor()) {
            this.cacheSizeHolder = new NullCacheSizeHolder();
            this.cacheTypeHolder = new NullCacheTypeHolder();
        }
    }

    static {
        PROJECT_DEFAULT_CACHE_TYPE = new MWCachingPolicy.CacheTypeOption("DEFAULT", "CACHING_POLICY_DEFAULT_VALUE", null);
    }

    private class CacheTypeHolderImpl
    implements CacheTypeHolder {
        private MWCachingPolicy.CacheTypeOption cacheType = (MWCachingPolicy.CacheTypeOption)MWDescriptorCachingPolicy.cacheTypeOptions().topLinkOptionForMWModelOption("DEFAULT");

        private CacheTypeHolderImpl() {
        }

        public boolean typeCanBeSet() {
            return true;
        }

        public MWCachingPolicy.CacheTypeOption getCacheType() {
            return this.cacheType;
        }

        public void setCacheType(MWCachingPolicy.CacheTypeOption cacheTypeOption) {
            this.cacheType = cacheTypeOption;
        }

        public void adjustRuntimeDescriptor(ClassDescriptor classDescriptor) {
            if (this.cacheType.getMWModelOption() == "DEFAULT") {
                classDescriptor.setIdentityMapClass(ClassTools.classForName((String)MWDescriptorCachingPolicy.this.getProject().getDefaultsPolicy().getCachingPolicy().getCacheType().getTopLinkModelOption()));
            } else {
                this.cacheType.setMWOptionOnTopLinkObject(classDescriptor);
            }
        }

        public MWCachingPolicy.CacheTypeOption getCacheTypeForTopLink() {
            return this.cacheType;
        }

        public void setCacheTypeForTopLink(MWCachingPolicy.CacheTypeOption cacheTypeOption) {
            this.cacheType = cacheTypeOption;
        }
    }

    private class NullCacheTypeHolder
    implements CacheTypeHolder {
        private NullCacheTypeHolder() {
        }

        public boolean typeCanBeSet() {
            return false;
        }

        public MWCachingPolicy.CacheTypeOption getCacheType() {
            MWDescriptor mWDescriptor = MWDescriptorCachingPolicy.this.getOwningDescriptor().getInheritancePolicy().getRootDescriptor();
            return mWDescriptor.getTransactionalPolicy().getCachingPolicy().getCacheType();
        }

        public void setCacheType(MWCachingPolicy.CacheTypeOption cacheTypeOption) {
        }

        public void adjustRuntimeDescriptor(ClassDescriptor classDescriptor) {
        }

        public MWCachingPolicy.CacheTypeOption getCacheTypeForTopLink() {
            return null;
        }

        public void setCacheTypeForTopLink(MWCachingPolicy.CacheTypeOption cacheTypeOption) {
        }
    }

    public static interface CacheTypeHolder {
        public boolean typeCanBeSet();

        public MWCachingPolicy.CacheTypeOption getCacheType();

        public void setCacheType(MWCachingPolicy.CacheTypeOption var1);

        public void adjustRuntimeDescriptor(ClassDescriptor var1);

        public MWCachingPolicy.CacheTypeOption getCacheTypeForTopLink();

        public void setCacheTypeForTopLink(MWCachingPolicy.CacheTypeOption var1);
    }

    private class CacheSizeHolderImpl
    implements CacheSizeHolder {
        private volatile int cacheSize = -1;
        private volatile transient boolean useProjectDefaultCacheSize = true;
        public static final String USE_PROJECT_DEFAULT_CACHE_SIZE_PROPERTY = "useProjectDefaultCacheSize";

        public boolean sizeCanBeSet() {
            return true;
        }

        public boolean usesProjectDefaultCacheSize() {
            return this.useProjectDefaultCacheSize;
        }

        public void setUseProjectDefaultCacheSize(boolean bl) {
            boolean bl2 = this.useProjectDefaultCacheSize;
            this.useProjectDefaultCacheSize = bl;
            if (bl2 != this.useProjectDefaultCacheSize) {
                if (this.useProjectDefaultCacheSize) {
                    this.cacheSize = -1;
                } else if (this.cacheSize == -1) {
                    this.setCacheSize(MWDescriptorCachingPolicy.this.getProject().getDefaultsPolicy().getCachingPolicy().getCacheSize());
                }
            }
            MWDescriptorCachingPolicy.this.firePropertyChanged("useProjectDefaultCacheSize", bl2, this.useProjectDefaultCacheSize);
        }

        public void setDontUseProjectDefaultCacheSize(int n) {
            this.setCacheSize(n);
            MWDescriptorCachingPolicy.this.firePropertyChanged("useProjectDefaultCacheSize", true, false);
        }

        public int getCacheSize() {
            return this.cacheSize;
        }

        public void setCacheSize(int n) {
            int n2 = this.cacheSize;
            this.cacheSize = n;
            if (n2 != this.cacheSize && n2 == -1) {
                this.setUseProjectDefaultCacheSize(false);
            }
            MWDescriptorCachingPolicy.this.firePropertyChanged("cacheSize", n2, n);
        }

        public int getCacheSizeForTopLink() {
            if (this.useProjectDefaultCacheSize) {
                return -1;
            }
            return this.cacheSize;
        }

        public void setCacheSizeForTopLink(int n) {
            this.useProjectDefaultCacheSize = n == -1;
            this.cacheSize = n;
        }

        public void adjustRuntimeDescriptor(ClassDescriptor classDescriptor) {
            if (this.usesProjectDefaultCacheSize()) {
                classDescriptor.setIdentityMapSize(MWDescriptorCachingPolicy.this.getProject().getDefaultsPolicy().getCachingPolicy().getCacheSize());
            } else {
                classDescriptor.setIdentityMapSize(this.getCacheSize());
            }
        }
    }

    private class NullCacheSizeHolder
    implements CacheSizeHolder {
        private NullCacheSizeHolder() {
        }

        public boolean sizeCanBeSet() {
            return false;
        }

        public boolean usesProjectDefaultCacheSize() {
            MWDescriptor mWDescriptor = MWDescriptorCachingPolicy.this.getOwningDescriptor().getInheritancePolicy().getRootDescriptor();
            return mWDescriptor.getTransactionalPolicy().getCachingPolicy().usesProjectDefaultCacheSize();
        }

        public void setUseProjectDefaultCacheSize(boolean bl) {
        }

        public int getCacheSize() {
            MWDescriptor mWDescriptor = MWDescriptorCachingPolicy.this.getOwningDescriptor().getInheritancePolicy().getRootDescriptor();
            return mWDescriptor.getTransactionalPolicy().getCachingPolicy().getCacheSize();
        }

        public void setCacheSize(int n) {
        }

        public int getCacheSizeForTopLink() {
            return -1;
        }

        public void setCacheSizeForTopLink(int n) {
        }

        public void adjustRuntimeDescriptor(ClassDescriptor classDescriptor) {
        }
    }

    public static interface CacheSizeHolder {
        public boolean sizeCanBeSet();

        public boolean usesProjectDefaultCacheSize();

        public void setUseProjectDefaultCacheSize(boolean var1);

        public int getCacheSize();

        public void setCacheSize(int var1);

        public int getCacheSizeForTopLink();

        public void setCacheSizeForTopLink(int var1);

        public void adjustRuntimeDescriptor(ClassDescriptor var1);
    }
}

