/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.mapping;

import java.util.List;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.foundation.AbstractTransformationMapping;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.mappings.XMLCompositeObjectMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.handles.MWClassHandle;
import org.eclipse.persistence.tools.workbench.mappingsmodel.handles.MWHandle;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWFieldTransformerAssociation;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWTransformationMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWTransformer;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.relational.AggregateFieldDescription;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClass;
import org.eclipse.persistence.tools.workbench.utility.node.Node;

public final class MWClassBasedTransformer
extends MWTransformer {
    private MWClassHandle transformerClassHandle;
    public static final String TRANSFORMER_CLASS_PROPERTY = "transformerClass";

    private MWClassBasedTransformer() {
    }

    MWClassBasedTransformer(MWTransformer.Parent parent, MWClass mWClass) {
        super(parent);
        this.setTransformerClass(mWClass);
    }

    protected void initialize(Node node) {
        super.initialize(node);
        this.transformerClassHandle = new MWClassHandle(this, this.buildTransformerClassScrubber());
    }

    protected void addChildrenTo(List list) {
        super.addChildrenTo(list);
        list.add(this.transformerClassHandle);
    }

    private MWHandle.NodeReferenceScrubber buildTransformerClassScrubber() {
        return new MWHandle.NodeReferenceScrubber(){

            public void nodeReferenceRemoved(Node node, MWHandle mWHandle) {
                MWClassBasedTransformer.this.setTransformerClass(null);
            }

            public String toString() {
                return "MWClassBasedTransformer.buildTransformerClassScrubber()";
            }
        };
    }

    public MWClass getTransformerClass() {
        return this.transformerClassHandle.getType();
    }

    public void setTransformerClass(MWClass mWClass) {
        MWClass mWClass2 = this.getTransformerClass();
        this.transformerClassHandle.setType(mWClass);
        if (this.attributeValueHasChanged(mWClass2, mWClass)) {
            this.firePropertyChanged(TRANSFORMER_CLASS_PROPERTY, mWClass2, mWClass);
            this.firePropertyChanged("transformer", mWClass2, mWClass);
            this.getProject().recalculateAggregatePathsToColumn(this.parentDescriptor());
        }
    }

    public String fieldNameForRuntime() {
        return "CLASS_TRANSFORMER " + (this.getTransformerClass() == null ? null : this.getTransformerClass().getName());
    }

    public AggregateFieldDescription fullFieldDescription() {
        return this.getDescriptionForTransformer(this.getTransformerClass());
    }

    private AggregateFieldDescription getDescriptionForTransformer(MWClass mWClass) {
        final String string = mWClass == null ? null : mWClass.getName();
        return new AggregateFieldDescription(){

            public String getMessageKey() {
                return "AGGREGATE_FIELD_DESCRIPTION_FOR_CLASS_BASED_TRANSFORMER";
            }

            public Object[] getMessageArguments() {
                return new Object[]{string};
            }
        };
    }

    public boolean fieldIsWritten() {
        return true;
    }

    public String transformerDisplayString() {
        MWClass mWClass = this.getTransformerClass();
        return mWClass == null ? null : mWClass.displayStringWithPackage();
    }

    public void addAttributeTransformerProblemsForMapping(List list, MWTransformationMapping mWTransformationMapping) {
        if (this.getTransformerClass() == null) {
            list.add(this.buildProblem("0521"));
        } else if (!this.getTransformerClass().mightBeAssignableToAttributeTransformer()) {
            list.add(this.buildProblem("0522", this.getTransformerClass().getName()));
        }
    }

    public void addFieldTransformerProblemsForAssociation(List list, MWFieldTransformerAssociation mWFieldTransformerAssociation) {
        if (this.getTransformerClass() == null) {
            list.add(this.buildProblem("0529", mWFieldTransformerAssociation.fieldName()));
        } else if (!this.getTransformerClass().mightBeAssignableToFieldTransformer()) {
            list.add(this.buildProblem("0530", this.getTransformerClass().getName(), mWFieldTransformerAssociation.fieldName()));
        }
    }

    public void setRuntimeAttributeTransformer(AbstractTransformationMapping abstractTransformationMapping) {
        if (this.getTransformerClass() != null) {
            abstractTransformationMapping.setAttributeTransformerClassName(this.getTransformerClass().getName());
        }
    }

    public void addRuntimeFieldTransformer(AbstractTransformationMapping abstractTransformationMapping, DatabaseField databaseField) {
        if (this.getTransformerClass() != null) {
            abstractTransformationMapping.addFieldTransformerClassName(databaseField, this.getTransformerClass().getName());
        }
    }

    public void toString(StringBuffer stringBuffer) {
        this.transformerClassHandle.toString(stringBuffer);
    }

    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor xMLDescriptor = new XMLDescriptor();
        xMLDescriptor.setJavaClass(MWClassBasedTransformer.class);
        xMLDescriptor.getInheritancePolicy().setParentClass(MWTransformer.class);
        XMLCompositeObjectMapping xMLCompositeObjectMapping = new XMLCompositeObjectMapping();
        xMLCompositeObjectMapping.setAttributeName("transformerClassHandle");
        xMLCompositeObjectMapping.setGetMethodName("getTransformerClassHandleForTopLink");
        xMLCompositeObjectMapping.setSetMethodName("setTransformerClassHandleForTopLink");
        xMLCompositeObjectMapping.setReferenceClass(MWClassHandle.class);
        xMLCompositeObjectMapping.setXPath("transformer-class-handle");
        xMLDescriptor.addMapping((DatabaseMapping)xMLCompositeObjectMapping);
        return xMLDescriptor;
    }

    private MWClassHandle getTransformerClassHandleForTopLink() {
        return this.transformerClassHandle.getType() == null ? null : this.transformerClassHandle;
    }

    private void setTransformerClassHandleForTopLink(MWClassHandle mWClassHandle) {
        MWHandle.NodeReferenceScrubber nodeReferenceScrubber = this.buildTransformerClassScrubber();
        this.transformerClassHandle = mWClassHandle == null ? new MWClassHandle(this, nodeReferenceScrubber) : mWClassHandle.setScrubber(nodeReferenceScrubber);
    }
}

