/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.relational;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import java.util.Vector;
import org.eclipse.persistence.internal.indirection.IndirectionPolicy;
import org.eclipse.persistence.internal.indirection.ProxyIndirectionPolicy;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.VariableOneToOneMapping;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.mappings.XMLCompositeCollectionMapping;
import org.eclipse.persistence.oxm.mappings.XMLCompositeObjectMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.ColumnStringHolder;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWColumn;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWTable;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWClassIndicatorPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWClassIndicatorValue;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWMappingDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational.MWInterfaceDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational.MWRelationalClassDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational.MWRelationalClassIndicatorFieldPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational.MWRelationalDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational.MWTableDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWAbstractReferenceMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWIndirectableContainerMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWIndirectableMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWProxyIndirectionMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.relational.MWColumnQueryKeyPair;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClassAttribute;
import org.eclipse.persistence.tools.workbench.mappingsmodel.project.relational.MWRelationalProject;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.iterators.CloneIterator;
import org.eclipse.persistence.tools.workbench.utility.iterators.NullIterator;
import org.eclipse.persistence.tools.workbench.utility.node.Node;
import org.eclipse.persistence.tools.workbench.utility.node.Problem;
import org.eclipse.persistence.tools.workbench.utility.string.PartialStringComparator;
import org.eclipse.persistence.tools.workbench.utility.string.PartialStringMatcher;
import org.eclipse.persistence.tools.workbench.utility.string.SimplePartialStringMatcher;
import org.eclipse.persistence.tools.workbench.utility.string.StringHolder;

public final class MWVariableOneToOneMapping
extends MWAbstractReferenceMapping
implements MWProxyIndirectionMapping,
MWClassIndicatorPolicy.Parent,
MWRelationalClassIndicatorFieldPolicy.Parent {
    private Collection columnQueryKeyPairs;
    public static final String COLUMN_QUERY_KEY_PAIRS_COLLECTION = "columnQueryKeyPairs";
    private volatile MWRelationalClassIndicatorFieldPolicy classIndicatorPolicy;
    private static final PartialStringMatcher COLUMN_NAME_MATCHER = new SimplePartialStringMatcher(PartialStringComparator.DEFAULT_COMPARATOR);

    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor xMLDescriptor = new XMLDescriptor();
        xMLDescriptor.setJavaClass(MWVariableOneToOneMapping.class);
        xMLDescriptor.getInheritancePolicy().setParentClass(MWAbstractReferenceMapping.class);
        XMLCompositeCollectionMapping xMLCompositeCollectionMapping = new XMLCompositeCollectionMapping();
        xMLCompositeCollectionMapping.setAttributeName(COLUMN_QUERY_KEY_PAIRS_COLLECTION);
        xMLCompositeCollectionMapping.setGetMethodName("getColumnQueryKeyPairsForTopLink");
        xMLCompositeCollectionMapping.setSetMethodName("setColumnQueryKeyPairsForTopLink");
        xMLCompositeCollectionMapping.setReferenceClass(MWColumnQueryKeyPair.class);
        xMLCompositeCollectionMapping.setXPath("column-query-key-pairs/column-query-key-pair");
        xMLDescriptor.addMapping((DatabaseMapping)xMLCompositeCollectionMapping);
        XMLCompositeObjectMapping xMLCompositeObjectMapping = new XMLCompositeObjectMapping();
        xMLCompositeObjectMapping.setAttributeName("classIndicatorPolicy");
        xMLCompositeObjectMapping.setReferenceClass(MWRelationalClassIndicatorFieldPolicy.class);
        xMLCompositeObjectMapping.setXPath("class-indicator-policy");
        xMLDescriptor.addMapping((DatabaseMapping)xMLCompositeObjectMapping);
        return xMLDescriptor;
    }

    private MWVariableOneToOneMapping() {
    }

    MWVariableOneToOneMapping(MWRelationalClassDescriptor mWRelationalClassDescriptor, MWClassAttribute mWClassAttribute, String string) {
        super(mWRelationalClassDescriptor, mWClassAttribute, string);
    }

    protected void initialize(Node node) {
        super.initialize(node);
        this.columnQueryKeyPairs = new Vector();
        this.classIndicatorPolicy = new MWRelationalClassIndicatorFieldPolicy(this);
    }

    protected void initialize(MWClassAttribute mWClassAttribute, String string) {
        super.initialize(mWClassAttribute, string);
        if (!this.getInstanceVariable().isValueHolder() && this.getInstanceVariable().getType().isInterface()) {
            this.indirectionType = "proxy-indirection";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addChildrenTo(List list) {
        super.addChildrenTo(list);
        Collection collection = this.columnQueryKeyPairs;
        synchronized (collection) {
            list.addAll(this.columnQueryKeyPairs);
        }
        list.add(this.classIndicatorPolicy);
    }

    public MWRelationalClassIndicatorFieldPolicy getClassIndicatorPolicy() {
        return this.classIndicatorPolicy;
    }

    public void setReferenceDescriptor(MWDescriptor mWDescriptor) {
        super.setReferenceDescriptor(mWDescriptor);
        if (mWDescriptor != null) {
            this.getClassIndicatorPolicy().resetDescriptorAvailableForIndication(((MWRelationalProject)this.getProject()).descriptorsThatImplement((MWRelationalDescriptor)((Object)this.getReferenceDescriptor())));
        } else {
            this.getClassIndicatorPolicy().resetDescriptorAvailableForIndication(NullIterator.instance());
        }
    }

    public boolean descriptorIsValidReferenceDescriptor(MWDescriptor mWDescriptor) {
        return ((MWRelationalDescriptor)((Object)mWDescriptor)).isInterfaceDescriptor();
    }

    public MWColumnQueryKeyPair addColumnQueryKeyPair(MWColumn mWColumn, String string) {
        return this.addColumnQueryKeyPair(new MWColumnQueryKeyPair(this, mWColumn, string));
    }

    private MWColumnQueryKeyPair addColumnQueryKeyPair(MWColumnQueryKeyPair mWColumnQueryKeyPair) {
        this.addItemToCollection(mWColumnQueryKeyPair, this.columnQueryKeyPairs, COLUMN_QUERY_KEY_PAIRS_COLLECTION);
        this.getProject().recalculateAggregatePathsToColumn(this.getParentDescriptor());
        return mWColumnQueryKeyPair;
    }

    public void removeColumnQueryKeyPair(MWColumnQueryKeyPair mWColumnQueryKeyPair) {
        this.removeItemFromCollection(mWColumnQueryKeyPair, this.columnQueryKeyPairs, COLUMN_QUERY_KEY_PAIRS_COLLECTION);
        this.getProject().recalculateAggregatePathsToColumn(this.getParentDescriptor());
    }

    public Iterator columnQueryKeyPairs() {
        return new CloneIterator(this.columnQueryKeyPairs);
    }

    public int columnQueryKeyPairsSize() {
        return this.columnQueryKeyPairs.size();
    }

    public Iterator queryKeyNameChoices() {
        if (this.getReferenceDescriptor() == null) {
            return NullIterator.instance();
        }
        return ((MWRelationalDescriptor)((Object)this.getReferenceDescriptor())).allQueryKeyNames();
    }

    public Collection invalidQueryKeyNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        MWRelationalDescriptor mWRelationalDescriptor = (MWRelationalDescriptor)((Object)this.getReferenceDescriptor());
        if (this.columnQueryKeyPairsSize() > 0 && mWRelationalDescriptor != null) {
            Iterator iterator = this.columnQueryKeyPairs();
            while (iterator.hasNext()) {
                MWColumnQueryKeyPair mWColumnQueryKeyPair = (MWColumnQueryKeyPair)iterator.next();
                if (mWRelationalDescriptor.queryKeyNamed(mWColumnQueryKeyPair.getQueryKeyName()) != null) continue;
                arrayList.add(mWColumnQueryKeyPair.getQueryKeyName());
            }
        }
        return arrayList;
    }

    public boolean usesProxyIndirection() {
        return this.getIndirectionType() == "proxy-indirection";
    }

    public void setUseProxyIndirection() {
        this.setIndirectionType("proxy-indirection");
    }

    public String iconKey() {
        return "mapping.variableOneToOne";
    }

    public void implementorsChangedFor(MWInterfaceDescriptor mWInterfaceDescriptor) {
        if (this.getReferenceDescriptor() == mWInterfaceDescriptor) {
            Collection collection = CollectionTools.collection(((MWRelationalProject)this.getProject()).descriptorsThatImplement(mWInterfaceDescriptor));
            this.removeOldIndicators(collection);
            this.addNewIndicators(collection);
        }
    }

    private void removeOldIndicators(Collection collection) {
        for (MWClassIndicatorValue mWClassIndicatorValue : CollectionTools.collection(this.classIndicatorPolicy.classIndicatorValues())) {
            if (collection.contains(mWClassIndicatorValue.getDescriptorValue())) continue;
            this.getClassIndicatorPolicy().removeIndicator(mWClassIndicatorValue);
        }
    }

    private void addNewIndicators(Collection collection) {
        for (MWMappingDescriptor mWMappingDescriptor : collection) {
            if (this.getClassIndicatorPolicy().getClassIndicatorValueForDescriptor(mWMappingDescriptor) != null) continue;
            this.getClassIndicatorPolicy().addIndicator(null, mWMappingDescriptor);
        }
    }

    public void parentDescriptorMorphedToAggregate() {
        super.parentDescriptorMorphedToAggregate();
        Iterator iterator = this.columnQueryKeyPairs();
        while (iterator.hasNext()) {
            ((MWColumnQueryKeyPair)iterator.next()).setColumn(null);
        }
        this.getClassIndicatorPolicy().setField(null);
    }

    protected Collection buildAggregateFieldNameGenerators() {
        Collection collection = super.buildAggregateFieldNameGenerators();
        collection.add(this.classIndicatorPolicy);
        Iterator iterator = this.columnQueryKeyPairs();
        while (iterator.hasNext()) {
            collection.add(iterator.next());
        }
        return collection;
    }

    public MWVariableOneToOneMapping asMWVariableOneToOneMapping() {
        return this;
    }

    protected void initializeOn(MWMapping mWMapping) {
        mWMapping.initializeFromMWVariableOneToOneMapping(this);
    }

    protected void initializeFromMWIndirectableContainerMapping(MWIndirectableContainerMapping mWIndirectableContainerMapping) {
        super.initializeFromMWIndirectableContainerMapping(mWIndirectableContainerMapping);
        if (mWIndirectableContainerMapping.usesValueHolderIndirection()) {
            this.setUseValueHolderIndirection();
        } else if (mWIndirectableContainerMapping.usesNoIndirection()) {
            this.setUseNoIndirection();
        }
    }

    protected void initializeFromMWIndirectableMapping(MWIndirectableMapping mWIndirectableMapping) {
        super.initializeFromMWIndirectableMapping(mWIndirectableMapping);
        if (mWIndirectableMapping.usesValueHolderIndirection()) {
            this.setUseValueHolderIndirection();
        }
    }

    public void addWrittenFieldsTo(Collection collection) {
        if (this.isReadOnly()) {
            return;
        }
        Iterator iterator = this.columnQueryKeyPairs();
        while (iterator.hasNext()) {
            MWColumnQueryKeyPair mWColumnQueryKeyPair = (MWColumnQueryKeyPair)iterator.next();
            if (mWColumnQueryKeyPair.getColumn() == null) continue;
            collection.add(mWColumnQueryKeyPair.getColumn());
        }
        if (this.getClassIndicatorPolicy().getField() != null) {
            collection.add(this.getClassIndicatorPolicy().getField());
        }
    }

    public boolean parentDescriptorIsAggregate() {
        return ((MWRelationalDescriptor)((Object)this.getParentDescriptor())).isAggregateDescriptor();
    }

    public MWRelationalDescriptor getParentRelationalDescriptor() {
        return (MWRelationalDescriptor)((Object)this.getParentDescriptor());
    }

    public MWMappingDescriptor getContainingDescriptor() {
        return this.getParentDescriptor();
    }

    protected void addProblemsTo(List list) {
        super.addProblemsTo(list);
        this.addNoQueryKeyAssociationsProblemTo(list);
        this.addForeignKeyFieldsInvalidProblemTo(list);
        this.addForeignKeysNotSpecifiedProblemTo(list);
        this.addInvalidQueryKeysProblemsTo(list);
        this.addClassIndicatorValueProblemsTo(list);
    }

    protected String referenceDescriptorInvalidProblemString() {
        return "0516";
    }

    private void addNoQueryKeyAssociationsProblemTo(List list) {
        if (this.columnQueryKeyPairsSize() == 0) {
            list.add(this.buildProblem("0510"));
        }
    }

    private void addForeignKeyFieldsInvalidProblemTo(List list) {
        ArrayList arrayList = new ArrayList();
        Iterator iterator = this.getParentRelationalDescriptor().associatedTables();
        while (iterator.hasNext()) {
            CollectionTools.addAll(arrayList, ((MWTable)iterator.next()).columns());
        }
        iterator = this.columnQueryKeyPairs();
        while (iterator.hasNext()) {
            MWColumnQueryKeyPair mWColumnQueryKeyPair = (MWColumnQueryKeyPair)iterator.next();
            MWColumn mWColumn = mWColumnQueryKeyPair.getColumn();
            if (mWColumn == null || arrayList.contains(mWColumn)) continue;
            list.add(this.buildProblem("0517", mWColumn.getName(), mWColumnQueryKeyPair.getQueryKeyName()));
        }
    }

    private void addForeignKeysNotSpecifiedProblemTo(List list) {
        boolean bl = true;
        Iterator iterator = this.columnQueryKeyPairs();
        while (iterator.hasNext()) {
            MWColumnQueryKeyPair mWColumnQueryKeyPair = (MWColumnQueryKeyPair)iterator.next();
            bl &= mWColumnQueryKeyPair.getColumn() != null;
        }
        if (!this.parentDescriptorIsAggregate() && !bl) {
            list.add(this.buildProblem("0511"));
        }
    }

    private void addInvalidQueryKeysProblemsTo(List list) {
        ArrayList arrayList = new ArrayList();
        Iterator iterator = this.invalidQueryKeyNames().iterator();
        while (iterator.hasNext()) {
            arrayList.add(iterator.next());
        }
        if (!arrayList.isEmpty()) {
            list.add(this.buildProblem("0512", arrayList));
        }
    }

    public void addClassIndicatorFieldNotSpecifiedProblemTo(List list) {
        boolean bl = true;
        if (this.columnQueryKeyPairsSize() == 0) {
            bl = false;
        }
        Iterator iterator = this.columnQueryKeyPairs();
        while (iterator.hasNext()) {
            MWColumn mWColumn = ((MWColumnQueryKeyPair)iterator.next()).getColumn();
            if (mWColumn == null) continue;
            bl &= mWColumn.isPrimaryKey() || mWColumn.isUnique();
        }
        if (bl) {
            return;
        }
        if (!this.parentDescriptorIsAggregate() && this.getClassIndicatorPolicy().getField() == null) {
            list.add(this.buildProblem("0513"));
        }
    }

    private void addClassIndicatorValueProblemsTo(List list) {
        MWRelationalDescriptor mWRelationalDescriptor = (MWRelationalDescriptor)((Object)this.getReferenceDescriptor());
        if (mWRelationalDescriptor == null || !mWRelationalDescriptor.isInterfaceDescriptor()) {
            return;
        }
        Iterator iterator = this.getClassIndicatorPolicy().classIndicatorValues();
        while (iterator.hasNext()) {
            MWClassIndicatorValue mWClassIndicatorValue = (MWClassIndicatorValue)iterator.next();
            if (CollectionTools.collection(mWRelationalDescriptor.implementors()).contains(mWClassIndicatorValue.getDescriptorValue()) || !mWClassIndicatorValue.isInclude()) continue;
            list.add(this.buildClassIndicatorValueInvalidProblem(mWClassIndicatorValue.getDescriptorValue()));
        }
    }

    private Problem buildClassIndicatorValueInvalidProblem(MWDescriptor mWDescriptor) {
        return this.buildProblem("0515", mWDescriptor.getName(), this.getReferenceDescriptor().getName());
    }

    public void automap() {
        super.automap();
        this.automapClassIndicatorField();
    }

    private void automapClassIndicatorField() {
        if (this.getClassIndicatorPolicy().getField() != null || this.parentDescriptorIsAggregate()) {
            return;
        }
        MWTable mWTable = ((MWTableDescriptor)this.getParentDescriptor()).getPrimaryTable();
        if (mWTable == null) {
            return;
        }
        StringHolder[] stringHolderArray = ColumnStringHolder.buildHolders(mWTable.nonPrimaryKeyColumns());
        PartialStringMatcher.StringHolderScore stringHolderScore = COLUMN_NAME_MATCHER.match(this.getName().toLowerCase(), stringHolderArray);
        if (stringHolderScore.getScore() > 0.5) {
            this.getClassIndicatorPolicy().setField(((ColumnStringHolder)stringHolderScore.getStringHolder()).getColumn());
        }
    }

    protected DatabaseMapping buildRuntimeMapping() {
        return new VariableOneToOneMapping();
    }

    public DatabaseMapping runtimeMapping() {
        VariableOneToOneMapping variableOneToOneMapping = (VariableOneToOneMapping)super.runtimeMapping();
        if (this.getReferenceDescriptor() != null && this.getReferenceDescriptor().getMWClass() != null) {
            variableOneToOneMapping.setReferenceClassName(this.getReferenceDescriptor().getMWClass().getName());
        }
        Iterator iterator = this.columnQueryKeyPairs();
        while (iterator.hasNext()) {
            ((MWColumnQueryKeyPair)iterator.next()).adjustRuntimeMapping(variableOneToOneMapping);
        }
        this.classIndicatorPolicy.adjustRuntimeMapping(variableOneToOneMapping);
        if (this.usesProxyIndirection()) {
            variableOneToOneMapping.setIndirectionPolicy((IndirectionPolicy)new ProxyIndirectionPolicy());
        }
        return variableOneToOneMapping;
    }

    private Collection getColumnQueryKeyPairsForTopLink() {
        return new TreeSet(this.columnQueryKeyPairs);
    }

    private void setColumnQueryKeyPairsForTopLink(Collection collection) {
        this.columnQueryKeyPairs = collection;
    }

    public void postProjectBuild() {
        super.postProjectBuild();
        if (this.getReferenceDescriptor() != null) {
            this.classIndicatorPolicy.setDescriptorsAvailableForIndicatorDictionaryForTopLink(((MWRelationalDescriptor)((Object)this.getReferenceDescriptor())).implementors());
        } else {
            this.classIndicatorPolicy.setDescriptorsAvailableForIndicatorDictionary(NullIterator.instance());
        }
    }

    private MWTable findBestMatchingTable(String string) {
        Iterator iterator = this.getDatabase().tables();
        while (iterator.hasNext()) {
            MWTable mWTable = (MWTable)iterator.next();
            if (!mWTable.getShortName().equals(string)) continue;
            return mWTable;
        }
        return null;
    }
}

