/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.meta;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.persistence.indirection.ValueHolder;
import org.eclipse.persistence.internal.codegen.NonreflectiveAttributeDefinition;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.mappings.XMLCompositeObjectMapping;
import org.eclipse.persistence.oxm.mappings.XMLDirectMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWModel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.handles.MWClassHandle;
import org.eclipse.persistence.tools.workbench.mappingsmodel.handles.MWHandle;
import org.eclipse.persistence.tools.workbench.mappingsmodel.handles.MWMethodHandle;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWAddMethodCodeGenPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClass;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClassCodeGenPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWGetMethodCodeGenPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWMethod;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWMethodCodeGenPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWModifiable;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWModifier;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWRemoveMethodCodeGenPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWSetMethodCodeGenPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWTypeDeclaration;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWValueGetMethodCodeGenPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWValueSetMethodCodeGenPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.spi.meta.ExternalField;
import org.eclipse.persistence.tools.workbench.utility.iterators.NullIterator;
import org.eclipse.persistence.tools.workbench.utility.node.Node;
import org.eclipse.persistence.tools.workbench.utility.string.StringTools;

public final class MWClassAttribute
extends MWModel
implements MWModifiable {
    private volatile String name;
    public static final String NAME_PROPERTY = "name";
    private MWModifier modifier;
    private MWTypeDeclaration typeDeclaration;
    public static final String TYPE_PROPERTY = "type";
    public static final String DIMENSIONALITY_PROPERTY = "dimensionality";
    public static final String DECLARATION_PROPERTY = "declaration";
    private MWClassHandle valueTypeHandle;
    public static final String VALUE_TYPE_PROPERTY = "valueType";
    private MWClassHandle itemTypeHandle;
    public static final String ITEM_TYPE_PROPERTY = "itemType";
    private MWClassHandle keyTypeHandle;
    public static final String KEY_TYPE_PROPERTY = "keyType";
    private MWMethodHandle getMethodHandle;
    public static final String GET_METHOD_PROPERTY = "getMethod";
    private MWMethodHandle setMethodHandle;
    public static final String SET_METHOD_PROPERTY = "setMethod";
    private MWMethodHandle valueGetMethodHandle;
    public static final String VALUE_GET_METHOD_PROPERTY = "valueGetMethod";
    private MWMethodHandle valueSetMethodHandle;
    public static final String VALUE_SET_METHOD_PROPERTY = "valueSetMethod";
    private MWMethodHandle addMethodHandle;
    public static final String ADD_METHOD_PROPERTY = "addMethod";
    private MWMethodHandle removeMethodHandle;
    public static final String REMOVE_METHOD_PROPERTY = "removeMethod";
    private static final String GET_PREFIX = "get";
    private static final String IS_PREFIX = "is";
    private static final String SET_PREFIX = "set";
    private static final String ADD_PREFIX = "addTo";
    private static final String REMOVE_PREFIX = "removeFrom";
    private static final String HOLDER_SUFFIX = "Holder";
    private static final String CR = StringTools.CR;
    private static final int ALLOWED_MODIFIERS_FLAGS = 80;

    private MWClassAttribute() {
    }

    MWClassAttribute(MWClass mWClass, ExternalField externalField) {
        this(mWClass, externalField.getName());
        this.refresh(externalField);
    }

    MWClassAttribute(MWClass mWClass, String string) {
        this(mWClass, string, mWClass.typeFor(Object.class));
    }

    MWClassAttribute(MWClass mWClass, String string, MWClass mWClass2) {
        this(mWClass, string, mWClass2, 0);
    }

    MWClassAttribute(MWClass mWClass, String string, MWClass mWClass2, int n) {
        super(mWClass);
        this.name = string;
        this.initialize(mWClass2, n);
    }

    protected void initialize() {
        super.initialize();
        this.modifier = new MWModifier(this);
    }

    protected void initialize(Node node) {
        super.initialize(node);
        if (this.getDeclaringType().isInterface()) {
            this.modifier.setPublic(true);
            this.modifier.setStatic(true);
            this.modifier.setFinal(true);
        }
        this.getMethodHandle = new MWMethodHandle(this, this.buildGetMethodScrubber());
        this.setMethodHandle = new MWMethodHandle(this, this.buildSetMethodScrubber());
        this.valueGetMethodHandle = new MWMethodHandle(this, this.buildValueGetMethodScrubber());
        this.valueSetMethodHandle = new MWMethodHandle(this, this.buildValueSetMethodScrubber());
        this.addMethodHandle = new MWMethodHandle(this, this.buildAddMethodScrubber());
        this.removeMethodHandle = new MWMethodHandle(this, this.buildRemoveMethodScrubber());
        this.valueTypeHandle = new MWClassHandle(this, this.buildValueTypeScrubber());
        this.itemTypeHandle = new MWClassHandle(this, this.buildItemTypeScrubber());
        this.keyTypeHandle = new MWClassHandle(this, this.buildKeyTypeScrubber());
    }

    private void initialize(MWClass mWClass, int n) {
        this.typeDeclaration = new MWTypeDeclaration(this, mWClass, n);
    }

    public MWClass getDeclaringType() {
        return (MWClass)this.getParent();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        String string2 = this.name;
        this.name = string;
        this.firePropertyChanged(NAME_PROPERTY, string2, string);
        if (this.attributeValueHasChanged(string2, string)) {
            this.firePropertyChanged(DECLARATION_PROPERTY, NAME_PROPERTY);
            this.getProject().nodeRenamed(this);
            this.updateAccessorNames();
        }
    }

    public MWModifier getModifier() {
        return this.modifier;
    }

    public MWClass getType() {
        return this.typeDeclaration.getType();
    }

    public void setType(MWClass mWClass) {
        if (mWClass.isVoid()) {
            throw new IllegalArgumentException("An attribute can not have a type of 'void'");
        }
        MWClass mWClass2 = this.typeDeclaration.getType();
        this.typeDeclaration.setType(mWClass);
        this.firePropertyChanged(TYPE_PROPERTY, mWClass2, mWClass);
        if (mWClass2 != mWClass) {
            this.firePropertyChanged(DECLARATION_PROPERTY, TYPE_PROPERTY);
            this.updateNestedTypes(mWClass2);
            this.updateGetAndSetMethods();
        }
    }

    public int getDimensionality() {
        return this.typeDeclaration.getDimensionality();
    }

    public void setDimensionality(int n) {
        int n2 = this.typeDeclaration.getDimensionality();
        this.typeDeclaration.setDimensionality(n);
        this.firePropertyChanged(DIMENSIONALITY_PROPERTY, n2, n);
        if (n2 != n) {
            this.firePropertyChanged(DECLARATION_PROPERTY, DIMENSIONALITY_PROPERTY);
            this.updateNestedTypes();
            this.updateGetAndSetMethods();
        }
    }

    public MWClass getValueType() {
        MWClass mWClass = this.valueTypeHandle.getType();
        if (mWClass == null && this.canHaveValueType()) {
            mWClass = this.objectType();
        }
        return mWClass;
    }

    public void setValueType(MWClass mWClass) {
        if (this.canHaveValueType() ^ mWClass != null) {
            throw new IllegalArgumentException(mWClass.toString());
        }
        MWClass mWClass2 = this.getValueType();
        this.valueTypeHandle.setType(mWClass == this.objectType() ? null : mWClass);
        this.firePropertyChanged(VALUE_TYPE_PROPERTY, this.getValueType());
        if (mWClass2 != this.getValueType()) {
            this.updateContainerTypes();
            this.updateValueGetAndSetMethods();
        }
    }

    public MWClass getItemType() {
        MWClass mWClass = this.itemTypeHandle.getType();
        if (mWClass == null && this.canHaveItemType()) {
            mWClass = this.objectType();
        }
        return mWClass;
    }

    public void setItemType(MWClass mWClass) {
        if (this.canHaveItemType() ^ mWClass != null) {
            throw new IllegalArgumentException(mWClass.toString());
        }
        MWClass mWClass2 = this.getItemType();
        this.itemTypeHandle.setType(mWClass == this.objectType() ? null : mWClass);
        this.firePropertyChanged(ITEM_TYPE_PROPERTY, this.getItemType());
        if (mWClass2 != this.getItemType()) {
            this.updateAddAndRemoveMethods();
        }
    }

    public MWClass getKeyType() {
        MWClass mWClass = this.keyTypeHandle.getType();
        if (mWClass == null && this.canHaveKeyType()) {
            mWClass = this.objectType();
        }
        return mWClass;
    }

    public void setKeyType(MWClass mWClass) {
        if (this.canHaveKeyType() ^ mWClass != null) {
            throw new IllegalArgumentException(mWClass.toString());
        }
        MWClass mWClass2 = this.getKeyType();
        this.keyTypeHandle.setType(mWClass == this.objectType() ? null : mWClass);
        this.firePropertyChanged(KEY_TYPE_PROPERTY, mWClass2, this.getKeyType());
        if (mWClass2 != this.getKeyType()) {
            this.updateAddAndRemoveMethods();
        }
    }

    public MWMethod getGetMethod() {
        return this.getMethodHandle.getMethod();
    }

    public void setGetMethod(MWMethod mWMethod) {
        MWMethod mWMethod2 = this.getGetMethod();
        this.getMethodHandle.setMethod(mWMethod);
        this.firePropertyChanged(GET_METHOD_PROPERTY, mWMethod2, mWMethod);
        if (mWMethod2 != mWMethod) {
            if (mWMethod2 != null) {
                mWMethod2.setAccessedAttribute(null);
            }
            if (mWMethod != null) {
                mWMethod.setAccessedAttribute(this);
            }
        }
    }

    public MWMethod getSetMethod() {
        return this.setMethodHandle.getMethod();
    }

    public void setSetMethod(MWMethod mWMethod) {
        MWMethod mWMethod2 = this.getSetMethod();
        this.setMethodHandle.setMethod(mWMethod);
        this.firePropertyChanged(SET_METHOD_PROPERTY, mWMethod2, mWMethod);
        if (mWMethod2 != mWMethod) {
            if (mWMethod2 != null) {
                mWMethod2.setAccessedAttribute(null);
            }
            if (mWMethod != null) {
                mWMethod.setAccessedAttribute(this);
            }
        }
    }

    public MWMethod getValueGetMethod() {
        return this.valueGetMethodHandle.getMethod();
    }

    public void setValueGetMethod(MWMethod mWMethod) {
        MWMethod mWMethod2 = this.getValueGetMethod();
        this.valueGetMethodHandle.setMethod(mWMethod);
        this.firePropertyChanged(VALUE_GET_METHOD_PROPERTY, mWMethod2, mWMethod);
        if (mWMethod2 != mWMethod) {
            if (mWMethod2 != null) {
                mWMethod2.setAccessedAttribute(null);
            }
            if (mWMethod != null) {
                mWMethod.setAccessedAttribute(this);
            }
        }
    }

    public MWMethod getValueSetMethod() {
        return this.valueSetMethodHandle.getMethod();
    }

    public void setValueSetMethod(MWMethod mWMethod) {
        MWMethod mWMethod2 = this.getValueSetMethod();
        this.valueSetMethodHandle.setMethod(mWMethod);
        this.firePropertyChanged(VALUE_SET_METHOD_PROPERTY, mWMethod2, mWMethod);
        if (mWMethod2 != mWMethod) {
            if (mWMethod2 != null) {
                mWMethod2.setAccessedAttribute(null);
            }
            if (mWMethod != null) {
                mWMethod.setAccessedAttribute(this);
            }
        }
    }

    public MWMethod getAddMethod() {
        return this.addMethodHandle.getMethod();
    }

    public void setAddMethod(MWMethod mWMethod) {
        MWMethod mWMethod2 = this.getAddMethod();
        this.addMethodHandle.setMethod(mWMethod);
        this.firePropertyChanged(ADD_METHOD_PROPERTY, mWMethod2, mWMethod);
        if (mWMethod2 != mWMethod) {
            if (mWMethod2 != null) {
                mWMethod2.setAccessedAttribute(null);
            }
            if (mWMethod != null) {
                mWMethod.setAccessedAttribute(this);
            }
        }
    }

    public MWMethod getRemoveMethod() {
        return this.removeMethodHandle.getMethod();
    }

    public void setRemoveMethod(MWMethod mWMethod) {
        MWMethod mWMethod2 = this.getRemoveMethod();
        this.removeMethodHandle.setMethod(mWMethod);
        this.firePropertyChanged(REMOVE_METHOD_PROPERTY, mWMethod2, mWMethod);
        if (mWMethod2 != mWMethod) {
            if (mWMethod2 != null) {
                mWMethod2.setAccessedAttribute(null);
            }
            if (mWMethod != null) {
                mWMethod.setAccessedAttribute(this);
            }
        }
    }

    public boolean supportsAbstract() {
        return false;
    }

    public boolean canBeSetAbstract() {
        return false;
    }

    public boolean canBeSetFinal() {
        return !this.getModifier().isVolatile();
    }

    public boolean supportsInterface() {
        return false;
    }

    public boolean canBeSetInterface() {
        return false;
    }

    public boolean supportsNative() {
        return false;
    }

    public boolean canBeSetNative() {
        return false;
    }

    public boolean canBeSetPackage() {
        return true;
    }

    public boolean canBeSetPrivate() {
        return true;
    }

    public boolean canBeSetProtected() {
        return true;
    }

    public boolean canBeSetPublic() {
        return true;
    }

    public boolean canBeSetStatic() {
        return true;
    }

    public boolean supportsStrict() {
        return false;
    }

    public boolean canBeSetStrict() {
        return false;
    }

    public boolean supportsSynchronized() {
        return false;
    }

    public boolean canBeSetSynchronized() {
        return false;
    }

    public boolean supportsTransient() {
        return true;
    }

    public boolean canBeSetTransient() {
        return true;
    }

    public boolean supportsVolatile() {
        return true;
    }

    public boolean canBeSetVolatile() {
        return !this.getModifier().isFinal();
    }

    public void modifierChanged(int n, int n2) {
        this.firePropertyChanged("modifierCode", n, n2);
        if (MWModifier.anyFlagsAreDifferent(80, n, n2)) {
            this.modifier.allowedModifiersChanged();
        }
    }

    public void accessLevelChanged(String string, String string2) {
        this.firePropertyChanged("modifierAccessLevel", string, string2);
    }

    public boolean isStatic() {
        return this.getModifier().isStatic();
    }

    public boolean isFinal() {
        return this.getModifier().isFinal();
    }

    public String typeName() {
        return this.typeDeclaration.typeName();
    }

    public String typeDeclaration() {
        return this.typeDeclaration.declaration();
    }

    public boolean isArray() {
        return this.typeDeclaration.isArray();
    }

    public boolean isValueHolder() {
        return this.typeDeclaration.isValueHolder();
    }

    public boolean isTLValueHolder() {
        return this.typeDeclaration.isTLValueHolder();
    }

    public boolean isBooleanPrimitive() {
        return this.typeDeclaration.isBooleanPrimitive();
    }

    public boolean isAssignableFrom(MWClass mWClass) {
        return this.typeDeclaration.isAssignableFrom(mWClass);
    }

    public boolean mightBeAssignableFrom(MWClass mWClass) {
        return this.typeDeclaration.mightBeAssignableFrom(mWClass);
    }

    public boolean isAssignableTo(MWClass mWClass) {
        return this.typeDeclaration.isAssignableTo(mWClass);
    }

    public boolean mightBeAssignableTo(MWClass mWClass) {
        return this.typeDeclaration.mightBeAssignableTo(mWClass);
    }

    public boolean isAssignableToCollection() {
        return this.typeDeclaration.isAssignableToCollection();
    }

    public boolean mightBeAssignableToCollection() {
        return this.typeDeclaration.mightBeAssignableToCollection();
    }

    public boolean isAssignableToList() {
        return this.typeDeclaration.isAssignableToList();
    }

    public boolean mightBeAssignableToList() {
        return this.typeDeclaration.mightBeAssignableToList();
    }

    public boolean isAssignableToMap() {
        return this.typeDeclaration.isAssignableToMap();
    }

    public boolean mightBeAssignableToMap() {
        return this.typeDeclaration.mightBeAssignableToMap();
    }

    public boolean isAssignableToSet() {
        return this.typeDeclaration.isAssignableToSet();
    }

    public boolean mightBeAssignableToSet() {
        return this.typeDeclaration.mightBeAssignableToSet();
    }

    public boolean isAssignableToIndirectContainer() {
        return this.typeDeclaration.isAssignableToIndirectContainer();
    }

    public boolean mightBeAssignableToIndirectContainer() {
        return this.typeDeclaration.mightBeAssignableToIndirectContainer();
    }

    public boolean isContainer() {
        return this.isAssignableToCollection() || this.isAssignableToMap();
    }

    public boolean mightBeContainer() {
        return this.mightBeAssignableToCollection() || this.mightBeAssignableToMap();
    }

    public boolean isInstanceVariable() {
        return !this.isStatic();
    }

    public boolean isClassVariable() {
        return this.isStatic() && !this.isFinal();
    }

    public boolean isConstant() {
        return this.isStatic() && this.isFinal();
    }

    public boolean isMappable() {
        return !this.isStatic() && !this.isFinal();
    }

    public boolean canHaveValueType() {
        return this.isValueHolder();
    }

    public boolean canHaveItemType() {
        return this.canHaveCollectionElementType() || this.canHaveMapValueType();
    }

    public boolean canHaveCollectionElementType() {
        return this.mightBeAssignableToCollection() || this.isValueHolder() && this.getValueType().mightBeAssignableToCollection();
    }

    public boolean canHaveMapValueType() {
        return this.canHaveMapKeyAndValueTypes();
    }

    public boolean canHaveKeyType() {
        return this.canHaveMapKeyAndValueTypes();
    }

    public boolean canHaveMapKeyAndValueTypes() {
        return this.mightBeAssignableToMap() || this.isValueHolder() && this.getValueType().mightBeAssignableToMap();
    }

    public boolean canHaveValueGetAndSetMethods() {
        return this.canHaveValueType();
    }

    public boolean canHaveAddAndRemoveMethods() {
        return this.canHaveItemType();
    }

    public MWMethod guessGetMethod() {
        MWMethod mWMethod = this.getGetMethod();
        return mWMethod != null ? mWMethod : this.standardGetMethod();
    }

    public MWMethod standardGetMethod() {
        return this.getDeclaringType().zeroArgumentMethodNamed(this.standardGetMethodName());
    }

    private String standardGetMethodName() {
        StringBuffer stringBuffer = new StringBuffer(this.getName().length() + 10);
        if (this.isBooleanPrimitive()) {
            stringBuffer.append(IS_PREFIX);
        } else {
            stringBuffer.append(GET_PREFIX);
        }
        StringTools.capitalizeOn(this.getName(), stringBuffer);
        if (this.isValueHolder()) {
            stringBuffer.append(HOLDER_SUFFIX);
        }
        return stringBuffer.toString();
    }

    public MWMethod guessSetMethod() {
        MWMethod mWMethod = this.getSetMethod();
        return mWMethod != null ? mWMethod : this.standardSetMethod();
    }

    public MWMethod standardSetMethod() {
        return this.getDeclaringType().oneArgumentMethodNamed(this.standardSetMethodName(), this.typeDeclaration);
    }

    private String standardSetMethodName() {
        StringBuffer stringBuffer = new StringBuffer(this.getName().length() + 10);
        stringBuffer.append(SET_PREFIX);
        StringTools.capitalizeOn(this.getName(), stringBuffer);
        if (this.isValueHolder()) {
            stringBuffer.append(HOLDER_SUFFIX);
        }
        return stringBuffer.toString();
    }

    public MWMethod guessValueGetMethod() {
        MWMethod mWMethod = this.getValueGetMethod();
        return mWMethod != null ? mWMethod : this.standardValueGetMethod();
    }

    public MWMethod standardValueGetMethod() {
        return this.getDeclaringType().zeroArgumentMethodNamed(this.standardValueGetMethodName());
    }

    private String standardValueGetMethodName() {
        StringBuffer stringBuffer = new StringBuffer(this.getName().length() + 3);
        if (this.isBooleanPrimitive()) {
            stringBuffer.append(IS_PREFIX);
        } else {
            stringBuffer.append(GET_PREFIX);
        }
        StringTools.capitalizeOn(this.getName(), stringBuffer);
        return stringBuffer.toString();
    }

    public MWMethod guessValueSetMethod() {
        MWMethod mWMethod = this.getValueSetMethod();
        return mWMethod != null ? mWMethod : this.standardValueSetMethod();
    }

    public MWMethod standardValueSetMethod() {
        return this.getDeclaringType().oneArgumentMethodNamed(this.standardValueSetMethodName(), this.getValueType());
    }

    private String standardValueSetMethodName() {
        StringBuffer stringBuffer = new StringBuffer(this.getName().length() + 3);
        stringBuffer.append(SET_PREFIX);
        StringTools.capitalizeOn(this.getName(), stringBuffer);
        return stringBuffer.toString();
    }

    public MWMethod guessAddMethod() {
        MWMethod mWMethod = this.getAddMethod();
        return mWMethod != null ? mWMethod : this.standardAddMethod();
    }

    public MWMethod standardAddMethod() {
        if (this.canHaveKeyType()) {
            return this.getDeclaringType().twoArgumentMethodNamed(this.standardAddMethodName(), this.getKeyType(), this.getItemType());
        }
        return this.getDeclaringType().oneArgumentMethodNamed(this.standardAddMethodName(), this.getItemType());
    }

    private String standardAddMethodName() {
        StringBuffer stringBuffer = new StringBuffer(this.getName().length() + 5);
        stringBuffer.append(ADD_PREFIX);
        StringTools.capitalizeOn(this.getName(), stringBuffer);
        return stringBuffer.toString();
    }

    public MWMethod guessRemoveMethod() {
        MWMethod mWMethod = this.getRemoveMethod();
        return mWMethod != null ? mWMethod : this.standardRemoveMethod();
    }

    public MWMethod standardRemoveMethod() {
        MWClass mWClass = this.canHaveKeyType() ? this.getKeyType() : this.getItemType();
        return this.getDeclaringType().oneArgumentMethodNamed(this.standardRemoveMethodName(), mWClass);
    }

    private String standardRemoveMethodName() {
        StringBuffer stringBuffer = new StringBuffer(this.getName().length() + 10);
        stringBuffer.append(REMOVE_PREFIX);
        StringTools.capitalizeOn(this.getName(), stringBuffer);
        return stringBuffer.toString();
    }

    public Iterator candidateGetMethods() {
        return this.getDeclaringType().candidateGetMethodsFor(this);
    }

    public Iterator candidateSetMethods() {
        return this.getDeclaringType().candidateSetMethodsFor(this);
    }

    public Iterator candidateValueGetMethods() {
        return this.canHaveValueType() ? this.getDeclaringType().candidateGetMethodsFor(this.getValueType()) : NullIterator.instance();
    }

    public Iterator candidateValueSetMethods() {
        return this.canHaveValueType() ? this.getDeclaringType().candidateSetMethodsFor(this.getValueType()) : NullIterator.instance();
    }

    public Iterator candidateAddMethods() {
        return this.canHaveItemType() ? (this.canHaveKeyType() ? this.getDeclaringType().candidateAddMethodsFor(this.getKeyType(), this.getItemType()) : this.getDeclaringType().candidateAddMethodsFor(this.getItemType())) : NullIterator.instance();
    }

    public Iterator candidateRemoveMethods() {
        return this.canHaveItemType() ? this.getDeclaringType().candidateRemoveMethodsFor(this.canHaveKeyType() ? this.getKeyType() : this.getItemType()) : NullIterator.instance();
    }

    public Collection allAccessors() {
        ArrayList<MWMethod> arrayList = new ArrayList<MWMethod>();
        arrayList.add(this.getGetMethod());
        arrayList.add(this.getSetMethod());
        arrayList.add(this.getValueGetMethod());
        arrayList.add(this.getValueSetMethod());
        arrayList.add(this.getAddMethod());
        arrayList.add(this.getRemoveMethod());
        return arrayList;
    }

    public MWMethodCodeGenPolicy accessorCodeGenPolicy(MWMethod mWMethod, MWClassCodeGenPolicy mWClassCodeGenPolicy) {
        if (mWMethod == this.getGetMethod()) {
            return new MWGetMethodCodeGenPolicy(mWMethod, this, mWClassCodeGenPolicy);
        }
        if (mWMethod == this.getSetMethod()) {
            return new MWSetMethodCodeGenPolicy(mWMethod, this, mWClassCodeGenPolicy);
        }
        if (mWMethod == this.getValueGetMethod()) {
            return new MWValueGetMethodCodeGenPolicy(mWMethod, this, mWClassCodeGenPolicy);
        }
        if (mWMethod == this.getValueSetMethod()) {
            return new MWValueSetMethodCodeGenPolicy(mWMethod, this, mWClassCodeGenPolicy);
        }
        if (mWMethod == this.getAddMethod()) {
            return new MWAddMethodCodeGenPolicy(mWMethod, this, mWClassCodeGenPolicy);
        }
        if (mWMethod == this.getRemoveMethod()) {
            return new MWRemoveMethodCodeGenPolicy(mWMethod, this, mWClassCodeGenPolicy);
        }
        throw new IllegalArgumentException(mWMethod.toString());
    }

    public MWMethodCodeGenPolicy accessorCodeGenPolicy(MWMethod mWMethod, MWClassAttribute mWClassAttribute, boolean bl, MWClassCodeGenPolicy mWClassCodeGenPolicy) {
        if (mWClassAttribute == null) {
            return this.accessorCodeGenPolicy(mWMethod, mWClassCodeGenPolicy);
        }
        if (mWMethod == this.getAddMethod()) {
            return new MWAddMethodCodeGenPolicy(mWMethod, this, mWClassAttribute, mWClassCodeGenPolicy);
        }
        if (mWMethod == this.getRemoveMethod()) {
            return new MWRemoveMethodCodeGenPolicy(mWMethod, this, mWClassAttribute, bl, mWClassCodeGenPolicy);
        }
        throw new IllegalArgumentException(mWMethod.toString());
    }

    public boolean isEjb20Attribute() {
        return this.getDeclaringType().ejb20AttributesContains(this);
    }

    public boolean isUnknownPrimaryKeyAttribute() {
        return this.getDeclaringType().getUnknownPrimaryKeyAttribute() == this;
    }

    NonreflectiveAttributeDefinition attributeDefinition() {
        NonreflectiveAttributeDefinition nonreflectiveAttributeDefinition = new NonreflectiveAttributeDefinition();
        nonreflectiveAttributeDefinition.setAccessLevel(this.getModifier().accessLevel());
        nonreflectiveAttributeDefinition.setType(this.typeDeclaration.declaration());
        nonreflectiveAttributeDefinition.setName(this.getName());
        return nonreflectiveAttributeDefinition;
    }

    public String initialValueSourceCode(MWClassCodeGenPolicy mWClassCodeGenPolicy) {
        MWClass mWClass = null;
        mWClass = this.isValueHolder() ? this.getValueType() : (this.getDimensionality() == 0 ? this.getType() : null);
        if (mWClass == null) {
            return this.initialValueSourceCodeFor(null);
        }
        if (mWClass.isContainer()) {
            return this.initialContainerValueSourceCodeFor(mWClassCodeGenPolicy, mWClass);
        }
        return this.initialValueSourceCodeFor(null);
    }

    private String initialContainerValueSourceCodeFor(MWClassCodeGenPolicy mWClassCodeGenPolicy, MWClass mWClass) {
        MWClass mWClass2 = mWClass.defaultContainerImplementationType();
        if (mWClass2 != null) {
            return this.initialValueSourceCodeFor(mWClass2);
        }
        StringBuffer stringBuffer = new StringBuffer(200);
        stringBuffer.append(CR);
        stringBuffer.append("\t\t");
        stringBuffer.append(mWClassCodeGenPolicy.collectionImplementationClassNotDeterminedComment(this, mWClass));
        stringBuffer.append(CR);
        stringBuffer.append("\t\t");
        this.appendInitialValueSourceCodeFor(null, stringBuffer);
        return stringBuffer.toString();
    }

    public String initialValueSourceCodeFor(MWClass mWClass) {
        StringBuffer stringBuffer = new StringBuffer(80);
        this.appendInitialValueSourceCodeFor(mWClass, stringBuffer);
        return stringBuffer.toString();
    }

    private void appendInitialValueSourceCodeFor(MWClass mWClass, StringBuffer stringBuffer) {
        boolean bl;
        if (mWClass != null && !mWClass.isInstantiable()) {
            mWClass = null;
        }
        if (bl = this.isValueHolder()) {
            stringBuffer.append("new ");
            stringBuffer.append(this.typeFor(ValueHolder.class).getName());
            stringBuffer.append('(');
        }
        if (mWClass != null) {
            stringBuffer.append("new ");
            stringBuffer.append(mWClass.getName());
            stringBuffer.append("()");
        }
        if (bl) {
            stringBuffer.append(')');
        }
    }

    private MWClass objectType() {
        return this.typeFor(Object.class);
    }

    void refresh(ExternalField externalField) {
        if (!this.getName().equals(externalField.getName())) {
            throw new IllegalArgumentException(externalField.getName());
        }
        this.getModifier().refresh(externalField.getModifiers());
        this.typeDeclaration.refresh(externalField.getType());
    }

    void removeAccessorMethod(MWMethod mWMethod) {
        if (mWMethod == this.getGetMethod()) {
            this.setGetMethod(null);
        } else if (mWMethod == this.getSetMethod()) {
            this.setSetMethod(null);
        } else if (mWMethod == this.getValueGetMethod()) {
            this.setValueGetMethod(null);
        } else if (mWMethod == this.getValueSetMethod()) {
            this.setValueSetMethod(null);
        } else if (mWMethod == this.getAddMethod()) {
            this.setAddMethod(null);
        } else if (mWMethod == this.getRemoveMethod()) {
            this.setRemoveMethod(null);
        }
    }

    private void updateNestedTypes(MWClass mWClass) {
        if (this.getDimensionality() == 0) {
            if (this.getType().isValueHolder() && !mWClass.isValueHolder()) {
                this.setValueType(mWClass);
            }
            if (this.getType().isContainer() && !mWClass.isContainer() && this.itemTypeHandle.getType() == null) {
                this.setItemType(mWClass);
            }
        }
        this.updateNestedTypes();
    }

    private void updateNestedTypes() {
        this.updateValueType();
        this.updateContainerTypes();
    }

    private void updateValueType() {
        if (!this.canHaveValueType()) {
            this.setValueType(null);
        }
        this.updateValueGetAndSetMethods();
    }

    private void updateContainerTypes() {
        this.updateItemType();
        this.updateKeyType();
    }

    private void updateItemType() {
        if (!this.canHaveItemType()) {
            this.setItemType(null);
        }
        this.updateAddAndRemoveMethods();
    }

    private void updateKeyType() {
        if (!this.canHaveKeyType()) {
            this.setKeyType(null);
        }
        this.updateAddAndRemoveMethods();
    }

    private void updateGetAndSetMethods() {
        this.updateZeroArgumentMethod(this.getGetMethod(), this.getType(), this.getDimensionality());
        this.updateSingleArgumentMethod(this.getSetMethod(), this.getType(), this.getDimensionality());
    }

    private void updateValueGetAndSetMethods() {
        if (this.canHaveValueType()) {
            this.updateZeroArgumentMethod(this.getValueGetMethod(), this.getValueType());
            this.updateSingleArgumentMethod(this.getValueSetMethod(), this.getValueType());
        } else {
            this.setValueGetMethod(null);
            this.setValueSetMethod(null);
        }
    }

    private void updateAddAndRemoveMethods() {
        if (this.canHaveItemType()) {
            if (this.canHaveKeyType()) {
                this.updateTwoArgumentMethod(this.getAddMethod(), this.getKeyType(), this.getItemType());
                this.updateSingleArgumentMethod(this.getRemoveMethod(), this.getKeyType());
            } else {
                this.updateSingleArgumentMethod(this.getAddMethod(), this.getItemType());
                this.updateSingleArgumentMethod(this.getRemoveMethod(), this.getItemType());
            }
        } else {
            this.setAddMethod(null);
            this.setRemoveMethod(null);
        }
    }

    private void updateZeroArgumentMethod(MWMethod mWMethod, MWClass mWClass) {
        this.updateZeroArgumentMethod(mWMethod, mWClass, 0);
    }

    private void updateZeroArgumentMethod(MWMethod mWMethod, MWClass mWClass, int n) {
        if (mWMethod == null) {
            return;
        }
        mWMethod.setReturnType(mWClass);
        mWMethod.setReturnTypeDimensionality(n);
        mWMethod.clearMethodParameters();
    }

    private void updateSingleArgumentMethod(MWMethod mWMethod, MWClass mWClass) {
        this.updateSingleArgumentMethod(mWMethod, mWClass, 0);
    }

    private void updateSingleArgumentMethod(MWMethod mWMethod, MWClass mWClass, int n) {
        this.updateMethodArguments(mWMethod, new MWClass[]{mWClass}, new int[]{n});
    }

    private void updateTwoArgumentMethod(MWMethod mWMethod, MWClass mWClass, MWClass mWClass2) {
        this.updateTwoArgumentMethod(mWMethod, mWClass, 0, mWClass2, 0);
    }

    private void updateTwoArgumentMethod(MWMethod mWMethod, MWClass mWClass, int n, MWClass mWClass2, int n2) {
        this.updateMethodArguments(mWMethod, new MWClass[]{mWClass, mWClass2}, new int[]{n, n2});
    }

    private void updateMethodArguments(MWMethod mWMethod, MWClass[] mWClassArray, int[] nArray) {
        if (mWMethod == null) {
            return;
        }
        int n = mWClassArray.length;
        if (nArray.length != n) {
            throw new IllegalArgumentException("arrays are different lengths");
        }
        if (mWMethod.methodParametersSize() == 0) {
            for (int i = 0; i < n; ++i) {
                mWMethod.addMethodParameter(mWClassArray[i], nArray[i]);
            }
        } else {
            int n2;
            while (mWMethod.methodParametersSize() < n) {
                n2 = mWMethod.methodParametersSize();
                mWMethod.addMethodParameter(mWClassArray[n2], nArray[n2]);
            }
            while (mWMethod.methodParametersSize() > n) {
                mWMethod.removeMethodParameter(n);
            }
            for (n2 = 0; n2 < n; ++n2) {
                mWMethod.getMethodParameter(n2).setType(mWClassArray[n2]);
                mWMethod.getMethodParameter(n2).setDimensionality(nArray[n2]);
            }
        }
    }

    private void updateAccessorNames() {
        if (this.getGetMethod() != null) {
            this.getGetMethod().setName(this.standardGetMethodName());
        }
        if (this.getSetMethod() != null) {
            this.getSetMethod().setName(this.standardSetMethodName());
        }
        if (this.getValueGetMethod() != null) {
            this.getValueGetMethod().setName(this.standardValueGetMethodName());
        }
        if (this.getValueSetMethod() != null) {
            this.getValueSetMethod().setName(this.standardValueSetMethodName());
        }
        if (this.getAddMethod() != null) {
            this.getAddMethod().setName(this.standardAddMethodName());
        }
        if (this.getRemoveMethod() != null) {
            this.getRemoveMethod().setName(this.standardRemoveMethodName());
        }
    }

    public void generateAllAccessors() {
        this.generateGetAndSetMethods();
        if (this.canHaveValueGetAndSetMethods()) {
            this.generateValueGetAndSetMethods();
        }
        if (this.canHaveAddAndRemoveMethods()) {
            this.generateAddAndRemoveMethods();
        }
    }

    public void generateGetAndSetMethods() {
        this.generateGetMethod();
        this.generateSetMethod();
    }

    private void generateGetMethod() {
        MWMethod mWMethod = this.guessGetMethod();
        if (mWMethod == null) {
            mWMethod = this.getDeclaringType().addMethod(this.standardGetMethodName());
            if (this.isValueHolder() || this.isContainer()) {
                mWMethod.getModifier().setProtected(true);
            }
        }
        mWMethod.setReturnType(this.getType());
        mWMethod.setReturnTypeDimensionality(this.getDimensionality());
        mWMethod.getModifier().setAbstract(this.isEjb20Attribute());
        if (this.isEjb20Attribute()) {
            mWMethod.getModifier().setPublic(true);
        }
        this.setGetMethod(mWMethod);
    }

    private void generateSetMethod() {
        MWMethod mWMethod = this.guessSetMethod();
        if (mWMethod == null) {
            mWMethod = this.getDeclaringType().addMethod(this.standardSetMethodName());
            mWMethod.addMethodParameter(this.getType(), this.getDimensionality());
            if (this.isValueHolder() || this.isContainer()) {
                mWMethod.getModifier().setProtected(true);
            }
        }
        mWMethod.getModifier().setAbstract(this.isEjb20Attribute());
        if (this.isEjb20Attribute()) {
            mWMethod.getModifier().setPublic(true);
            mWMethod.setReturnType(this.getRepository().voidType());
        }
        this.setSetMethod(mWMethod);
    }

    public void generateValueGetAndSetMethods() {
        this.generateValueGetMethod();
        this.generateValueSetMethod();
    }

    public void generateValueGetMethod() {
        MWMethod mWMethod = this.guessValueGetMethod();
        if (mWMethod == null) {
            mWMethod = this.getDeclaringType().addMethod(this.standardValueGetMethodName());
            if (this.getValueType().isContainer()) {
                mWMethod.getModifier().setProtected(true);
            }
        }
        mWMethod.setReturnType(this.getValueType());
        mWMethod.setReturnTypeDimensionality(0);
        this.setValueGetMethod(mWMethod);
    }

    public void generateValueSetMethod() {
        MWMethod mWMethod = this.guessValueSetMethod();
        if (mWMethod == null) {
            mWMethod = this.getDeclaringType().addMethod(this.standardValueSetMethodName());
            mWMethod.addMethodParameter(this.getValueType());
            if (this.getValueType().isContainer()) {
                mWMethod.getModifier().setProtected(true);
            }
        }
        this.setValueSetMethod(mWMethod);
    }

    public void generateAddAndRemoveMethods() {
        this.generateAddMethod();
        this.generateRemoveMethod();
    }

    private void generateAddMethod() {
        if (this.canHaveKeyType()) {
            this.generateAddMethodForMap();
        } else {
            this.generateAddMethodForCollection();
        }
    }

    private void generateAddMethodForCollection() {
        MWMethod mWMethod = this.guessAddMethod();
        if (mWMethod == null) {
            mWMethod = this.getDeclaringType().addMethod(this.standardAddMethodName());
            mWMethod.addMethodParameter(this.getItemType());
        }
        this.setAddMethod(mWMethod);
    }

    private void generateAddMethodForMap() {
        MWMethod mWMethod = this.guessAddMethod();
        if (mWMethod == null) {
            mWMethod = this.getDeclaringType().addMethod(this.standardAddMethodName());
            mWMethod.addMethodParameter(this.getKeyType());
            mWMethod.addMethodParameter(this.getItemType());
        }
        this.setAddMethod(mWMethod);
    }

    private void generateRemoveMethod() {
        if (this.canHaveKeyType()) {
            this.generateRemoveMethodForMap();
        } else {
            this.generateRemoveMethodForCollection();
        }
    }

    private void generateRemoveMethodForCollection() {
        MWMethod mWMethod = this.guessRemoveMethod();
        if (mWMethod == null) {
            mWMethod = this.getDeclaringType().addMethod(this.standardRemoveMethodName());
            mWMethod.addMethodParameter(this.getItemType());
        }
        this.setRemoveMethod(mWMethod);
    }

    private void generateRemoveMethodForMap() {
        MWMethod mWMethod = this.guessRemoveMethod();
        if (mWMethod == null) {
            mWMethod = this.getDeclaringType().addMethod(this.standardRemoveMethodName());
            mWMethod.addMethodParameter(this.getKeyType());
        }
        this.setRemoveMethod(mWMethod);
    }

    public void setEjb20Attribute(boolean bl) {
        if (this.isEjb20Attribute() == bl) {
            return;
        }
        if (bl) {
            this.getDeclaringType().changeToEjb20(this);
        } else {
            this.getDeclaringType().changeFromEjb20(this);
        }
    }

    public void addAccessorCodeGenPoliciesTo(MWClassCodeGenPolicy mWClassCodeGenPolicy) {
        this.addAccessorCodeGenPolicyTo(mWClassCodeGenPolicy, this.getGetMethod());
        this.addAccessorCodeGenPolicyTo(mWClassCodeGenPolicy, this.getSetMethod());
        this.addAccessorCodeGenPolicyTo(mWClassCodeGenPolicy, this.getValueGetMethod());
        this.addAccessorCodeGenPolicyTo(mWClassCodeGenPolicy, this.getValueSetMethod());
        this.addAccessorCodeGenPolicyTo(mWClassCodeGenPolicy, this.getAddMethod());
        this.addAccessorCodeGenPolicyTo(mWClassCodeGenPolicy, this.getRemoveMethod());
    }

    private void addAccessorCodeGenPolicyTo(MWClassCodeGenPolicy mWClassCodeGenPolicy, MWMethod mWMethod) {
        if (mWMethod != null) {
            mWClassCodeGenPolicy.addAccessorCodeGenPolicy(mWMethod, this.accessorCodeGenPolicy(mWMethod, mWClassCodeGenPolicy));
        }
    }

    public void addAccessorCodeGenPoliciesTo(MWClassCodeGenPolicy mWClassCodeGenPolicy, MWMapping mWMapping) {
        this.addAccessorCodeGenPolicyTo(mWClassCodeGenPolicy, mWMapping, this.getAddMethod());
        this.addAccessorCodeGenPolicyTo(mWClassCodeGenPolicy, mWMapping, this.getRemoveMethod());
    }

    private void addAccessorCodeGenPolicyTo(MWClassCodeGenPolicy mWClassCodeGenPolicy, MWMapping mWMapping, MWMethod mWMethod) {
        if (mWMethod != null) {
            mWClassCodeGenPolicy.addAccessorCodeGenPolicy(mWMethod, mWMapping.accessorCodeGenPolicy(mWMethod, mWClassCodeGenPolicy));
        }
    }

    protected void addProblemsTo(List list) {
        super.addProblemsTo(list);
    }

    void addDescriptorProblemsTo(List list) {
        this.checkGetMethod(list);
        this.checkSetMethod(list);
        this.checkValueGetMethod(list);
        this.checkValueSetMethod(list);
        this.checkAddMethod(list);
        this.checkRemoveMethod(list);
    }

    private void checkGetMethod(List list) {
        MWMethod mWMethod = this.getGetMethod();
        if (mWMethod == null) {
            return;
        }
        if (mWMethod.methodParametersSize() == 0) {
            if (!mWMethod.getReturnTypeDeclaration().mightBeAssignableFrom(this.typeDeclaration)) {
                list.add(this.buildProblem("0901", this.getName()));
            }
        } else {
            list.add(this.buildProblem("0902", this.getName()));
        }
    }

    private void checkSetMethod(List list) {
        MWMethod mWMethod = this.getSetMethod();
        if (mWMethod == null) {
            return;
        }
        if (mWMethod.methodParametersSize() == 1) {
            if (!mWMethod.getMethodParameter().mightBeAssignableTo(this.typeDeclaration)) {
                list.add(this.buildProblem("0903", this.getName()));
            }
        } else {
            list.add(this.buildProblem("0904", this.getName()));
        }
    }

    private void checkValueGetMethod(List list) {
        MWMethod mWMethod = this.getValueGetMethod();
        if (mWMethod == null) {
            return;
        }
        if (mWMethod.methodParametersSize() == 0) {
            if (!mWMethod.getReturnTypeDeclaration().mightBeAssignableFrom(this.getValueType())) {
                list.add(this.buildProblem("0905", this.getName()));
            }
        } else {
            list.add(this.buildProblem("0906", this.getName()));
        }
    }

    private void checkValueSetMethod(List list) {
        MWMethod mWMethod = this.getValueSetMethod();
        if (mWMethod == null) {
            return;
        }
        if (mWMethod.methodParametersSize() == 1) {
            if (!mWMethod.getMethodParameter().mightBeAssignableTo(this.getValueType())) {
                list.add(this.buildProblem("0907", this.getName()));
            }
        } else {
            list.add(this.buildProblem("0908", this.getName()));
        }
    }

    private void checkAddMethod(List list) {
        if (this.canHaveItemType()) {
            if (this.canHaveKeyType()) {
                this.checkAddMethodForMap(list);
            } else {
                this.checkAddMethodForCollection(list);
            }
        }
    }

    private void checkAddMethodForCollection(List list) {
        MWMethod mWMethod = this.getAddMethod();
        if (mWMethod == null) {
            return;
        }
        if (mWMethod.methodParametersSize() == 1) {
            if (!mWMethod.getMethodParameter().mightBeAssignableTo(this.getItemType())) {
                list.add(this.buildProblem("0909", this.getName()));
            }
        } else {
            list.add(this.buildProblem("0910", this.getName()));
        }
    }

    private void checkAddMethodForMap(List list) {
        MWMethod mWMethod = this.getAddMethod();
        if (mWMethod == null) {
            return;
        }
        if (mWMethod.methodParametersSize() == 2) {
            if (!mWMethod.getMethodParameter(0).mightBeAssignableTo(this.getKeyType()) || !mWMethod.getMethodParameter(1).mightBeAssignableTo(this.getItemType())) {
                list.add(this.buildProblem("0911", this.getName()));
            }
        } else {
            list.add(this.buildProblem("0912", this.getName()));
        }
    }

    private void checkRemoveMethod(List list) {
        if (this.canHaveItemType()) {
            if (this.canHaveKeyType()) {
                this.checkRemoveMethodForMap(list);
            } else {
                this.checkRemoveMethodForCollection(list);
            }
        }
    }

    private void checkRemoveMethodForCollection(List list) {
        MWMethod mWMethod = this.getRemoveMethod();
        if (mWMethod == null) {
            return;
        }
        if (mWMethod.methodParametersSize() == 1) {
            if (!mWMethod.getMethodParameter().mightBeAssignableTo(this.getItemType())) {
                list.add(this.buildProblem("0913", this.getName()));
            }
        } else {
            list.add(this.buildProblem("0914", this.getName()));
        }
    }

    private void checkRemoveMethodForMap(List list) {
        MWMethod mWMethod = this.getRemoveMethod();
        if (mWMethod == null) {
            return;
        }
        if (mWMethod.methodParametersSize() == 1) {
            if (!mWMethod.getMethodParameter().mightBeAssignableTo(this.getKeyType())) {
                list.add(this.buildProblem("0915", this.getName()));
            }
        } else {
            list.add(this.buildProblem("0916", this.getName()));
        }
    }

    protected void addChildrenTo(List list) {
        super.addChildrenTo(list);
        list.add(this.modifier);
        list.add(this.typeDeclaration);
        list.add(this.getMethodHandle);
        list.add(this.setMethodHandle);
        list.add(this.valueGetMethodHandle);
        list.add(this.valueSetMethodHandle);
        list.add(this.addMethodHandle);
        list.add(this.removeMethodHandle);
        list.add(this.itemTypeHandle);
        list.add(this.valueTypeHandle);
        list.add(this.keyTypeHandle);
    }

    private MWHandle.NodeReferenceScrubber buildGetMethodScrubber() {
        return new MWHandle.NodeReferenceScrubber(){

            public void nodeReferenceRemoved(Node node, MWHandle mWHandle) {
                MWClassAttribute.this.setGetMethod(null);
            }

            public String toString() {
                return "MWClassAttribute.buildGetMethodScrubber()";
            }
        };
    }

    private MWHandle.NodeReferenceScrubber buildSetMethodScrubber() {
        return new MWHandle.NodeReferenceScrubber(){

            public void nodeReferenceRemoved(Node node, MWHandle mWHandle) {
                MWClassAttribute.this.setSetMethod(null);
            }

            public String toString() {
                return "MWClassAttribute.buildSetMethodScrubber()";
            }
        };
    }

    private MWHandle.NodeReferenceScrubber buildValueGetMethodScrubber() {
        return new MWHandle.NodeReferenceScrubber(){

            public void nodeReferenceRemoved(Node node, MWHandle mWHandle) {
                MWClassAttribute.this.setValueGetMethod(null);
            }

            public String toString() {
                return "MWClassAttribute.buildValueGetMethodScrubber()";
            }
        };
    }

    private MWHandle.NodeReferenceScrubber buildValueSetMethodScrubber() {
        return new MWHandle.NodeReferenceScrubber(){

            public void nodeReferenceRemoved(Node node, MWHandle mWHandle) {
                MWClassAttribute.this.setValueSetMethod(null);
            }

            public String toString() {
                return "MWClassAttribute.buildValueSetMethodScrubber()";
            }
        };
    }

    private MWHandle.NodeReferenceScrubber buildAddMethodScrubber() {
        return new MWHandle.NodeReferenceScrubber(){

            public void nodeReferenceRemoved(Node node, MWHandle mWHandle) {
                MWClassAttribute.this.setAddMethod(null);
            }

            public String toString() {
                return "MWClassAttribute.buildAddMethodScrubber()";
            }
        };
    }

    private MWHandle.NodeReferenceScrubber buildRemoveMethodScrubber() {
        return new MWHandle.NodeReferenceScrubber(){

            public void nodeReferenceRemoved(Node node, MWHandle mWHandle) {
                MWClassAttribute.this.setRemoveMethod(null);
            }

            public String toString() {
                return "MWClassAttribute.buildRemoveMethodScrubber()";
            }
        };
    }

    private MWHandle.NodeReferenceScrubber buildValueTypeScrubber() {
        return new MWHandle.NodeReferenceScrubber(){

            public void nodeReferenceRemoved(Node node, MWHandle mWHandle) {
                MWClassAttribute.this.setValueType(null);
            }

            public String toString() {
                return "MWClassAttribute.buildValueTypeScrubber()";
            }
        };
    }

    private MWHandle.NodeReferenceScrubber buildItemTypeScrubber() {
        return new MWHandle.NodeReferenceScrubber(){

            public void nodeReferenceRemoved(Node node, MWHandle mWHandle) {
                MWClassAttribute.this.setItemType(null);
            }

            public String toString() {
                return "MWClassAttribute.buildItemTypeScrubber()";
            }
        };
    }

    private MWHandle.NodeReferenceScrubber buildKeyTypeScrubber() {
        return new MWHandle.NodeReferenceScrubber(){

            public void nodeReferenceRemoved(Node node, MWHandle mWHandle) {
                MWClassAttribute.this.setKeyType(null);
            }

            public String toString() {
                return "MWClassAttribute.buildKeyTypeScrubber()";
            }
        };
    }

    public void nodeRenamed(Node node) {
        super.nodeRenamed(node);
        if (this.getType() == node) {
            this.firePropertyChanged(DECLARATION_PROPERTY, TYPE_PROPERTY);
        }
    }

    public String displayString() {
        return this.getName();
    }

    public void toString(StringBuffer stringBuffer) {
        stringBuffer.append(this.getName());
    }

    public String nameWithType() {
        return this.nameWithType(true);
    }

    public String nameWithShortType() {
        return this.nameWithType(false);
    }

    private String nameWithType(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.name);
        stringBuffer.append(" : ");
        if (bl) {
            this.typeDeclaration.printDeclarationOn(stringBuffer);
        } else {
            this.typeDeclaration.printShortDeclarationOn(stringBuffer);
        }
        return stringBuffer.toString();
    }

    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor xMLDescriptor = new XMLDescriptor();
        xMLDescriptor.setJavaClass(MWClassAttribute.class);
        xMLDescriptor.addDirectMapping(NAME_PROPERTY, "name/text()");
        XMLDirectMapping xMLDirectMapping = (XMLDirectMapping)xMLDescriptor.addDirectMapping("modifier", "getModifierForTopLink", "setModifierForTopLink", "modifier/text()");
        xMLDirectMapping.setNullValue((Object)new Integer(0));
        XMLCompositeObjectMapping xMLCompositeObjectMapping = new XMLCompositeObjectMapping();
        xMLCompositeObjectMapping.setAttributeName("typeDeclaration");
        xMLCompositeObjectMapping.setReferenceClass(MWTypeDeclaration.class);
        xMLCompositeObjectMapping.setXPath("type-declaration");
        xMLDescriptor.addMapping((DatabaseMapping)xMLCompositeObjectMapping);
        XMLCompositeObjectMapping xMLCompositeObjectMapping2 = new XMLCompositeObjectMapping();
        xMLCompositeObjectMapping2.setAttributeName("valueTypeHandle");
        xMLCompositeObjectMapping2.setGetMethodName("getValueTypeHandleForTopLink");
        xMLCompositeObjectMapping2.setSetMethodName("setValueTypeHandleForTopLink");
        xMLCompositeObjectMapping2.setReferenceClass(MWClassHandle.class);
        xMLCompositeObjectMapping2.setXPath("value-type-handle");
        xMLDescriptor.addMapping((DatabaseMapping)xMLCompositeObjectMapping2);
        XMLCompositeObjectMapping xMLCompositeObjectMapping3 = new XMLCompositeObjectMapping();
        xMLCompositeObjectMapping3.setAttributeName("itemTypeHandle");
        xMLCompositeObjectMapping3.setGetMethodName("getItemTypeHandleForTopLink");
        xMLCompositeObjectMapping3.setSetMethodName("setItemTypeHandleForTopLink");
        xMLCompositeObjectMapping3.setReferenceClass(MWClassHandle.class);
        xMLCompositeObjectMapping3.setXPath("item-type-handle");
        xMLDescriptor.addMapping((DatabaseMapping)xMLCompositeObjectMapping3);
        XMLCompositeObjectMapping xMLCompositeObjectMapping4 = new XMLCompositeObjectMapping();
        xMLCompositeObjectMapping4.setAttributeName("keyTypeHandle");
        xMLCompositeObjectMapping4.setGetMethodName("getKeyTypeHandleForTopLink");
        xMLCompositeObjectMapping4.setSetMethodName("setKeyTypeHandleForTopLink");
        xMLCompositeObjectMapping4.setReferenceClass(MWClassHandle.class);
        xMLCompositeObjectMapping4.setXPath("key-type-handle");
        xMLDescriptor.addMapping((DatabaseMapping)xMLCompositeObjectMapping4);
        XMLCompositeObjectMapping xMLCompositeObjectMapping5 = new XMLCompositeObjectMapping();
        xMLCompositeObjectMapping5.setAttributeName("getMethodHandle");
        xMLCompositeObjectMapping5.setGetMethodName("getGetMethodHandleForTopLink");
        xMLCompositeObjectMapping5.setSetMethodName("setGetMethodHandleForTopLink");
        xMLCompositeObjectMapping5.setReferenceClass(MWMethodHandle.class);
        xMLCompositeObjectMapping5.setXPath("get-method-handle");
        xMLDescriptor.addMapping((DatabaseMapping)xMLCompositeObjectMapping5);
        XMLCompositeObjectMapping xMLCompositeObjectMapping6 = new XMLCompositeObjectMapping();
        xMLCompositeObjectMapping6.setAttributeName("setMethodHandle");
        xMLCompositeObjectMapping6.setGetMethodName("getSetMethodHandleForTopLink");
        xMLCompositeObjectMapping6.setSetMethodName("setSetMethodHandleForTopLink");
        xMLCompositeObjectMapping6.setReferenceClass(MWMethodHandle.class);
        xMLCompositeObjectMapping6.setXPath("set-method-handle");
        xMLDescriptor.addMapping((DatabaseMapping)xMLCompositeObjectMapping6);
        XMLCompositeObjectMapping xMLCompositeObjectMapping7 = new XMLCompositeObjectMapping();
        xMLCompositeObjectMapping7.setAttributeName("valueGetMethodHandle");
        xMLCompositeObjectMapping7.setGetMethodName("getValueGetMethodHandleForTopLink");
        xMLCompositeObjectMapping7.setSetMethodName("setValueGetMethodHandleForTopLink");
        xMLCompositeObjectMapping7.setReferenceClass(MWMethodHandle.class);
        xMLCompositeObjectMapping7.setXPath("value-get-method-handle");
        xMLDescriptor.addMapping((DatabaseMapping)xMLCompositeObjectMapping7);
        XMLCompositeObjectMapping xMLCompositeObjectMapping8 = new XMLCompositeObjectMapping();
        xMLCompositeObjectMapping8.setAttributeName("valueSetMethodHandle");
        xMLCompositeObjectMapping8.setGetMethodName("getValueSetMethodHandleForTopLink");
        xMLCompositeObjectMapping8.setSetMethodName("setValueSetMethodHandleForTopLink");
        xMLCompositeObjectMapping8.setReferenceClass(MWMethodHandle.class);
        xMLCompositeObjectMapping8.setXPath("value-set-method-handle");
        xMLDescriptor.addMapping((DatabaseMapping)xMLCompositeObjectMapping8);
        XMLCompositeObjectMapping xMLCompositeObjectMapping9 = new XMLCompositeObjectMapping();
        xMLCompositeObjectMapping9.setAttributeName("addMethodHandle");
        xMLCompositeObjectMapping9.setGetMethodName("getAddMethodHandleForTopLink");
        xMLCompositeObjectMapping9.setSetMethodName("setAddMethodHandleForTopLink");
        xMLCompositeObjectMapping9.setReferenceClass(MWMethodHandle.class);
        xMLCompositeObjectMapping9.setXPath("add-method-handle");
        xMLDescriptor.addMapping((DatabaseMapping)xMLCompositeObjectMapping9);
        XMLCompositeObjectMapping xMLCompositeObjectMapping10 = new XMLCompositeObjectMapping();
        xMLCompositeObjectMapping10.setAttributeName("removeMethodHandle");
        xMLCompositeObjectMapping10.setGetMethodName("getRemoveMethodHandleForTopLink");
        xMLCompositeObjectMapping10.setSetMethodName("setRemoveMethodHandleForTopLink");
        xMLCompositeObjectMapping10.setReferenceClass(MWMethodHandle.class);
        xMLCompositeObjectMapping10.setXPath("remove-method-handle");
        xMLDescriptor.addMapping((DatabaseMapping)xMLCompositeObjectMapping10);
        return xMLDescriptor;
    }

    private int getModifierForTopLink() {
        return this.modifier.getCode();
    }

    private void setModifierForTopLink(int n) {
        this.modifier.setCodeForTopLink(n);
    }

    private MWClassHandle getValueTypeHandleForTopLink() {
        return this.valueTypeHandle.getType() == null ? null : this.valueTypeHandle;
    }

    private void setValueTypeHandleForTopLink(MWClassHandle mWClassHandle) {
        MWHandle.NodeReferenceScrubber nodeReferenceScrubber = this.buildValueTypeScrubber();
        this.valueTypeHandle = mWClassHandle == null ? new MWClassHandle(this, nodeReferenceScrubber) : mWClassHandle.setScrubber(nodeReferenceScrubber);
    }

    private MWClassHandle getItemTypeHandleForTopLink() {
        return this.itemTypeHandle.getType() == null ? null : this.itemTypeHandle;
    }

    private void setItemTypeHandleForTopLink(MWClassHandle mWClassHandle) {
        MWHandle.NodeReferenceScrubber nodeReferenceScrubber = this.buildItemTypeScrubber();
        this.itemTypeHandle = mWClassHandle == null ? new MWClassHandle(this, nodeReferenceScrubber) : mWClassHandle.setScrubber(nodeReferenceScrubber);
    }

    private MWClassHandle getKeyTypeHandleForTopLink() {
        return this.keyTypeHandle.getType() == null ? null : this.keyTypeHandle;
    }

    private void setKeyTypeHandleForTopLink(MWClassHandle mWClassHandle) {
        MWHandle.NodeReferenceScrubber nodeReferenceScrubber = this.buildKeyTypeScrubber();
        this.keyTypeHandle = mWClassHandle == null ? new MWClassHandle(this, nodeReferenceScrubber) : mWClassHandle.setScrubber(nodeReferenceScrubber);
    }

    private MWMethodHandle getGetMethodHandleForTopLink() {
        return this.getMethodHandle.getMethod() == null ? null : this.getMethodHandle;
    }

    private void setGetMethodHandleForTopLink(MWMethodHandle mWMethodHandle) {
        MWHandle.NodeReferenceScrubber nodeReferenceScrubber = this.buildGetMethodScrubber();
        this.getMethodHandle = mWMethodHandle == null ? new MWMethodHandle(this, nodeReferenceScrubber) : mWMethodHandle.setScrubber(nodeReferenceScrubber);
    }

    private MWMethodHandle getSetMethodHandleForTopLink() {
        return this.setMethodHandle.getMethod() == null ? null : this.setMethodHandle;
    }

    private void setSetMethodHandleForTopLink(MWMethodHandle mWMethodHandle) {
        MWHandle.NodeReferenceScrubber nodeReferenceScrubber = this.buildSetMethodScrubber();
        this.setMethodHandle = mWMethodHandle == null ? new MWMethodHandle(this, nodeReferenceScrubber) : mWMethodHandle.setScrubber(nodeReferenceScrubber);
    }

    private MWMethodHandle getValueGetMethodHandleForTopLink() {
        return this.valueGetMethodHandle.getMethod() == null ? null : this.valueGetMethodHandle;
    }

    private void setValueGetMethodHandleForTopLink(MWMethodHandle mWMethodHandle) {
        MWHandle.NodeReferenceScrubber nodeReferenceScrubber = this.buildValueGetMethodScrubber();
        this.valueGetMethodHandle = mWMethodHandle == null ? new MWMethodHandle(this, nodeReferenceScrubber) : mWMethodHandle.setScrubber(nodeReferenceScrubber);
    }

    private MWMethodHandle getValueSetMethodHandleForTopLink() {
        return this.valueSetMethodHandle.getMethod() == null ? null : this.valueSetMethodHandle;
    }

    private void setValueSetMethodHandleForTopLink(MWMethodHandle mWMethodHandle) {
        MWHandle.NodeReferenceScrubber nodeReferenceScrubber = this.buildValueSetMethodScrubber();
        this.valueSetMethodHandle = mWMethodHandle == null ? new MWMethodHandle(this, nodeReferenceScrubber) : mWMethodHandle.setScrubber(nodeReferenceScrubber);
    }

    private MWMethodHandle getAddMethodHandleForTopLink() {
        return this.addMethodHandle.getMethod() == null ? null : this.addMethodHandle;
    }

    private void setAddMethodHandleForTopLink(MWMethodHandle mWMethodHandle) {
        MWHandle.NodeReferenceScrubber nodeReferenceScrubber = this.buildAddMethodScrubber();
        this.addMethodHandle = mWMethodHandle == null ? new MWMethodHandle(this, nodeReferenceScrubber) : mWMethodHandle.setScrubber(nodeReferenceScrubber);
    }

    private MWMethodHandle getRemoveMethodHandleForTopLink() {
        return this.removeMethodHandle.getMethod() == null ? null : this.removeMethodHandle;
    }

    private void setRemoveMethodHandleForTopLink(MWMethodHandle mWMethodHandle) {
        MWHandle.NodeReferenceScrubber nodeReferenceScrubber = this.buildRemoveMethodScrubber();
        this.removeMethodHandle = mWMethodHandle == null ? new MWMethodHandle(this, nodeReferenceScrubber) : mWMethodHandle.setScrubber(nodeReferenceScrubber);
    }
}

