/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.meta;

import java.util.List;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.mappings.XMLCompositeObjectMapping;
import org.eclipse.persistence.oxm.mappings.XMLDirectMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWModel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.handles.MWClassHandle;
import org.eclipse.persistence.tools.workbench.mappingsmodel.handles.MWHandle;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClass;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWMethodParameter;
import org.eclipse.persistence.tools.workbench.mappingsmodel.spi.meta.ExternalClassDescription;
import org.eclipse.persistence.tools.workbench.utility.ClassTools;
import org.eclipse.persistence.tools.workbench.utility.node.Node;

public final class MWTypeDeclaration
extends MWModel {
    private MWClassHandle typeHandle;
    private volatile int dimensionality;
    private static final String BRACKETS = "[]";

    private MWTypeDeclaration() {
    }

    public MWTypeDeclaration(MWModel mWModel) {
        super(mWModel);
    }

    public MWTypeDeclaration(MWModel mWModel, MWClass mWClass) {
        this(mWModel, mWClass, 0);
    }

    public MWTypeDeclaration(MWModel mWModel, MWClass mWClass, int n) {
        this(mWModel);
        this.setType(mWClass);
        this.setDimensionality(n);
    }

    MWTypeDeclaration(MWModel mWModel, ExternalClassDescription externalClassDescription) {
        this(mWModel);
        this.refresh(externalClassDescription);
    }

    protected void initialize(Node node) {
        super.initialize(node);
        this.typeHandle = new MWClassHandle(this, this.buildTypeScrubber());
    }

    public MWClass getType() {
        return this.typeHandle.getType();
    }

    public void setType(MWClass mWClass) {
        if (mWClass == null) {
            throw new NullPointerException();
        }
        this.typeHandle.setType(mWClass);
    }

    public int getDimensionality() {
        return this.dimensionality;
    }

    public void setDimensionality(int n) {
        if (n != 0 && !this.allowsDimension()) {
            throw new IllegalArgumentException("The type declaration 'void' cannot have a dimension: " + new Integer(n));
        }
        this.dimensionality = n;
    }

    public String typeName() {
        return this.getType().getName();
    }

    public String shortTypeName() {
        return this.getType().shortName();
    }

    boolean matches(MWTypeDeclaration mWTypeDeclaration) {
        return this.dimensionality == mWTypeDeclaration.getDimensionality() && this.getType() == mWTypeDeclaration.getType();
    }

    boolean hasSameSignatureAs(ExternalClassDescription externalClassDescription) {
        return this.dimensionality == externalClassDescription.getArrayDepth() && this.getType() == this.typeNamed(externalClassDescription.getElementTypeName());
    }

    boolean hasSameSignatureAs(MWMethodParameter mWMethodParameter) {
        return this.dimensionality == mWMethodParameter.getDimensionality() && this.getType() == mWMethodParameter.getType();
    }

    boolean isArray() {
        return !this.isScalar();
    }

    boolean isScalar() {
        return this.dimensionality == 0;
    }

    boolean isVoid() {
        return this.dimensionality == 0 && this.getType().isVoid();
    }

    boolean isValueHolder() {
        return this.dimensionality == 0 && this.getType().isValueHolder();
    }

    boolean isTLValueHolder() {
        return this.dimensionality == 0 && "oracle.toplink.indirection.ValueHolderInterface".equals(this.getType().fullName());
    }

    boolean isBooleanPrimitive() {
        return this.dimensionality == 0 && this.getType().isBooleanPrimitive();
    }

    boolean allowsDimension() {
        return !this.getType().isVoid();
    }

    boolean isAssignableFrom(MWClass mWClass) {
        return this.isAssignableFrom(mWClass, 0);
    }

    boolean mightBeAssignableFrom(MWClass mWClass) {
        return this.mightBeAssignableFrom(mWClass, 0);
    }

    boolean isAssignableFrom(MWClass mWClass, int n) {
        return this.targetIsAssignableFromSource(this.getType(), this.dimensionality, mWClass, n);
    }

    boolean mightBeAssignableFrom(MWClass mWClass, int n) {
        return this.targetMightBeAssignableFromSource(this.getType(), this.dimensionality, mWClass, n);
    }

    boolean isAssignableFrom(MWTypeDeclaration mWTypeDeclaration) {
        return this.isAssignableFrom(mWTypeDeclaration.getType(), mWTypeDeclaration.getDimensionality());
    }

    boolean mightBeAssignableFrom(MWTypeDeclaration mWTypeDeclaration) {
        return this.mightBeAssignableFrom(mWTypeDeclaration.getType(), mWTypeDeclaration.getDimensionality());
    }

    boolean isAssignableTo(MWClass mWClass) {
        return this.isAssignableTo(mWClass, 0);
    }

    boolean mightBeAssignableTo(MWClass mWClass) {
        return this.mightBeAssignableTo(mWClass, 0);
    }

    boolean isAssignableTo(MWClass mWClass, int n) {
        return this.targetIsAssignableFromSource(mWClass, n, this.getType(), this.dimensionality);
    }

    boolean mightBeAssignableTo(MWClass mWClass, int n) {
        return this.targetMightBeAssignableFromSource(mWClass, n, this.getType(), this.dimensionality);
    }

    boolean isAssignableTo(MWTypeDeclaration mWTypeDeclaration) {
        return this.isAssignableTo(mWTypeDeclaration.getType(), mWTypeDeclaration.getDimensionality());
    }

    boolean mightBeAssignableTo(MWTypeDeclaration mWTypeDeclaration) {
        return this.mightBeAssignableTo(mWTypeDeclaration.getType(), mWTypeDeclaration.getDimensionality());
    }

    private boolean targetIsAssignableFromSource(MWClass mWClass, int n, MWClass mWClass2, int n2) {
        if (n == n2) {
            return mWClass.isAssignableFrom(mWClass2);
        }
        return this.targetIsAssignableFromSource2(mWClass, n, mWClass2, n2);
    }

    private boolean targetIsAssignableFromSource2(MWClass mWClass, int n, MWClass mWClass2, int n2) {
        if (n > n2) {
            return false;
        }
        return mWClass.isObject() || mWClass.isCloneable() || mWClass.isSerializable();
    }

    private boolean targetMightBeAssignableFromSource(MWClass mWClass, int n, MWClass mWClass2, int n2) {
        if (n == n2) {
            return mWClass.mightBeAssignableFrom(mWClass2);
        }
        return this.targetIsAssignableFromSource2(mWClass, n, mWClass2, n2);
    }

    boolean isAssignableToCollection() {
        return this.dimensionality == 0 && this.getType().isAssignableToCollection();
    }

    boolean mightBeAssignableToCollection() {
        return this.dimensionality == 0 && this.getType().mightBeAssignableToCollection();
    }

    boolean isAssignableToList() {
        return this.dimensionality == 0 && this.getType().isAssignableToList();
    }

    boolean mightBeAssignableToList() {
        return this.dimensionality == 0 && this.getType().mightBeAssignableToList();
    }

    boolean isAssignableToSet() {
        return this.dimensionality == 0 && this.getType().isAssignableToSet();
    }

    boolean mightBeAssignableToSet() {
        return this.dimensionality == 0 && this.getType().mightBeAssignableToSet();
    }

    boolean isAssignableToMap() {
        return this.dimensionality == 0 && this.getType().isAssignableToMap();
    }

    boolean mightBeAssignableToMap() {
        return this.dimensionality == 0 && this.getType().mightBeAssignableToMap();
    }

    boolean isAssignableToIndirectContainer() {
        return this.dimensionality == 0 && this.getType().isAssignableToIndirectContainer();
    }

    boolean mightBeAssignableToIndirectContainer() {
        return this.dimensionality == 0 && this.getType().mightBeAssignableToIndirectContainer();
    }

    protected void addChildrenTo(List list) {
        super.addChildrenTo(list);
        list.add(this.typeHandle);
    }

    private MWHandle.NodeReferenceScrubber buildTypeScrubber() {
        return new MWHandle.NodeReferenceScrubber(){

            public void nodeReferenceRemoved(Node node, MWHandle mWHandle) {
                MWTypeDeclaration.this.setType(null);
            }

            public String toString() {
                return "MWTypeDeclaration.buildTypeScrubber()";
            }
        };
    }

    void refresh(ExternalClassDescription externalClassDescription) {
        this.setType(this.typeNamed(externalClassDescription.getElementTypeName()));
        this.setDimensionality(externalClassDescription.getArrayDepth());
    }

    public String displayString() {
        int n = this.dimensionality;
        if (n == 0) {
            return this.typeName();
        }
        String string = this.typeName();
        StringBuffer stringBuffer = new StringBuffer(string.length() + (n << 1));
        stringBuffer.append(string);
        int n2 = n;
        while (n2-- > 0) {
            stringBuffer.append(BRACKETS);
        }
        return stringBuffer.toString();
    }

    public String displayStringWithPackage() {
        int n = this.dimensionality;
        if (n == 0) {
            return this.getType().displayStringWithPackage();
        }
        StringBuffer stringBuffer = new StringBuffer(200);
        stringBuffer.append(this.shortTypeName());
        int n2 = n;
        while (n2-- > 0) {
            stringBuffer.append(BRACKETS);
        }
        if (this.getType().isReferenceType()) {
            stringBuffer.append(" (");
            stringBuffer.append(this.getType().packageDisplayName());
            stringBuffer.append(')');
        }
        return stringBuffer.toString();
    }

    public void toString(StringBuffer stringBuffer) {
        stringBuffer.append(this.displayString());
    }

    void printDeclarationOn(StringBuffer stringBuffer) {
        stringBuffer.append(this.typeName());
        this.printBracketsOn(stringBuffer);
    }

    void printShortDeclarationOn(StringBuffer stringBuffer) {
        stringBuffer.append(this.shortTypeName());
        this.printBracketsOn(stringBuffer);
    }

    String declaration() {
        StringBuffer stringBuffer = new StringBuffer(200);
        this.printDeclarationOn(stringBuffer);
        return stringBuffer.toString();
    }

    void printSignatureOn(StringBuffer stringBuffer) {
        this.printDeclarationOn(stringBuffer);
    }

    void printShortSignatureOn(StringBuffer stringBuffer) {
        this.printShortDeclarationOn(stringBuffer);
    }

    String defaultReturnValueString() {
        StringBuffer stringBuffer = new StringBuffer(200);
        this.printDefaultReturnValueOn(stringBuffer);
        return stringBuffer.toString();
    }

    void printDefaultReturnValueOn(StringBuffer stringBuffer) {
        if (this.isArray()) {
            stringBuffer.append("null");
        } else {
            this.getType().printDefaultReturnValueOn(stringBuffer);
        }
    }

    private void printBracketsOn(StringBuffer stringBuffer) {
        int n = this.dimensionality;
        while (n-- > 0) {
            stringBuffer.append(BRACKETS);
        }
    }

    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor xMLDescriptor = new XMLDescriptor();
        xMLDescriptor.setJavaClass(MWTypeDeclaration.class);
        XMLCompositeObjectMapping xMLCompositeObjectMapping = new XMLCompositeObjectMapping();
        xMLCompositeObjectMapping.setAttributeName("typeHandle");
        xMLCompositeObjectMapping.setReferenceClass(MWClassHandle.class);
        xMLCompositeObjectMapping.setGetMethodName("getTypeHandleForTopLink");
        xMLCompositeObjectMapping.setSetMethodName("setTypeHandleForTopLink");
        xMLCompositeObjectMapping.setXPath("type-handle");
        xMLDescriptor.addMapping((DatabaseMapping)xMLCompositeObjectMapping);
        XMLDirectMapping xMLDirectMapping = (XMLDirectMapping)xMLDescriptor.addDirectMapping("dimensionality", "dimensionality/text()");
        xMLDirectMapping.setNullValue((Object)new Integer(0));
        return xMLDescriptor;
    }

    private MWClassHandle getTypeHandleForTopLink() {
        return this.typeHandle.getType() == null ? null : this.typeHandle;
    }

    private void setTypeHandleForTopLink(MWClassHandle mWClassHandle) {
        MWHandle.NodeReferenceScrubber nodeReferenceScrubber = this.buildTypeScrubber();
        this.typeHandle = mWClassHandle == null ? new MWClassHandle(this, nodeReferenceScrubber) : mWClassHandle.setScrubber(nodeReferenceScrubber);
    }

    public static XMLDescriptor legacy60BuildDescriptor() {
        XMLDescriptor xMLDescriptor = MWModel.legacy60BuildStandardDescriptor();
        xMLDescriptor.setJavaClass(MWTypeDeclaration.class);
        XMLCompositeObjectMapping xMLCompositeObjectMapping = new XMLCompositeObjectMapping();
        xMLCompositeObjectMapping.setAttributeName("typeHandle");
        xMLCompositeObjectMapping.setReferenceClass(MWClassHandle.class);
        xMLCompositeObjectMapping.setGetMethodName("getTypeHandleForTopLink");
        xMLCompositeObjectMapping.setSetMethodName("setTypeHandleForTopLink");
        xMLCompositeObjectMapping.setXPath("type-handle");
        xMLDescriptor.addMapping((DatabaseMapping)xMLCompositeObjectMapping);
        XMLDirectMapping xMLDirectMapping = (XMLDirectMapping)xMLDescriptor.addDirectMapping("dimensionality", "dimensionality/text()");
        xMLDirectMapping.setNullValue((Object)new Integer(0));
        return xMLDescriptor;
    }

    private void legacy50SetTypeNameForTopLink(String string) {
        this.typeHandle = new MWClassHandle(this, this.buildTypeScrubber());
        if (ClassTools.classNamedIsArray(string)) {
            this.dimensionality = ClassTools.arrayDepthForClassNamed(string);
            string = ClassTools.elementTypeNameForClassNamed(string);
        }
        this.typeHandle.legacySetTypeNameForTopLink(string);
    }

    private String legacyGetTypeNameForTopLink() {
        return this.typeHandle.legacyGetTypeNameForTopLink();
    }
}

