/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.project.relational;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.mappings.XMLCompositeObjectMapping;
import org.eclipse.persistence.oxm.mappings.XMLDirectMapping;
import org.eclipse.persistence.sessions.DatabaseLogin;
import org.eclipse.persistence.sessions.DatasourceLogin;
import org.eclipse.persistence.sessions.factories.TableCreatorClassGenerator;
import org.eclipse.persistence.tools.schemaframework.TableCreator;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWModel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWDatabase;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWTable;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.TableStringHolder;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.DescriptorStringHolder;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.InterfaceDescriptorCreationException;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWMappingDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational.MWAggregateDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational.MWInterfaceDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational.MWRelationalDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational.MWTableDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.relational.MWAggregateMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.relational.MWManyToManyMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClass;
import org.eclipse.persistence.tools.workbench.mappingsmodel.project.MWProject;
import org.eclipse.persistence.tools.workbench.mappingsmodel.project.MWProjectDefaultsPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.project.relational.MWRelationalProjectDefaultsPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.project.relational.MWSequencingPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.project.relational.MWTableGenerationPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.spi.SPIManager;
import org.eclipse.persistence.tools.workbench.platformsmodel.DatabasePlatform;
import org.eclipse.persistence.tools.workbench.utility.ClassTools;
import org.eclipse.persistence.tools.workbench.utility.Classpath;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.iterators.FilteringIterator;
import org.eclipse.persistence.tools.workbench.utility.node.Node;
import org.eclipse.persistence.tools.workbench.utility.string.PartialStringComparatorEngine;
import org.eclipse.persistence.tools.workbench.utility.string.StringHolder;

public final class MWRelationalProject
extends MWProject {
    private MWDatabase tableRepository;
    private MWSequencingPolicy sequencingPolicy;
    private volatile String tableCreatorSourceClassName;
    public static final String TABLE_CREATOR_SOURCE_CLASS_NAME_PROPERTY = "tableCreatorSourceClassName";
    private volatile String tableCreatorSourceDirectoryName;
    public static final String TABLE_CREATOR_SOURCE_DIRECTORY_NAME_PROPERTY = "tableCreatorSourceDirectoryName";
    private MWTableGenerationPolicy tableGenerationPolicy;
    private volatile boolean generateDeprecatedDirectMappings;
    public static final String GENERATE_DEPRECATED_DIRECT_MAPPINGS_PROPERTY = "generateDeprecatedDirectMappings";

    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor xMLDescriptor = new XMLDescriptor();
        xMLDescriptor.setJavaClass(MWRelationalProject.class);
        xMLDescriptor.getInheritancePolicy().setParentClass(MWProject.class);
        XMLCompositeObjectMapping xMLCompositeObjectMapping = new XMLCompositeObjectMapping();
        xMLCompositeObjectMapping.setAttributeName("tableRepository");
        xMLCompositeObjectMapping.setReferenceClass(MWDatabase.class);
        xMLCompositeObjectMapping.setXPath("table-repository");
        xMLDescriptor.addMapping((DatabaseMapping)xMLCompositeObjectMapping);
        XMLCompositeObjectMapping xMLCompositeObjectMapping2 = new XMLCompositeObjectMapping();
        xMLCompositeObjectMapping2.setAttributeName("sequencingPolicy");
        xMLCompositeObjectMapping2.setReferenceClass(MWSequencingPolicy.class);
        xMLCompositeObjectMapping2.setXPath("sequencing");
        xMLDescriptor.addMapping((DatabaseMapping)xMLCompositeObjectMapping2);
        XMLDirectMapping xMLDirectMapping = new XMLDirectMapping();
        xMLDirectMapping.setAttributeName(TABLE_CREATOR_SOURCE_CLASS_NAME_PROPERTY);
        xMLDirectMapping.setXPath("table-creator/class/text()");
        xMLDirectMapping.setNullValue((Object)"");
        xMLDescriptor.addMapping((DatabaseMapping)xMLDirectMapping);
        XMLDirectMapping xMLDirectMapping2 = new XMLDirectMapping();
        xMLDirectMapping2.setAttributeName(TABLE_CREATOR_SOURCE_DIRECTORY_NAME_PROPERTY);
        xMLDirectMapping2.setSetMethodName("setTableCreatorSourceDirectoryNameForTopLink");
        xMLDirectMapping2.setGetMethodName("getTableCreatorSourceDirectoryNameForTopLink");
        xMLDirectMapping2.setXPath("table-creator/directory/text()");
        xMLDirectMapping2.setNullValue((Object)"");
        xMLDescriptor.addMapping((DatabaseMapping)xMLDirectMapping2);
        XMLCompositeObjectMapping xMLCompositeObjectMapping3 = new XMLCompositeObjectMapping();
        xMLCompositeObjectMapping3.setAttributeName("tableGenerationPolicy");
        xMLCompositeObjectMapping3.setReferenceClass(MWTableGenerationPolicy.class);
        xMLCompositeObjectMapping3.setXPath("table-generation");
        xMLDescriptor.addMapping((DatabaseMapping)xMLCompositeObjectMapping3);
        XMLDirectMapping xMLDirectMapping3 = new XMLDirectMapping();
        xMLDirectMapping3.setAttributeName(GENERATE_DEPRECATED_DIRECT_MAPPINGS_PROPERTY);
        xMLDirectMapping3.setXPath("generate-deprecated-direct-mappings/text()");
        xMLDirectMapping3.setNullValue((Object)Boolean.FALSE);
        xMLDescriptor.addMapping((DatabaseMapping)xMLDirectMapping3);
        return xMLDescriptor;
    }

    private MWRelationalProject() {
    }

    public MWRelationalProject(String string, SPIManager sPIManager, DatabasePlatform databasePlatform) {
        super(string, sPIManager);
        this.tableRepository = new MWDatabase(this, databasePlatform);
    }

    protected void initialize(Node node) {
        super.initialize(node);
        this.sequencingPolicy = new MWSequencingPolicy(this);
        this.tableCreatorSourceClassName = "";
        this.tableCreatorSourceDirectoryName = "";
        this.tableGenerationPolicy = new MWTableGenerationPolicy(this);
        this.generateDeprecatedDirectMappings = false;
    }

    protected MWProjectDefaultsPolicy buildDefaultsPolicy() {
        return new MWRelationalProjectDefaultsPolicy(this);
    }

    protected void addChildrenTo(List list) {
        super.addChildrenTo(list);
        list.add(this.tableRepository);
        list.add(this.sequencingPolicy);
        list.add(this.tableGenerationPolicy);
    }

    public void notifyExpressionsToRecalculateQueryables() {
        Iterator iterator = this.descriptors();
        while (iterator.hasNext()) {
            ((MWRelationalDescriptor)iterator.next()).notifyExpressionsToRecalculateQueryables();
        }
    }

    public MWModel getMetaDataRepository() {
        return this.getTableRepository();
    }

    public MWDatabase getTableRepository() {
        return this.tableRepository;
    }

    public MWSequencingPolicy getSequencingPolicy() {
        return this.sequencingPolicy;
    }

    public MWTableGenerationPolicy getTableGenerationPolicy() {
        return this.tableGenerationPolicy;
    }

    public String getTableCreatorSourceClassName() {
        return this.tableCreatorSourceClassName;
    }

    public void setTableCreatorSourceClassName(String string) {
        String string2 = this.tableCreatorSourceClassName;
        this.tableCreatorSourceClassName = string;
        this.firePropertyChanged(TABLE_CREATOR_SOURCE_CLASS_NAME_PROPERTY, string2, string);
    }

    public String getTableCreatorSourceDirectoryName() {
        return this.tableCreatorSourceDirectoryName;
    }

    public void setTableCreatorSourceDirectoryName(String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        String string2 = this.tableCreatorSourceDirectoryName;
        this.tableCreatorSourceDirectoryName = string;
        this.firePropertyChanged(TABLE_CREATOR_SOURCE_DIRECTORY_NAME_PROPERTY, string2, string);
    }

    protected MWDescriptor createDescriptorForType(MWClass mWClass) throws InterfaceDescriptorCreationException {
        if (mWClass.isInterface()) {
            return new MWInterfaceDescriptor(this, mWClass, mWClass.fullName());
        }
        return new MWTableDescriptor(this, mWClass, mWClass.fullName());
    }

    public MWAggregateDescriptor addAggregateDescriptorForType(MWClass mWClass) {
        MWAggregateDescriptor mWAggregateDescriptor = new MWAggregateDescriptor(this, mWClass, mWClass.fullName());
        this.addDescriptor(mWAggregateDescriptor);
        return mWAggregateDescriptor;
    }

    public Iterator descriptorsThatImplement(final MWRelationalDescriptor mWRelationalDescriptor) {
        return new FilteringIterator(this.tableDescriptors()){

            protected boolean accept(Object object) {
                return ((MWDescriptor)object).getMWClass().allInterfacesContains(mWRelationalDescriptor.getMWClass());
            }
        };
    }

    public Iterator tableDescriptors() {
        return new FilteringIterator(this.descriptors()){

            protected boolean accept(Object object) {
                return ((MWRelationalDescriptor)object).isTableDescriptor();
            }
        };
    }

    public Iterator aggregateDescriptors() {
        return new FilteringIterator(this.descriptors()){

            protected boolean accept(Object object) {
                return ((MWRelationalDescriptor)object).isAggregateDescriptor();
            }
        };
    }

    public Iterator interfaceDescriptors() {
        return new FilteringIterator(this.descriptors()){

            protected boolean accept(Object object) {
                return ((MWRelationalDescriptor)object).isInterfaceDescriptor();
            }
        };
    }

    public Iterator allWriteableManyToManyMappings() {
        return new FilteringIterator(this.allWriteableMappings()){

            protected boolean accept(Object object) {
                return (MWMapping)object instanceof MWManyToManyMapping;
            }
        };
    }

    public Iterator interfaceDescriptorsThatImplement(final MWMappingDescriptor mWMappingDescriptor) {
        return new FilteringIterator(this.interfaceDescriptors()){

            protected boolean accept(Object object) {
                return ((MWInterfaceDescriptor)object).hasImplementor(mWMappingDescriptor);
            }
        };
    }

    public boolean canAutomapDescriptors() {
        return this.getDatabase().tablesSize() > 0;
    }

    protected void matchClassesAndMetaData(Collection collection) {
        super.matchClassesAndMetaData(collection);
        StringHolder[] stringHolderArray = this.buildMetaDataDescriptorStringHolders(collection);
        StringHolder[] stringHolderArray2 = this.buildTableStringHolders();
        PartialStringComparatorEngine.StringHolderPair[] stringHolderPairArray = CLASS_META_DATA_NAME_COMPARATOR_ENGINE.match(stringHolderArray, stringHolderArray2);
        int n = stringHolderPairArray.length;
        while (n-- > 0) {
            PartialStringComparatorEngine.StringHolderPair stringHolderPair = stringHolderPairArray[n];
            DescriptorStringHolder descriptorStringHolder = (DescriptorStringHolder)stringHolderPair.getStringHolder1();
            TableStringHolder tableStringHolder = (TableStringHolder)stringHolderPair.getStringHolder2();
            if (descriptorStringHolder == null || tableStringHolder == null || !(stringHolderPair.getScore() > 0.45)) continue;
            ((MWTableDescriptor)descriptorStringHolder.getDescriptor()).setPrimaryTable(tableStringHolder.getTable());
        }
    }

    private TableStringHolder[] buildTableStringHolders() {
        ArrayList arrayList = new ArrayList(this.getDatabase().tablesSize());
        CollectionTools.addAll(arrayList, this.getDatabase().tables());
        arrayList.removeAll(this.assignedTables());
        return TableStringHolder.buildHolders(arrayList);
    }

    private Set assignedTables() {
        HashSet<MWTable> hashSet = new HashSet<MWTable>(this.descriptorsSize());
        Iterator iterator = this.tableDescriptors();
        while (iterator.hasNext()) {
            hashSet.add(((MWTableDescriptor)iterator.next()).getPrimaryTable());
        }
        return hashSet;
    }

    public void exportTableCreatorSource() {
        File file = this.tableCreatorSourceFile();
        file.getParentFile().mkdirs();
        TableCreator tableCreator = new TableCreator(CollectionTools.vector(this.getDatabase().runtimeTableDefinitions()));
        tableCreator.setName(this.getName());
        TableCreatorClassGenerator tableCreatorClassGenerator = new TableCreatorClassGenerator(tableCreator);
        tableCreatorClassGenerator.setClassName(this.tableCreatorSourceClassName);
        tableCreatorClassGenerator.setPackageName(this.tableCreatorSourcePackageName());
        tableCreatorClassGenerator.setOutputFileName(file.getAbsolutePath());
        tableCreatorClassGenerator.generate();
    }

    public File tableCreatorSourceFile() {
        return new File(this.absoluteTableCreatorSourceDirectory(), Classpath.convertToJavaFileName(this.tableCreatorSourceClassName));
    }

    public File absoluteTableCreatorSourceDirectory() {
        File file = new File(this.tableCreatorSourceDirectoryName);
        if (!file.isAbsolute()) {
            file = new File(this.getSaveDirectory(), this.tableCreatorSourceDirectoryName);
        }
        return file;
    }

    public String tableCreatorSourcePackageName() {
        return ClassTools.packageNameForClassNamed(this.tableCreatorSourceClassName);
    }

    public void recalculateAggregatePathsToColumn(MWMappingDescriptor mWMappingDescriptor) {
        this.recalculateAggregatePathsToColumn(mWMappingDescriptor, null);
    }

    public void recalculateAggregatePathsToColumn(MWMappingDescriptor mWMappingDescriptor, MWAggregateMapping mWAggregateMapping) {
        Iterator iterator = this.aggregateMappingsWithReferenceDescriptor(mWMappingDescriptor);
        while (iterator.hasNext()) {
            MWAggregateMapping mWAggregateMapping2 = (MWAggregateMapping)iterator.next();
            if (mWAggregateMapping2 == mWAggregateMapping) continue;
            mWAggregateMapping2.updatePathsToFields();
            this.recalculateAggregatePathsToColumn(mWAggregateMapping2.getParentDescriptor(), mWAggregateMapping2);
        }
    }

    private Iterator aggregateMappingsWithReferenceDescriptor(final MWMappingDescriptor mWMappingDescriptor) {
        return new FilteringIterator(this.allAggregateMappings()){

            protected boolean accept(Object object) {
                return ((MWAggregateMapping)object).getReferenceDescriptor() == mWMappingDescriptor;
            }
        };
    }

    private Iterator allAggregateMappings() {
        return new FilteringIterator(this.allMappings()){

            protected boolean accept(Object object) {
                return object instanceof MWAggregateMapping;
            }
        };
    }

    public boolean isGenerateDeprecatedDirectMappings() {
        return this.generateDeprecatedDirectMappings;
    }

    public void setGenerateDeprecatedDirectMappings(boolean bl) {
        boolean bl2 = this.generateDeprecatedDirectMappings;
        this.generateDeprecatedDirectMappings = bl;
        this.firePropertyChanged(GENERATE_DEPRECATED_DIRECT_MAPPINGS_PROPERTY, bl2, bl);
    }

    protected DatasourceLogin buildRuntimeLogin() {
        DatabaseLogin databaseLogin = this.getDatabase().buildDeploymentRuntimeDatabaseLogin();
        this.getSequencingPolicy().adjustRuntimeLogin(databaseLogin);
        return databaseLogin;
    }

    private String getTableCreatorSourceDirectoryNameForTopLink() {
        return this.tableCreatorSourceDirectoryName.replace('\\', '/');
    }

    private void setTableCreatorSourceDirectoryNameForTopLink(String string) {
        this.tableCreatorSourceDirectoryName = new File(string).getPath();
    }
}

