/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.project.xml;

import java.util.Iterator;
import java.util.List;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.mappings.XMLCompositeObjectMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWModel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.project.MWProject;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.MWXmlSchema;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.MWXmlSchemaRepository;
import org.eclipse.persistence.tools.workbench.mappingsmodel.spi.SPIManager;
import org.eclipse.persistence.tools.workbench.mappingsmodel.xml.MWXmlNode;
import org.eclipse.persistence.tools.workbench.mappingsmodel.xml.SchemaChange;
import org.eclipse.persistence.tools.workbench.utility.node.Node;

public abstract class MWXmlProject
extends MWProject
implements MWXmlNode {
    private MWXmlSchemaRepository schemaRepository;

    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor xMLDescriptor = new XMLDescriptor();
        xMLDescriptor.setJavaClass(MWXmlProject.class);
        xMLDescriptor.getInheritancePolicy().setParentClass(MWProject.class);
        XMLCompositeObjectMapping xMLCompositeObjectMapping = new XMLCompositeObjectMapping();
        xMLCompositeObjectMapping.setAttributeName("schemaRepository");
        xMLCompositeObjectMapping.setReferenceClass(MWXmlSchemaRepository.class);
        xMLCompositeObjectMapping.setXPath("xml-schema-repository");
        xMLDescriptor.addMapping((DatabaseMapping)xMLCompositeObjectMapping);
        return xMLDescriptor;
    }

    protected MWXmlProject() {
    }

    protected MWXmlProject(String string, SPIManager sPIManager) {
        super(string, sPIManager);
    }

    protected void initialize(Node node) {
        super.initialize(node);
        this.schemaRepository = new MWXmlSchemaRepository(this);
    }

    protected void addChildrenTo(List list) {
        super.addChildrenTo(list);
        list.add(this.schemaRepository);
    }

    public MWXmlSchemaRepository getSchemaRepository() {
        return this.schemaRepository;
    }

    public MWModel getMetaDataRepository() {
        return this.getSchemaRepository();
    }

    public MWXmlSchema schemaNamed(String string) {
        return this.getSchemaRepository().getSchema(string);
    }

    public boolean canAutomapDescriptors() {
        return false;
    }

    public void resolveXpaths() {
        Iterator iterator = this.mappingDescriptors();
        while (iterator.hasNext()) {
            ((MWXmlNode)iterator.next()).resolveXpaths();
        }
    }

    public void schemaChanged(SchemaChange schemaChange) {
        Iterator iterator = this.mappingDescriptors();
        while (iterator.hasNext()) {
            ((MWXmlNode)iterator.next()).schemaChanged(schemaChange);
        }
    }

    protected void resolveInternalReferences() {
        Iterator iterator = this.schemaRepository.schemas();
        while (iterator.hasNext()) {
            ((MWXmlSchema)iterator.next()).resolveReferences();
        }
        super.resolveInternalReferences();
    }
}

