/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.query;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;
import org.eclipse.persistence.descriptors.InheritancePolicy;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.converters.Converter;
import org.eclipse.persistence.mappings.converters.ObjectTypeConverter;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.mappings.XMLCompositeCollectionMapping;
import org.eclipse.persistence.oxm.mappings.XMLDirectMapping;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.queries.QueryResultsCachePolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWModel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.TopLinkOption;
import org.eclipse.persistence.tools.workbench.mappingsmodel.TopLinkOptionSet;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWMappingDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClass;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.MWQuery;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.MWQueryManager;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.MWQueryParameter;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.MWReadAllQuery;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.MWReadObjectQuery;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.MWReadQuery;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWRelationalQuery;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWRelationalReadAllQuery;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWRelationalReadObjectQuery;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWReportQuery;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.xml.MWEisReadAllQuery;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.xml.MWEisReadObjectQuery;
import org.eclipse.persistence.tools.workbench.utility.NameTools;
import org.eclipse.persistence.tools.workbench.utility.iterators.CloneListIterator;
import org.eclipse.persistence.tools.workbench.utility.iterators.TransformationListIterator;
import org.eclipse.persistence.tools.workbench.utility.node.Node;

public abstract class MWAbstractQuery
extends MWModel
implements MWQuery {
    private volatile String name;
    private List parameters;
    private volatile boolean cacheQueryResults;
    private volatile boolean outerJoinAllSubclasses;
    private volatile int maximumRows;
    private volatile int firstResult;
    private volatile Integer queryTimeout;
    private volatile boolean exclusiveConnection;
    private volatile LockingModel lockMode;
    private static TopLinkOptionSet lockingOptions;
    private volatile DistinctStateModel distinctState;
    private static TopLinkOptionSet distinctStateOptions;

    public static synchronized TopLinkOptionSet lockingOptions() {
        if (lockingOptions == null) {
            ArrayList<LockingModel> arrayList = new ArrayList<LockingModel>();
            arrayList.add(new LockingModel("Use Descriptor Setting", "USE_DESCRIPTOR_SETTING_OPTION", -1));
            arrayList.add(new LockingModel("Acquire Locks", "ACQUIRE_LOCKS_OPTION", 1));
            arrayList.add(new LockingModel("Acquire Locks NO WAIT", "ACQUIRE_LOCKS_NO_WAIT_OPTION", 2));
            arrayList.add(new LockingModel("Do Not Acquire Locks", "DONT_ACQUIRE_LOCKS_OPTION", 0));
            lockingOptions = new TopLinkOptionSet(arrayList);
        }
        return lockingOptions;
    }

    public static synchronized TopLinkOptionSet distinctStateOptions() {
        if (distinctStateOptions == null) {
            ArrayList<DistinctStateModel> arrayList = new ArrayList<DistinctStateModel>();
            arrayList.add(new DistinctStateModel("Uncomputed Distinct", "UNCOMPUTED_DISTINCT_OPTION", 0));
            arrayList.add(new DistinctStateModel("Use Distinct", "USE_DISTINCT_OPTION", 1));
            arrayList.add(new DistinctStateModel("Do Not Use Distinct", "DO_NOT_USE_DISTINCT_OPTION", 2));
            distinctStateOptions = new TopLinkOptionSet(arrayList);
        }
        return distinctStateOptions;
    }

    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor xMLDescriptor = new XMLDescriptor();
        xMLDescriptor.setJavaClass(MWAbstractQuery.class);
        InheritancePolicy inheritancePolicy = xMLDescriptor.getInheritancePolicy();
        inheritancePolicy.setClassIndicatorFieldName("@type");
        inheritancePolicy.addClassIndicator(MWRelationalReadAllQuery.class, (Object)"relational-read-all");
        inheritancePolicy.addClassIndicator(MWRelationalReadObjectQuery.class, (Object)"relational-read-object");
        inheritancePolicy.addClassIndicator(MWEisReadAllQuery.class, (Object)"eis-read-all");
        inheritancePolicy.addClassIndicator(MWEisReadObjectQuery.class, (Object)"eis-read-object");
        inheritancePolicy.addClassIndicator(MWReportQuery.class, (Object)"report");
        xMLDescriptor.addDirectMapping("name", "name/text()");
        XMLCompositeCollectionMapping xMLCompositeCollectionMapping = new XMLCompositeCollectionMapping();
        xMLCompositeCollectionMapping.setAttributeName("parameters");
        xMLCompositeCollectionMapping.setReferenceClass(MWQueryParameter.class);
        xMLCompositeCollectionMapping.setXPath("parameter-list/query-parameter");
        xMLDescriptor.addMapping((DatabaseMapping)xMLCompositeCollectionMapping);
        XMLDirectMapping xMLDirectMapping = new XMLDirectMapping();
        xMLDirectMapping.setAttributeName("cacheQueryResults");
        xMLDirectMapping.setXPath("cache-query-results/text()");
        xMLDirectMapping.setNullValue((Object)Boolean.FALSE);
        xMLDescriptor.addMapping((DatabaseMapping)xMLDirectMapping);
        XMLDirectMapping xMLDirectMapping2 = new XMLDirectMapping();
        xMLDirectMapping2.setAttributeName("outerJoinAllSubclasses");
        xMLDirectMapping2.setXPath("outer-join-all-subclasses/text()");
        xMLDirectMapping2.setNullValue((Object)Boolean.FALSE);
        xMLDescriptor.addMapping((DatabaseMapping)xMLDirectMapping2);
        XMLDirectMapping xMLDirectMapping3 = new XMLDirectMapping();
        xMLDirectMapping3.setAttributeName("exclusiveConnection");
        xMLDirectMapping3.setXPath("exclusive-connection/text()");
        xMLDirectMapping3.setNullValue((Object)Boolean.FALSE);
        xMLDescriptor.addMapping((DatabaseMapping)xMLDirectMapping3);
        XMLDirectMapping xMLDirectMapping4 = new XMLDirectMapping();
        xMLDirectMapping4.setAttributeName("queryTimeout");
        xMLDirectMapping4.setXPath("query-timeout/text()");
        xMLDirectMapping4.setGetMethodName("getQueryTimeoutForTopLink");
        xMLDirectMapping4.setSetMethodName("setQueryTimeoutForTopLink");
        xMLDirectMapping4.setNullValue((Object)QUERY_TIMEOUT_UNDEFINED);
        xMLDescriptor.addMapping((DatabaseMapping)xMLDirectMapping4);
        XMLDirectMapping xMLDirectMapping5 = new XMLDirectMapping();
        xMLDirectMapping5.setAttributeName("maximumRows");
        xMLDirectMapping5.setXPath("maximum-rows/text()");
        xMLDirectMapping5.setNullValue((Object)new Integer(0));
        xMLDescriptor.addMapping((DatabaseMapping)xMLDirectMapping5);
        XMLDirectMapping xMLDirectMapping6 = new XMLDirectMapping();
        xMLDirectMapping6.setAttributeName("firstResult");
        xMLDirectMapping6.setXPath("first-result/text()");
        xMLDirectMapping6.setNullValue((Object)new Integer(0));
        xMLDescriptor.addMapping((DatabaseMapping)xMLDirectMapping6);
        XMLDirectMapping xMLDirectMapping7 = new XMLDirectMapping();
        xMLDirectMapping7.setAttributeName("lockMode");
        xMLDirectMapping7.setXPath("lock-mode/text()");
        ObjectTypeConverter objectTypeConverter = new ObjectTypeConverter();
        MWAbstractQuery.lockingOptions().addConversionValuesForTopLinkTo(objectTypeConverter);
        xMLDirectMapping7.setConverter((Converter)objectTypeConverter);
        xMLDirectMapping7.setNullValue((Object)MWAbstractQuery.lockingOptions().topLinkOptionForMWModelOption("Use Descriptor Setting"));
        xMLDescriptor.addMapping((DatabaseMapping)xMLDirectMapping7);
        XMLDirectMapping xMLDirectMapping8 = new XMLDirectMapping();
        xMLDirectMapping8.setAttributeName("distinctState");
        xMLDirectMapping8.setXPath("distinct-state/text()");
        ObjectTypeConverter objectTypeConverter2 = new ObjectTypeConverter();
        MWAbstractQuery.distinctStateOptions().addConversionValuesForTopLinkTo(objectTypeConverter2);
        xMLDirectMapping8.setConverter((Converter)objectTypeConverter2);
        xMLDirectMapping8.setNullValue((Object)MWAbstractQuery.distinctStateOptions().topLinkOptionForMWModelOption("Uncomputed Distinct"));
        xMLDescriptor.addMapping((DatabaseMapping)xMLDirectMapping8);
        return xMLDescriptor;
    }

    public static XMLDescriptor legacy60BuildDescriptor() {
        XMLDescriptor xMLDescriptor = MWModel.legacy60BuildStandardDescriptor();
        xMLDescriptor.setJavaClass(MWAbstractQuery.class);
        InheritancePolicy inheritancePolicy = xMLDescriptor.getInheritancePolicy();
        inheritancePolicy.setClassIndicatorFieldName("@type");
        inheritancePolicy.addClassIndicator(MWRelationalReadAllQuery.class, (Object)"relational-read-all");
        inheritancePolicy.addClassIndicator(MWRelationalReadObjectQuery.class, (Object)"relational-read-object");
        inheritancePolicy.addClassIndicator(MWEisReadAllQuery.class, (Object)"eis-read-all");
        inheritancePolicy.addClassIndicator(MWEisReadObjectQuery.class, (Object)"eis-read-object");
        inheritancePolicy.addClassIndicator(MWReportQuery.class, (Object)"report");
        xMLDescriptor.addDirectMapping("name", "name/text()");
        XMLCompositeCollectionMapping xMLCompositeCollectionMapping = new XMLCompositeCollectionMapping();
        xMLCompositeCollectionMapping.setAttributeName("parameters");
        xMLCompositeCollectionMapping.setReferenceClass(MWQueryParameter.class);
        xMLCompositeCollectionMapping.setXPath("parameter-list/query-parameter");
        xMLDescriptor.addMapping((DatabaseMapping)xMLCompositeCollectionMapping);
        XMLDirectMapping xMLDirectMapping = new XMLDirectMapping();
        xMLDirectMapping.setAttributeName("cacheQueryResults");
        xMLDirectMapping.setXPath("cache-query-results/text()");
        xMLDirectMapping.setNullValue((Object)Boolean.FALSE);
        xMLDescriptor.addMapping((DatabaseMapping)xMLDirectMapping);
        XMLDirectMapping xMLDirectMapping2 = new XMLDirectMapping();
        xMLDirectMapping2.setAttributeName("exclusiveConnection");
        xMLDirectMapping2.setXPath("exclusive-connection/text()");
        xMLDirectMapping2.setNullValue((Object)Boolean.FALSE);
        xMLDescriptor.addMapping((DatabaseMapping)xMLDirectMapping2);
        XMLDirectMapping xMLDirectMapping3 = new XMLDirectMapping();
        xMLDirectMapping3.setAttributeName("queryTimeout");
        xMLDirectMapping3.setXPath("query-timeout/text()");
        xMLDirectMapping3.setGetMethodName("getQueryTimeoutForTopLink");
        xMLDirectMapping3.setSetMethodName("setQueryTimeoutForTopLink");
        xMLDirectMapping3.setNullValue((Object)QUERY_TIMEOUT_UNDEFINED);
        xMLDescriptor.addMapping((DatabaseMapping)xMLDirectMapping3);
        XMLDirectMapping xMLDirectMapping4 = new XMLDirectMapping();
        xMLDirectMapping4.setAttributeName("maximumRows");
        xMLDirectMapping4.setXPath("maximum-rows/text()");
        xMLDirectMapping4.setNullValue((Object)new Integer(0));
        xMLDescriptor.addMapping((DatabaseMapping)xMLDirectMapping4);
        XMLDirectMapping xMLDirectMapping5 = new XMLDirectMapping();
        xMLDirectMapping5.setAttributeName("lockMode");
        xMLDirectMapping5.setXPath("lock-mode/text()");
        ObjectTypeConverter objectTypeConverter = new ObjectTypeConverter();
        MWAbstractQuery.lockingOptions().addConversionValuesForTopLinkTo(objectTypeConverter);
        xMLDirectMapping5.setConverter((Converter)objectTypeConverter);
        xMLDirectMapping5.setNullValue((Object)MWAbstractQuery.lockingOptions().topLinkOptionForMWModelOption("Use Descriptor Setting"));
        xMLDescriptor.addMapping((DatabaseMapping)xMLDirectMapping5);
        XMLDirectMapping xMLDirectMapping6 = new XMLDirectMapping();
        xMLDirectMapping6.setAttributeName("distinctState");
        xMLDirectMapping6.setXPath("distinct-state/text()");
        ObjectTypeConverter objectTypeConverter2 = new ObjectTypeConverter();
        MWAbstractQuery.distinctStateOptions().addConversionValuesForTopLinkTo(objectTypeConverter2);
        xMLDirectMapping6.setConverter((Converter)objectTypeConverter2);
        xMLDirectMapping6.setNullValue((Object)MWAbstractQuery.distinctStateOptions().topLinkOptionForMWModelOption("Uncomputed Distinct"));
        xMLDescriptor.addMapping((DatabaseMapping)xMLDirectMapping6);
        return xMLDescriptor;
    }

    protected MWAbstractQuery() {
    }

    protected MWAbstractQuery(MWQueryManager mWQueryManager, String string) {
        super(mWQueryManager);
        this.initialize(string);
    }

    protected void initialize(Node node) {
        super.initialize(node);
        this.parameters = new Vector();
        this.cacheQueryResults = false;
        this.outerJoinAllSubclasses = false;
        this.maximumRows = 0;
        this.firstResult = 0;
        this.queryTimeout = QUERY_TIMEOUT_UNDEFINED;
        this.exclusiveConnection = false;
        this.lockMode = (LockingModel)MWAbstractQuery.lockingOptions().topLinkOptionForMWModelOption("Use Descriptor Setting");
        this.distinctState = (DistinctStateModel)MWAbstractQuery.distinctStateOptions().topLinkOptionForMWModelOption("Uncomputed Distinct");
    }

    protected void initialize(String string) {
        this.name = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addChildrenTo(List list) {
        super.addChildrenTo(list);
        List list2 = this.parameters;
        synchronized (list2) {
            list.addAll(this.parameters);
        }
    }

    public MWMappingDescriptor getOwningDescriptor() {
        return ((MWQueryManager)this.getParent()).getOwningDescriptor();
    }

    public String signature() {
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append(this.getName());
        stringBuffer.append('(');
        ListIterator listIterator = this.parameters();
        while (listIterator.hasNext()) {
            stringBuffer.append(((MWQueryParameter)listIterator.next()).getType().getName());
            if (!listIterator.hasNext()) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    public void signatureChanged() {
        this.getProject().nodeRenamed(this);
        this.firePropertyChanged("signature", this.signature());
    }

    public Iterator queryTypes() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("READ_ALL_QUERY");
        arrayList.add("READ_OBJECT_QUERY");
        arrayList.add("REPORT_QUERY");
        return arrayList.iterator();
    }

    public MWReadAllQuery asReadAllQuery() {
        this.getQueryManager().removeQuery(this);
        MWReadAllQuery mWReadAllQuery = this.getQueryManager().addReadAllQuery(this.getName());
        ((MWAbstractQuery)((Object)mWReadAllQuery)).initializeFrom(this);
        return mWReadAllQuery;
    }

    public MWReadObjectQuery asReadObjectQuery() {
        this.getQueryManager().removeQuery(this);
        MWReadObjectQuery mWReadObjectQuery = this.getQueryManager().addReadObjectQuery(this.getName());
        ((MWAbstractQuery)((Object)mWReadObjectQuery)).initializeFrom(this);
        return mWReadObjectQuery;
    }

    public void initializeFrom(MWQuery mWQuery) {
        this.setCacheQueryResults(mWQuery.isCacheQueryResults());
        this.setExclusiveConnection(mWQuery.isExclusiveConnection());
        this.setOuterJoinAllSubclasses(mWQuery.isOuterJoinAllSubclasses());
        this.setMaximumRows(mWQuery.getMaximumRows());
        this.setFirstResult(mWQuery.getFirstResult());
        this.setQueryTimeout(mWQuery.getQueryTimeout());
        ListIterator listIterator = mWQuery.parameters();
        while (listIterator.hasNext()) {
            MWQueryParameter mWQueryParameter = (MWQueryParameter)listIterator.next();
            if (this.getParameterNamed(mWQueryParameter.getName()) != null) {
                this.removeParameter(this.getParameterNamed(mWQueryParameter.getName()));
            }
            this.addParameter(mWQueryParameter.getType(), mWQueryParameter.getName());
        }
        this.setDistinctState(mWQuery.getDistinctState());
        this.setLocking(mWQuery.getLocking());
    }

    public void initializeFrom(MWReadQuery mWReadQuery) {
        this.initializeFrom((MWQuery)mWReadQuery);
    }

    public void initializeFrom(MWReadAllQuery mWReadAllQuery) {
        this.initializeFrom((MWReadQuery)mWReadAllQuery);
    }

    public void initializeFrom(MWRelationalQuery mWRelationalQuery) {
        this.initializeFrom((MWQuery)((Object)mWRelationalQuery));
    }

    public void initializeFrom(MWReportQuery mWReportQuery) {
        this.initializeFrom((MWRelationalQuery)mWReportQuery);
    }

    public MWQueryManager getQueryManager() {
        return (MWQueryManager)this.getParent();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        String string2 = this.name;
        this.name = string;
        this.firePropertyChanged("name", string2, string);
        if (this.attributeValueHasChanged(string2, string)) {
            this.getProject().nodeRenamed(this);
        }
    }

    public MWQueryParameter addParameter(MWClass mWClass) {
        return this.addParameter(mWClass, NameTools.uniqueNameFor("arg", this.parameterNames()));
    }

    public MWQueryParameter addParameter(MWClass mWClass, String string) {
        MWQueryParameter mWQueryParameter = new MWQueryParameter(this, string, mWClass);
        this.addParameter(mWQueryParameter);
        this.signatureChanged();
        return mWQueryParameter;
    }

    private void addParameter(MWQueryParameter mWQueryParameter) {
        this.addParameter(this.parametersSize(), mWQueryParameter);
    }

    private void addParameter(int n, MWQueryParameter mWQueryParameter) {
        this.parameters.add(n, mWQueryParameter);
        this.fireItemAdded("parameters", n, mWQueryParameter);
    }

    public void removeParameter(MWQueryParameter mWQueryParameter) {
        this.removeNodeFromList(this.parameters.indexOf(mWQueryParameter), this.parameters, "parameters");
        this.signatureChanged();
    }

    public void removeParameters(Iterator iterator) {
        while (iterator.hasNext()) {
            this.removeParameter((MWQueryParameter)iterator.next());
        }
    }

    public void removParameters(Collection collection) {
        this.removeParameters(collection.iterator());
    }

    public ListIterator parameters() {
        return new CloneListIterator(this.parameters);
    }

    public int parametersSize() {
        return this.parameters.size();
    }

    public int getParameterIndex(MWQueryParameter mWQueryParameter) {
        return this.parameters.indexOf(mWQueryParameter);
    }

    public MWQueryParameter getParameter(int n) {
        return (MWQueryParameter)this.parameters.get(n);
    }

    public MWQueryParameter getParameterNamed(String string) {
        for (MWQueryParameter mWQueryParameter : this.parameters) {
            if (!mWQueryParameter.getName().equals(string)) continue;
            return mWQueryParameter;
        }
        return null;
    }

    public Iterator parameterNames() {
        return new TransformationListIterator(this.parameters()){

            protected Object transform(Object object) {
                return ((MWQueryParameter)object).getName();
            }
        };
    }

    public void moveParameterUp(MWQueryParameter mWQueryParameter) {
        int n = this.getParameterIndex(mWQueryParameter);
        this.removeParameter(mWQueryParameter);
        this.addParameter(n - 1, mWQueryParameter);
    }

    public void moveParameterDown(MWQueryParameter mWQueryParameter) {
        int n = this.getParameterIndex(mWQueryParameter);
        this.removeParameter(mWQueryParameter);
        this.addParameter(n + 1, mWQueryParameter);
    }

    public int getMaximumRows() {
        return this.maximumRows;
    }

    public void setMaximumRows(int n) {
        int n2 = this.maximumRows;
        this.maximumRows = n;
        this.firePropertyChanged("maximumRows", n2, this.maximumRows);
    }

    public int getFirstResult() {
        return this.firstResult;
    }

    public void setFirstResult(int n) {
        int n2 = this.firstResult;
        this.firstResult = n;
        this.firePropertyChanged("firstResult", n2, this.firstResult);
    }

    public Integer getQueryTimeout() {
        return this.queryTimeout;
    }

    public void setQueryTimeout(Integer n) {
        Integer n2 = this.getQueryTimeout();
        this.queryTimeout = n;
        this.firePropertyChanged("queryTimeout", n2, n);
    }

    public boolean isExclusiveConnection() {
        return this.exclusiveConnection;
    }

    public void setExclusiveConnection(boolean bl) {
        boolean bl2 = this.exclusiveConnection;
        this.exclusiveConnection = bl;
        this.firePropertyChanged("exclusiveConnection", bl2, this.exclusiveConnection);
    }

    public boolean isCacheQueryResults() {
        return this.cacheQueryResults;
    }

    public void setCacheQueryResults(boolean bl) {
        boolean bl2 = this.isCacheQueryResults();
        this.cacheQueryResults = bl;
        this.firePropertyChanged("cacheQueryResults", bl2, bl);
    }

    public boolean isOuterJoinAllSubclasses() {
        return this.outerJoinAllSubclasses;
    }

    public void setOuterJoinAllSubclasses(boolean bl) {
        boolean bl2 = this.isOuterJoinAllSubclasses();
        this.outerJoinAllSubclasses = bl;
        this.firePropertyChanged("outerJoinAllSubclasses", bl2, bl);
    }

    public DistinctStateModel getDistinctState() {
        return this.distinctState;
    }

    public void setDistinctState(DistinctStateModel distinctStateModel) {
        DistinctStateModel distinctStateModel2 = this.distinctState;
        this.distinctState = distinctStateModel;
        this.firePropertyChanged("distinctState", distinctStateModel2, this.distinctState);
    }

    public void setDistinctState(String string) {
        this.setDistinctState((DistinctStateModel)distinctStateOptions.topLinkOptionForMWModelOption(string));
    }

    private void setDistinctStateFrom(ObjectLevelReadQuery objectLevelReadQuery) {
        this.setDistinctState(this.distinctStateModelFromTopLinkModelOption(objectLevelReadQuery.getDistinctState()));
    }

    private DistinctStateModel distinctStateModelFromTopLinkModelOption(short s) {
        ListIterator listIterator = MWAbstractQuery.distinctStateOptions().toplinkOptions();
        while (listIterator.hasNext()) {
            DistinctStateModel distinctStateModel = (DistinctStateModel)listIterator.next();
            if ((Short)distinctStateModel.getTopLinkModelOption() != s) continue;
            return distinctStateModel;
        }
        throw new IllegalArgumentException();
    }

    public LockingModel getLocking() {
        return this.lockMode;
    }

    public void setLocking(LockingModel lockingModel) {
        LockingModel lockingModel2 = this.lockMode;
        this.lockMode = lockingModel;
        this.firePropertyChanged("lockMode", lockingModel2, this.lockMode);
    }

    public void setLocking(String string) {
        this.setLocking((LockingModel)MWAbstractQuery.lockingOptions().topLinkOptionForMWModelOption(string));
    }

    private void setLockingFrom(ObjectLevelReadQuery objectLevelReadQuery) {
        this.setLocking(this.lockingModelFromTopLinkModelOption(objectLevelReadQuery.getLockMode()));
    }

    private LockingModel lockingModelFromTopLinkModelOption(short s) {
        ListIterator listIterator = MWAbstractQuery.lockingOptions().toplinkOptions();
        while (listIterator.hasNext()) {
            LockingModel lockingModel = (LockingModel)listIterator.next();
            if ((Short)lockingModel.getTopLinkModelOption() != s) continue;
            return lockingModel;
        }
        throw new IllegalArgumentException();
    }

    public boolean isTopLinkReservedFinder() {
        return MWQueryManager.topLinkReservedFinderNames().contains(this.getName());
    }

    public String displayString() {
        return this.signature();
    }

    public void toString(StringBuffer stringBuffer) {
        stringBuffer.append(this.signature());
    }

    public DatabaseQuery runtimeQuery() {
        ObjectLevelReadQuery objectLevelReadQuery = this.buildRuntimeQuery();
        objectLevelReadQuery.setName(this.getName());
        ListIterator listIterator = this.parameters();
        while (listIterator.hasNext()) {
            ((MWQueryParameter)listIterator.next()).convertToRuntime(objectLevelReadQuery);
        }
        if (this.isCacheQueryResults()) {
            objectLevelReadQuery.setQueryResultsCachePolicy(new QueryResultsCachePolicy());
        }
        objectLevelReadQuery.setShouldOuterJoinSubclasses(this.isOuterJoinAllSubclasses());
        objectLevelReadQuery.setShouldUseExclusiveConnection(this.isExclusiveConnection());
        if (this.getMaximumRows() > 0) {
            objectLevelReadQuery.setMaxRows(this.getMaximumRows());
        }
        if (this.getFirstResult() > 0) {
            objectLevelReadQuery.setFirstResult(this.getFirstResult());
        }
        if (this.getQueryTimeout() != MWQuery.QUERY_TIMEOUT_UNDEFINED) {
            objectLevelReadQuery.setQueryTimeout(this.getQueryTimeout().intValue());
        }
        this.getLocking().setMWOptionOnTopLinkObject(objectLevelReadQuery);
        this.getDistinctState().setMWOptionOnTopLinkObject(objectLevelReadQuery);
        return objectLevelReadQuery;
    }

    protected abstract ObjectLevelReadQuery buildRuntimeQuery();

    public void adjustFromRuntime(ObjectLevelReadQuery objectLevelReadQuery) {
        this.parameters = new Vector();
        Iterator iterator = objectLevelReadQuery.getArguments().iterator();
        Iterator iterator2 = objectLevelReadQuery.getArgumentTypes().iterator();
        while (iterator.hasNext() && iterator2.hasNext()) {
            String string = (String)iterator.next();
            MWClass mWClass = this.typeNamed(((Class)iterator2.next()).getName());
            this.addParameter(new MWQueryParameter(this, string, mWClass));
        }
        this.setCacheQueryResults(objectLevelReadQuery.shouldCacheQueryResults());
        this.setMaximumRows(objectLevelReadQuery.getMaxRows());
        this.setFirstResult(objectLevelReadQuery.getFirstResult());
        if (objectLevelReadQuery.getQueryTimeout() == -1) {
            this.setQueryTimeout(QUERY_TIMEOUT_UNDEFINED);
        } else if (objectLevelReadQuery.getQueryTimeout() == 0) {
            this.setQueryTimeout(QUERY_TIMEOUT_NO_TIMEOUT);
        } else {
            this.setQueryTimeout(new Integer(objectLevelReadQuery.getQueryTimeout()));
        }
        this.setLockingFrom(objectLevelReadQuery);
        this.setExclusiveConnection(objectLevelReadQuery.shouldUseExclusiveConnection());
        this.setDistinctStateFrom(objectLevelReadQuery);
    }

    private Integer getQueryTimeoutForTopLink() {
        return this.queryTimeout;
    }

    private void setQueryTimeoutForTopLink(Integer n) {
        this.queryTimeout = n.equals(QUERY_TIMEOUT_NO_TIMEOUT) ? QUERY_TIMEOUT_NO_TIMEOUT : (n.equals(QUERY_TIMEOUT_UNDEFINED) ? QUERY_TIMEOUT_UNDEFINED : n);
    }

    public static class DistinctStateModel
    extends TopLinkOption {
        public DistinctStateModel(String string, String string2, short s) {
            super(string, string2, new Short(s));
        }

        public void setMWOptionOnTopLinkObject(Object object) {
            ((ObjectLevelReadQuery)object).setDistinctState(((Short)this.getTopLinkModelOption()).shortValue());
        }
    }

    public static class LockingModel
    extends TopLinkOption {
        public LockingModel(String string, String string2, short s) {
            super(string, string2, new Short(s));
        }

        public void setMWOptionOnTopLinkObject(Object object) {
            ((ObjectLevelReadQuery)object).setLockMode(((Short)this.getTopLinkModelOption()).shortValue());
        }
    }
}

