/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.query;

import java.util.List;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.mappings.XMLDirectMapping;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.MWAbstractQuery;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.MWQueryManager;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.MWReadQuery;
import org.eclipse.persistence.tools.workbench.utility.node.Node;

public abstract class MWAbstractReadQuery
extends MWAbstractQuery
implements MWReadQuery {
    private volatile boolean refreshIdentityMapResult;
    private volatile boolean refreshRemoteIdentityMapResult;
    private volatile boolean useWrapperPolicy;
    private volatile boolean maintainCache;

    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor xMLDescriptor = new XMLDescriptor();
        xMLDescriptor.setJavaClass(MWAbstractReadQuery.class);
        xMLDescriptor.getInheritancePolicy().setParentClass(MWAbstractQuery.class);
        XMLDirectMapping xMLDirectMapping = new XMLDirectMapping();
        xMLDirectMapping.setAttributeName("maintainCache");
        xMLDirectMapping.setXPath("maintain-cache/text()");
        xMLDirectMapping.setNullValue((Object)Boolean.TRUE);
        xMLDescriptor.addMapping((DatabaseMapping)xMLDirectMapping);
        XMLDirectMapping xMLDirectMapping2 = new XMLDirectMapping();
        xMLDirectMapping2.setAttributeName("refreshIdentityMapResult");
        xMLDirectMapping2.setXPath("refresh-identity-map-result/text()");
        xMLDirectMapping2.setNullValue((Object)Boolean.FALSE);
        xMLDescriptor.addMapping((DatabaseMapping)xMLDirectMapping2);
        XMLDirectMapping xMLDirectMapping3 = new XMLDirectMapping();
        xMLDirectMapping3.setAttributeName("refreshRemoteIdentityMapResult");
        xMLDirectMapping3.setXPath("refresh-remote-identity-map-result/text()");
        xMLDirectMapping3.setNullValue((Object)Boolean.FALSE);
        xMLDescriptor.addMapping((DatabaseMapping)xMLDirectMapping3);
        XMLDirectMapping xMLDirectMapping4 = new XMLDirectMapping();
        xMLDirectMapping4.setAttributeName("useWrapperPolicy");
        xMLDirectMapping4.setXPath("use-wrapper-policy/text()");
        xMLDirectMapping4.setNullValue((Object)Boolean.TRUE);
        xMLDescriptor.addMapping((DatabaseMapping)xMLDirectMapping4);
        return xMLDescriptor;
    }

    protected MWAbstractReadQuery() {
    }

    protected MWAbstractReadQuery(MWQueryManager mWQueryManager, String string) {
        super(mWQueryManager, string);
    }

    protected void initialize(Node node) {
        super.initialize(node);
        this.refreshIdentityMapResult = false;
        this.refreshRemoteIdentityMapResult = false;
        this.useWrapperPolicy = true;
        this.maintainCache = true;
    }

    public void initializeFrom(MWReadQuery mWReadQuery) {
        super.initializeFrom(mWReadQuery);
        this.setMaintainCache(mWReadQuery.isMaintainCache());
        this.setRefreshIdentityMapResult(mWReadQuery.isRefreshIdentityMapResult());
        this.setRefreshRemoteIdentityMapResult(mWReadQuery.isRefreshRemoteIdentityMapResult());
        this.setUseWrapperPolicy(mWReadQuery.isUseWrapperPolicy());
    }

    public boolean isMaintainCache() {
        return this.maintainCache;
    }

    public void setMaintainCache(boolean bl) {
        boolean bl2 = this.isMaintainCache();
        this.maintainCache = bl;
        this.firePropertyChanged("maintainCache", bl2, bl);
    }

    public boolean isRefreshIdentityMapResult() {
        return this.refreshIdentityMapResult;
    }

    public void setRefreshIdentityMapResult(boolean bl) {
        boolean bl2 = this.isRefreshIdentityMapResult();
        this.refreshIdentityMapResult = bl;
        this.setRefreshRemoteIdentityMapResult(bl);
        this.firePropertyChanged("refreshIdentityMapResult", bl2, bl);
    }

    public boolean isRefreshRemoteIdentityMapResult() {
        return this.refreshRemoteIdentityMapResult;
    }

    public void setRefreshRemoteIdentityMapResult(boolean bl) {
        boolean bl2 = this.isRefreshRemoteIdentityMapResult();
        this.refreshRemoteIdentityMapResult = bl;
        this.firePropertyChanged("refreshRemoteIdentityMapResult", bl2, bl);
    }

    public boolean isUseWrapperPolicy() {
        return this.useWrapperPolicy;
    }

    public void setUseWrapperPolicy(boolean bl) {
        boolean bl2 = this.isUseWrapperPolicy();
        this.useWrapperPolicy = bl;
        this.firePropertyChanged("useWrapperPolicy", bl2, bl);
    }

    protected void addProblemsTo(List list) {
        super.addProblemsTo(list);
        this.checkDoesNotMaintainCacheButDoesRefreshIdentityMapResults(list);
        this.checkRefreshesIdentityButDoesNotRemoteIdentityMapResults(list);
    }

    private void checkDoesNotMaintainCacheButDoesRefreshIdentityMapResults(List list) {
        if (!this.isMaintainCache()) {
            if (this.isRefreshIdentityMapResult()) {
                list.add(this.buildProblem("0243", this.getName()));
            }
            if (this.isRefreshRemoteIdentityMapResult()) {
                list.add(this.buildProblem("0242", this.getName()));
            }
        }
    }

    private void checkRefreshesIdentityButDoesNotRemoteIdentityMapResults(List list) {
        if (this.isRefreshIdentityMapResult() && !this.isRefreshRemoteIdentityMapResult()) {
            list.add(this.buildProblem("0245", this.getName()));
        }
    }

    public DatabaseQuery runtimeQuery() {
        ObjectLevelReadQuery objectLevelReadQuery = (ObjectLevelReadQuery)super.runtimeQuery();
        objectLevelReadQuery.setShouldMaintainCache(this.isMaintainCache());
        objectLevelReadQuery.setShouldRefreshIdentityMapResult(this.isRefreshIdentityMapResult());
        objectLevelReadQuery.setShouldRefreshRemoteIdentityMapResult(this.isRefreshRemoteIdentityMapResult());
        objectLevelReadQuery.setShouldUseWrapperPolicy(this.isUseWrapperPolicy());
        return objectLevelReadQuery;
    }

    public void adjustFromRuntime(ObjectLevelReadQuery objectLevelReadQuery) {
        super.adjustFromRuntime(objectLevelReadQuery);
        this.setMaintainCache(objectLevelReadQuery.shouldMaintainCache());
        this.setRefreshIdentityMapResult(objectLevelReadQuery.shouldRefreshIdentityMapResult());
        this.setRefreshRemoteIdentityMapResult(objectLevelReadQuery.shouldRefreshRemoteIdentityMapResult());
        this.setUseWrapperPolicy(objectLevelReadQuery.shouldUseWrapperPolicy());
    }
}

