/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.query;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.DescriptorQueryManager;
import org.eclipse.persistence.descriptors.InheritancePolicy;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.mappings.XMLCompositeCollectionMapping;
import org.eclipse.persistence.oxm.mappings.XMLDirectMapping;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWModel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWAbstractTransactionalPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWMappingDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWTransactionalPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClass;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.MWAbstractQuery;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.MWQuery;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.MWReadAllQuery;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.MWReadObjectQuery;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.MWReadQuery;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWRelationalQueryManager;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.xml.MWEisQueryManager;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.xml.MWOXQueryManager;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.iterators.CloneIterator;
import org.eclipse.persistence.tools.workbench.utility.node.Node;

public abstract class MWQueryManager
extends MWModel {
    private Collection queries;
    public static final String QUERY_COLLECTION = "queries";
    private volatile Integer queryTimeout;
    public static final String QUERY_TIMEOUT_PROPERTY = "queryTimeout";
    public static final Integer DEFAULT_QUERY_TIMEOUT = new Integer(-1);
    public static final Integer QUERY_TIMEOUT_NO_TIMEOUT = new Integer(0);
    public static final Integer QUERY_TIMEOUT_TIMEOUT = new Integer(1);

    protected MWQueryManager() {
    }

    protected MWQueryManager(MWAbstractTransactionalPolicy mWAbstractTransactionalPolicy) {
        super(mWAbstractTransactionalPolicy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addChildrenTo(List list) {
        super.addChildrenTo(list);
        Collection collection = this.queries;
        synchronized (collection) {
            list.addAll(this.queries);
        }
    }

    protected void initialize(Node node) {
        super.initialize(node);
        this.queries = new Vector();
        this.queryTimeout = DEFAULT_QUERY_TIMEOUT;
    }

    public MWMappingDescriptor getOwningDescriptor() {
        return (MWMappingDescriptor)((MWTransactionalPolicy)this.getParent()).getParent();
    }

    private void adjustParametersForToplinkReservedFinder(MWQuery mWQuery) {
        MWClass mWClass = this.typeFor(Object.class);
        MWClass mWClass2 = this.typeFor(String.class);
        MWClass mWClass3 = this.typeFor(Vector.class);
        if (mWQuery.getName().equals("findByPrimaryKey")) {
            mWQuery.addParameter(mWClass).setName("primaryKey");
        } else if (!mWQuery.getName().equals("findAll")) {
            if (mWQuery.getName().equals("findOneBySql")) {
                mWQuery.addParameter(mWClass2).setName("1");
                mWQuery.addParameter(mWClass3).setName("2");
            } else if (mWQuery.getName().equals("findManyBySql")) {
                mWQuery.addParameter(mWClass2).setName("1");
                mWQuery.addParameter(mWClass3).setName("2");
            } else if (mWQuery.getName().equals("findOneByEjbql")) {
                mWQuery.addParameter(mWClass2).setName("1");
                mWQuery.addParameter(mWClass3).setName("2");
            } else if (mWQuery.getName().equals("findManyByEjbql")) {
                mWQuery.addParameter(mWClass2).setName("1");
                mWQuery.addParameter(mWClass3).setName("2");
            } else if (mWQuery.getName().equals("findOneByQuery")) {
                mWQuery.addParameter(this.typeFor(ReadObjectQuery.class)).setName("1");
                mWQuery.addParameter(mWClass3).setName("2");
            } else if (mWQuery.getName().equals("findManyByQuery")) {
                mWQuery.addParameter(this.typeFor(ReadAllQuery.class)).setName("1");
                mWQuery.addParameter(mWClass3).setName("2");
            } else {
                throw new IllegalArgumentException();
            }
        }
    }

    public MWReadObjectQuery addReadObjectQuery(String string) {
        return (MWReadObjectQuery)this.addQuery(this.buildReadObjectQuery(string));
    }

    public MWReadAllQuery addReadAllQuery(String string) {
        return (MWReadAllQuery)this.addQuery(this.buildReadAllQuery(string));
    }

    public abstract boolean supportsReportQueries();

    public abstract MWReadObjectQuery buildReadObjectQuery(String var1);

    public abstract MWReadAllQuery buildReadAllQuery(String var1);

    protected MWQuery addQuery(MWQuery mWQuery) {
        this.queries.add(mWQuery);
        this.fireItemAdded(QUERY_COLLECTION, mWQuery);
        return mWQuery;
    }

    public void removeQuery(MWQuery mWQuery) {
        this.removeItemFromCollection(mWQuery, this.queries, QUERY_COLLECTION);
    }

    public Iterator queries() {
        return new CloneIterator(this.queries);
    }

    public int queriesSize() {
        return this.queries.size();
    }

    public MWQuery queryWithSignature(String string) {
        Iterator iterator = this.queries();
        while (iterator.hasNext()) {
            MWQuery mWQuery = (MWQuery)iterator.next();
            if (!mWQuery.signature().equals(string)) continue;
            return mWQuery;
        }
        return null;
    }

    public Integer getQueryTimeout() {
        return this.queryTimeout;
    }

    private Collection getQueriesForTopLink() {
        return CollectionTools.sort((List)this.queries);
    }

    private void setQueriesForTopLink(Collection collection) {
        this.queries = collection;
    }

    public void setQueryTimeout(Integer n) {
        Integer n2 = this.getQueryTimeout();
        this.queryTimeout = n;
        this.firePropertyChanged(QUERY_TIMEOUT_PROPERTY, n2, n);
    }

    public static Vector topLinkReservedFinderNames() {
        Vector<String> vector = new Vector<String>();
        vector.add("findByPrimaryKey");
        vector.add("findAll");
        vector.add("findOneBySql");
        vector.add("findManyBySql");
        vector.add("findOneByEjbql");
        vector.add("findManyByEjbql");
        vector.addAll(MWQueryManager.topLinkReservedFindByQueryFinderNames());
        return vector;
    }

    public static Vector topLinkReservedFindByQueryFinderNames() {
        Vector<String> vector = new Vector<String>();
        vector.add("findOneByQuery");
        vector.add("findManyByQuery");
        return vector;
    }

    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor xMLDescriptor = new XMLDescriptor();
        xMLDescriptor.setJavaClass(MWQueryManager.class);
        InheritancePolicy inheritancePolicy = xMLDescriptor.getInheritancePolicy();
        inheritancePolicy.setClassIndicatorFieldName("@type");
        inheritancePolicy.addClassIndicator(MWRelationalQueryManager.class, (Object)"relational");
        inheritancePolicy.addClassIndicator(MWEisQueryManager.class, (Object)"eis");
        inheritancePolicy.addClassIndicator(MWOXQueryManager.class, (Object)"ox");
        XMLDirectMapping xMLDirectMapping = new XMLDirectMapping();
        xMLDirectMapping.setAttributeName(QUERY_TIMEOUT_PROPERTY);
        xMLDirectMapping.setXPath("query-timeout/text()");
        xMLDirectMapping.setGetMethodName("getQueryTimeoutForTopLink");
        xMLDirectMapping.setSetMethodName("setQueryTimeoutForTopLink");
        xMLDirectMapping.setNullValue((Object)DEFAULT_QUERY_TIMEOUT);
        xMLDescriptor.addMapping((DatabaseMapping)xMLDirectMapping);
        XMLCompositeCollectionMapping xMLCompositeCollectionMapping = new XMLCompositeCollectionMapping();
        xMLCompositeCollectionMapping.setAttributeName(QUERY_COLLECTION);
        xMLCompositeCollectionMapping.setGetMethodName("getQueriesForTopLink");
        xMLCompositeCollectionMapping.setSetMethodName("setQueriesForTopLink");
        xMLCompositeCollectionMapping.setReferenceClass(MWAbstractQuery.class);
        xMLCompositeCollectionMapping.setXPath("query-list/query");
        xMLDescriptor.addMapping((DatabaseMapping)xMLCompositeCollectionMapping);
        return xMLDescriptor;
    }

    private Integer getQueryTimeoutForTopLink() {
        return this.queryTimeout;
    }

    private void setQueryTimeoutForTopLink(Integer n) {
        this.queryTimeout = n.equals(QUERY_TIMEOUT_NO_TIMEOUT) ? QUERY_TIMEOUT_NO_TIMEOUT : (n.equals(DEFAULT_QUERY_TIMEOUT) ? DEFAULT_QUERY_TIMEOUT : n);
    }

    public void adjustRuntimeDescriptor(ClassDescriptor classDescriptor) {
        DescriptorQueryManager descriptorQueryManager = classDescriptor.getQueryManager();
        descriptorQueryManager.setQueryTimeout(this.getQueryTimeout().intValue());
        Iterator iterator = this.queries();
        while (iterator.hasNext()) {
            descriptorQueryManager.addQuery(((MWQuery)iterator.next()).runtimeQuery());
        }
    }

    public void adjustFromRuntime(ClassDescriptor classDescriptor) {
        DescriptorQueryManager descriptorQueryManager = classDescriptor.getQueryManager();
        this.queries.clear();
        Iterator iterator = descriptorQueryManager.getQueries().values().iterator();
        while (iterator.hasNext()) {
            for (DatabaseQuery databaseQuery : (Vector)iterator.next()) {
                MWReadQuery mWReadQuery;
                if (databaseQuery instanceof ReadObjectQuery) {
                    mWReadQuery = this.addReadObjectQuery(databaseQuery.getName());
                } else {
                    if (!(databaseQuery instanceof ReadAllQuery)) continue;
                    mWReadQuery = this.addReadAllQuery(databaseQuery.getName());
                }
                mWReadQuery.adjustFromRuntime((ObjectLevelReadQuery)databaseQuery);
            }
        }
    }
}

