/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational;

import java.util.Iterator;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.DescriptorQueryManager;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational.MWRelationalTransactionalPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.MWQueryManager;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.MWReadAllQuery;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.MWReadObjectQuery;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWRelationalQuery;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWRelationalReadAllQuery;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWRelationalReadObjectQuery;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWReportQuery;
import org.eclipse.persistence.tools.workbench.utility.string.StringTools;

public final class MWRelationalQueryManager
extends MWQueryManager {
    private volatile String insertSQLString;
    public static final String INSERT_SQL_STRING_PROPERTY = "insertSQLString";
    private volatile String updateSQLString;
    public static final String UPDATE_SQL_STRING_PROPERTY = "updateSQLString";
    private volatile String deleteSQLString;
    public static final String DELETE_SQL_STRING_PROPERTY = "deleteSQLString";
    private volatile String readObjectSQLString;
    public static final String READ_OBJECT_SQL_STRING_PROPERTY = "readObjectSQLString";
    private volatile String readAllSQLString;
    public static final String READ_ALL_SQL_STRING_PROPERTY = "readAllSQLString";
    private String legacyDescriptorAlias;

    private MWRelationalQueryManager() {
    }

    public MWRelationalQueryManager(MWRelationalTransactionalPolicy mWRelationalTransactionalPolicy) {
        super(mWRelationalTransactionalPolicy);
    }

    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor xMLDescriptor = new XMLDescriptor();
        xMLDescriptor.setJavaClass(MWRelationalQueryManager.class);
        xMLDescriptor.getInheritancePolicy().setParentClass(MWQueryManager.class);
        xMLDescriptor.addDirectMapping(INSERT_SQL_STRING_PROPERTY, "insert-string/text()");
        xMLDescriptor.addDirectMapping(UPDATE_SQL_STRING_PROPERTY, "update-string/text()");
        xMLDescriptor.addDirectMapping(DELETE_SQL_STRING_PROPERTY, "delete-string/text()");
        xMLDescriptor.addDirectMapping(READ_OBJECT_SQL_STRING_PROPERTY, "read-object-string/text()");
        xMLDescriptor.addDirectMapping(READ_ALL_SQL_STRING_PROPERTY, "read-all-string/text()");
        return xMLDescriptor;
    }

    public MWReportQuery addReportQuery(String string) {
        return (MWReportQuery)this.addQuery(new MWReportQuery(this, string));
    }

    public MWReadAllQuery buildReadAllQuery(String string) {
        return new MWRelationalReadAllQuery(this, string);
    }

    public MWReadObjectQuery buildReadObjectQuery(String string) {
        return new MWRelationalReadObjectQuery(this, string);
    }

    public boolean supportsReportQueries() {
        return true;
    }

    public String getDeleteSQLString() {
        return this.deleteSQLString;
    }

    public String getInsertSQLString() {
        return this.insertSQLString;
    }

    public String getReadAllSQLString() {
        return this.readAllSQLString;
    }

    public String getReadObjectSQLString() {
        return this.readObjectSQLString;
    }

    public String getUpdateSQLString() {
        return this.updateSQLString;
    }

    public void setDeleteSQLString(String string) {
        String string2 = this.getDeleteSQLString();
        this.deleteSQLString = string;
        this.firePropertyChanged(DELETE_SQL_STRING_PROPERTY, string2, string);
    }

    public void setInsertSQLString(String string) {
        String string2 = this.getInsertSQLString();
        this.insertSQLString = string;
        this.firePropertyChanged(INSERT_SQL_STRING_PROPERTY, string2, string);
    }

    public void setReadAllSQLString(String string) {
        String string2 = this.getReadAllSQLString();
        this.readAllSQLString = string;
        this.firePropertyChanged(READ_ALL_SQL_STRING_PROPERTY, string2, string);
    }

    public void setReadObjectSQLString(String string) {
        String string2 = this.getReadObjectSQLString();
        this.readObjectSQLString = string;
        this.firePropertyChanged(READ_OBJECT_SQL_STRING_PROPERTY, string2, string);
    }

    public void setUpdateSQLString(String string) {
        String string2 = this.getUpdateSQLString();
        this.updateSQLString = string;
        this.firePropertyChanged(UPDATE_SQL_STRING_PROPERTY, string2, string);
    }

    public void notifyExpressionsToRecalculateQueryables() {
        Iterator iterator = this.queries();
        while (iterator.hasNext()) {
            ((MWRelationalQuery)iterator.next()).notifyExpressionsToRecalculateQueryables();
        }
    }

    public void adjustRuntimeDescriptor(ClassDescriptor classDescriptor) {
        super.adjustRuntimeDescriptor(classDescriptor);
        DescriptorQueryManager descriptorQueryManager = classDescriptor.getQueryManager();
        if (!StringTools.stringIsEmpty(this.getDeleteSQLString())) {
            descriptorQueryManager.setDeleteSQLString(this.getDeleteSQLString());
        }
        if (!StringTools.stringIsEmpty(this.getInsertSQLString())) {
            descriptorQueryManager.setInsertSQLString(this.getInsertSQLString());
        }
        if (!StringTools.stringIsEmpty(this.getUpdateSQLString())) {
            descriptorQueryManager.setUpdateSQLString(this.getUpdateSQLString());
        }
        if (!StringTools.stringIsEmpty(this.getReadAllSQLString())) {
            descriptorQueryManager.setReadAllSQLString(this.getReadAllSQLString());
        }
        if (!StringTools.stringIsEmpty(this.getReadObjectSQLString())) {
            descriptorQueryManager.setReadObjectSQLString(this.getReadObjectSQLString());
        }
    }

    public void adjustFromRuntimeDescriptor(ClassDescriptor classDescriptor) {
        super.adjustFromRuntime(classDescriptor);
        DescriptorQueryManager descriptorQueryManager = classDescriptor.getQueryManager();
        this.setDeleteSQLString(descriptorQueryManager.getDeleteSQLString());
        this.setInsertSQLString(descriptorQueryManager.getInsertSQLString());
        this.setUpdateSQLString(descriptorQueryManager.getUpdateSQLString());
        this.setReadAllSQLString(descriptorQueryManager.getReadAllSQLString());
        this.setReadObjectSQLString(descriptorQueryManager.getReadObjectSQLString());
    }
}

