/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational;

import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.mappings.XMLCompositeCollectionMapping;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.MWAbstractQuery;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.MWQueryable;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.MWReadAllQuery;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.MWReadObjectQuery;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWAbstractRelationalReadQuery;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWBatchReadItem;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWOrderableQuery;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWOrderingItem;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWRelationalQueryManager;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWReportQuery;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.Ordering;
import org.eclipse.persistence.tools.workbench.utility.iterators.CloneListIterator;
import org.eclipse.persistence.tools.workbench.utility.node.Node;

public final class MWRelationalReadAllQuery
extends MWAbstractRelationalReadQuery
implements MWReadAllQuery,
MWOrderableQuery {
    private List batchReadItems;
    public static final String BATCH_READ_ITEMS_LIST = "batchReadItems";
    private List orderingItems;
    public static final String ORDERING_ITEMS_LIST = "orderingItems";

    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor xMLDescriptor = new XMLDescriptor();
        xMLDescriptor.setJavaClass(MWRelationalReadAllQuery.class);
        xMLDescriptor.getInheritancePolicy().setParentClass(MWAbstractRelationalReadQuery.class);
        XMLCompositeCollectionMapping xMLCompositeCollectionMapping = new XMLCompositeCollectionMapping();
        xMLCompositeCollectionMapping.setAttributeName(BATCH_READ_ITEMS_LIST);
        xMLCompositeCollectionMapping.setReferenceClass(MWOrderingItem.class);
        xMLCompositeCollectionMapping.setXPath("batch-reads/batch-read-item");
        xMLDescriptor.addMapping((DatabaseMapping)xMLCompositeCollectionMapping);
        XMLCompositeCollectionMapping xMLCompositeCollectionMapping2 = new XMLCompositeCollectionMapping();
        xMLCompositeCollectionMapping2.setAttributeName(ORDERING_ITEMS_LIST);
        xMLCompositeCollectionMapping2.setReferenceClass(MWOrderingItem.class);
        xMLCompositeCollectionMapping2.setXPath("orderings/ordering-item");
        xMLDescriptor.addMapping((DatabaseMapping)xMLCompositeCollectionMapping2);
        return xMLDescriptor;
    }

    private MWRelationalReadAllQuery() {
    }

    MWRelationalReadAllQuery(MWRelationalQueryManager mWRelationalQueryManager, String string) {
        super(mWRelationalQueryManager, string);
    }

    protected void initialize(Node node) {
        super.initialize(node);
        this.batchReadItems = new Vector();
        this.orderingItems = new Vector();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addChildrenTo(List list) {
        super.addChildrenTo(list);
        List list2 = this.batchReadItems;
        synchronized (list2) {
            list.addAll(this.batchReadItems);
        }
        list2 = this.orderingItems;
        synchronized (list2) {
            list.addAll(this.orderingItems);
        }
    }

    public MWReportQuery asReportQuery() {
        this.getQueryManager().removeQuery(this);
        MWReportQuery mWReportQuery = ((MWRelationalQueryManager)this.getQueryManager()).addReportQuery(this.getName());
        mWReportQuery.initializeFrom(this);
        return mWReportQuery;
    }

    public MWReadObjectQuery asReadObjectQuery() {
        this.getQueryManager().removeQuery(this);
        MWReadObjectQuery mWReadObjectQuery = this.getQueryManager().addReadObjectQuery(this.getName());
        ((MWAbstractQuery)((Object)mWReadObjectQuery)).initializeFrom(this);
        return mWReadObjectQuery;
    }

    public MWReadAllQuery asReadAllQuery() {
        return this;
    }

    public String queryType() {
        return "READ_ALL_QUERY";
    }

    public void initializeFrom(MWReportQuery mWReportQuery) {
        super.initializeFrom(mWReportQuery);
        ListIterator listIterator = mWReportQuery.orderingItems();
        while (listIterator.hasNext()) {
            MWOrderingItem mWOrderingItem = (MWOrderingItem)listIterator.next();
            this.addOrderingItem(mWOrderingItem);
            mWOrderingItem.setParent(this);
        }
    }

    public Ordering addOrderingItem(MWQueryable mWQueryable) {
        if (this.orderingAttributesAllowed()) {
            MWOrderingItem mWOrderingItem = new MWOrderingItem(this, mWQueryable);
            this.addOrderingItem(mWOrderingItem);
            return mWOrderingItem;
        }
        throw new IllegalStateException("Ordering Items are not allowed if the QueryFormat is EJBQL or SQL");
    }

    public Ordering addOrderingItem(Iterator iterator) {
        if (this.orderingAttributesAllowed()) {
            MWOrderingItem mWOrderingItem = new MWOrderingItem(this, iterator);
            this.addOrderingItem(mWOrderingItem);
            return mWOrderingItem;
        }
        throw new IllegalStateException("Ordering Items are not allowed if the QueryFormat is EJBQL or SQL");
    }

    public Ordering addOrderingItem(Iterator iterator, Iterator iterator2) {
        if (this.orderingAttributesAllowed()) {
            MWOrderingItem mWOrderingItem = new MWOrderingItem(this, iterator, iterator2);
            this.addOrderingItem(mWOrderingItem);
            return mWOrderingItem;
        }
        throw new IllegalStateException("Ordering Items are not allowed if the QueryFormat is EJBQL or SQL");
    }

    public Ordering addOrderingItem(int n, Iterator iterator, Iterator iterator2) {
        if (this.orderingAttributesAllowed()) {
            MWOrderingItem mWOrderingItem = new MWOrderingItem(this, iterator, iterator2);
            this.addOrderingItem(n, mWOrderingItem);
            return mWOrderingItem;
        }
        throw new IllegalStateException("Ordering Items are not allowed if the QueryFormat is EJBQL or SQL");
    }

    private boolean orderingAttributesAllowed() {
        return this.getQueryFormat().orderingAttributesAllowed();
    }

    private void addOrderingItem(MWOrderingItem mWOrderingItem) {
        this.addOrderingItem(this.orderingItemsSize(), mWOrderingItem);
    }

    private void addOrderingItem(int n, Ordering ordering) {
        this.addItemToList(n, ordering, this.orderingItems, ORDERING_ITEMS_LIST);
    }

    public void removeOrderingItem(Ordering ordering) {
        this.removeOrderingItem(this.orderingItems.indexOf(ordering));
    }

    public void removeOrderingItem(int n) {
        this.removeItemFromList(n, this.orderingItems, ORDERING_ITEMS_LIST);
    }

    public void removeOrderingItems(Iterator iterator) {
        while (iterator.hasNext()) {
            this.removeOrderingItem((Ordering)iterator.next());
        }
    }

    public ListIterator orderingItems() {
        return new CloneListIterator(this.orderingItems);
    }

    public int orderingItemsSize() {
        return this.orderingItems.size();
    }

    public int indexOfOrderingItem(Ordering ordering) {
        return this.orderingItems.indexOf(ordering);
    }

    public void moveOrderingItemUp(Ordering ordering) {
        int n = this.indexOfOrderingItem(ordering);
        this.removeOrderingItem(n);
        this.addOrderingItem(n - 1, ordering);
    }

    public void moveOrderingItemDown(Ordering ordering) {
        int n = this.indexOfOrderingItem(ordering);
        this.removeOrderingItem(n);
        this.addOrderingItem(n + 1, ordering);
    }

    public MWBatchReadItem addBatchReadItem(MWQueryable mWQueryable) {
        if (this.batchReadAttributesAllowed()) {
            MWBatchReadItem mWBatchReadItem = new MWBatchReadItem(this, mWQueryable);
            this.addBatchReadItem(mWBatchReadItem);
            return mWBatchReadItem;
        }
        throw new IllegalStateException("BatchRead Items are not allowed if the QueryFormat is SQL");
    }

    public MWBatchReadItem addBatchReadItem(Iterator iterator) {
        if (this.batchReadAttributesAllowed()) {
            MWBatchReadItem mWBatchReadItem = new MWBatchReadItem(this, iterator);
            this.addBatchReadItem(mWBatchReadItem);
            return mWBatchReadItem;
        }
        throw new IllegalStateException("BatchRead Items are not allowed if the QueryFormat is SQL");
    }

    public MWBatchReadItem addBatchReadItem(Iterator iterator, Iterator iterator2) {
        if (this.batchReadAttributesAllowed()) {
            MWBatchReadItem mWBatchReadItem = new MWBatchReadItem(this, iterator, iterator2);
            this.addBatchReadItem(mWBatchReadItem);
            return mWBatchReadItem;
        }
        throw new IllegalStateException("BatchRead Items are not allowed if the QueryFormat is SQL");
    }

    public MWBatchReadItem addBatchReadItem(int n, Iterator iterator, Iterator iterator2) {
        if (this.batchReadAttributesAllowed()) {
            MWBatchReadItem mWBatchReadItem = new MWBatchReadItem(this, iterator, iterator2);
            this.addBatchReadItem(n, mWBatchReadItem);
            return mWBatchReadItem;
        }
        throw new IllegalStateException("BatchRead Items are not allowed if the QueryFormat is SQL");
    }

    private boolean batchReadAttributesAllowed() {
        return this.getQueryFormat().batchReadAttributesAllowed();
    }

    private void addBatchReadItem(MWBatchReadItem mWBatchReadItem) {
        this.addBatchReadItem(this.batchReadItemsSize(), mWBatchReadItem);
    }

    private void addBatchReadItem(int n, MWBatchReadItem mWBatchReadItem) {
        this.addItemToList(n, mWBatchReadItem, this.batchReadItems, BATCH_READ_ITEMS_LIST);
    }

    public void removeBatchReadItem(MWBatchReadItem mWBatchReadItem) {
        this.removeBatchReadItem(this.batchReadItems.indexOf(mWBatchReadItem));
    }

    public void removeBatchReadItem(int n) {
        this.removeItemFromList(n, this.batchReadItems, BATCH_READ_ITEMS_LIST);
    }

    public void removeBatchReadItems(Iterator iterator) {
        while (iterator.hasNext()) {
            this.removeBatchReadItem((MWBatchReadItem)iterator.next());
        }
    }

    public void moveBatchReadItemUp(MWBatchReadItem mWBatchReadItem) {
        int n = this.indexOfBatchReadItem(mWBatchReadItem);
        this.removeBatchReadItem(n);
        this.addBatchReadItem(n - 1, mWBatchReadItem);
    }

    public void moveBatchReadItemDown(MWBatchReadItem mWBatchReadItem) {
        int n = this.indexOfBatchReadItem(mWBatchReadItem);
        this.removeBatchReadItem(n);
        this.addBatchReadItem(n + 1, mWBatchReadItem);
    }

    public ListIterator batchReadItems() {
        return new CloneListIterator(this.batchReadItems);
    }

    public int batchReadItemsSize() {
        return this.batchReadItems.size();
    }

    public int indexOfBatchReadItem(MWBatchReadItem mWBatchReadItem) {
        return this.batchReadItems.indexOf(mWBatchReadItem);
    }

    public void formatSetToEjbql() {
        this.removeOrderingItems(this.orderingItems());
    }

    public void formatSetToSql() {
        this.removeOrderingItems(this.orderingItems());
        this.removeBatchReadItems(this.batchReadItems());
    }

    public DatabaseQuery runtimeQuery() {
        ReadAllQuery readAllQuery = (ReadAllQuery)super.runtimeQuery();
        ListIterator listIterator = this.batchReadItems();
        while (listIterator.hasNext()) {
            ((MWBatchReadItem)listIterator.next()).adjustRuntimeQuery((ObjectLevelReadQuery)readAllQuery);
        }
        listIterator = this.orderingItems();
        while (listIterator.hasNext()) {
            ((MWOrderingItem)listIterator.next()).adjustRuntimeQuery((ObjectLevelReadQuery)readAllQuery);
        }
        return readAllQuery;
    }

    protected ObjectLevelReadQuery buildRuntimeQuery() {
        return new ReadAllQuery();
    }
}

