/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.converters.Converter;
import org.eclipse.persistence.mappings.converters.ObjectTypeConverter;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.mappings.XMLCompositeCollectionMapping;
import org.eclipse.persistence.oxm.mappings.XMLCompositeObjectMapping;
import org.eclipse.persistence.oxm.mappings.XMLDirectMapping;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.queries.ReportQuery;
import org.eclipse.persistence.tools.workbench.mappingsmodel.TopLinkOption;
import org.eclipse.persistence.tools.workbench.mappingsmodel.TopLinkOptionSet;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.MWAbstractQuery;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.MWQuery;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.MWQueryManager;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.MWQueryable;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.MWReadAllQuery;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.MWReadObjectQuery;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.MWReadQuery;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWGroupingItem;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWOrderableQuery;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWQueryFormat;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWRelationalQuery;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWRelationalSpecificQueryOptions;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWReportAttributeItem;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWReportOrderingItem;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.Ordering;
import org.eclipse.persistence.tools.workbench.utility.TriStateBoolean;
import org.eclipse.persistence.tools.workbench.utility.iterators.CloneListIterator;
import org.eclipse.persistence.tools.workbench.utility.node.Node;

public final class MWReportQuery
extends MWAbstractQuery
implements MWRelationalQuery,
MWOrderableQuery {
    private volatile MWRelationalSpecificQueryOptions relationalOptions;
    private ReturnChoiceOption returnChoice;
    public static final String RETURN_CHOICE_PROPERTY = "returnChoice";
    public static final String RETURN_SINGLE_RESULT = "returnSingleResult";
    public static final String RETURN_SINGLE_VALUE = "returnSingleValue";
    public static final String RETURN_SINGLE_ATTRIBUTE = "returnSingleAttribute";
    public static final String RETURN_RESULT_COLLECTION = "returnResultCollection";
    public static final String DEFAULT_RETURN_CHOICE = "returnResultCollection";
    private static TopLinkOptionSet returnChoiceOptions;
    private RetrievePrimaryKeysOption retrievePrimaryKeys;
    public static final String NO_PRIMARY_KEY = "noPrimaryKey";
    public static final String FULL_PRIMARY_KEY = "fullPrimaryKey";
    public static final String FIRST_PRIMARY_KEY = "firstPrimaryKey";
    public static final String DEFAULT_RETRIEVE_PRIMARY_KEYS = "noPrimaryKey";
    public static final String RETRIVE_PRIMARY_KEYS_PROPERTY = "retrievePrimaryKeys";
    private static TopLinkOptionSet retrievePrimaryKeysOptions;
    private List attributeItems;
    public static final String ATTRIBUTE_ITEMS_LIST = "attributeItems";
    private List groupingItems;
    public static final String GROUPING_ITEMS_LIST = "groupingItems";
    private List orderingItems;
    public static final String ORDERING_ITEMS_LIST = "orderingItems";

    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor xMLDescriptor = new XMLDescriptor();
        xMLDescriptor.setJavaClass(MWReportQuery.class);
        xMLDescriptor.getDescriptorInheritancePolicy().setParentClass(MWAbstractQuery.class);
        XMLCompositeCollectionMapping xMLCompositeCollectionMapping = new XMLCompositeCollectionMapping();
        xMLCompositeCollectionMapping.setAttributeName(ATTRIBUTE_ITEMS_LIST);
        xMLCompositeCollectionMapping.setReferenceClass(MWReportAttributeItem.class);
        xMLCompositeCollectionMapping.setXPath("attributes/attribute-item");
        xMLDescriptor.addMapping((DatabaseMapping)xMLCompositeCollectionMapping);
        XMLCompositeCollectionMapping xMLCompositeCollectionMapping2 = new XMLCompositeCollectionMapping();
        xMLCompositeCollectionMapping2.setAttributeName(GROUPING_ITEMS_LIST);
        xMLCompositeCollectionMapping2.setReferenceClass(MWGroupingItem.class);
        xMLCompositeCollectionMapping2.setXPath("groupings/grouping");
        xMLDescriptor.addMapping((DatabaseMapping)xMLCompositeCollectionMapping2);
        XMLCompositeCollectionMapping xMLCompositeCollectionMapping3 = new XMLCompositeCollectionMapping();
        xMLCompositeCollectionMapping3.setAttributeName(ORDERING_ITEMS_LIST);
        xMLCompositeCollectionMapping3.setReferenceClass(MWReportOrderingItem.class);
        xMLCompositeCollectionMapping3.setXPath("orderings/ordering");
        xMLDescriptor.addMapping((DatabaseMapping)xMLCompositeCollectionMapping3);
        XMLCompositeObjectMapping xMLCompositeObjectMapping = new XMLCompositeObjectMapping();
        xMLCompositeObjectMapping.setAttributeName("relationalOptions");
        xMLCompositeObjectMapping.setReferenceClass(MWRelationalSpecificQueryOptions.class);
        xMLCompositeObjectMapping.setXPath("relational-options");
        xMLDescriptor.addMapping((DatabaseMapping)xMLCompositeObjectMapping);
        XMLDirectMapping xMLDirectMapping = new XMLDirectMapping();
        xMLDirectMapping.setAttributeName(RETURN_CHOICE_PROPERTY);
        xMLDirectMapping.setXPath("return-choice/text()");
        ObjectTypeConverter objectTypeConverter = new ObjectTypeConverter();
        MWReportQuery.returnChoiceOptions().addConversionValuesForTopLinkTo(objectTypeConverter);
        xMLDirectMapping.setConverter((Converter)objectTypeConverter);
        xMLDirectMapping.setNullValue((Object)MWReportQuery.returnChoiceOptions().topLinkOptionForMWModelOption("returnResultCollection"));
        xMLDescriptor.addMapping((DatabaseMapping)xMLDirectMapping);
        XMLDirectMapping xMLDirectMapping2 = new XMLDirectMapping();
        xMLDirectMapping2.setAttributeName(RETRIVE_PRIMARY_KEYS_PROPERTY);
        xMLDirectMapping2.setXPath("retrieve-primary-keys/text()");
        ObjectTypeConverter objectTypeConverter2 = new ObjectTypeConverter();
        MWReportQuery.retrievePrimaryKeysOptions().addConversionValuesForTopLinkTo(objectTypeConverter2);
        xMLDirectMapping2.setConverter((Converter)objectTypeConverter2);
        xMLDirectMapping2.setNullValue((Object)MWReportQuery.retrievePrimaryKeysOptions().topLinkOptionForMWModelOption("noPrimaryKey"));
        xMLDescriptor.addMapping((DatabaseMapping)xMLDirectMapping2);
        return xMLDescriptor;
    }

    public static synchronized TopLinkOptionSet returnChoiceOptions() {
        if (returnChoiceOptions == null) {
            ArrayList<ReturnChoiceOption> arrayList = new ArrayList<ReturnChoiceOption>();
            arrayList.add(new ReturnChoiceOption("returnResultCollection", "RESULT_COLLECTION_RETURN_OPTION"));
            arrayList.add(new ReturnChoiceOption(RETURN_SINGLE_RESULT, "SINGLE_RESULT_RETURN_OPTION"));
            arrayList.add(new ReturnChoiceOption(RETURN_SINGLE_VALUE, "SINGLE_VALUE_RETURN_OPTION"));
            arrayList.add(new ReturnChoiceOption(RETURN_SINGLE_ATTRIBUTE, "SINGLE_ATTRIBUTE_RETURN_OPTION"));
            returnChoiceOptions = new TopLinkOptionSet(arrayList);
        }
        return returnChoiceOptions;
    }

    public static synchronized TopLinkOptionSet retrievePrimaryKeysOptions() {
        if (retrievePrimaryKeysOptions == null) {
            ArrayList<RetrievePrimaryKeysOption> arrayList = new ArrayList<RetrievePrimaryKeysOption>();
            arrayList.add(new RetrievePrimaryKeysOption("noPrimaryKey", "NO_PRIMARY_KEY_OPTION"));
            arrayList.add(new RetrievePrimaryKeysOption(FULL_PRIMARY_KEY, "FULL_PRIMARY_KEY_OPTION"));
            arrayList.add(new RetrievePrimaryKeysOption(FIRST_PRIMARY_KEY, "FIRST_PRIMARY_KEY_OPTION"));
            retrievePrimaryKeysOptions = new TopLinkOptionSet(arrayList);
        }
        return retrievePrimaryKeysOptions;
    }

    private MWReportQuery() {
    }

    MWReportQuery(MWQueryManager mWQueryManager, String string) {
        super(mWQueryManager, string);
    }

    protected void initialize(Node node) {
        super.initialize(node);
        this.relationalOptions = new MWRelationalSpecificQueryOptions(this);
        this.returnChoice = (ReturnChoiceOption)MWReportQuery.returnChoiceOptions().topLinkOptionForMWModelOption("returnResultCollection");
        this.retrievePrimaryKeys = (RetrievePrimaryKeysOption)MWReportQuery.retrievePrimaryKeysOptions().topLinkOptionForMWModelOption("noPrimaryKey");
        this.attributeItems = new Vector();
        this.groupingItems = new Vector();
        this.orderingItems = new Vector();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addChildrenTo(List list) {
        super.addChildrenTo(list);
        list.add(this.relationalOptions);
        List list2 = this.attributeItems;
        synchronized (list2) {
            list.addAll(this.attributeItems);
        }
        list2 = this.groupingItems;
        synchronized (list2) {
            list.addAll(this.groupingItems);
        }
        list2 = this.orderingItems;
        synchronized (list2) {
            list.addAll(this.orderingItems);
        }
    }

    public MWReadAllQuery asReadAllQuery() {
        this.getQueryManager().removeQuery(this);
        MWReadAllQuery mWReadAllQuery = this.getQueryManager().addReadAllQuery(this.getName());
        ((MWAbstractQuery)((Object)mWReadAllQuery)).initializeFrom(this);
        return mWReadAllQuery;
    }

    public MWReadObjectQuery asReadObjectQuery() {
        this.getQueryManager().removeQuery(this);
        MWReadObjectQuery mWReadObjectQuery = this.getQueryManager().addReadObjectQuery(this.getName());
        ((MWAbstractQuery)((Object)mWReadObjectQuery)).initializeFrom(this);
        return mWReadObjectQuery;
    }

    public MWReportQuery asReportQuery() {
        return this;
    }

    public void initializeFrom(MWReadQuery mWReadQuery) {
        super.initializeFrom(mWReadQuery);
        this.initializeFrom((MWRelationalQuery)((Object)mWReadQuery));
    }

    public void initializeFrom(MWRelationalQuery mWRelationalQuery) {
        super.initializeFrom(mWRelationalQuery);
        this.getRelationalOptions().initializeFrom(mWRelationalQuery.getRelationalOptions());
    }

    public String queryType() {
        return "REPORT_QUERY";
    }

    public void formatSetToEjbql() {
        this.removeAttributeItems(this.attributeItems());
        this.removeOrderingItems(this.orderingItems());
        this.removeGroupingItems(this.groupingItems());
    }

    public void formatSetToSql() {
        this.removeOrderingItems(this.orderingItems());
        this.removeGroupingItems(this.groupingItems());
    }

    public MWRelationalSpecificQueryOptions getRelationalOptions() {
        return this.relationalOptions;
    }

    public String getQueryFormatType() {
        return this.relationalOptions.getQueryFormatType();
    }

    public void setQueryFormatType(String string) {
        this.relationalOptions.setQueryFormatType(string);
    }

    public MWQueryFormat getQueryFormat() {
        return this.relationalOptions.getQueryFormat();
    }

    public TriStateBoolean isCacheStatement() {
        return this.relationalOptions.isCacheStatement();
    }

    public void setCacheStatement(TriStateBoolean triStateBoolean) {
        this.relationalOptions.setCacheStatement(triStateBoolean);
    }

    public TriStateBoolean isBindAllParameters() {
        return this.relationalOptions.isBindAllParameters();
    }

    public void setBindAllParameters(TriStateBoolean triStateBoolean) {
        this.relationalOptions.setBindAllParameters(triStateBoolean);
    }

    public boolean isPrepare() {
        return this.relationalOptions.isPrepare();
    }

    public void setPrepare(boolean bl) {
        this.relationalOptions.setPrepare(bl);
    }

    public ReturnChoiceOption getReturnChoice() {
        return this.returnChoice;
    }

    public void setReturnChoice(ReturnChoiceOption returnChoiceOption) {
        ReturnChoiceOption returnChoiceOption2 = this.returnChoice;
        this.returnChoice = returnChoiceOption;
        this.firePropertyChanged(RETURN_CHOICE_PROPERTY, returnChoiceOption2, this.returnChoice);
    }

    public void setReturnChoice(String string) {
        this.setReturnChoice((ReturnChoiceOption)MWReportQuery.returnChoiceOptions().topLinkOptionForMWModelOption(string));
    }

    public RetrievePrimaryKeysOption getRetrievePrimaryKeys() {
        return this.retrievePrimaryKeys;
    }

    public void setRetrievePrimaryKeys(RetrievePrimaryKeysOption retrievePrimaryKeysOption) {
        RetrievePrimaryKeysOption retrievePrimaryKeysOption2 = this.retrievePrimaryKeys;
        this.retrievePrimaryKeys = retrievePrimaryKeysOption;
        this.firePropertyChanged(RETRIVE_PRIMARY_KEYS_PROPERTY, retrievePrimaryKeysOption2, this.retrievePrimaryKeys);
    }

    public void setRetrievePrimaryKeys(String string) {
        this.setRetrievePrimaryKeys((RetrievePrimaryKeysOption)MWReportQuery.retrievePrimaryKeysOptions().topLinkOptionForMWModelOption(string));
    }

    public MWReportAttributeItem addAttributeItem(String string, MWQueryable mWQueryable) {
        if (this.attributeItemsAllowed()) {
            MWReportAttributeItem mWReportAttributeItem = new MWReportAttributeItem((MWQuery)this, string, mWQueryable);
            this.addAttributeItem(mWReportAttributeItem);
            return mWReportAttributeItem;
        }
        throw new IllegalStateException("Attribute Items are not allowed if the QueryFormat is EJBQL");
    }

    public MWReportAttributeItem addAttributeItem(String string, Iterator iterator) {
        if (this.attributeItemsAllowed()) {
            MWReportAttributeItem mWReportAttributeItem = new MWReportAttributeItem((MWQuery)this, string, iterator);
            this.addAttributeItem(mWReportAttributeItem);
            return mWReportAttributeItem;
        }
        throw new IllegalStateException("Attribute Items are not allowed if the QueryFormat is EJBQL");
    }

    public MWReportAttributeItem addAttributeItem(String string, Iterator iterator, Iterator iterator2) {
        if (this.attributeItemsAllowed()) {
            MWReportAttributeItem mWReportAttributeItem = new MWReportAttributeItem(this, string, iterator, iterator2);
            this.addAttributeItem(mWReportAttributeItem);
            return mWReportAttributeItem;
        }
        throw new IllegalStateException("Attribute Items are not allowed if the QueryFormat is EJBQL");
    }

    public MWReportAttributeItem addAttributeItem(int n, String string, Iterator iterator, Iterator iterator2) {
        if (this.attributeItemsAllowed()) {
            MWReportAttributeItem mWReportAttributeItem = new MWReportAttributeItem(this, string, iterator, iterator2);
            this.addAttributeItem(n, mWReportAttributeItem);
            return mWReportAttributeItem;
        }
        throw new IllegalStateException("Attribute Items are not allowed if the QueryFormat is EJBQL");
    }

    private boolean attributeItemsAllowed() {
        return this.getQueryFormat().reportAttributesAllowed();
    }

    private void addAttributeItem(MWReportAttributeItem mWReportAttributeItem) {
        this.addAttributeItem(this.attributeItemsSize(), mWReportAttributeItem);
    }

    private void addAttributeItem(int n, MWReportAttributeItem mWReportAttributeItem) {
        this.addItemToList(n, mWReportAttributeItem, this.attributeItems, ATTRIBUTE_ITEMS_LIST);
    }

    public void removeAttributeItem(MWReportAttributeItem mWReportAttributeItem) {
        this.removeAttributeItem(this.attributeItems.indexOf(mWReportAttributeItem));
    }

    public void removeAttributeItem(int n) {
        MWReportOrderingItem mWReportOrderingItem = null;
        ListIterator listIterator = this.orderingItems();
        while (listIterator.hasNext()) {
            MWReportOrderingItem mWReportOrderingItem2 = (MWReportOrderingItem)listIterator.next();
            if (mWReportOrderingItem2.attributeItem() != this.attributeItems.get(n)) continue;
            mWReportOrderingItem = mWReportOrderingItem2;
        }
        this.removeItemFromList(n, this.attributeItems, ATTRIBUTE_ITEMS_LIST);
        if (mWReportOrderingItem != null) {
            this.removeOrderingItem(mWReportOrderingItem);
        }
    }

    public void removeAttributeItems(Iterator iterator) {
        while (iterator.hasNext()) {
            this.removeAttributeItem((MWReportAttributeItem)iterator.next());
        }
    }

    public ListIterator attributeItems() {
        return new CloneListIterator(this.attributeItems);
    }

    public int attributeItemsSize() {
        return this.attributeItems.size();
    }

    public int indexOfAttributeItem(MWReportAttributeItem mWReportAttributeItem) {
        return this.attributeItems.indexOf(mWReportAttributeItem);
    }

    public void moveAttributeItemUp(MWReportAttributeItem mWReportAttributeItem) {
        int n = this.indexOfAttributeItem(mWReportAttributeItem);
        this.removeAttributeItem(n);
        this.addAttributeItem(n - 1, mWReportAttributeItem);
    }

    public void moveAttributeItemDown(MWReportAttributeItem mWReportAttributeItem) {
        int n = this.indexOfAttributeItem(mWReportAttributeItem);
        this.removeAttributeItem(n);
        this.addAttributeItem(n + 1, mWReportAttributeItem);
    }

    public MWGroupingItem addGroupingItem(MWQueryable mWQueryable) {
        if (this.groupingAttribttesAllowed()) {
            MWGroupingItem mWGroupingItem = new MWGroupingItem(this, mWQueryable);
            this.addGroupingItem(mWGroupingItem);
            return mWGroupingItem;
        }
        throw new IllegalStateException("Grouping Items are not allowed if the QueryFormat is EJBQL or SQL");
    }

    public MWGroupingItem addGroupingItem(Iterator iterator) {
        if (this.groupingAttribttesAllowed()) {
            MWGroupingItem mWGroupingItem = new MWGroupingItem(this, iterator);
            this.addGroupingItem(mWGroupingItem);
            return mWGroupingItem;
        }
        throw new IllegalStateException("Grouping Items are not allowed if the QueryFormat is EJBQL or SQL");
    }

    public MWGroupingItem addGroupingItem(Iterator iterator, Iterator iterator2) {
        if (this.groupingAttribttesAllowed()) {
            MWGroupingItem mWGroupingItem = new MWGroupingItem(this, iterator, iterator2);
            this.addGroupingItem(mWGroupingItem);
            return mWGroupingItem;
        }
        throw new IllegalStateException("Grouping Items are not allowed if the QueryFormat is EJBQL or SQL");
    }

    public MWGroupingItem addGroupingItem(int n, Iterator iterator, Iterator iterator2) {
        if (this.groupingAttribttesAllowed()) {
            MWGroupingItem mWGroupingItem = new MWGroupingItem(this, iterator, iterator2);
            this.addGroupingItem(n, mWGroupingItem);
            return mWGroupingItem;
        }
        throw new IllegalStateException("Grouping Items are not allowed if the QueryFormat is EJBQL or SQL");
    }

    private boolean groupingAttribttesAllowed() {
        return this.getQueryFormat().groupingAtributesAllowed();
    }

    private void addGroupingItem(MWGroupingItem mWGroupingItem) {
        this.addGroupingItem(this.groupingItemsSize(), mWGroupingItem);
    }

    private void addGroupingItem(int n, MWGroupingItem mWGroupingItem) {
        this.addItemToList(n, mWGroupingItem, this.groupingItems, GROUPING_ITEMS_LIST);
    }

    public void removeGroupingItem(MWGroupingItem mWGroupingItem) {
        this.removeGroupingItem(this.groupingItems.indexOf(mWGroupingItem));
    }

    public void removeGroupingItem(int n) {
        this.removeItemFromList(n, this.groupingItems, GROUPING_ITEMS_LIST);
    }

    public void removeGroupingItems(Iterator iterator) {
        while (iterator.hasNext()) {
            this.removeGroupingItem((MWGroupingItem)iterator.next());
        }
    }

    public ListIterator groupingItems() {
        return new CloneListIterator(this.groupingItems);
    }

    public int groupingItemsSize() {
        return this.groupingItems.size();
    }

    public int indexOfGroupingItem(MWGroupingItem mWGroupingItem) {
        return this.groupingItems.indexOf(mWGroupingItem);
    }

    public void moveGroupingItemUp(MWGroupingItem mWGroupingItem) {
        int n = this.indexOfGroupingItem(mWGroupingItem);
        this.removeGroupingItem(n);
        this.addGroupingItem(n - 1, mWGroupingItem);
    }

    public void moveGroupingItemDown(MWGroupingItem mWGroupingItem) {
        int n = this.indexOfGroupingItem(mWGroupingItem);
        this.removeGroupingItem(n);
        this.addGroupingItem(n + 1, mWGroupingItem);
    }

    public Ordering addOrderingItem(MWQueryable mWQueryable) {
        if (this.orderingAttributesAllowed()) {
            MWReportOrderingItem mWReportOrderingItem = new MWReportOrderingItem(this, mWQueryable);
            this.addOrderingItem(mWReportOrderingItem);
            return mWReportOrderingItem;
        }
        throw new IllegalStateException("Ordering Items are not allowed if the QueryFormat is EJBQL or SQL");
    }

    public Ordering addOrderingItem(Iterator iterator) {
        if (this.orderingAttributesAllowed()) {
            MWReportOrderingItem mWReportOrderingItem = new MWReportOrderingItem(this, iterator);
            this.addOrderingItem(mWReportOrderingItem);
            return mWReportOrderingItem;
        }
        throw new IllegalStateException("Ordering Items are not allowed if the QueryFormat is EJBQL or SQL");
    }

    public Ordering addOrderingItem(Iterator iterator, Iterator iterator2) {
        if (this.orderingAttributesAllowed()) {
            MWReportOrderingItem mWReportOrderingItem = new MWReportOrderingItem(this, iterator, iterator2);
            this.addOrderingItem(mWReportOrderingItem);
            return mWReportOrderingItem;
        }
        throw new IllegalStateException("Ordering Items are not allowed if the QueryFormat is EJBQL or SQL");
    }

    public Ordering addOrderingItem(int n, Iterator iterator, Iterator iterator2) {
        if (this.orderingAttributesAllowed()) {
            MWReportOrderingItem mWReportOrderingItem = new MWReportOrderingItem(this, iterator, iterator2);
            this.addOrderingItem(n, mWReportOrderingItem);
            return mWReportOrderingItem;
        }
        throw new IllegalStateException("Ordering Items are not allowed if the QueryFormat is EJBQL or SQL");
    }

    public MWReportOrderingItem addOrderingItem(MWReportAttributeItem mWReportAttributeItem) {
        MWReportOrderingItem mWReportOrderingItem = new MWReportOrderingItem(this, mWReportAttributeItem);
        this.addOrderingItem(mWReportOrderingItem);
        return mWReportOrderingItem;
    }

    private void addOrderingItem(Ordering ordering) {
        this.addOrderingItem(this.orderingItemsSize(), ordering);
    }

    private void addOrderingItem(int n, Ordering ordering) {
        this.addItemToList(n, ordering, this.orderingItems, ORDERING_ITEMS_LIST);
    }

    private boolean orderingAttributesAllowed() {
        return this.getQueryFormat().orderingAttributesAllowed();
    }

    public void removeOrderingItem(Ordering ordering) {
        this.removeOrderingItem(this.orderingItems.indexOf(ordering));
    }

    public void removeOrderingItem(int n) {
        this.removeItemFromList(n, this.orderingItems, ORDERING_ITEMS_LIST);
    }

    public void removeOrderingItems(Iterator iterator) {
        while (iterator.hasNext()) {
            this.removeOrderingItem((Ordering)iterator.next());
        }
    }

    public ListIterator orderingItems() {
        return new CloneListIterator(this.orderingItems);
    }

    public int orderingItemsSize() {
        return this.orderingItems.size();
    }

    public int indexOfOrderingItem(Ordering ordering) {
        return this.orderingItems.indexOf(ordering);
    }

    public void moveOrderingItemUp(Ordering ordering) {
        int n = this.indexOfOrderingItem(ordering);
        this.removeOrderingItem(n);
        this.addOrderingItem(n - 1, ordering);
    }

    public void moveOrderingItemDown(Ordering ordering) {
        int n = this.indexOfOrderingItem(ordering);
        this.removeOrderingItem(n);
        this.addOrderingItem(n + 1, ordering);
    }

    public void notifyExpressionsToRecalculateQueryables() {
        this.relationalOptions.notifyExpressionsToRecalculateQueryables();
    }

    public DatabaseQuery runtimeQuery() {
        ReportQuery reportQuery = (ReportQuery)super.runtimeQuery();
        this.getReturnChoice().setMWOptionOnTopLinkObject(reportQuery);
        this.getRetrievePrimaryKeys().setMWOptionOnTopLinkObject(reportQuery);
        ListIterator listIterator = this.attributeItems();
        while (listIterator.hasNext()) {
            ((MWReportAttributeItem)listIterator.next()).adjustRuntimeQuery((ObjectLevelReadQuery)reportQuery);
        }
        listIterator = this.groupingItems();
        while (listIterator.hasNext()) {
            ((MWGroupingItem)listIterator.next()).adjustRuntimeQuery((ObjectLevelReadQuery)reportQuery);
        }
        listIterator = this.orderingItems();
        while (listIterator.hasNext()) {
            ((MWReportOrderingItem)listIterator.next()).adjustRuntimeQuery((ObjectLevelReadQuery)reportQuery);
        }
        this.getRelationalOptions().adjustRuntimeQuery((ObjectLevelReadQuery)reportQuery);
        return reportQuery;
    }

    protected ObjectLevelReadQuery buildRuntimeQuery() {
        return new ReportQuery();
    }

    public static class RetrievePrimaryKeysOption
    extends TopLinkOption {
        private RetrievePrimaryKeysOption(String string, String string2) {
            super(string, string2);
        }

        public void setMWOptionOnTopLinkObject(Object object) {
            if (this.getMWModelOption() == MWReportQuery.FULL_PRIMARY_KEY) {
                ((ReportQuery)object).setShouldRetrievePrimaryKeys(true);
            } else if (this.getMWModelOption() == MWReportQuery.FIRST_PRIMARY_KEY) {
                ((ReportQuery)object).setShouldRetrieveFirstPrimaryKey(true);
            }
        }
    }

    public static class ReturnChoiceOption
    extends TopLinkOption {
        private ReturnChoiceOption(String string, String string2) {
            super(string, string2);
        }

        public void setMWOptionOnTopLinkObject(Object object) {
            String string = this.getMWModelOption();
            if (string == MWReportQuery.RETURN_SINGLE_ATTRIBUTE) {
                ((ReportQuery)object).returnSingleAttribute();
            } else if (string == MWReportQuery.RETURN_SINGLE_RESULT) {
                ((ReportQuery)object).returnSingleResult();
            } else if (string == MWReportQuery.RETURN_SINGLE_VALUE) {
                ((ReportQuery)object).returnSingleValue();
            } else if (string != "returnResultCollection") {
                throw new IllegalStateException();
            }
        }
    }
}

