/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.resource;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWModel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.resource.ResourceException;
import org.eclipse.persistence.tools.workbench.mappingsmodel.resource.ResourceSpecification;

public final class FileResourceSpecification
extends ResourceSpecification {
    private static String KEY = "FILE_RESOURCE";

    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor xMLDescriptor = new XMLDescriptor();
        xMLDescriptor.setJavaClass(FileResourceSpecification.class);
        xMLDescriptor.getInheritancePolicy().setParentClass(ResourceSpecification.class);
        return xMLDescriptor;
    }

    private FileResourceSpecification() {
    }

    public FileResourceSpecification(MWModel mWModel, String string) {
        super(mWModel, string);
    }

    public String getSourceKey() {
        return KEY;
    }

    protected URL resourceUrl() throws ResourceException {
        if (this.location == null || this.location == "") {
            throw ResourceException.unspecifiedResourceException(null);
        }
        File file = this.absoluteFile();
        if (!file.exists()) {
            throw ResourceException.nonexistentResourceException(null);
        }
        try {
            return file.toURL();
        }
        catch (MalformedURLException malformedURLException) {
            throw ResourceException.incorrectlySpecifiedResourceException(malformedURLException);
        }
    }

    private File absoluteFile() {
        File file = new File(this.location);
        if (file.isAbsolute()) {
            return file;
        }
        return new File(this.getProject().getSaveDirectory(), this.location);
    }

    protected String getLocationForTopLink2() {
        return this.location.replace('\\', '/');
    }

    protected void setLocationForTopLink2(String string) {
        this.location = new File(string).getPath();
    }
}

