/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.schema;

import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;
import org.apache.xerces.impl.dv.xs.XSSimpleTypeDecl;
import org.apache.xerces.xs.XSObject;
import org.apache.xerces.xs.XSSimpleTypeDefinition;
import org.apache.xerces.xs.XSTypeDefinition;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.converters.Converter;
import org.eclipse.persistence.mappings.converters.ObjectTypeConverter;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.mappings.XMLCompositeCollectionMapping;
import org.eclipse.persistence.oxm.mappings.XMLCompositeObjectMapping;
import org.eclipse.persistence.oxm.mappings.XMLDirectMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWModel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.ExplicitSchemaTypeDefinition;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.MWElementDeclaration;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.MWSchemaTypeDefinition;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.MWSimpleTypeDefinition;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.ReferencedSimpleTypeDefinition;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.XercesTools;
import org.eclipse.persistence.tools.workbench.utility.iterators.CompositeIterator;
import org.eclipse.persistence.tools.workbench.utility.iterators.NullIterator;
import org.eclipse.persistence.tools.workbench.utility.iterators.SingleElementIterator;
import org.eclipse.persistence.tools.workbench.utility.iterators.TransformationIterator;
import org.eclipse.persistence.tools.workbench.utility.node.Node;

public final class ExplicitSimpleTypeDefinition
extends ExplicitSchemaTypeDefinition
implements MWSimpleTypeDefinition {
    private volatile String variety;
    private volatile ReferencedSimpleTypeDefinition baseType;
    private volatile MWSimpleTypeDefinition itemType;
    private volatile List<MWSimpleTypeDefinition> memberTypes;

    protected ExplicitSimpleTypeDefinition() {
    }

    ExplicitSimpleTypeDefinition(MWModel mWModel, String string) {
        super(mWModel, string);
    }

    ExplicitSimpleTypeDefinition(MWModel mWModel, String string, String string2) {
        super(mWModel, string, string2);
    }

    ExplicitSimpleTypeDefinition(MWModel mWModel, String string, String string2, boolean bl) {
        super(mWModel, string, string2, bl);
    }

    protected void initialize(Node node) {
        super.initialize(node);
        this.variety = "atomic";
        this.baseType = ReferencedSimpleTypeDefinition.simpleUrType(this);
        this.memberTypes = new Vector<MWSimpleTypeDefinition>();
    }

    protected void addChildrenTo(List list) {
        super.addChildrenTo(list);
        list.add(this.baseType);
        if (this.itemType != null) {
            list.add(this.itemType);
        }
        list.addAll(this.memberTypes);
    }

    public String getVariety() {
        return this.variety;
    }

    public boolean isAtomic() {
        return this.variety == "atomic";
    }

    public boolean isList() {
        return this.variety == "list";
    }

    public boolean isUnion() {
        return this.variety == "union";
    }

    public MWSimpleTypeDefinition getItemType() {
        return this.itemType;
    }

    public ListIterator memberTypes() {
        return this.memberTypes.listIterator();
    }

    public MWSchemaTypeDefinition getBaseType() {
        return this.baseType;
    }

    public boolean isComplex() {
        return false;
    }

    public Iterator baseBuiltInTypes() {
        if (this.builtIn) {
            return new SingleElementIterator(this);
        }
        if (this.isList()) {
            return this.itemType.baseBuiltInTypes();
        }
        if (this.isUnion()) {
            return new CompositeIterator(this.memberTypeBaseBuiltInTypes());
        }
        return this.baseType.baseBuiltInTypes();
    }

    private Iterator memberTypeBaseBuiltInTypes() {
        return new TransformationIterator(this.memberTypes.iterator()){

            protected Object transform(Object object) {
                return ((MWSimpleTypeDefinition)object).baseBuiltInTypes();
            }
        };
    }

    public boolean containsText() {
        return true;
    }

    public boolean containsWildcard() {
        return false;
    }

    public int compareSchemaOrder(MWElementDeclaration mWElementDeclaration, MWElementDeclaration mWElementDeclaration2) {
        return 0;
    }

    public String componentTypeName() {
        return "simpleType";
    }

    public Iterator structuralComponents() {
        return NullIterator.instance();
    }

    protected void reloadInternal(XSObject xSObject) {
        super.reloadInternal(xSObject);
        XSSimpleTypeDecl xSSimpleTypeDecl = (XSSimpleTypeDecl)xSObject;
        this.reloadVariety(xSSimpleTypeDecl);
        if (this.getNamespaceUrl() != null) {
            this.builtIn = this.getNamespaceUrl().equals("http://www.w3.org/2001/XMLSchema") || this.getNamespaceUrl().equals("http://www.w3.org/2003/11/xpath-datatypes");
        }
    }

    private void reloadVariety(XSSimpleTypeDecl xSSimpleTypeDecl) {
        if (xSSimpleTypeDecl.getVariety() == 2) {
            this.variety = "list";
        } else if (xSSimpleTypeDecl.getVariety() == 3) {
            this.variety = "union";
        } else if (xSSimpleTypeDecl.getVariety() == 1) {
            this.variety = "atomic";
        } else if (xSSimpleTypeDecl.getVariety() == 0) {
            this.variety = "absent";
        } else {
            throw new IllegalArgumentException();
        }
        this.reloadBaseType(xSSimpleTypeDecl);
        this.reloadItemType(xSSimpleTypeDecl);
        this.reloadMemberTypes(xSSimpleTypeDecl);
    }

    private void reloadBaseType(XSSimpleTypeDecl xSSimpleTypeDecl) {
        XSTypeDefinition xSTypeDefinition = xSSimpleTypeDecl.getBaseType();
        if (xSTypeDefinition != null) {
            if (this.baseType == null) {
                this.baseType = new ReferencedSimpleTypeDefinition(this, xSTypeDefinition.getName(), xSTypeDefinition.getNamespace());
            }
            this.baseType.reload((XSObject)xSTypeDefinition);
        } else {
            this.baseType = ReferencedSimpleTypeDefinition.simpleUrType(this);
        }
    }

    private void reloadItemType(XSSimpleTypeDecl xSSimpleTypeDecl) {
        MWSimpleTypeDefinition mWSimpleTypeDefinition = this.itemType;
        XSSimpleTypeDefinition xSSimpleTypeDefinition = xSSimpleTypeDecl.getItemType();
        this.itemType = this.isList() ? MWSimpleTypeDefinition.Reloader.reloadedSimpleType(this, mWSimpleTypeDefinition, xSSimpleTypeDefinition) : null;
        if (mWSimpleTypeDefinition != null && mWSimpleTypeDefinition != this.itemType) {
            this.getProject().nodeRemoved(mWSimpleTypeDefinition);
        }
    }

    private void reloadMemberTypes(XSSimpleTypeDecl xSSimpleTypeDecl) {
        if (this.isUnion()) {
            Object object;
            MWSimpleTypeDefinition mWSimpleTypeDefinition;
            ListIterator<MWSimpleTypeDefinition> listIterator = this.memberTypes.listIterator();
            ListIterator<XSObject> listIterator2 = XercesTools.listIteratorFromXSObjectList(xSSimpleTypeDecl.getMemberTypes());
            while (listIterator.hasNext() && listIterator2.hasNext()) {
                MWSimpleTypeDefinition mWSimpleTypeDefinition2;
                mWSimpleTypeDefinition = listIterator.next();
                if (mWSimpleTypeDefinition == (mWSimpleTypeDefinition2 = MWSimpleTypeDefinition.Reloader.reloadedSimpleType(this, mWSimpleTypeDefinition, object = (XSSimpleTypeDefinition)listIterator2.next()))) continue;
                listIterator.set(mWSimpleTypeDefinition2);
                this.getProject().nodeRemoved(mWSimpleTypeDefinition);
            }
            while (listIterator2.hasNext()) {
                mWSimpleTypeDefinition = (XSSimpleTypeDefinition)listIterator2.next();
                object = MWSimpleTypeDefinition.Reloader.reloadedSimpleType(this, null, (XSSimpleTypeDefinition)mWSimpleTypeDefinition);
                listIterator.add((MWSimpleTypeDefinition)object);
            }
            while (listIterator.hasNext()) {
                mWSimpleTypeDefinition = listIterator.next();
                listIterator.remove();
                this.getProject().nodeRemoved(mWSimpleTypeDefinition);
            }
        } else {
            Iterator<MWSimpleTypeDefinition> iterator = this.memberTypes.iterator();
            while (iterator.hasNext()) {
                MWSimpleTypeDefinition mWSimpleTypeDefinition = iterator.next();
                iterator.remove();
                this.getProject().nodeRemoved(mWSimpleTypeDefinition);
            }
        }
    }

    public void resolveReferences() {
        super.resolveReferences();
        this.baseType.resolveReferences();
        if (this.itemType != null) {
            this.itemType.resolveReferences();
        }
        Iterator<MWSimpleTypeDefinition> iterator = this.memberTypes.iterator();
        while (iterator.hasNext()) {
            iterator.next().resolveReferences();
        }
    }

    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor xMLDescriptor = new XMLDescriptor();
        xMLDescriptor.setJavaClass(ExplicitSimpleTypeDefinition.class);
        xMLDescriptor.getInheritancePolicy().setParentClass(ExplicitSchemaTypeDefinition.class);
        XMLDirectMapping xMLDirectMapping = (XMLDirectMapping)xMLDescriptor.addDirectMapping("variety", "variety/text()");
        ObjectTypeConverter objectTypeConverter = new ObjectTypeConverter();
        objectTypeConverter.addConversionValue(null, (Object)"atomic");
        objectTypeConverter.addConversionValue((Object)"atomic", (Object)"atomic");
        objectTypeConverter.addConversionValue((Object)"list", (Object)"list");
        objectTypeConverter.addConversionValue((Object)"union", (Object)"union");
        xMLDirectMapping.setConverter((Converter)objectTypeConverter);
        XMLCompositeObjectMapping xMLCompositeObjectMapping = new XMLCompositeObjectMapping();
        xMLCompositeObjectMapping.setAttributeName("baseType");
        xMLCompositeObjectMapping.setReferenceClass(ReferencedSimpleTypeDefinition.class);
        xMLCompositeObjectMapping.setXPath("base-type");
        xMLDescriptor.addMapping((DatabaseMapping)xMLCompositeObjectMapping);
        XMLCompositeObjectMapping xMLCompositeObjectMapping2 = new XMLCompositeObjectMapping();
        xMLCompositeObjectMapping2.setAttributeName("itemType");
        xMLCompositeObjectMapping2.setReferenceClass(ReferencedSimpleTypeDefinition.class);
        xMLCompositeObjectMapping2.setXPath("item-type");
        xMLDescriptor.addMapping((DatabaseMapping)xMLCompositeObjectMapping2);
        XMLCompositeCollectionMapping xMLCompositeCollectionMapping = new XMLCompositeCollectionMapping();
        xMLCompositeCollectionMapping.setAttributeName("memberTypes");
        xMLCompositeCollectionMapping.setReferenceClass(ReferencedSimpleTypeDefinition.class);
        xMLCompositeCollectionMapping.setXPath("member-types");
        xMLDescriptor.addMapping((DatabaseMapping)xMLCompositeCollectionMapping);
        return xMLDescriptor;
    }
}

