/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.xml;

import org.eclipse.persistence.tools.workbench.mappingsmodel.MWModel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.MWAttributeDeclaration;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.MWElementDeclaration;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.MWNamespace;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.MWSchemaContextComponent;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.MWXpathableSchemaComponent;
import org.eclipse.persistence.tools.workbench.mappingsmodel.xml.MWXmlField;

final class MWXpathStep
extends MWModel {
    private transient String stepString;
    private transient MWNamespace namespace;
    private MWXpathableSchemaComponent xpathComponent;
    private boolean isText;
    private boolean isAttribute;
    private String localName = "";
    private int position = ANY_POSITION;
    private static int ANY_POSITION = 0;
    private transient boolean resolved;
    private transient boolean valid;

    private MWXpathStep(MWXmlField mWXmlField) {
        super(mWXmlField);
    }

    MWXpathStep(MWXmlField mWXmlField, String string) {
        this(mWXmlField);
        this.stepString = string;
    }

    boolean isText() {
        return this.isText;
    }

    boolean isAttribute() {
        return this.xpathComponent instanceof MWAttributeDeclaration;
    }

    boolean isElement() {
        return this.xpathComponent instanceof MWElementDeclaration;
    }

    boolean isPositional() {
        return this.position != ANY_POSITION;
    }

    boolean isSingular() {
        if (this.xpathComponent != null && this.xpathComponent.getMaxOccurs() == -1) {
            return false;
        }
        return this.isText || this.position != ANY_POSITION || this.xpathComponent.getMaxOccurs() <= 1;
    }

    MWXpathableSchemaComponent xpathComponent() {
        return this.xpathComponent;
    }

    String getStepString() {
        return this.stepString;
    }

    void updateStepString() {
        this.stepString = this.isText ? this.textStepString() : this.componentStepString();
    }

    private String textStepString() {
        return "text()";
    }

    private String componentStepString() {
        String string = "";
        if (this.isAttribute) {
            string = string + "@";
        }
        string = string + this.namespacePrefix();
        string = string + this.localName;
        string = string + this.positionString();
        return string;
    }

    private String namespacePrefix() {
        if (this.namespace != null && !"".equals(this.namespace.getNamespacePrefix()) && !this.namespace.getSchema().getDefaultNamespaceUrl().equals(this.namespace.getNamespaceUrl())) {
            return this.namespace.getNamespacePrefix() + ":";
        }
        return "";
    }

    private String positionString() {
        if (this.position != ANY_POSITION) {
            return "[" + this.position + "]";
        }
        return "";
    }

    boolean isResolved() {
        return this.resolved;
    }

    boolean isValid() {
        return this.valid;
    }

    MWSchemaContextComponent resolveContext(MWSchemaContextComponent mWSchemaContextComponent) {
        if (mWSchemaContextComponent == null) {
            this.unresolve();
            return null;
        }
        if ("text()".equals(this.stepString)) {
            return this.resolveTextContext(mWSchemaContextComponent);
        }
        if (this.stepString.startsWith("@")) {
            return this.resolveAttributeContext(mWSchemaContextComponent);
        }
        return this.resolveElementContext(mWSchemaContextComponent);
    }

    private void unresolve() {
        this.namespace = null;
        this.xpathComponent = null;
        this.localName = "";
        this.isAttribute = false;
        this.isText = false;
        this.position = ANY_POSITION;
        this.resolved = false;
        this.valid = false;
    }

    private MWSchemaContextComponent resolveTextContext(MWSchemaContextComponent mWSchemaContextComponent) {
        this.namespace = null;
        this.isText = true;
        this.isAttribute = false;
        this.localName = "";
        this.position = ANY_POSITION;
        this.resolved = true;
        this.valid = mWSchemaContextComponent.containsText();
        return null;
    }

    private MWSchemaContextComponent resolveAttributeContext(MWSchemaContextComponent mWSchemaContextComponent) {
        this.isAttribute = true;
        this.position = ANY_POSITION;
        String string = this.stepString.substring(1);
        return this.resolveComponentContext(mWSchemaContextComponent, string);
    }

    private MWSchemaContextComponent resolveElementContext(MWSchemaContextComponent mWSchemaContextComponent) {
        this.isAttribute = false;
        this.position = ANY_POSITION;
        int n = this.stepString.indexOf(91);
        int n2 = this.stepString.indexOf(93);
        String string = this.stepString;
        if (n != -1 && n2 > n + 1) {
            try {
                this.position = Integer.valueOf(this.stepString.substring(n + 1, n2));
                string = this.stepString.substring(0, n);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return this.resolveComponentContext(mWSchemaContextComponent, string);
    }

    private MWSchemaContextComponent resolveComponentContext(MWSchemaContextComponent mWSchemaContextComponent, String string) {
        String string2 = "";
        String string3 = "";
        String string4 = string;
        int n = string.indexOf(58);
        if (n != -1) {
            string2 = string.substring(0, n);
            string3 = mWSchemaContextComponent.getSchema().namespaceUrlForPrefix(string2);
            string4 = string4.substring(n + 1);
        }
        this.localName = string4;
        this.namespace = mWSchemaContextComponent.getSchema().namespaceForUrl(string3);
        this.xpathComponent = this.isAttribute ? mWSchemaContextComponent.nestedAttribute(string3, string4) : mWSchemaContextComponent.nestedElement(string3, string4);
        this.resolved = this.xpathComponent != null;
        this.valid = this.xpathComponent != null && this.position <= this.xpathComponent.getMaxOccurs();
        return this.xpathComponent;
    }

    static int compareSchemaOrder(MWSchemaContextComponent mWSchemaContextComponent, MWXpathStep mWXpathStep, MWXpathStep mWXpathStep2) {
        MWElementDeclaration mWElementDeclaration;
        if (mWXpathStep.isAttribute()) {
            if (mWXpathStep2.isAttribute()) {
                return 0;
            }
            return -1;
        }
        if (mWXpathStep.isText()) {
            if (mWXpathStep2.isAttribute()) {
                return 1;
            }
            if (mWXpathStep2.isText()) {
                return 0;
            }
            return -1;
        }
        if (!mWXpathStep2.isElement()) {
            return 1;
        }
        MWElementDeclaration mWElementDeclaration2 = (MWElementDeclaration)mWXpathStep.xpathComponent();
        int n = mWSchemaContextComponent.compareSchemaOrder(mWElementDeclaration2, mWElementDeclaration = (MWElementDeclaration)mWXpathStep2.xpathComponent());
        if (n == 0) {
            return new Integer(mWXpathStep.position).compareTo(new Integer(mWXpathStep2.position));
        }
        return n;
    }
}

