/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.platformsmodel;

import java.io.File;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import java.util.Vector;
import org.eclipse.persistence.tools.workbench.platformsmodel.CorruptXMLException;
import org.eclipse.persistence.tools.workbench.platformsmodel.DatabasePlatformRepository;
import org.eclipse.persistence.tools.workbench.platformsmodel.DatabaseType;
import org.eclipse.persistence.tools.workbench.platformsmodel.JDBCType;
import org.eclipse.persistence.tools.workbench.platformsmodel.JDBCTypeRepository;
import org.eclipse.persistence.tools.workbench.platformsmodel.JDBCTypeToDatabaseTypeMapping;
import org.eclipse.persistence.tools.workbench.utility.ClassTools;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.XMLTools;
import org.eclipse.persistence.tools.workbench.utility.iterators.CloneIterator;
import org.eclipse.persistence.tools.workbench.utility.iterators.TransformationIterator;
import org.eclipse.persistence.tools.workbench.utility.node.AbstractNodeModel;
import org.eclipse.persistence.tools.workbench.utility.node.Node;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public final class DatabasePlatform
extends AbstractNodeModel {
    private String name;
    public static final String NAME_PROPERTY = "name";
    private String shortFileName;
    public static final String SHORT_FILE_NAME_PROPERTY = "shortFileName";
    private String runtimePlatformClassName;
    public static final String RUNTIME_PLATFORM_CLASS_NAME_PROPERTY = "runtimePlatformClassName";
    private boolean supportsNativeSequencing;
    public static final String SUPPORTS_NATIVE_SEQUENCING_PROPERTY = "supportsNativeSequencing";
    private boolean supportsIdentityClause;
    public static final String SUPPORTS_IDENTITY_CLAUSE_PROPERTY = "supportsIdentityClause";
    private boolean supportsNativeReturning;
    public static final String SUPPORTS_NATIVE_RETURNING_PROPERTY = "supportsNativeReturning";
    private Collection databaseTypes;
    public static final String DATABASE_TYPES_COLLECTION = "databaseTypes";
    private Collection jdbcTypeToDatabaseTypeMappings;
    public static final String JDBC_TYPE_TO_DATABASE_TYPE_MAPPINGS_COLLECTION = "jdbcTypeToDatabaseTypeMappings";

    DatabasePlatform(DatabasePlatformRepository databasePlatformRepository, File file) throws CorruptXMLException {
        super(databasePlatformRepository);
        this.read(file);
    }

    DatabasePlatform(DatabasePlatformRepository databasePlatformRepository, String string, String string2) {
        super(databasePlatformRepository);
        this.name = string;
        this.shortFileName = string2;
        this.initializeJDBCTypeToDatabaseTypeMappings();
    }

    protected void initialize() {
        super.initialize();
        this.runtimePlatformClassName = this.defaultRuntimePlatformClassName();
        this.supportsNativeSequencing = false;
        this.supportsNativeReturning = false;
        this.supportsIdentityClause = false;
        this.databaseTypes = new Vector();
        this.jdbcTypeToDatabaseTypeMappings = new Vector();
    }

    private String defaultRuntimePlatformClassName() {
        return "org.eclipse.persistence.platform.database.DatabasePlatform";
    }

    private void initializeJDBCTypeToDatabaseTypeMappings() {
        Iterator iterator = this.jdbcTypeRepository().jdbcTypes();
        while (iterator.hasNext()) {
            this.jdbcTypeToDatabaseTypeMappings.add(new JDBCTypeToDatabaseTypeMapping(this, (JDBCType)iterator.next()));
        }
    }

    public DatabasePlatformRepository getRepository() {
        return (DatabasePlatformRepository)this.getParent();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        if (string != null && string.equals(this.name)) {
            return;
        }
        this.getRepository().checkPlatformName(string);
        String string2 = this.name;
        this.name = string;
        this.firePropertyChanged(NAME_PROPERTY, string2, string);
    }

    public String getShortFileName() {
        return this.shortFileName;
    }

    public void setShortFileName(String string) {
        if (string != null && string.equals(this.shortFileName)) {
            return;
        }
        this.getRepository().checkPlatformShortFileName(string);
        String string2 = this.shortFileName;
        this.shortFileName = string;
        this.firePropertyChanged(SHORT_FILE_NAME_PROPERTY, string2, string);
    }

    public String getRuntimePlatformClassName() {
        return this.runtimePlatformClassName;
    }

    public void setRuntimePlatformClassName(String string) {
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("run-time platform class name is required");
        }
        String string2 = string;
        this.runtimePlatformClassName = string;
        this.firePropertyChanged(RUNTIME_PLATFORM_CLASS_NAME_PROPERTY, string2, string);
    }

    public boolean supportsNativeReturning() {
        return this.supportsNativeReturning;
    }

    public void setSupportsNativeReturning(boolean bl) {
        boolean bl2 = this.supportsNativeReturning;
        this.supportsNativeReturning = bl;
        this.firePropertyChanged(SUPPORTS_NATIVE_RETURNING_PROPERTY, bl2, bl);
    }

    public boolean supportsNativeSequencing() {
        return this.supportsNativeSequencing;
    }

    public void setSupportsNativeSequencing(boolean bl) {
        boolean bl2 = this.supportsNativeSequencing;
        this.supportsNativeSequencing = bl;
        this.firePropertyChanged(SUPPORTS_NATIVE_SEQUENCING_PROPERTY, bl2, bl);
        if (!bl) {
            this.setSupportsIdentityClause(false);
        }
    }

    public boolean supportsIdentityClause() {
        return this.supportsIdentityClause;
    }

    public void setSupportsIdentityClause(boolean bl) {
        boolean bl2 = this.supportsIdentityClause;
        this.supportsIdentityClause = bl;
        this.firePropertyChanged(SUPPORTS_IDENTITY_CLAUSE_PROPERTY, bl2, bl);
        if (bl) {
            this.setSupportsNativeSequencing(true);
        }
    }

    public Iterator databaseTypes() {
        return new CloneIterator(this.databaseTypes){

            protected void remove(Object object) {
                DatabasePlatform.this.removeDatabaseType((DatabaseType)object);
            }
        };
    }

    public int databaseTypesSize() {
        return this.databaseTypes.size();
    }

    public DatabaseType addDatabaseType(String string) {
        this.checkDatabaseTypeName(string);
        return this.addDatabaseType(new DatabaseType(this, string));
    }

    private DatabaseType addDatabaseType(DatabaseType databaseType) {
        this.addItemToCollection(databaseType, this.databaseTypes, DATABASE_TYPES_COLLECTION);
        return databaseType;
    }

    public void removeDatabaseType(DatabaseType databaseType) {
        this.removeItemFromCollection(databaseType, this.databaseTypes, DATABASE_TYPES_COLLECTION);
        this.databaseTypeRemoved(databaseType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void databaseTypeRemoved(DatabaseType databaseType) {
        Collection collection = this.jdbcTypeToDatabaseTypeMappings;
        synchronized (collection) {
            for (JDBCTypeToDatabaseTypeMapping jDBCTypeToDatabaseTypeMapping : this.jdbcTypeToDatabaseTypeMappings) {
                if (jDBCTypeToDatabaseTypeMapping.getDatabaseType() != databaseType) continue;
                jDBCTypeToDatabaseTypeMapping.setDatabaseType(null);
            }
        }
    }

    public void removeDatabaseTypes(Collection collection) {
        this.removeItemsFromCollection(collection, this.databaseTypes, DATABASE_TYPES_COLLECTION);
        this.databaseTypesRemoved(collection);
    }

    private void databaseTypesRemoved(Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.databaseTypeRemoved((DatabaseType)iterator.next());
        }
    }

    public void removeDatabaseTypes(Iterator iterator) {
        this.removeDatabaseTypes(CollectionTools.collection(iterator));
    }

    public Iterator jdbcTypeToDatabaseTypeMappings() {
        return new CloneIterator(this.jdbcTypeToDatabaseTypeMappings);
    }

    public int jdbcTypeToDatabaseTypeMappingsSize() {
        return this.jdbcTypeToDatabaseTypeMappings.size();
    }

    private JDBCTypeToDatabaseTypeMapping addJDBCTypeToDatabaseTypeMapping(JDBCType jDBCType) {
        return this.addJDBCTypeToDatabaseTypeMapping(new JDBCTypeToDatabaseTypeMapping(this, jDBCType));
    }

    private JDBCTypeToDatabaseTypeMapping addJDBCTypeToDatabaseTypeMapping(JDBCTypeToDatabaseTypeMapping jDBCTypeToDatabaseTypeMapping) {
        this.addItemToCollection(jDBCTypeToDatabaseTypeMapping, this.jdbcTypeToDatabaseTypeMappings, JDBC_TYPE_TO_DATABASE_TYPE_MAPPINGS_COLLECTION);
        return jDBCTypeToDatabaseTypeMapping;
    }

    private Iterator internalJDBCTypeToDatabaseTypeMappings() {
        return new CloneIterator(this.jdbcTypeToDatabaseTypeMappings){

            protected void remove(Object object) {
                DatabasePlatform.this.removeJDBCTypeToDatabaseTypeMapping((JDBCTypeToDatabaseTypeMapping)object);
            }
        };
    }

    void removeJDBCTypeToDatabaseTypeMapping(JDBCTypeToDatabaseTypeMapping jDBCTypeToDatabaseTypeMapping) {
        this.removeItemFromCollection(jDBCTypeToDatabaseTypeMapping, this.jdbcTypeToDatabaseTypeMappings, JDBC_TYPE_TO_DATABASE_TYPE_MAPPINGS_COLLECTION);
    }

    public DatabaseType databaseTypeNamed(String string) {
        Collection collection = this.databaseTypes;
        synchronized (collection) {
            for (DatabaseType databaseType : this.databaseTypes) {
                if (!databaseType.getName().equals(string)) continue;
                return databaseType;
            }
            throw new IllegalArgumentException("missing database type named: " + string + " (platform: " + this.name + ")");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsDatabaseTypeNamed(String string) {
        Collection collection = this.databaseTypes;
        synchronized (collection) {
            for (DatabaseType databaseType : this.databaseTypes) {
                if (!databaseType.getName().equals(string)) continue;
                return true;
            }
        }
        return false;
    }

    private JDBCTypeRepository jdbcTypeRepository() {
        return this.getRepository().getJDBCTypeRepository();
    }

    private JDBCType jdbcTypeForCode(int n) {
        return this.jdbcTypeRepository().jdbcTypeForCode(n);
    }

    JDBCType jdbcTypeNamed(String string) {
        return this.jdbcTypeRepository().jdbcTypeNamed(string);
    }

    public DatabaseType defaultDatabaseType() {
        return this.databaseTypeFor(this.jdbcTypeRepository().getDefaultJDBCType());
    }

    public DatabaseType databaseTypeFor(DatabaseType databaseType) {
        try {
            return this.databaseTypeNamed(databaseType.getName());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return this.databaseTypeFor(databaseType.getJDBCType());
        }
    }

    private Iterator databaseTypeNames() {
        return new TransformationIterator(this.databaseTypes()){

            protected Object transform(Object object) {
                return ((DatabaseType)object).getName();
            }
        };
    }

    private boolean maps(JDBCType jDBCType) {
        Iterator iterator = this.jdbcTypeToDatabaseTypeMappings.iterator();
        while (iterator.hasNext()) {
            if (((JDBCTypeToDatabaseTypeMapping)iterator.next()).getJDBCType() != jDBCType) continue;
            return true;
        }
        return false;
    }

    private JDBCTypeToDatabaseTypeMapping jdbcTypeToDatabaseTypeMappingFor(JDBCType jDBCType) {
        Collection collection = this.jdbcTypeToDatabaseTypeMappings;
        synchronized (collection) {
            for (JDBCTypeToDatabaseTypeMapping jDBCTypeToDatabaseTypeMapping : this.jdbcTypeToDatabaseTypeMappings) {
                if (!jDBCTypeToDatabaseTypeMapping.maps(jDBCType)) continue;
                return jDBCTypeToDatabaseTypeMapping;
            }
            throw new IllegalStateException("JDBC type to database type mapping is missing: " + jDBCType.getName() + " (platform: " + this.name + ")");
        }
    }

    private DatabaseType databaseTypeFor(JDBCType jDBCType) {
        return this.jdbcTypeToDatabaseTypeMappingFor(jDBCType).getDatabaseType();
    }

    public DatabaseType databaseTypeForJDBCTypeCode(int n) {
        return this.databaseTypeFor(this.jdbcTypeForCode(n));
    }

    public boolean javaTypeDeclarationCanBeMappedToDatabaseType(String string, int n) {
        return this.jdbcTypeRepository().javaTypeDeclarationCanBeMappedToJDBCType(string, n);
    }

    public DatabaseType databaseTypeForJavaTypeDeclaration(String string, int n) {
        return this.databaseTypeFor(this.jdbcTypeRepository().jdbcTypeForJavaTypeDeclaration(string, n));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addChildrenTo(List list) {
        super.addChildrenTo(list);
        Collection collection = this.databaseTypes;
        synchronized (collection) {
            list.addAll(this.databaseTypes);
        }
        collection = this.jdbcTypeToDatabaseTypeMappings;
        synchronized (collection) {
            list.addAll(this.jdbcTypeToDatabaseTypeMappings);
        }
    }

    public void nodeRemoved(Node node) {
        super.nodeRemoved(node);
        Iterator iterator = this.internalJDBCTypeToDatabaseTypeMappings();
        while (iterator.hasNext()) {
            if (((JDBCTypeToDatabaseTypeMapping)iterator.next()).getJDBCType() != node) continue;
            iterator.remove();
            break;
        }
    }

    void jdbcTypeAdded(JDBCType jDBCType) {
        this.addJDBCTypeToDatabaseTypeMapping(jDBCType);
    }

    void cloneFrom(DatabasePlatform databasePlatform) {
        AbstractNodeModel abstractNodeModel;
        AbstractNodeModel abstractNodeModel2;
        this.setComment(databasePlatform.getComment());
        this.runtimePlatformClassName = databasePlatform.getRuntimePlatformClassName();
        this.supportsNativeSequencing = databasePlatform.supportsNativeSequencing();
        this.supportsNativeReturning = databasePlatform.supportsNativeReturning();
        this.supportsIdentityClause = databasePlatform.supportsIdentityClause();
        Iterator iterator = databasePlatform.databaseTypes();
        while (iterator.hasNext()) {
            abstractNodeModel2 = (DatabaseType)iterator.next();
            abstractNodeModel = this.addDatabaseType(((DatabaseType)abstractNodeModel2).getName());
            ((DatabaseType)abstractNodeModel).cloneFrom((DatabaseType)abstractNodeModel2);
        }
        iterator = databasePlatform.jdbcTypeToDatabaseTypeMappings();
        while (iterator.hasNext()) {
            abstractNodeModel2 = (JDBCTypeToDatabaseTypeMapping)iterator.next();
            abstractNodeModel = this.jdbcTypeToDatabaseTypeMappingFor(((JDBCTypeToDatabaseTypeMapping)abstractNodeModel2).getJDBCType());
            ((JDBCTypeToDatabaseTypeMapping)abstractNodeModel).cloneFrom((JDBCTypeToDatabaseTypeMapping)abstractNodeModel2);
        }
    }

    private void checkDatabaseType(DatabaseType databaseType) {
        this.checkDatabaseTypeName(databaseType.getName());
    }

    void checkDatabaseTypeName(String string) {
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("database type name is required");
        }
        if (CollectionTools.contains(this.databaseTypeNames(), (Object)string)) {
            throw new IllegalArgumentException("duplicate database type name: " + string);
        }
    }

    private void read(File file) throws CorruptXMLException {
        this.shortFileName = file.getName();
        Document document = XMLTools.parse(file);
        org.w3c.dom.Node node = XMLTools.child(document, "database-platform");
        if (node == null) {
            throw new CorruptXMLException("missing root node: database-platform (" + file.getPath() + ")");
        }
        this.name = XMLTools.childTextContent(node, NAME_PROPERTY, null);
        if (this.name == null || this.name.length() == 0) {
            throw new CorruptXMLException("name is required (" + file.getPath() + ")");
        }
        ClassTools.setFieldValue(this, "comment", XMLTools.childTextContent(node, "comment", ""));
        this.runtimePlatformClassName = XMLTools.childTextContent(node, "runtime-platform-class", null);
        if (this.runtimePlatformClassName == null || this.runtimePlatformClassName.length() == 0) {
            throw this.buildCorruptXMLException("run-time platform class name is required");
        }
        this.supportsNativeSequencing = XMLTools.childBooleanContent(node, "supports-native-sequencing", false);
        this.supportsNativeReturning = XMLTools.childBooleanContent(node, "supports-native-returning", false);
        this.supportsIdentityClause = XMLTools.childBooleanContent(node, "supports-identity-clause", false);
        if (this.supportsIdentityClause && !this.supportsNativeSequencing) {
            throw this.buildCorruptXMLException("platform must support native sequencing if it supports the IDENTITY clause");
        }
        this.readDatabaseTypeNodes(XMLTools.child(node, "database-types"));
        this.readJDBCMappingNodes(XMLTools.child(node, "jdbc-mappings"));
    }

    private void readDatabaseTypeNodes(org.w3c.dom.Node node) throws CorruptXMLException {
        org.w3c.dom.Node[] nodeArray = XMLTools.children(node, "database-type");
        int n = nodeArray.length;
        for (int i = 0; i < n; ++i) {
            DatabaseType databaseType = new DatabaseType(this, nodeArray[i]);
            try {
                this.checkDatabaseType(databaseType);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw this.buildCorruptXMLException(illegalArgumentException);
            }
            this.databaseTypes.add(databaseType);
        }
    }

    private void readJDBCMappingNodes(org.w3c.dom.Node node) throws CorruptXMLException {
        org.w3c.dom.Node[] nodeArray = XMLTools.children(node, "jdbc-mapping");
        int n = nodeArray.length;
        for (int i = 0; i < n; ++i) {
            JDBCTypeToDatabaseTypeMapping jDBCTypeToDatabaseTypeMapping = new JDBCTypeToDatabaseTypeMapping(this, nodeArray[i]);
            if (this.maps(jDBCTypeToDatabaseTypeMapping.getJDBCType())) {
                throw this.buildCorruptXMLException("duplicate JDBC to database type mapping: " + jDBCTypeToDatabaseTypeMapping);
            }
            this.jdbcTypeToDatabaseTypeMappings.add(jDBCTypeToDatabaseTypeMapping);
        }
        if (this.jdbcTypeToDatabaseTypeMappings.size() != this.jdbcTypeRepository().jdbcTypesSize()) {
            throw this.buildCorruptXMLException("missing JDBC to database type mappings (number of mappings: " + this.jdbcTypeToDatabaseTypeMappings.size() + " - number of JDBC types: " + this.jdbcTypeRepository().jdbcTypesSize() + ")");
        }
    }

    private CorruptXMLException buildCorruptXMLException(String string) {
        return new CorruptXMLException(string + " (platform: " + this.name + ")");
    }

    private CorruptXMLException buildCorruptXMLException(Throwable throwable) {
        return new CorruptXMLException("platform: " + this.name, throwable);
    }

    void write(File file) {
        if (this.isCleanBranch()) {
            return;
        }
        Document document = XMLTools.newDocument();
        Element element = document.createElement("database-platform");
        document.appendChild(element);
        XMLTools.addSimpleTextNode((org.w3c.dom.Node)element, NAME_PROPERTY, this.name);
        XMLTools.addSimpleTextNode((org.w3c.dom.Node)element, "comment", (String)ClassTools.getFieldValue(this, "comment"), "");
        XMLTools.addSimpleTextNode((org.w3c.dom.Node)element, "runtime-platform-class", this.runtimePlatformClassName);
        XMLTools.addSimpleTextNode((org.w3c.dom.Node)element, "supports-native-sequencing", this.supportsNativeSequencing, false);
        XMLTools.addSimpleTextNode((org.w3c.dom.Node)element, "supports-native-returning", this.supportsNativeReturning, false);
        XMLTools.addSimpleTextNode((org.w3c.dom.Node)element, "supports-identity-clause", this.supportsIdentityClause, false);
        this.writeDatabaseTypeNodes(element.appendChild(document.createElement("database-types")));
        this.writeJDBCMappingNodes(element.appendChild(document.createElement("jdbc-mappings")));
        XMLTools.print(document, new File(file, this.shortFileName));
        this.markEntireBranchClean();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeDatabaseTypeNodes(org.w3c.dom.Node node) {
        Document document = node.getOwnerDocument();
        Collection collection = this.databaseTypes;
        synchronized (collection) {
            Iterator iterator = new TreeSet(this.databaseTypes).iterator();
            while (iterator.hasNext()) {
                Element element = document.createElement("database-type");
                node.appendChild(element);
                ((DatabaseType)iterator.next()).write(element);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeJDBCMappingNodes(org.w3c.dom.Node node) {
        Document document = node.getOwnerDocument();
        Collection collection = this.jdbcTypeToDatabaseTypeMappings;
        synchronized (collection) {
            Iterator iterator = new TreeSet(this.jdbcTypeToDatabaseTypeMappings).iterator();
            while (iterator.hasNext()) {
                Element element = document.createElement("jdbc-mapping");
                node.appendChild(element);
                ((JDBCTypeToDatabaseTypeMapping)iterator.next()).write(element);
            }
        }
    }

    public String displayString() {
        return this.name;
    }

    public void toString(StringBuffer stringBuffer) {
        stringBuffer.append(this.name);
    }
}

