/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.platformsmodel;

import org.eclipse.persistence.tools.workbench.platformsmodel.CorruptXMLException;
import org.eclipse.persistence.tools.workbench.utility.XMLTools;
import org.eclipse.persistence.tools.workbench.utility.node.AbstractNodeModel;
import org.w3c.dom.Node;

public final class JavaTypeDeclaration
extends AbstractNodeModel {
    private String javaClassName;
    private int arrayDepth;

    JavaTypeDeclaration(AbstractNodeModel abstractNodeModel, Node node) throws CorruptXMLException {
        super(abstractNodeModel);
        this.read(node);
    }

    JavaTypeDeclaration(AbstractNodeModel abstractNodeModel, String string, int n) {
        super(abstractNodeModel);
        this.javaClassName = string;
        this.arrayDepth = n;
        this.checkState();
    }

    JavaTypeDeclaration(AbstractNodeModel abstractNodeModel, String string) {
        this(abstractNodeModel, string, 0);
    }

    public String getJavaClassName() {
        return this.javaClassName;
    }

    public int getArrayDepth() {
        return this.arrayDepth;
    }

    boolean equals(String string, int n) {
        return this.javaClassName.equals(string) && this.arrayDepth == n;
    }

    boolean equals(JavaTypeDeclaration javaTypeDeclaration) {
        return this.equals(javaTypeDeclaration.javaClassName, javaTypeDeclaration.arrayDepth);
    }

    private void checkState() {
        if (this.javaClassName == null || this.javaClassName.length() == 0) {
            throw new IllegalStateException("Java class name is required");
        }
        if (this.arrayDepth < 0) {
            throw new IllegalStateException("array depth must be greater than or equal to zero: " + this.arrayDepth);
        }
        if (this.javaClassName.equals(Void.TYPE.getName()) && this.arrayDepth != 0) {
            throw new IllegalStateException("'void' must have an array depth of zero: " + this.arrayDepth);
        }
    }

    private void read(Node node) throws CorruptXMLException {
        if (node == null) {
            throw new CorruptXMLException("missing node");
        }
        this.javaClassName = XMLTools.childTextContent(node, "java-class-name", null);
        this.arrayDepth = XMLTools.childIntContent(node, "array-depth", 0);
        try {
            this.checkState();
        }
        catch (IllegalStateException illegalStateException) {
            throw new CorruptXMLException("illegal state: " + this, illegalStateException);
        }
    }

    void write(Node node) {
        XMLTools.addSimpleTextNode(node, "java-class-name", this.javaClassName);
        XMLTools.addSimpleTextNode(node, "array-depth", this.arrayDepth, 0);
    }

    public String displayString() {
        StringBuffer stringBuffer = new StringBuffer();
        this.displayStringOn(stringBuffer);
        return stringBuffer.toString();
    }

    public void displayStringOn(StringBuffer stringBuffer) {
        stringBuffer.append(this.javaClassName);
        int n = this.arrayDepth;
        while (n-- > 0) {
            stringBuffer.append("[]");
        }
    }

    public void toString(StringBuffer stringBuffer) {
        this.displayStringOn(stringBuffer);
    }
}

