/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.utility;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.Stack;
import org.eclipse.persistence.tools.workbench.utility.string.StringTools;

public final class ClassTools {
    public static final Class[] ZERO_PARAMETER_TYPES = new Class[0];
    public static final Object[] ZERO_PARAMETERS = new Object[0];
    private static final String CR = StringTools.CR;
    public static final char NESTED_CLASS_NAME_SEPARATOR = '$';
    public static final char ARRAY_INDICATOR = '[';
    public static final char REFERENCE_CLASS_CODE = 'L';
    public static final char REFERENCE_CLASS_NAME_DELIMITER = ';';
    private static PrimitiveClassCode[] primitiveClassCodes;
    public static final char BYTE_CODE = 'B';
    public static final char CHAR_CODE = 'C';
    public static final char DOUBLE_CODE = 'D';
    public static final char FLOAT_CODE = 'F';
    public static final char INT_CODE = 'I';
    public static final char LONG_CODE = 'J';
    public static final char SHORT_CODE = 'S';
    public static final char BOOLEAN_CODE = 'Z';
    public static final char VOID_CODE = 'V';

    public static Field[] allFields(Class clazz) {
        Stack stack = new Stack();
        for (Class clazz2 = clazz; clazz2 != null; clazz2 = clazz2.getSuperclass()) {
            ClassTools.pushDeclaredFields(clazz2, stack);
        }
        Collections.reverse(stack);
        return stack.toArray(new Field[stack.size()]);
    }

    public static Method[] allMethods(Class clazz) {
        Stack stack = new Stack();
        for (Class clazz2 = clazz; clazz2 != null; clazz2 = clazz2.getSuperclass()) {
            ClassTools.pushDeclaredMethods(clazz2, stack);
        }
        Collections.reverse(stack);
        return stack.toArray(new Method[stack.size()]);
    }

    public static Object attemptNewInstance(Class clazz) throws NoSuchMethodException {
        return ClassTools.attemptNewInstance(clazz, ZERO_PARAMETER_TYPES, ZERO_PARAMETERS);
    }

    public static Object attemptNewInstance(Class clazz, Class[] classArray, Object[] objectArray) throws NoSuchMethodException {
        try {
            return ClassTools.constructor(clazz, classArray).newInstance(objectArray);
        }
        catch (InstantiationException instantiationException) {
            throw new RuntimeException(instantiationException + CR + ClassTools.fullyQualifiedConstructorSignature(clazz, classArray), instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException(illegalAccessException + CR + ClassTools.fullyQualifiedConstructorSignature(clazz, classArray), illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new RuntimeException(ClassTools.fullyQualifiedConstructorSignature(clazz, classArray) + CR + invocationTargetException.getTargetException(), invocationTargetException);
        }
    }

    public static Object attemptNewInstance(Class clazz, Class clazz2, Object object) throws NoSuchMethodException {
        return ClassTools.attemptNewInstance(clazz, new Class[]{clazz2}, new Object[]{object});
    }

    public static Object attemptToGetFieldValue(Object object, String string) throws NoSuchFieldException {
        try {
            return ClassTools.field(object, string).get(object);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException(illegalAccessException + CR + ClassTools.fullyQualifiedFieldName(object, string), illegalAccessException);
        }
    }

    public static Object attemptToGetStaticFieldValue(Class clazz, String string) throws NoSuchFieldException {
        try {
            return ClassTools.field(clazz, string).get(null);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException(illegalAccessException + CR + ClassTools.fullyQualifiedFieldName(clazz, string), illegalAccessException);
        }
    }

    public static Object attemptToInvokeMethod(Object object, String string) throws NoSuchMethodException {
        return ClassTools.attemptToInvokeMethod(object, string, ZERO_PARAMETER_TYPES, ZERO_PARAMETERS);
    }

    public static Object attemptToInvokeMethod(Object object, String string, Class clazz, Object object2) throws NoSuchMethodException {
        return ClassTools.attemptToInvokeMethod(object, string, new Class[]{clazz}, new Object[]{object2});
    }

    public static Object attemptToInvokeMethod(Object object, String string, Class[] classArray, Object[] objectArray) throws NoSuchMethodException {
        return ClassTools.invokeMethod(ClassTools.method(object, string, classArray), object, objectArray);
    }

    public static Object attemptToInvokeMethodWithException(Object object, String string, Class[] classArray, Object[] objectArray) throws Throwable, NoSuchMethodException {
        return ClassTools.invokeMethodWithException(ClassTools.method(object, string, classArray), object, objectArray);
    }

    public static Object attemptToInvokeStaticMethod(Class clazz, String string) throws NoSuchMethodException {
        return ClassTools.attemptToInvokeStaticMethod(clazz, string, ZERO_PARAMETER_TYPES, ZERO_PARAMETERS);
    }

    public static Object attemptToInvokeStaticMethod(Class clazz, String string, Class[] classArray, Object[] objectArray) throws NoSuchMethodException {
        return ClassTools.invokeStaticMethod(ClassTools.staticMethod(clazz, string, classArray), objectArray);
    }

    public static Object attemptToInvokeStaticMethod(Class clazz, String string, Class clazz2, Object object) throws NoSuchMethodException {
        return ClassTools.attemptToInvokeStaticMethod(clazz, string, new Class[]{clazz2}, new Object[]{object});
    }

    public static void attemptToSetFieldValue(Object object, String string, Object object2) throws NoSuchFieldException {
        try {
            ClassTools.field(object, string).set(object, object2);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException(illegalAccessException + CR + ClassTools.fullyQualifiedFieldName(object, string), illegalAccessException);
        }
    }

    public static void attemptToSetStaticFieldValue(Class clazz, String string, Object object) throws NoSuchFieldException {
        try {
            ClassTools.field(clazz, string).set(null, object);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException(illegalAccessException + CR + ClassTools.fullyQualifiedFieldName(clazz, string), illegalAccessException);
        }
    }

    public static Constructor constructor(Class clazz) throws NoSuchMethodException {
        return ClassTools.constructor(clazz, ZERO_PARAMETER_TYPES);
    }

    public static Constructor constructor(Class clazz, Class[] classArray) throws NoSuchMethodException {
        Constructor constructor = clazz.getDeclaredConstructor(classArray);
        constructor.setAccessible(true);
        return constructor;
    }

    public static Constructor constructor(Class clazz, Class clazz2) throws NoSuchMethodException {
        return ClassTools.constructor(clazz, new Class[]{clazz2});
    }

    public static Field[] declaredFields(Class clazz) {
        Field[] fieldArray = clazz.getDeclaredFields();
        for (int i = 0; i < fieldArray.length; ++i) {
            fieldArray[i].setAccessible(true);
        }
        return fieldArray;
    }

    public static Method[] declaredMethods(Class clazz) {
        Method[] methodArray = clazz.getDeclaredMethods();
        for (int i = 0; i < methodArray.length; ++i) {
            methodArray[i].setAccessible(true);
        }
        return methodArray;
    }

    public static Constructor defaultConstructor(Class clazz) throws NoSuchMethodException {
        return ClassTools.constructor(clazz);
    }

    public static Field field(Class clazz, String string) throws NoSuchFieldException {
        Field field = null;
        try {
            field = clazz.getDeclaredField(string);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            Class clazz2 = clazz.getSuperclass();
            if (clazz2 == null) {
                throw noSuchFieldException;
            }
            return ClassTools.field(clazz2, string);
        }
        field.setAccessible(true);
        return field;
    }

    public static Field field(Object object, String string) throws NoSuchFieldException {
        return ClassTools.field(object.getClass(), string);
    }

    private static String fullyQualifiedConstructorSignature(Class clazz, Class[] classArray) {
        return ClassTools.fullyQualifiedMethodSignature(clazz, null, classArray);
    }

    private static String fullyQualifiedFieldName(Class clazz, String string) {
        StringBuffer stringBuffer = new StringBuffer(200);
        stringBuffer.append(clazz.getName());
        stringBuffer.append('.');
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    private static String fullyQualifiedFieldName(Object object, String string) {
        return ClassTools.fullyQualifiedFieldName(object.getClass(), string);
    }

    private static String fullyQualifiedMethodSignature(Class clazz, String string, Class[] classArray) {
        StringBuffer stringBuffer = new StringBuffer(200);
        stringBuffer.append(clazz.getName());
        if (string != null) {
            stringBuffer.append('.');
            stringBuffer.append(string);
        }
        stringBuffer.append('(');
        for (int i = 0; i < classArray.length; ++i) {
            stringBuffer.append(classArray[i].getName());
            if (i >= classArray.length - 1) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    private static String fullyQualifiedMethodSignature(Object object, String string, Class[] classArray) {
        return ClassTools.fullyQualifiedMethodSignature(object.getClass(), string, classArray);
    }

    public static Object getFieldValue(Object object, String string) {
        try {
            return ClassTools.attemptToGetFieldValue(object, string);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new RuntimeException(noSuchFieldException + CR + ClassTools.fullyQualifiedFieldName(object, string), noSuchFieldException);
        }
    }

    public static Object getStaticFieldValue(Class clazz, String string) {
        try {
            return ClassTools.attemptToGetStaticFieldValue(clazz, string);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new RuntimeException(noSuchFieldException + CR + ClassTools.fullyQualifiedFieldName(clazz, string), noSuchFieldException);
        }
    }

    public static Object invokeMethod(Object object, String string) {
        return ClassTools.invokeMethod(object, string, ZERO_PARAMETER_TYPES, ZERO_PARAMETERS);
    }

    public static Object invokeMethod(Object object, String string, Class[] classArray, Object[] objectArray) {
        try {
            return ClassTools.attemptToInvokeMethod(object, string, classArray, objectArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new RuntimeException(noSuchMethodException + CR + ClassTools.fullyQualifiedMethodSignature(object, string, classArray), noSuchMethodException);
        }
    }

    public static Object invokeMethod(Object object, String string, Class clazz, Object object2) {
        return ClassTools.invokeMethod(object, string, new Class[]{clazz}, new Object[]{object2});
    }

    public static Object invokeMethodWithException(Object object, String string) throws Throwable {
        return ClassTools.invokeMethodWithException(object, string, ZERO_PARAMETER_TYPES, ZERO_PARAMETERS);
    }

    public static Object invokeMethodWithException(Object object, String string, Class clazz, Object object2) throws Throwable {
        return ClassTools.invokeMethodWithException(object, string, new Class[]{clazz}, new Object[]{object2});
    }

    public static Object invokeMethodWithException(Object object, String string, Class[] classArray, Object[] objectArray) throws Throwable {
        try {
            return ClassTools.attemptToInvokeMethodWithException(object, string, classArray, objectArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new RuntimeException(noSuchMethodException + CR + ClassTools.fullyQualifiedMethodSignature(object, string, classArray), noSuchMethodException);
        }
    }

    public static Object invokeMethod(Method method, Object object, Object[] objectArray) {
        try {
            return method.invoke(object, objectArray);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException(illegalAccessException + CR + method, illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new RuntimeException(method + CR + invocationTargetException.getTargetException(), invocationTargetException);
        }
    }

    public static Object invokeMethodWithException(Method method, Object object, Object[] objectArray) throws Throwable {
        try {
            return method.invoke(object, objectArray);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException(illegalAccessException + CR + method, illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getCause();
            if (throwable == null) {
                throw new RuntimeException(method.toString(), invocationTargetException);
            }
            throw throwable;
        }
    }

    public static Object invokeStaticMethod(Class clazz, String string) {
        return ClassTools.invokeStaticMethod(clazz, string, ZERO_PARAMETER_TYPES, ZERO_PARAMETERS);
    }

    public static Object invokeStaticMethod(Class clazz, String string, Class[] classArray, Object[] objectArray) {
        try {
            return ClassTools.attemptToInvokeStaticMethod(clazz, string, classArray, objectArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new RuntimeException(noSuchMethodException + CR + ClassTools.fullyQualifiedMethodSignature(clazz, string, classArray), noSuchMethodException);
        }
    }

    public static Object invokeStaticMethod(Class clazz, String string, Class clazz2, Object object) {
        return ClassTools.invokeStaticMethod(clazz, string, new Class[]{clazz2}, new Object[]{object});
    }

    public static Object invokeStaticMethod(Method method, Object[] objectArray) {
        return ClassTools.invokeMethod(method, null, objectArray);
    }

    public static Method method(Class clazz, String string) throws NoSuchMethodException {
        return ClassTools.method(clazz, string, ZERO_PARAMETER_TYPES);
    }

    public static Method method(Class clazz, String string, Class[] classArray) throws NoSuchMethodException {
        Method method = null;
        try {
            method = clazz.getDeclaredMethod(string, classArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            Class clazz2 = clazz.getSuperclass();
            if (clazz2 == null) {
                throw noSuchMethodException;
            }
            return ClassTools.method(clazz2, string, classArray);
        }
        method.setAccessible(true);
        return method;
    }

    public static Method method(Class clazz, String string, Class clazz2) throws NoSuchMethodException {
        return ClassTools.method(clazz, string, new Class[]{clazz2});
    }

    public static Method method(Object object, String string) throws NoSuchMethodException {
        return ClassTools.method(object.getClass(), string);
    }

    public static Method method(Object object, String string, Class[] classArray) throws NoSuchMethodException {
        return ClassTools.method(object.getClass(), string, classArray);
    }

    public static Method method(Object object, String string, Class clazz) throws NoSuchMethodException {
        return ClassTools.method(object.getClass(), string, clazz);
    }

    public static Class classForName(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RuntimeException(string, classNotFoundException);
        }
    }

    public static Object newInstance(Class clazz) {
        return ClassTools.newInstance(clazz, ZERO_PARAMETER_TYPES, ZERO_PARAMETERS);
    }

    public static Object newInstance(String string) throws ClassNotFoundException {
        return ClassTools.newInstance(string, null);
    }

    public static Object newInstance(String string, ClassLoader classLoader) throws ClassNotFoundException {
        return ClassTools.newInstance(Class.forName(string, true, classLoader));
    }

    public static Object newInstance(Class clazz, Class[] classArray, Object[] objectArray) {
        try {
            return ClassTools.attemptNewInstance(clazz, classArray, objectArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new RuntimeException(noSuchMethodException + CR + ClassTools.fullyQualifiedConstructorSignature(clazz, classArray), noSuchMethodException);
        }
    }

    public static Object newInstance(String string, Class[] classArray, Object[] objectArray) throws ClassNotFoundException {
        return ClassTools.newInstance(string, classArray, objectArray, null);
    }

    public static Object newInstance(String string, Class[] classArray, Object[] objectArray, ClassLoader classLoader) throws ClassNotFoundException {
        return ClassTools.newInstance(Class.forName(string, true, classLoader), classArray, objectArray);
    }

    public static Object newInstance(Class clazz, Class clazz2, Object object) {
        return ClassTools.newInstance(clazz, new Class[]{clazz2}, new Object[]{object});
    }

    public static Object newInstance(String string, Class clazz, Object object) throws ClassNotFoundException {
        return ClassTools.newInstance(string, clazz, object, null);
    }

    public static Object newInstance(String string, Class clazz, Object object, ClassLoader classLoader) throws ClassNotFoundException {
        return ClassTools.newInstance(Class.forName(string, false, classLoader), clazz, object);
    }

    private static void pushDeclaredFields(Class clazz, Stack stack) {
        Field[] fieldArray = ClassTools.declaredFields(clazz);
        for (int i = fieldArray.length - 1; i >= 0; --i) {
            stack.push(fieldArray[i]);
        }
    }

    private static void pushDeclaredMethods(Class clazz, Stack stack) {
        Method[] methodArray = ClassTools.declaredMethods(clazz);
        for (int i = methodArray.length - 1; i >= 0; --i) {
            stack.push(methodArray[i]);
        }
    }

    public static void setFieldValue(Object object, String string, Object object2) {
        try {
            ClassTools.attemptToSetFieldValue(object, string, object2);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new RuntimeException(noSuchFieldException + CR + ClassTools.fullyQualifiedFieldName(object, string), noSuchFieldException);
        }
    }

    public static void setStaticFieldValue(Class clazz, String string, Object object) {
        try {
            ClassTools.attemptToSetStaticFieldValue(clazz, string, object);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new RuntimeException(noSuchFieldException + CR + ClassTools.fullyQualifiedFieldName(clazz, string), noSuchFieldException);
        }
    }

    public static String shortClassNameForObject(Object object) {
        return ClassTools.shortNameFor(object.getClass());
    }

    public static String shortNameForClassNamed(String string) {
        return string.substring(string.lastIndexOf(46) + 1);
    }

    public static String shortNameFor(Class clazz) {
        return ClassTools.shortNameForClassNamed(clazz.getName());
    }

    public static String nestedClassNameForObject(Object object) {
        return ClassTools.nestedNameFor(object.getClass());
    }

    public static String nestedNameForClassNamed(String string) {
        return string.substring(string.lastIndexOf(36) + 1);
    }

    public static String nestedNameFor(Class clazz) {
        return ClassTools.nestedNameForClassNamed(clazz.getName());
    }

    public static String toStringClassNameForObject(Object object) {
        return ClassTools.toStringNameFor(object.getClass());
    }

    public static String toStringNameForClassNamed(String string) {
        return ClassTools.classNamedIsMember(string) ? string.substring(string.lastIndexOf(36) + 1) : string.substring(string.lastIndexOf(46) + 1);
    }

    public static String toStringNameFor(Class clazz) {
        return ClassTools.toStringNameForClassNamed(clazz.getName());
    }

    public static String packageNameFor(Class clazz) {
        return ClassTools.packageNameForClassNamed(clazz.getName());
    }

    public static String packageNameForClassNamed(String string) {
        int n = string.lastIndexOf(46);
        if (n == -1) {
            return "";
        }
        return string.substring(0, n);
    }

    public static String shortNameWithPackage(Class clazz) {
        StringBuffer stringBuffer = new StringBuffer(200);
        stringBuffer.append(ClassTools.shortNameFor(clazz));
        if (!clazz.isPrimitive()) {
            stringBuffer.append(" (");
            stringBuffer.append(ClassTools.packageNameFor(clazz));
            stringBuffer.append(')');
        }
        return stringBuffer.toString();
    }

    public static Method staticMethod(Class clazz, String string) throws NoSuchMethodException {
        return ClassTools.staticMethod(clazz, string, ZERO_PARAMETER_TYPES);
    }

    public static Method staticMethod(Class clazz, String string, Class[] classArray) throws NoSuchMethodException {
        Method method = ClassTools.method(clazz, string, classArray);
        if (Modifier.isStatic(method.getModifiers())) {
            return method;
        }
        throw new NoSuchMethodException(ClassTools.fullyQualifiedMethodSignature(clazz, string, classArray));
    }

    public static Method staticMethod(Class clazz, String string, Class clazz2) throws NoSuchMethodException {
        return ClassTools.staticMethod(clazz, string, new Class[]{clazz2});
    }

    public static boolean classNamedIsDeclarable(String string) {
        if (string.charAt(0) == '[') {
            return false;
        }
        int n = string.indexOf(36);
        if (n == -1) {
            return true;
        }
        do {
            if (!Character.isDigit(string.charAt(++n))) continue;
            return false;
        } while ((n = string.indexOf(36, n)) != -1);
        return true;
    }

    public static boolean classNamedIsTopLevel(String string) {
        if (ClassTools.classNamedIsArray(string)) {
            return false;
        }
        return string.indexOf(36) == -1;
    }

    public static boolean classNamedIsMember(String string) {
        if (ClassTools.classNamedIsArray(string)) {
            return false;
        }
        int n = string.indexOf(36);
        if (n == -1) {
            return false;
        }
        do {
            if (!Character.isDigit(string.charAt(++n))) continue;
            return false;
        } while ((n = string.indexOf(36, n)) != -1);
        return true;
    }

    public static boolean classNamedIsLocal(String string) {
        if (ClassTools.classNamedIsArray(string)) {
            return false;
        }
        int n = string.indexOf(36);
        if (n == -1) {
            return false;
        }
        if (!Character.isDigit(string.charAt(n + 1))) {
            return false;
        }
        for (int i = n + 2; i < string.length(); ++i) {
            if (!Character.isJavaIdentifierStart(string.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public static boolean classNamedIsAnonymous(String string) {
        if (ClassTools.classNamedIsArray(string)) {
            return false;
        }
        int n = string.indexOf(36);
        if (n == -1) {
            return false;
        }
        int n2 = n + 1;
        int n3 = string.length();
        while (n3-- > n2) {
            if (Character.isDigit(string.charAt(n3))) continue;
            return false;
        }
        return true;
    }

    public static int arrayDepthFor(Class clazz) {
        int n = 0;
        while (clazz.isArray()) {
            ++n;
            clazz = clazz.getComponentType();
        }
        return n;
    }

    public static int arrayDepthForObject(Object object) {
        return ClassTools.arrayDepthFor(object.getClass());
    }

    public static int arrayDepthForClassNamed(String string) {
        int n = 0;
        while (string.charAt(n) == '[') {
            ++n;
        }
        return n;
    }

    public static boolean classNamedIsArray(String string) {
        return string.charAt(0) == '[';
    }

    public static Class elementTypeFor(Class clazz) {
        while (clazz.isArray()) {
            clazz = clazz.getComponentType();
        }
        return clazz;
    }

    public static Class elementTypeForObject(Object object) {
        return ClassTools.elementTypeFor(object.getClass());
    }

    public static String elementTypeNameFor(Class clazz) {
        return ClassTools.elementTypeFor(clazz).getName();
    }

    public static String elementTypeNameForClassNamed(String string) {
        int n = ClassTools.arrayDepthForClassNamed(string);
        if (n == 0) {
            return string;
        }
        int n2 = string.length() - 1;
        if (string.charAt(n) == 'L') {
            return string.substring(n + 1, n2);
        }
        return ClassTools.classNameForCode(string.charAt(n2));
    }

    public static boolean classNamedIsReference(String string) {
        return !ClassTools.classNamedIsNonReference(string);
    }

    public static boolean classNamedIsNonReference(String string) {
        PrimitiveClassCode[] primitiveClassCodeArray = ClassTools.getPrimitiveClassCodes();
        int n = primitiveClassCodeArray.length;
        while (n-- > 0) {
            if (!primitiveClassCodeArray[n].javaClass.getName().equals(string)) continue;
            return true;
        }
        return false;
    }

    public static String classNameForCode(char c) {
        return ClassTools.classForCode(c).getName();
    }

    public static String classNameForCode(int n) {
        return ClassTools.classNameForCode((char)n);
    }

    public static Class classForCode(char c) {
        PrimitiveClassCode[] primitiveClassCodeArray = ClassTools.getPrimitiveClassCodes();
        int n = primitiveClassCodeArray.length;
        while (n-- > 0) {
            if (primitiveClassCodeArray[n].code != c) continue;
            return primitiveClassCodeArray[n].javaClass;
        }
        throw new IllegalArgumentException(String.valueOf(c));
    }

    public static Class classForCode(int n) {
        return ClassTools.classForCode((char)n);
    }

    public static char codeForClass(Class clazz) {
        PrimitiveClassCode[] primitiveClassCodeArray = ClassTools.getPrimitiveClassCodes();
        int n = primitiveClassCodeArray.length;
        while (n-- > 0) {
            if (primitiveClassCodeArray[n].javaClass != clazz) continue;
            return primitiveClassCodeArray[n].code;
        }
        throw new IllegalArgumentException(clazz.getName());
    }

    public static char codeForClassNamed(String string) {
        PrimitiveClassCode[] primitiveClassCodeArray = ClassTools.getPrimitiveClassCodes();
        int n = primitiveClassCodeArray.length;
        while (n-- > 0) {
            if (!primitiveClassCodeArray[n].javaClass.getName().equals(string)) continue;
            return primitiveClassCodeArray[n].code;
        }
        throw new IllegalArgumentException(string);
    }

    public static Class classForTypeDeclaration(String string, int n) throws ClassNotFoundException {
        return ClassTools.classForTypeDeclaration(string, n, null);
    }

    public static Class classForTypeDeclaration(String string, int n, ClassLoader classLoader) throws ClassNotFoundException {
        PrimitiveClassCode[] primitiveClassCodeArray = ClassTools.getPrimitiveClassCodes();
        PrimitiveClassCode primitiveClassCode = null;
        int n2 = primitiveClassCodeArray.length;
        while (n2-- > 0) {
            if (!primitiveClassCodeArray[n2].javaClass.getName().equals(string)) continue;
            primitiveClassCode = primitiveClassCodeArray[n2];
            break;
        }
        if (n == 0) {
            return primitiveClassCode == null ? Class.forName(string, false, classLoader) : primitiveClassCode.javaClass;
        }
        StringBuffer stringBuffer = new StringBuffer(100);
        int n3 = n;
        while (n3-- > 0) {
            stringBuffer.append('[');
        }
        if (primitiveClassCode == null) {
            stringBuffer.append('L');
            stringBuffer.append(string);
            stringBuffer.append(';');
        } else {
            stringBuffer.append(primitiveClassCode.code);
        }
        return Class.forName(stringBuffer.toString(), false, classLoader);
    }

    public static String classNameForTypeDeclaration(String string, int n) {
        if (n == 0) {
            return string;
        }
        if (string.equals(Void.TYPE.getName())) {
            throw new IllegalArgumentException("'void' must have an array depth of zero: " + n + '.');
        }
        StringBuffer stringBuffer = new StringBuffer(100);
        int n2 = n;
        while (n2-- > 0) {
            stringBuffer.append('[');
        }
        PrimitiveClassCode[] primitiveClassCodeArray = ClassTools.getPrimitiveClassCodes();
        PrimitiveClassCode primitiveClassCode = null;
        int n3 = primitiveClassCodeArray.length;
        while (n3-- > 0) {
            if (!primitiveClassCodeArray[n3].javaClass.getName().equals(string)) continue;
            primitiveClassCode = primitiveClassCodeArray[n3];
            break;
        }
        if (primitiveClassCode == null) {
            stringBuffer.append('L');
            stringBuffer.append(string);
            stringBuffer.append(';');
        } else {
            stringBuffer.append(primitiveClassCode.code);
        }
        return stringBuffer.toString();
    }

    private static PrimitiveClassCode[] getPrimitiveClassCodes() {
        if (primitiveClassCodes == null) {
            primitiveClassCodes = ClassTools.buildPrimitiveClassCodes();
        }
        return primitiveClassCodes;
    }

    private static PrimitiveClassCode[] buildPrimitiveClassCodes() {
        PrimitiveClassCode[] primitiveClassCodeArray = new PrimitiveClassCode[]{new PrimitiveClassCode('B', Byte.TYPE), new PrimitiveClassCode('C', Character.TYPE), new PrimitiveClassCode('D', Double.TYPE), new PrimitiveClassCode('F', Float.TYPE), new PrimitiveClassCode('I', Integer.TYPE), new PrimitiveClassCode('J', Long.TYPE), new PrimitiveClassCode('S', Short.TYPE), new PrimitiveClassCode('Z', Boolean.TYPE), new PrimitiveClassCode('V', Void.TYPE)};
        return primitiveClassCodeArray;
    }

    private ClassTools() {
        throw new UnsupportedOperationException();
    }

    private static class PrimitiveClassCode {
        char code;
        Class javaClass;

        PrimitiveClassCode(char c, Class clazz) {
            this.code = c;
            this.javaClass = clazz;
        }
    }
}

