/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.utility;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.eclipse.persistence.tools.workbench.utility.Bag;
import org.eclipse.persistence.tools.workbench.utility.HashBag;

public class IdentityHashBag
extends AbstractCollection
implements Bag,
Cloneable,
Serializable {
    transient Entry[] table;
    transient int count = 0;
    transient int uniqueCount = 0;
    private int threshold;
    private float loadFactor;
    transient int modCount = 0;
    private static Iterator emptyIterator = new EmptyIterator();
    private static final long serialVersionUID = 1L;

    public IdentityHashBag() {
        this(11, 0.75f);
    }

    public IdentityHashBag(int n) {
        this(n, 0.75f);
    }

    public IdentityHashBag(int n, float f) {
        if (n < 0) {
            throw new IllegalArgumentException("Illegal Initial Capacity: " + n);
        }
        if (f <= 0.0f || Float.isNaN(f)) {
            throw new IllegalArgumentException("Illegal Load factor: " + f);
        }
        if (n == 0) {
            n = 1;
        }
        this.loadFactor = f;
        this.table = new Entry[n];
        this.threshold = (int)((float)n * f);
    }

    public IdentityHashBag(Collection collection) {
        this(Math.max(2 * collection.size(), 11));
        this.addAll(collection);
    }

    public int size() {
        return this.count;
    }

    public boolean isEmpty() {
        return this.count == 0;
    }

    public boolean contains(Object object) {
        Entry[] entryArray = this.table;
        int n = System.identityHashCode(object);
        int n2 = (n & Integer.MAX_VALUE) % entryArray.length;
        Entry entry = entryArray[n2];
        while (entry != null) {
            if (entry.hash == n && entry.object == object) {
                return true;
            }
            entry = entry.next;
        }
        return false;
    }

    public int count(Object object) {
        Entry[] entryArray = this.table;
        int n = System.identityHashCode(object);
        int n2 = (n & Integer.MAX_VALUE) % entryArray.length;
        Entry entry = entryArray[n2];
        while (entry != null) {
            if (entry.hash == n && entry.object == object) {
                return entry.count;
            }
            entry = entry.next;
        }
        return 0;
    }

    private void rehash() {
        Entry[] entryArray = this.table;
        int n = entryArray.length;
        int n2 = n * 2 + 1;
        Entry[] entryArray2 = new Entry[n2];
        ++this.modCount;
        this.threshold = (int)((float)n2 * this.loadFactor);
        this.table = entryArray2;
        int n3 = n;
        while (n3-- > 0) {
            Entry entry = entryArray[n3];
            while (entry != null) {
                Entry entry2 = entry;
                entry = entry.next;
                int n4 = (entry2.hash & Integer.MAX_VALUE) % n2;
                entry2.next = entryArray2[n4];
                entryArray2[n4] = entry2;
            }
        }
    }

    public boolean add(Object object) {
        ++this.modCount;
        Entry[] entryArray = this.table;
        int n = 0;
        int n2 = 0;
        n = System.identityHashCode(object);
        n2 = (n & Integer.MAX_VALUE) % entryArray.length;
        Entry entry = entryArray[n2];
        while (entry != null) {
            if (entry.hash == n && entry.object == object) {
                ++entry.count;
                ++this.count;
                return true;
            }
            entry = entry.next;
        }
        if (this.uniqueCount >= this.threshold) {
            this.rehash();
            entryArray = this.table;
            n2 = (n & Integer.MAX_VALUE) % entryArray.length;
        }
        entryArray[n2] = entry = new Entry(n, object, entryArray[n2]);
        ++this.count;
        ++this.uniqueCount;
        return true;
    }

    public boolean remove(Object object) {
        Entry[] entryArray = this.table;
        int n = System.identityHashCode(object);
        int n2 = (n & Integer.MAX_VALUE) % entryArray.length;
        Entry entry = entryArray[n2];
        Entry entry2 = null;
        while (entry != null) {
            if (entry.hash == n && entry.object == object) {
                ++this.modCount;
                --entry.count;
                if (entry.count == 0) {
                    if (entry2 == null) {
                        entryArray[n2] = entry.next;
                    } else {
                        entry2.next = entry.next;
                    }
                    --this.uniqueCount;
                }
                --this.count;
                return true;
            }
            entry2 = entry;
            entry = entry.next;
        }
        return false;
    }

    public boolean removeAll(Collection collection) {
        return super.removeAll(new IdentityHashBag(collection));
    }

    public boolean retainAll(Collection collection) {
        return super.retainAll(new IdentityHashBag(collection));
    }

    public void clear() {
        Entry[] entryArray = this.table;
        ++this.modCount;
        int n = entryArray.length;
        while (--n >= 0) {
            entryArray[n] = null;
        }
        this.count = 0;
        this.uniqueCount = 0;
    }

    public Object clone() {
        try {
            IdentityHashBag identityHashBag = (IdentityHashBag)super.clone();
            identityHashBag.table = new Entry[this.table.length];
            int n = this.table.length;
            while (n-- > 0) {
                identityHashBag.table[n] = this.table[n] == null ? null : (Entry)this.table[n].clone();
            }
            identityHashBag.modCount = 0;
            return identityHashBag;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public Iterator iterator() {
        if (this.count == 0) {
            return emptyIterator;
        }
        return new HashIterator();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof IdentityHashBag) {
            IdentityHashBag identityHashBag = (IdentityHashBag)object;
            if (identityHashBag.size() != this.size()) {
                return false;
            }
            IdentityHashBag identityHashBag2 = (IdentityHashBag)this.clone();
            Iterator iterator = identityHashBag.iterator();
            while (iterator.hasNext()) {
                if (identityHashBag2.remove(iterator.next())) continue;
                return false;
            }
            return identityHashBag2.isEmpty();
        }
        if (object instanceof Bag) {
            return new HashBag(this).equals(object);
        }
        return false;
    }

    public int hashCode() {
        int n = 0;
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            n += System.identityHashCode(iterator.next());
        }
        return n;
    }

    private synchronized void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this.table.length);
        objectOutputStream.writeInt(this.uniqueCount);
        for (int i = this.table.length - 1; i >= 0; --i) {
            Entry entry = this.table[i];
            while (entry != null) {
                objectOutputStream.writeObject(entry.object);
                objectOutputStream.writeInt(entry.count);
                entry = entry.next;
            }
        }
    }

    private synchronized void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n = objectInputStream.readInt();
        this.table = new Entry[n];
        int n2 = objectInputStream.readInt();
        for (int i = 0; i < n2; ++i) {
            Object object = objectInputStream.readObject();
            int n3 = objectInputStream.readInt();
            for (int j = 0; j < n3; ++j) {
                this.add(object);
            }
        }
    }

    private class HashIterator
    implements Iterator {
        Entry[] localTable;
        int index;
        Entry nextEntry;
        int nextEntryCount;
        Entry lastReturnedEntry;
        private int expectedModCount;

        HashIterator() {
            this.localTable = IdentityHashBag.this.table;
            this.index = this.localTable.length;
            this.nextEntry = null;
            this.nextEntryCount = 0;
            this.lastReturnedEntry = null;
            this.expectedModCount = IdentityHashBag.this.modCount;
        }

        public boolean hasNext() {
            Entry entry = this.nextEntry;
            int n = this.index;
            Entry[] entryArray = this.localTable;
            while (entry == null && n > 0) {
                entry = entryArray[--n];
            }
            this.nextEntry = entry;
            this.index = n;
            return entry != null;
        }

        public Object next() {
            if (IdentityHashBag.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            Entry entry = this.nextEntry;
            int n = this.index;
            Entry[] entryArray = this.localTable;
            while (entry == null && n > 0) {
                entry = entryArray[--n];
            }
            this.nextEntry = entry;
            this.index = n;
            if (entry == null) {
                throw new NoSuchElementException();
            }
            Entry entry2 = this.lastReturnedEntry = this.nextEntry;
            ++this.nextEntryCount;
            if (this.nextEntryCount == entry2.count) {
                this.nextEntry = entry2.next;
                this.nextEntryCount = 0;
            }
            return entry2.object;
        }

        public void remove() {
            if (this.lastReturnedEntry == null) {
                throw new IllegalStateException();
            }
            if (IdentityHashBag.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            Entry[] entryArray = this.localTable;
            int n = (this.lastReturnedEntry.hash & Integer.MAX_VALUE) % entryArray.length;
            Entry entry = entryArray[n];
            Entry entry2 = null;
            while (entry != null) {
                if (entry == this.lastReturnedEntry) {
                    ++IdentityHashBag.this.modCount;
                    ++this.expectedModCount;
                    --entry.count;
                    if (entry.count == 0) {
                        if (entry2 == null) {
                            entryArray[n] = entry.next;
                        } else {
                            entry2.next = entry.next;
                        }
                        --IdentityHashBag.this.uniqueCount;
                    } else {
                        --this.nextEntryCount;
                    }
                    --IdentityHashBag.this.count;
                    this.lastReturnedEntry = null;
                    return;
                }
                entry2 = entry;
                entry = entry.next;
            }
            throw new ConcurrentModificationException();
        }
    }

    private static class EmptyIterator
    implements Iterator {
        private EmptyIterator() {
        }

        public boolean hasNext() {
            return false;
        }

        public Object next() {
            throw new NoSuchElementException();
        }

        public void remove() {
            throw new IllegalStateException();
        }
    }

    private static class Entry {
        int hash;
        Object object;
        int count;
        Entry next;

        Entry(int n, Object object, Entry entry) {
            this(n, object, 1, entry);
        }

        private Entry(int n, Object object, int n2, Entry entry) {
            this.hash = n;
            this.object = object;
            this.count = n2;
            this.next = entry;
        }

        protected Object clone() {
            return new Entry(this.hash, this.object, this.count, this.next == null ? null : (Entry)this.next.clone());
        }

        public String toString() {
            return this.object + "=>" + this.count;
        }
    }
}

