/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.utility;

import java.io.PrintStream;
import java.io.Serializable;
import org.eclipse.persistence.tools.workbench.utility.ClassTools;
import org.eclipse.persistence.tools.workbench.utility.ExceptionBroadcaster;
import org.eclipse.persistence.tools.workbench.utility.ExceptionListener;

public class SimpleExceptionBroadcaster
implements ExceptionBroadcaster,
Serializable {
    private ExceptionListener[] listeners;
    private final PrintStream defaultStream;
    private static final ExceptionListener[] EMPTY_LISTENERS = new ExceptionListener[0];
    private static final long serialVersionUID = 1L;

    public SimpleExceptionBroadcaster(PrintStream printStream) {
        this.defaultStream = printStream;
    }

    public SimpleExceptionBroadcaster() {
        this(System.err);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void broadcast(Thread thread, Throwable throwable) {
        ExceptionListener[] exceptionListenerArray = null;
        SimpleExceptionBroadcaster simpleExceptionBroadcaster = this;
        synchronized (simpleExceptionBroadcaster) {
            if (this.listeners != null) {
                int n = this.listeners.length;
                exceptionListenerArray = new ExceptionListener[n];
                System.arraycopy(this.listeners, 0, exceptionListenerArray, 0, n);
            }
        }
        if (exceptionListenerArray == null) {
            this.broadcastOnDefaultStream(thread, throwable);
        } else {
            int n = exceptionListenerArray.length;
            while (n-- > 0) {
                try {
                    exceptionListenerArray[n].exceptionThrown(thread, throwable);
                }
                catch (Throwable throwable2) {
                    this.broadcastOnDefaultStream(Thread.currentThread(), throwable2);
                    this.broadcastOnDefaultStream(thread, throwable);
                }
            }
        }
    }

    public synchronized void addExceptionListener(ExceptionListener exceptionListener) {
        ExceptionListener[] exceptionListenerArray;
        if (exceptionListener == null) {
            throw new NullPointerException();
        }
        int n = 0;
        if (this.listeners == null) {
            exceptionListenerArray = new ExceptionListener[1];
        } else {
            n = this.listeners.length;
            exceptionListenerArray = new ExceptionListener[n + 1];
            System.arraycopy(this.listeners, 0, exceptionListenerArray, 0, n);
        }
        exceptionListenerArray[n] = exceptionListener;
        this.listeners = exceptionListenerArray;
    }

    public synchronized void removeExceptionListener(ExceptionListener exceptionListener) {
        int n;
        if (this.listeners == null) {
            throw new IllegalArgumentException("listener not registered");
        }
        int n2 = n = this.listeners.length;
        while (n2-- > 0 && this.listeners[n2] != exceptionListener) {
        }
        if (n2 == -1) {
            throw new IllegalArgumentException("listener not registered");
        }
        if (n == 1) {
            this.listeners = null;
        } else {
            int n3;
            ExceptionListener[] exceptionListenerArray = new ExceptionListener[n - 1];
            if (n2 != 0) {
                System.arraycopy(this.listeners, 0, exceptionListenerArray, 0, n2);
            }
            if ((n3 = n2 + 1) != n) {
                System.arraycopy(this.listeners, n3, exceptionListenerArray, n2, n - n3);
            }
            this.listeners = exceptionListenerArray;
        }
    }

    public synchronized ExceptionListener[] getExceptionListeners() {
        if (this.listeners == null) {
            return EMPTY_LISTENERS;
        }
        int n = this.listeners.length;
        ExceptionListener[] exceptionListenerArray = new ExceptionListener[n];
        System.arraycopy(this.listeners, 0, exceptionListenerArray, 0, n);
        return exceptionListenerArray;
    }

    public synchronized boolean hasExceptionListeners() {
        return this.listeners != null;
    }

    public synchronized boolean hasNoExceptionListeners() {
        return this.listeners == null;
    }

    public String toString() {
        return ClassTools.shortClassNameForObject(this);
    }

    protected void broadcastOnDefaultStream(Thread thread, Throwable throwable) {
        this.broadcastOn(thread, throwable, this.defaultStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void broadcastOn(Thread thread, Throwable throwable, PrintStream printStream) {
        PrintStream printStream2 = printStream;
        synchronized (printStream2) {
            printStream.println(thread);
            throwable.printStackTrace(printStream);
        }
    }
}

