/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.utility.classfile;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Modifier;
import org.eclipse.persistence.tools.workbench.utility.ClassTools;
import org.eclipse.persistence.tools.workbench.utility.classfile.ConstantPool;
import org.eclipse.persistence.tools.workbench.utility.classfile.Visitor;
import org.eclipse.persistence.tools.workbench.utility.classfile.tools.ClassFileDataInputStream;
import org.eclipse.persistence.tools.workbench.utility.io.IndentingPrintWriter;

public class ClassDeclaration {
    private ConstantPool constantPool;
    private short accessFlags;
    private short standardAccessFlags;
    private short thisClassIndex;
    private short superClassIndex;
    private short interfacesCount;
    private short[] interfaceIndexes;
    public static final short ACC_SUPER = 32;
    public static final short ACC_SYNTHETIC = 4096;
    public static final short ACC_ANNOTATION = 8192;
    public static final short ACC_ENUM = 16384;
    static final String[] EMPTY_STRING_ARRAY = new String[0];
    public static final int VISIBLE_ACCESS_FLAGS_MASK = 3615;

    ClassDeclaration(ClassFileDataInputStream classFileDataInputStream, ConstantPool constantPool) throws IOException {
        this.constantPool = constantPool;
        this.initialize(classFileDataInputStream);
    }

    private void initialize(ClassFileDataInputStream classFileDataInputStream) throws IOException {
        this.accessFlags = classFileDataInputStream.readU2();
        this.standardAccessFlags = this.buildStandardAccessFlags();
        this.thisClassIndex = classFileDataInputStream.readU2();
        this.superClassIndex = classFileDataInputStream.readU2();
        short s = this.interfacesCount = classFileDataInputStream.readU2();
        short[] sArray = this.interfaceIndexes = new short[s];
        for (short s2 = 0; s2 < s; s2 = (short)(s2 + 1)) {
            sArray[s2] = classFileDataInputStream.readU2();
        }
    }

    private short buildStandardAccessFlags() {
        short s = this.accessFlags;
        s = (short)(s & 0xE1F);
        return s;
    }

    void setStandardAccessFlagsForNestedClass(short s) {
        this.standardAccessFlags = s;
    }

    public String displayString() {
        StringWriter stringWriter = new StringWriter();
        IndentingPrintWriter indentingPrintWriter = new IndentingPrintWriter(stringWriter);
        this.displayStringOn(indentingPrintWriter);
        return stringWriter.toString();
    }

    public void displayStringOn(IndentingPrintWriter indentingPrintWriter) {
        indentingPrintWriter.println("Declaration:");
        indentingPrintWriter.indent();
        this.printDeclarationOn(indentingPrintWriter);
        indentingPrintWriter.undent();
        indentingPrintWriter.println();
    }

    public void printDeclarationOn(PrintWriter printWriter) {
        short s;
        String string = this.modifierString();
        if (string.length() != 0) {
            printWriter.print(string);
            printWriter.print(' ');
        }
        if (this.isClass()) {
            printWriter.print("class ");
        }
        printWriter.print(this.thisClassName());
        if (this.isClass()) {
            printWriter.print(" extends ");
            printWriter.print(this.superClassName());
        }
        if ((s = this.interfacesCount) != 0) {
            if (this.isClass()) {
                printWriter.print(" implements ");
            } else {
                printWriter.print(" extends ");
            }
            for (short s2 = 0; s2 < s; s2 = (short)(s2 + 1)) {
                if (s2 != 0) {
                    printWriter.write(", ");
                }
                printWriter.write(this.interfaceName(s2));
            }
        }
    }

    public String modifierString() {
        return Modifier.toString(this.standardAccessFlags);
    }

    public short standardAccessFlags() {
        return this.standardAccessFlags;
    }

    public boolean isInterface() {
        return Modifier.isInterface(this.accessFlags);
    }

    public boolean isClass() {
        return !this.isInterface();
    }

    public boolean isSuper() {
        return (this.accessFlags & 0x20) != 0;
    }

    public boolean isSynthetic() {
        return (this.accessFlags & 0x1000) != 0;
    }

    public boolean isAnnotation() {
        return (this.accessFlags & 0x2000) != 0;
    }

    public boolean isEnum() {
        return (this.accessFlags & 0x4000) != 0;
    }

    public String thisClassName() {
        return this.className(this.thisClassIndex);
    }

    public String superClassName() {
        if (this.isInterface()) {
            return null;
        }
        short s = this.superClassIndex;
        return s == 0 ? null : this.className(s);
    }

    public String interfaceName(int n) {
        return this.className(this.interfaceIndexes[n]);
    }

    public String[] interfaceNames() {
        short s = this.interfacesCount;
        if (s == 0) {
            return EMPTY_STRING_ARRAY;
        }
        String[] stringArray = new String[s];
        for (short s2 = 0; s2 < s; s2 = (short)(s2 + 1)) {
            stringArray[s2] = this.interfaceName(s2);
        }
        return stringArray;
    }

    private String className(short s) {
        return this.constantPool.getClassConstant(s).name();
    }

    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    public ConstantPool getConstantPool() {
        return this.constantPool;
    }

    public short getAccessFlags() {
        return this.accessFlags;
    }

    public short getThisClassIndex() {
        return this.thisClassIndex;
    }

    public short getSuperClassIndex() {
        return this.superClassIndex;
    }

    public short getInterfacesCount() {
        return this.interfacesCount;
    }

    public short[] getInterfaceIndexes() {
        return this.interfaceIndexes;
    }

    public short getInterfaceIndex(int n) {
        return this.interfaceIndexes[n];
    }

    public String toString() {
        StringWriter stringWriter = new StringWriter(200);
        PrintWriter printWriter = new PrintWriter(stringWriter);
        printWriter.print(ClassTools.shortClassNameForObject(this));
        printWriter.print('(');
        this.printDeclarationOn(printWriter);
        printWriter.print(')');
        return stringWriter.toString();
    }
}

