/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.utility.classfile;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.util.Collection;
import java.util.HashSet;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.eclipse.persistence.tools.workbench.utility.ClassTools;
import org.eclipse.persistence.tools.workbench.utility.Classpath;
import org.eclipse.persistence.tools.workbench.utility.classfile.AttributePool;
import org.eclipse.persistence.tools.workbench.utility.classfile.ClassDeclaration;
import org.eclipse.persistence.tools.workbench.utility.classfile.ConstantPool;
import org.eclipse.persistence.tools.workbench.utility.classfile.FieldPool;
import org.eclipse.persistence.tools.workbench.utility.classfile.MethodPool;
import org.eclipse.persistence.tools.workbench.utility.classfile.Visitor;
import org.eclipse.persistence.tools.workbench.utility.classfile.VisitorAdapter;
import org.eclipse.persistence.tools.workbench.utility.classfile.descriptor.ObjectType;
import org.eclipse.persistence.tools.workbench.utility.classfile.tools.ClassFileDataInputStream;
import org.eclipse.persistence.tools.workbench.utility.io.IndentingPrintWriter;

public class ClassFile {
    private Header header;
    private ConstantPool constantPool;
    private ClassDeclaration declaration;
    private FieldPool fieldPool;
    private MethodPool methodPool;
    private AttributePool attributePool;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ClassFile fromInputStream(InputStream inputStream) throws IOException {
        ClassFile classFile = null;
        try {
            inputStream = new BufferedInputStream(inputStream);
            classFile = new ClassFile(inputStream);
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        return classFile;
    }

    public static ClassFile fromArchiveEntry(JarFile jarFile, JarEntry jarEntry) throws IOException {
        return ClassFile.fromInputStream(jarFile.getInputStream(jarEntry));
    }

    public static ClassFile fromArchiveEntry(JarFile jarFile, String string) throws IOException {
        String string2 = Classpath.convertToArchiveClassFileEntryName(string);
        return ClassFile.fromInputStream(jarFile.getInputStream(jarFile.getJarEntry(string2)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ClassFile fromArchiveEntry(File file, String string) throws IOException {
        JarFile jarFile = null;
        try {
            jarFile = new JarFile(file);
            ClassFile classFile = ClassFile.fromArchiveEntry(jarFile, string);
            return classFile;
        }
        finally {
            if (jarFile != null) {
                jarFile.close();
            }
        }
    }

    public static ClassFile fromFile(File file) throws IOException {
        return ClassFile.fromInputStream(new FileInputStream(file));
    }

    public static ClassFile fromClassFile(File file, String string) throws IOException {
        return ClassFile.fromFile(new File(file, Classpath.convertToClassFileName(string)));
    }

    public static ClassFile forClass(File file, String string) throws IOException {
        if (Classpath.fileNameIsArchive(file.getPath())) {
            return ClassFile.fromArchiveEntry(file, string);
        }
        return ClassFile.fromClassFile(file, string);
    }

    public static ClassFile forClass(Class clazz) throws IOException {
        return ClassFile.forClass(new File(Classpath.locationFor(clazz)), clazz.getName());
    }

    public ClassFile(InputStream inputStream) throws IOException {
        this.initialize(new ClassFileDataInputStream(inputStream));
    }

    private void initialize(ClassFileDataInputStream classFileDataInputStream) throws IOException {
        this.header = new Header(classFileDataInputStream);
        this.constantPool = new ConstantPool(classFileDataInputStream);
        this.declaration = new ClassDeclaration(classFileDataInputStream, this.constantPool);
        this.fieldPool = new FieldPool(classFileDataInputStream, this);
        this.methodPool = new MethodPool(classFileDataInputStream, this);
        this.attributePool = new AttributePool(classFileDataInputStream, this);
        if (this.isNestedClass()) {
            this.declaration.setStandardAccessFlagsForNestedClass(this.nestedClassAccessFlags());
        }
    }

    public String className() {
        return this.declaration.thisClassName();
    }

    public String displayString() {
        StringWriter stringWriter = new StringWriter(2000);
        IndentingPrintWriter indentingPrintWriter = new IndentingPrintWriter(stringWriter);
        this.displayStringOn(indentingPrintWriter);
        return stringWriter.toString();
    }

    public void displayStringOn(IndentingPrintWriter indentingPrintWriter) {
        indentingPrintWriter.print("ClassFile: ");
        indentingPrintWriter.println(this.className());
        indentingPrintWriter.indent();
        this.header.displayStringOn(indentingPrintWriter);
        this.constantPool.displayStringOn(indentingPrintWriter);
        this.declaration.displayStringOn(indentingPrintWriter);
        this.fieldPool.displayStringOn(indentingPrintWriter);
        this.methodPool.displayStringOn(indentingPrintWriter);
        this.attributePool.displayStringOn(indentingPrintWriter);
        indentingPrintWriter.undent();
    }

    public short standardAccessFlags() {
        return this.declaration.standardAccessFlags();
    }

    public boolean isInterface() {
        return this.declaration.isInterface();
    }

    public boolean isClass() {
        return this.declaration.isClass();
    }

    public String superClassName() {
        return this.declaration.superClassName();
    }

    public String[] interfaceNames() {
        return this.declaration.interfaceNames();
    }

    public boolean isDeprecated() {
        return this.attributePool.isDeprecated();
    }

    public boolean isSynthetic() {
        return this.declaration.isSynthetic() || this.attributePool.isSynthetic();
    }

    public boolean isTopLevelClass() {
        return !this.isNestedClass();
    }

    public boolean isNestedClass() {
        return this.attributePool.isNestedClass();
    }

    public boolean isMemberClass() {
        return this.attributePool.isMemberClass();
    }

    public boolean isLocalClass() {
        return this.attributePool.isLocalClass();
    }

    public boolean isAnonymousClass() {
        return this.attributePool.isAnonymousClass();
    }

    public String sourceFileName() {
        return this.attributePool.sourceFileName();
    }

    public String declaringClassName() {
        return this.attributePool.declaringClassName();
    }

    public String nestedClassName() {
        return this.attributePool.nestedClassName();
    }

    public short nestedClassAccessFlags() {
        return this.attributePool.nestedClassAccessFlags();
    }

    public String[] nestedClassNames() {
        return this.attributePool.nestedClassNames();
    }

    public String[] declaredMemberClassNames() {
        return this.attributePool.declaredMemberClassNames();
    }

    public String[] referencedClassNames() {
        return new ReferencedClassNamesVisitor(this).referencedClassNames();
    }

    public void accept(Visitor visitor) {
        visitor.visit(this);
        this.header.accept(visitor);
        this.constantPool.accept(visitor);
        this.declaration.accept(visitor);
        this.fieldPool.accept(visitor);
        this.methodPool.accept(visitor);
        this.attributePool.accept(visitor);
    }

    public Header getHeader() {
        return this.header;
    }

    public ConstantPool getConstantPool() {
        return this.constantPool;
    }

    public ClassDeclaration getDeclaration() {
        return this.declaration;
    }

    public FieldPool getFieldPool() {
        return this.fieldPool;
    }

    public MethodPool getMethodPool() {
        return this.methodPool;
    }

    public AttributePool getAttributePool() {
        return this.attributePool;
    }

    public String toString() {
        return ClassTools.shortClassNameForObject(this) + '(' + this.className() + ')';
    }

    private static class ReferencedClassNamesVisitor
    extends VisitorAdapter {
        private final Collection referencedClassNames = new HashSet(200);

        ReferencedClassNamesVisitor(ClassFile classFile) {
            classFile.accept(this);
        }

        public void visit(ObjectType objectType) {
            this.addReferencedClassName(objectType.elementTypeName());
        }

        private void addReferencedClassName(String string) {
            if (ClassTools.classNamedIsReference(string)) {
                this.referencedClassNames.add(string);
            }
        }

        String[] referencedClassNames() {
            return this.referencedClassNames.toArray(new String[this.referencedClassNames.size()]);
        }
    }

    public static class Header {
        private int magic;
        private short minorVersion;
        private short majorVersion;

        Header(ClassFileDataInputStream classFileDataInputStream) throws IOException {
            this.initialize(classFileDataInputStream);
        }

        private void initialize(ClassFileDataInputStream classFileDataInputStream) throws IOException {
            this.magic = classFileDataInputStream.readU4();
            if (this.magic != -889275714) {
                throw new IOException("bad magic");
            }
            this.minorVersion = classFileDataInputStream.readU2();
            this.majorVersion = classFileDataInputStream.readU2();
        }

        public String displayString() {
            StringWriter stringWriter = new StringWriter();
            IndentingPrintWriter indentingPrintWriter = new IndentingPrintWriter(stringWriter);
            this.displayStringOn(indentingPrintWriter);
            return stringWriter.toString();
        }

        public void displayStringOn(IndentingPrintWriter indentingPrintWriter) {
            indentingPrintWriter.println("Header");
            indentingPrintWriter.indent();
            indentingPrintWriter.print("magic: 0x");
            indentingPrintWriter.println(this.magicString());
            indentingPrintWriter.print("class file format version: ");
            indentingPrintWriter.println(this.version());
            indentingPrintWriter.undent();
        }

        public String magicString() {
            return Integer.toHexString(this.magic).toUpperCase();
        }

        public float version() {
            float f;
            for (f = (float)this.minorVersion; f > 1.0f; f /= 10.0f) {
            }
            return (float)this.majorVersion + f;
        }

        public String versionString() {
            return String.valueOf(this.version());
        }

        public void accept(Visitor visitor) {
            visitor.visit(this);
        }

        public int getMagic() {
            return this.magic;
        }

        public short getMinorVersion() {
            return this.minorVersion;
        }

        public short getMajorVersion() {
            return this.majorVersion;
        }

        public String toString() {
            return ClassTools.shortClassNameForObject(this) + "(class file version: " + this.version() + ')';
        }
    }
}

