/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.utility.classfile;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import org.eclipse.persistence.tools.workbench.utility.classfile.Attribute;
import org.eclipse.persistence.tools.workbench.utility.classfile.AttributePool;
import org.eclipse.persistence.tools.workbench.utility.classfile.Method;
import org.eclipse.persistence.tools.workbench.utility.classfile.NameAndTypeConstant;
import org.eclipse.persistence.tools.workbench.utility.classfile.Visitor;
import org.eclipse.persistence.tools.workbench.utility.classfile.descriptor.FieldType;
import org.eclipse.persistence.tools.workbench.utility.classfile.tools.ClassFileDataInputStream;
import org.eclipse.persistence.tools.workbench.utility.io.IndentingPrintWriter;

public class EnclosingMethodAttribute
extends Attribute {
    private short classIndex;
    private short methodIndex;
    private FieldType methodReturnDescriptor;
    private FieldType[] methodParameterDescriptors;

    EnclosingMethodAttribute(ClassFileDataInputStream classFileDataInputStream, short s, AttributePool attributePool) throws IOException {
        super(classFileDataInputStream, s, attributePool);
    }

    void initializeInfo(ClassFileDataInputStream classFileDataInputStream) throws IOException {
        this.classIndex = classFileDataInputStream.readU2();
        this.methodIndex = classFileDataInputStream.readU2();
    }

    void displayInfoStringOn(IndentingPrintWriter indentingPrintWriter) {
        this.printFullyQualifiedMethodDeclarationOn(indentingPrintWriter);
        indentingPrintWriter.println();
    }

    public void printFullyQualifiedMethodDeclarationOn(PrintWriter printWriter) {
        printWriter.print(this.className());
        printWriter.print('.');
        if (this.methodIndex == 0) {
            printWriter.print("<static initialization>");
            return;
        }
        if (this.methodIsConstructor()) {
            printWriter.print(this.codeConstructorName());
        } else {
            printWriter.print(this.methodName());
        }
        printWriter.print('(');
        int n = this.getMethodParameterDescriptors().length;
        for (int i = 0; i < n; ++i) {
            if (i != 0) {
                printWriter.write(", ");
            }
            this.getMethodParameterDescriptor(i).printDeclarationOn(printWriter);
        }
        printWriter.print(')');
    }

    public void accept(Visitor visitor) {
        visitor.visit(this);
        this.getMethodReturnDescriptor().accept(visitor);
        FieldType[] fieldTypeArray = this.getMethodParameterDescriptors();
        int n = fieldTypeArray.length;
        for (int i = 0; i < n; ++i) {
            fieldTypeArray[i].accept(visitor);
        }
    }

    private String codeConstructorName() {
        String string = this.className();
        return string.substring(string.lastIndexOf(46) + 1);
    }

    public String fullyQualifiedSignature() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        this.printFullyQualifiedMethodDeclarationOn(printWriter);
        return stringWriter.toString();
    }

    public String className() {
        return this.constantPool().getClassConstant(this.classIndex).name();
    }

    public String methodName() {
        NameAndTypeConstant nameAndTypeConstant = this.methodNameAndTypeConstant();
        return nameAndTypeConstant == null ? null : nameAndTypeConstant.name();
    }

    public String methodDescriptor() {
        NameAndTypeConstant nameAndTypeConstant = this.methodNameAndTypeConstant();
        return nameAndTypeConstant == null ? null : nameAndTypeConstant.descriptor();
    }

    public NameAndTypeConstant methodNameAndTypeConstant() {
        short s = this.methodIndex;
        return s == 0 ? null : this.constantPool().getNameAndTypeConstant(s);
    }

    public short getClassIndex() {
        return this.classIndex;
    }

    public short getMethodIndex() {
        return this.methodIndex;
    }

    void toString(StringBuffer stringBuffer) {
        stringBuffer.append(this.fullyQualifiedSignature());
    }

    public boolean methodIsConstructor() {
        return this.methodName().equals("<init>");
    }

    public FieldType getMethodReturnDescriptor() {
        if (this.methodReturnDescriptor == null) {
            this.buildTypeDeclarations();
        }
        return this.methodReturnDescriptor;
    }

    public FieldType[] getMethodParameterDescriptors() {
        if (this.methodParameterDescriptors == null) {
            this.buildTypeDeclarations();
        }
        return this.methodParameterDescriptors;
    }

    public FieldType getMethodParameterDescriptor(int n) {
        if (this.methodParameterDescriptors == null) {
            this.buildTypeDeclarations();
        }
        return this.methodParameterDescriptors[n];
    }

    private void buildTypeDeclarations() {
        StringReader stringReader = new StringReader(this.methodDescriptor());
        try {
            this.methodParameterDescriptors = Method.buildParameterDescriptors(stringReader);
            this.methodReturnDescriptor = FieldType.createFieldType(stringReader);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }
}

