/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.utility.classfile;

import java.io.IOException;
import java.io.StringWriter;
import java.lang.reflect.Modifier;
import java.util.List;
import org.eclipse.persistence.tools.workbench.utility.ClassTools;
import org.eclipse.persistence.tools.workbench.utility.classfile.ClassFile;
import org.eclipse.persistence.tools.workbench.utility.classfile.ConstantPool;
import org.eclipse.persistence.tools.workbench.utility.classfile.InnerClassesAttribute;
import org.eclipse.persistence.tools.workbench.utility.classfile.Visitor;
import org.eclipse.persistence.tools.workbench.utility.classfile.tools.ClassFileDataInputStream;
import org.eclipse.persistence.tools.workbench.utility.io.IndentingPrintWriter;

public class InnerClass {
    private InnerClassesAttribute pool;
    private short innerClassInfoIndex;
    private short outerClassInfoIndex;
    private short innerClassNameIndex;
    private short innerClassAccessFlags;
    public static final short ACC_SYNTHETIC = 4096;
    public static final short ACC_ANNOTATION = 8192;
    public static final short ACC_ENUM = 16384;
    private static final String ANONYMOUS = "<anonymous>";
    private static final String NOT_APPLICABLE = "<N/A>";

    InnerClass(ClassFileDataInputStream classFileDataInputStream, InnerClassesAttribute innerClassesAttribute) throws IOException {
        this.pool = innerClassesAttribute;
        this.initialize(classFileDataInputStream);
    }

    void initialize(ClassFileDataInputStream classFileDataInputStream) throws IOException {
        this.innerClassInfoIndex = classFileDataInputStream.readU2();
        this.outerClassInfoIndex = classFileDataInputStream.readU2();
        this.innerClassNameIndex = classFileDataInputStream.readU2();
        this.innerClassAccessFlags = classFileDataInputStream.readU2();
    }

    public String displayString() {
        StringWriter stringWriter = new StringWriter(1000);
        IndentingPrintWriter indentingPrintWriter = new IndentingPrintWriter(stringWriter);
        this.displayStringOn(indentingPrintWriter);
        return stringWriter.toString();
    }

    public void displayStringOn(IndentingPrintWriter indentingPrintWriter) {
        indentingPrintWriter.println(this.innerClassName());
        indentingPrintWriter.indent();
        indentingPrintWriter.print("inner class info name: ");
        indentingPrintWriter.println(this.innerClassInfoName());
        indentingPrintWriter.print("outer class info name: ");
        indentingPrintWriter.println(this.outerClassInfoName());
        indentingPrintWriter.print("inner class name: ");
        indentingPrintWriter.println(this.innerClassName());
        indentingPrintWriter.print("modifier string: ");
        indentingPrintWriter.println(this.modifierString());
        indentingPrintWriter.undent();
    }

    boolean isNamed(short s) {
        return this.innerClassInfoIndex == s;
    }

    public boolean isNamed(String string) {
        return this.innerClassInfoName().equals(string);
    }

    String declaringClassName() {
        short s = this.outerClassInfoIndex;
        return s == 0 ? null : this.className(s);
    }

    void addDeclaredMemberClassTo(List list) {
        if (this.isSynthetic()) {
            return;
        }
        short s = this.classFile().getDeclaration().getThisClassIndex();
        if (this.outerClassInfoIndex == s) {
            list.add(this.innerClassInfoName());
        }
    }

    public String innerClassInfoName() {
        return this.className(this.innerClassInfoIndex);
    }

    public String outerClassInfoName() {
        short s = this.outerClassInfoIndex;
        return s == 0 ? NOT_APPLICABLE : this.className(s);
    }

    private String className(short s) {
        return this.constantPool().getClassConstant(s).name();
    }

    public String innerClassName() {
        short s = this.innerClassNameIndex;
        return s == 0 ? ANONYMOUS : this.constantPool().getUTF8String(s);
    }

    public String modifierString() {
        return Modifier.toString(this.innerClassAccessFlags);
    }

    public ConstantPool constantPool() {
        return this.pool.constantPool();
    }

    public ClassFile classFile() {
        return this.pool.classFile();
    }

    public boolean isSynthetic() {
        return (this.innerClassAccessFlags & 0x1000) != 0;
    }

    public boolean isAnnotation() {
        return (this.innerClassAccessFlags & 0x2000) != 0;
    }

    public boolean isEnum() {
        return (this.innerClassAccessFlags & 0x4000) != 0;
    }

    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    public InnerClassesAttribute getPool() {
        return this.pool;
    }

    public short getInnerClassInfoIndex() {
        return this.innerClassInfoIndex;
    }

    public short getOuterClassInfoIndex() {
        return this.outerClassInfoIndex;
    }

    public short getInnerClassNameIndex() {
        return this.innerClassNameIndex;
    }

    public short getInnerClassAccessFlags() {
        return this.innerClassAccessFlags;
    }

    public String toString() {
        return ClassTools.shortClassNameForObject(this) + '(' + this.innerClassName() + ')';
    }
}

