/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.utility.classfile;

import java.io.IOException;
import java.util.ArrayList;
import org.eclipse.persistence.tools.workbench.utility.classfile.Attribute;
import org.eclipse.persistence.tools.workbench.utility.classfile.AttributePool;
import org.eclipse.persistence.tools.workbench.utility.classfile.InnerClass;
import org.eclipse.persistence.tools.workbench.utility.classfile.Visitor;
import org.eclipse.persistence.tools.workbench.utility.classfile.tools.ClassFileDataInputStream;
import org.eclipse.persistence.tools.workbench.utility.io.IndentingPrintWriter;

public class InnerClassesAttribute
extends Attribute {
    private short count;
    private InnerClass[] innerClasses;

    InnerClassesAttribute(ClassFileDataInputStream classFileDataInputStream, short s, AttributePool attributePool) throws IOException {
        super(classFileDataInputStream, s, attributePool);
    }

    void initializeInfo(ClassFileDataInputStream classFileDataInputStream) throws IOException {
        short s = this.count = classFileDataInputStream.readU2();
        InnerClass[] innerClassArray = this.innerClasses = new InnerClass[s];
        for (short s2 = 0; s2 < s; s2 = (short)(s2 + 1)) {
            innerClassArray[s2] = new InnerClass(classFileDataInputStream, this);
        }
    }

    void displayInfoStringOn(IndentingPrintWriter indentingPrintWriter) {
        short s = this.count;
        InnerClass[] innerClassArray = this.innerClasses;
        for (short s2 = 0; s2 < s; s2 = (short)(s2 + 1)) {
            indentingPrintWriter.print(s2);
            indentingPrintWriter.print(": ");
            innerClassArray[s2].displayStringOn(indentingPrintWriter);
        }
    }

    public String nestedClassName(short s) {
        return this.innerClasses[s].innerClassInfoName();
    }

    public InnerClass innerClassNamed(String string) {
        short s = this.count;
        InnerClass[] innerClassArray = this.innerClasses;
        for (short s2 = 0; s2 < s; s2 = (short)(s2 + 1)) {
            InnerClass innerClass = innerClassArray[s2];
            if (!innerClass.isNamed(string)) continue;
            return innerClass;
        }
        return null;
    }

    private InnerClass innerClassNamed(short s) {
        short s2 = this.count;
        InnerClass[] innerClassArray = this.innerClasses;
        for (short s3 = 0; s3 < s2; s3 = (short)(s3 + 1)) {
            InnerClass innerClass = innerClassArray[s3];
            if (!innerClass.isNamed(s)) continue;
            return innerClass;
        }
        return null;
    }

    private InnerClass thisInnerClassAttribute() {
        return this.innerClassNamed(this.classFile().getDeclaration().getThisClassIndex());
    }

    public boolean isTopLevelClass() {
        return !this.isNestedClass();
    }

    public boolean isNestedClass() {
        return this.thisInnerClassAttribute() != null;
    }

    public boolean isMemberClass() {
        InnerClass innerClass = this.thisInnerClassAttribute();
        return innerClass != null && innerClass.getOuterClassInfoIndex() != 0;
    }

    public boolean isLocalClass() {
        InnerClass innerClass = this.thisInnerClassAttribute();
        return innerClass != null && innerClass.getOuterClassInfoIndex() == 0 && innerClass.getInnerClassNameIndex() != 0;
    }

    public boolean isAnonymousClass() {
        InnerClass innerClass = this.thisInnerClassAttribute();
        return innerClass != null && innerClass.getOuterClassInfoIndex() == 0 && innerClass.getInnerClassNameIndex() == 0;
    }

    public String declaringClassName() {
        InnerClass innerClass = this.thisInnerClassAttribute();
        return innerClass == null ? null : innerClass.declaringClassName();
    }

    public String nestedClassName() {
        InnerClass innerClass = this.thisInnerClassAttribute();
        return innerClass == null ? null : innerClass.innerClassName();
    }

    public short nestedClassAccessFlags() {
        InnerClass innerClass = this.thisInnerClassAttribute();
        return innerClass == null ? (short)0 : innerClass.getInnerClassAccessFlags();
    }

    public String[] nestedClassNames() {
        short s = this.count;
        if (s == 0) {
            return EMPTY_STRING_ARRAY;
        }
        String[] stringArray = new String[s];
        for (short s2 = 0; s2 < s; s2 = (short)(s2 + 1)) {
            stringArray[s2] = this.nestedClassName(s2);
        }
        return stringArray;
    }

    public String[] declaredMemberClassNames() {
        short s = this.count;
        if (s == 0) {
            return EMPTY_STRING_ARRAY;
        }
        InnerClass[] innerClassArray = this.innerClasses;
        ArrayList arrayList = new ArrayList(s);
        for (short s2 = 0; s2 < s; s2 = (short)(s2 + 1)) {
            innerClassArray[s2].addDeclaredMemberClassTo(arrayList);
        }
        return arrayList.size() == 0 ? EMPTY_STRING_ARRAY : arrayList.toArray(new String[arrayList.size()]);
    }

    public void accept(Visitor visitor) {
        visitor.visit(this);
        short s = this.count;
        InnerClass[] innerClassArray = this.innerClasses;
        for (short s2 = 0; s2 < s; s2 = (short)(s2 + 1)) {
            innerClassArray[s2].accept(visitor);
        }
    }

    public short getCount() {
        return this.count;
    }

    public InnerClass[] getInnerClasses() {
        return this.innerClasses;
    }

    public InnerClass getInnerClass(short s) {
        return this.innerClasses[s];
    }

    void toString(StringBuffer stringBuffer) {
        stringBuffer.append(this.count);
        stringBuffer.append(" inner class(es)");
    }
}

