/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.utility.classfile;

import java.io.IOException;
import org.eclipse.persistence.tools.workbench.utility.classfile.Attribute;
import org.eclipse.persistence.tools.workbench.utility.classfile.AttributePool;
import org.eclipse.persistence.tools.workbench.utility.classfile.LocalVariable;
import org.eclipse.persistence.tools.workbench.utility.classfile.Visitor;
import org.eclipse.persistence.tools.workbench.utility.classfile.tools.ClassFileDataInputStream;
import org.eclipse.persistence.tools.workbench.utility.io.IndentingPrintWriter;

public class LocalVariableTableAttribute
extends Attribute {
    private short count;
    private LocalVariable[] localVariables;

    LocalVariableTableAttribute(ClassFileDataInputStream classFileDataInputStream, short s, AttributePool attributePool) throws IOException {
        super(classFileDataInputStream, s, attributePool);
    }

    void initializeInfo(ClassFileDataInputStream classFileDataInputStream) throws IOException {
        short s = this.count = classFileDataInputStream.readU2();
        LocalVariable[] localVariableArray = this.localVariables = new LocalVariable[s];
        for (short s2 = 0; s2 < s; s2 = (short)(s2 + 1)) {
            localVariableArray[s2] = new LocalVariable(classFileDataInputStream, this.constantPool());
        }
    }

    public void displayNameOn(IndentingPrintWriter indentingPrintWriter) {
        super.displayNameOn(indentingPrintWriter);
        indentingPrintWriter.print(" (count: ");
        indentingPrintWriter.print(this.count);
        indentingPrintWriter.print(")");
    }

    void displayInfoStringOn(IndentingPrintWriter indentingPrintWriter) {
        short s = this.count;
        LocalVariable[] localVariableArray = this.localVariables;
        for (short s2 = 0; s2 < s; s2 = (short)(s2 + 1)) {
            indentingPrintWriter.print(s2);
            indentingPrintWriter.print(": ");
            localVariableArray[s2].displayStringOn(indentingPrintWriter);
        }
    }

    public String localVariableName(short s) {
        return this.localVariables[s].name();
    }

    public LocalVariable localVariableNamed(String string) {
        short s = this.count;
        LocalVariable[] localVariableArray = this.localVariables;
        for (short s2 = 0; s2 < s; s2 = (short)(s2 + 1)) {
            LocalVariable localVariable = localVariableArray[s2];
            if (!localVariable.isNamed(string)) continue;
            return localVariable;
        }
        return null;
    }

    public String[] localVariableNames() {
        short s = this.count;
        if (s == 0) {
            return EMPTY_STRING_ARRAY;
        }
        String[] stringArray = new String[s];
        for (short s2 = 0; s2 < s; s2 = (short)(s2 + 1)) {
            stringArray[s2] = this.localVariableName(s2);
        }
        return stringArray;
    }

    public void accept(Visitor visitor) {
        visitor.visit(this);
        short s = this.count;
        LocalVariable[] localVariableArray = this.localVariables;
        for (short s2 = 0; s2 < s; s2 = (short)(s2 + 1)) {
            localVariableArray[s2].accept(visitor);
        }
    }

    public short getCount() {
        return this.count;
    }

    public LocalVariable[] getLocalVariables() {
        return this.localVariables;
    }

    public LocalVariable getLocalVariable(short s) {
        return this.localVariables[s];
    }

    void toString(StringBuffer stringBuffer) {
        stringBuffer.append(this.count);
        stringBuffer.append(" local variable(s)");
    }
}

