/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.utility.classfile.descriptor;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import org.eclipse.persistence.tools.workbench.utility.classfile.Visitor;
import org.eclipse.persistence.tools.workbench.utility.classfile.descriptor.FieldType;

public class ArrayType
extends FieldType {
    private FieldType componentType;

    ArrayType(Reader reader) throws IOException {
        this.componentType = FieldType.createFieldType(reader);
    }

    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    public int arrayDepth() {
        return this.componentType.arrayDepth() + 1;
    }

    public String elementTypeName() {
        return this.componentType.elementTypeName();
    }

    public String javaName() {
        StringBuffer stringBuffer = new StringBuffer();
        this.appendArrayJavaNameTo(stringBuffer);
        return stringBuffer.toString();
    }

    public Class javaClass() throws ClassNotFoundException {
        return Class.forName(this.javaName());
    }

    public void appendDeclarationTo(StringBuffer stringBuffer) {
        this.componentType.appendDeclarationTo(stringBuffer);
        stringBuffer.append("[]");
    }

    public void printDeclarationOn(PrintWriter printWriter) {
        this.componentType.printDeclarationOn(printWriter);
        printWriter.print("[]");
    }

    public String internalName() {
        StringBuffer stringBuffer = new StringBuffer();
        this.appendArrayInternalNameTo(stringBuffer);
        return stringBuffer.toString();
    }

    void appendArrayJavaNameTo(StringBuffer stringBuffer) {
        stringBuffer.append('[');
        this.componentType.appendArrayJavaNameTo(stringBuffer);
    }

    void appendArrayInternalNameTo(StringBuffer stringBuffer) {
        stringBuffer.append('[');
        this.componentType.appendArrayInternalNameTo(stringBuffer);
    }
}

