/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.utility.classfile.tools;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.jar.JarFile;
import org.eclipse.persistence.tools.workbench.utility.Classpath;
import org.eclipse.persistence.tools.workbench.utility.classfile.ClassFile;

public class ClassFileIterator
implements Iterator {
    private File file;
    private JarFile jarFile;
    private boolean archive;
    private Iterator classNames;

    public ClassFileIterator(String string) {
        this.file = new File(string);
        this.archive = Classpath.fileNameIsArchive(string);
        if (this.archive) {
            this.jarFile = this.buildJarFile();
        }
        this.classNames = this.buildClassNames(string);
    }

    private JarFile buildJarFile() {
        try {
            return new JarFile(this.file);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    protected Iterator buildClassNames(String string) {
        Classpath classpath = new Classpath(new String[]{string});
        return classpath.classNamesStream();
    }

    public boolean hasNext() {
        return this.classNames.hasNext();
    }

    public Object next() {
        String string = (String)this.classNames.next();
        ClassFile classFile = null;
        try {
            classFile = this.archive ? this.buildClassFileFromArchive(string) : this.buildClassFileFromDirectory(string);
        }
        catch (IOException iOException) {
            throw new RuntimeException(string, iOException);
        }
        if (this.archive && !this.hasNext()) {
            this.closeJarFile();
        }
        return classFile;
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    private ClassFile buildClassFileFromArchive(String string) throws IOException {
        return ClassFile.fromArchiveEntry(this.jarFile, string);
    }

    private ClassFile buildClassFileFromDirectory(String string) throws IOException {
        return ClassFile.fromClassFile(this.file, string);
    }

    private void closeJarFile() {
        try {
            this.jarFile.close();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }
}

