/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.utility.iterators;

import java.util.List;
import java.util.ListIterator;
import org.eclipse.persistence.tools.workbench.utility.ClassTools;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;

public class CloneListIterator
implements ListIterator {
    private ListIterator nestedListIterator;
    private int cursor;
    private String state;
    private Mutator mutator;
    private static final String UNKNOWN = "unknown";
    private static final String PREVIOUS = "previous";
    private static final String NEXT = "next";

    public CloneListIterator(List list) {
        this(list, Mutator.READ_ONLY_INSTANCE);
    }

    public CloneListIterator(List list, Mutator mutator) {
        this.nestedListIterator = CollectionTools.list(list.toArray()).listIterator();
        this.mutator = mutator;
        this.cursor = 0;
        this.state = UNKNOWN;
    }

    public boolean hasNext() {
        return this.nestedListIterator.hasNext();
    }

    public Object next() {
        Object e = this.nestedListIterator.next();
        ++this.cursor;
        this.state = NEXT;
        return e;
    }

    public void remove() {
        this.nestedListIterator.remove();
        if (this.state == PREVIOUS) {
            this.remove(this.cursor);
        } else {
            --this.cursor;
            this.remove(this.cursor);
        }
    }

    public int nextIndex() {
        return this.nestedListIterator.nextIndex();
    }

    public int previousIndex() {
        return this.nestedListIterator.previousIndex();
    }

    public boolean hasPrevious() {
        return this.nestedListIterator.hasPrevious();
    }

    public Object previous() {
        Object e = this.nestedListIterator.previous();
        --this.cursor;
        this.state = PREVIOUS;
        return e;
    }

    public void add(Object object) {
        this.nestedListIterator.add(object);
        this.add(this.cursor, object);
        ++this.cursor;
    }

    public void set(Object object) {
        this.nestedListIterator.set(object);
        if (this.state == PREVIOUS) {
            this.set(this.cursor, object);
        } else {
            this.set(this.cursor - 1, object);
        }
    }

    protected void add(int n, Object object) {
        this.mutator.add(n, object);
    }

    protected void remove(int n) {
        this.mutator.remove(n);
    }

    protected void set(int n, Object object) {
        this.mutator.set(n, object);
    }

    public String toString() {
        return ClassTools.shortClassNameForObject(this);
    }

    public static interface Mutator {
        public static final Mutator READ_ONLY_INSTANCE = new Mutator(){

            public void add(int n, Object object) {
                throw new UnsupportedOperationException();
            }

            public void remove(int n) {
                throw new UnsupportedOperationException();
            }

            public void set(int n, Object object) {
                throw new UnsupportedOperationException();
            }

            public String toString() {
                return "ReadOnlyListMutator";
            }
        };

        public void add(int var1, Object var2);

        public void remove(int var1);

        public void set(int var1, Object var2);
    }
}

