/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.utility.iterators;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.eclipse.persistence.tools.workbench.utility.ClassTools;
import org.eclipse.persistence.tools.workbench.utility.iterators.ArrayListIterator;
import org.eclipse.persistence.tools.workbench.utility.iterators.SingleElementListIterator;

public class CompositeListIterator
implements ListIterator {
    private ListIterator iterators;
    private ListIterator nextIterator;
    private int nextIndex;
    private boolean nextReturned;
    private ListIterator lastIteratorToReturnElement;

    public CompositeListIterator(List list) {
        this(list.listIterator());
    }

    public CompositeListIterator(ListIterator listIterator) {
        this.iterators = listIterator;
        this.nextIndex = 0;
        this.nextReturned = false;
    }

    public CompositeListIterator(Object object, ListIterator listIterator) {
        this((ListIterator)new SingleElementListIterator(object), listIterator);
    }

    public CompositeListIterator(ListIterator listIterator, Object object) {
        this(listIterator, (ListIterator)new SingleElementListIterator(object));
    }

    public CompositeListIterator(ListIterator listIterator, ListIterator listIterator2) {
        this(CompositeListIterator.buildIterators(listIterator, listIterator2));
    }

    public CompositeListIterator(ListIterator listIterator, ListIterator listIterator2, ListIterator listIterator3) {
        this(CompositeListIterator.buildIterators(listIterator, listIterator2, listIterator3));
    }

    public CompositeListIterator(ListIterator[] listIteratorArray) {
        this(new ArrayListIterator(listIteratorArray));
    }

    private static ListIterator buildIterators(ListIterator listIterator, ListIterator listIterator2) {
        ArrayList<ListIterator> arrayList = new ArrayList<ListIterator>(2);
        arrayList.add(listIterator);
        arrayList.add(listIterator2);
        return arrayList.listIterator();
    }

    private static ListIterator buildIterators(ListIterator listIterator, ListIterator listIterator2, ListIterator listIterator3) {
        ArrayList<ListIterator> arrayList = new ArrayList<ListIterator>(3);
        arrayList.add(listIterator);
        arrayList.add(listIterator2);
        arrayList.add(listIterator3);
        return arrayList.listIterator();
    }

    public void add(Object object) {
        this.checkNextIterator();
        this.nextIterator.add(object);
        ++this.nextIndex;
    }

    public boolean hasNext() {
        try {
            this.loadNextIterator();
        }
        catch (NoSuchElementException noSuchElementException) {
            return false;
        }
        return this.nextIterator.hasNext();
    }

    public boolean hasPrevious() {
        try {
            this.loadPreviousIterator();
        }
        catch (NoSuchElementException noSuchElementException) {
            return false;
        }
        return this.nextIterator.hasPrevious();
    }

    public Object next() {
        this.loadNextIterator();
        Object e = this.nextIterator.next();
        this.lastIteratorToReturnElement = this.nextIterator;
        ++this.nextIndex;
        this.nextReturned = true;
        return e;
    }

    public int nextIndex() {
        return this.nextIndex;
    }

    public Object previous() {
        this.loadPreviousIterator();
        Object e = this.nextIterator.previous();
        this.lastIteratorToReturnElement = this.nextIterator;
        --this.nextIndex;
        this.nextReturned = false;
        return e;
    }

    public int previousIndex() {
        return this.nextIndex - 1;
    }

    public void remove() {
        if (this.lastIteratorToReturnElement == null) {
            throw new IllegalStateException();
        }
        this.lastIteratorToReturnElement.remove();
        if (this.nextReturned) {
            --this.nextIndex;
        }
    }

    public void set(Object object) {
        if (this.lastIteratorToReturnElement == null) {
            throw new IllegalStateException();
        }
        this.lastIteratorToReturnElement.set(object);
    }

    private void loadNextIterator() {
        this.checkNextIterator();
        while (!this.nextIterator.hasNext() && this.iterators.hasNext()) {
            this.nextIterator = (ListIterator)this.iterators.next();
        }
    }

    private void loadPreviousIterator() {
        this.checkNextIterator();
        while (!this.nextIterator.hasPrevious() && this.iterators.hasPrevious()) {
            this.nextIterator = (ListIterator)this.iterators.previous();
        }
    }

    private void checkNextIterator() {
        if (this.nextIterator == null) {
            this.nextIterator = (ListIterator)this.iterators.next();
        }
    }

    public String toString() {
        return ClassTools.shortClassNameForObject(this) + '(' + this.iterators + ')';
    }
}

