/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.utility.string;

import java.util.Comparator;
import org.eclipse.persistence.tools.workbench.utility.string.StringHolder;
import org.eclipse.persistence.tools.workbench.utility.string.StringTools;

public interface PartialStringComparatorEngine {
    public StringHolderPair[] match(StringHolder[] var1, StringHolder[] var2);

    public static class SimpleStringHolderPair
    implements StringHolderPair {
        private final StringHolder stringHolder1;
        private final StringHolder stringHolder2;
        private final double score;

        public SimpleStringHolderPair(StringHolder stringHolder, StringHolder stringHolder2, double d) {
            this.stringHolder1 = stringHolder;
            this.stringHolder2 = stringHolder2;
            this.score = d;
        }

        public StringHolder getStringHolder1() {
            return this.stringHolder1;
        }

        public StringHolder getStringHolder2() {
            return this.stringHolder2;
        }

        public double getScore() {
            return this.score;
        }

        public int compareTo(Object object) {
            return DEFAULT_COMPARATOR.compare(this, object);
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer(100);
            StringTools.buildSimpleToStringOn(this, stringBuffer);
            stringBuffer.append(" (");
            this.appendStringHolder(this.stringHolder1, stringBuffer);
            stringBuffer.append(" vs. ");
            this.appendStringHolder(this.stringHolder2, stringBuffer);
            stringBuffer.append(" => ");
            stringBuffer.append(this.score);
            stringBuffer.append(')');
            return stringBuffer.toString();
        }

        private void appendStringHolder(StringHolder stringHolder, StringBuffer stringBuffer) {
            if (stringHolder == null) {
                stringBuffer.append("<null>");
            } else {
                stringBuffer.append('\"');
                stringBuffer.append(stringHolder.getString());
                stringBuffer.append('\"');
            }
        }
    }

    public static interface StringHolderPair
    extends Comparable {
        public static final Comparator DEFAULT_COMPARATOR = new Comparator(){

            public int compare(Object object, Object object2) {
                double d;
                double d2 = ((StringHolderPair)object).getScore();
                return d2 < (d = ((StringHolderPair)object2).getScore()) ? -1 : (d2 == d ? 0 : 1);
            }
        };

        public StringHolder getStringHolder1();

        public StringHolder getStringHolder2();

        public double getScore();
    }
}

