/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.utility.string;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.persistence.tools.workbench.utility.ClassTools;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;

public final class StringTools {
    public static final String CR = System.getProperty("line.separator");
    public static final int MINIMUM_MATCHING_LETTER = 2;
    public static final int NO_MATCH = 0;
    public static final int STRING_CONTAINS = 6;
    public static final int STRING_CONTAINS_PART = 2;
    public static final int STRING_CONTAINS_PART_CONTINUOUS = 4;
    public static final int STRINGS_EQUAL = 10;
    public static final int STRINGS_EQUAL_WITH_IGNORE_CHARACTERS = 8;
    private static final char[] VOWELS = new char[]{'a', 'e', 'i', 'o', 'u'};

    public static String pad(String string, int n) {
        int n2 = string.length();
        if (n2 > n) {
            throw new IllegalArgumentException("String is too long: " + n2 + " > " + n);
        }
        if (n2 == n) {
            return string;
        }
        return StringTools.padInternal(string, n);
    }

    public static String padOrTruncate(String string, int n) {
        int n2 = string.length();
        if (n2 == n) {
            return string;
        }
        if (n2 > n) {
            return string.substring(0, n);
        }
        return StringTools.padInternal(string, n);
    }

    private static String padInternal(String string, int n) {
        char[] cArray = new char[n];
        int n2 = string.length();
        string.getChars(0, n2, cArray, 0);
        Arrays.fill(cArray, n2, n, ' ');
        return new String(cArray);
    }

    public static String zeroPad(String string, int n) {
        int n2 = string.length();
        if (n2 > n) {
            throw new IllegalArgumentException("String is too long: " + n2 + " > " + n);
        }
        if (n2 == n) {
            return string;
        }
        return StringTools.zeroPadInternal(string, n);
    }

    public static String zeroPadOrTruncate(String string, int n) {
        int n2 = string.length();
        if (n2 == n) {
            return string;
        }
        if (n2 > n) {
            return string.substring(n2 - n);
        }
        return StringTools.zeroPadInternal(string, n);
    }

    private static String zeroPadInternal(String string, int n) {
        char[] cArray = new char[n];
        int n2 = string.length();
        int n3 = n - n2;
        string.getChars(0, n2, cArray, n3);
        Arrays.fill(cArray, 0, n3, '0');
        return new String(cArray);
    }

    public static String removeFirstOccurrence(String string, char c) {
        int n = string.indexOf(c);
        if (n == -1) {
            return string;
        }
        if (n == 0) {
            return string.substring(1);
        }
        int n2 = string.length() - 1;
        if (n == n2) {
            return string.substring(0, n2);
        }
        return string.substring(0, n).concat(string.substring(n + 1));
    }

    public static String removeAllOccurrences(String string, char c) {
        StringBuffer stringBuffer = new StringBuffer(string.length());
        StringTools.removeAllOccurrencesOn(string, c, stringBuffer);
        return stringBuffer.toString();
    }

    public static void removeAllOccurrencesOn(String string, char c, StringBuffer stringBuffer) {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c2 = string.charAt(i);
            if (c2 == c) continue;
            stringBuffer.append(c2);
        }
    }

    public static String removeAllSpaces(String string) {
        return StringTools.removeAllOccurrences(string, ' ');
    }

    public static int commonPrefixLength(String string, String string2) {
        return StringTools.commonPrefixLength(string.toCharArray(), string2.toCharArray());
    }

    public static int commonPrefixLength(char[] cArray, char[] cArray2) {
        return StringTools.commonPrefixLengthInternal(cArray, cArray2, Math.min(cArray.length, cArray2.length));
    }

    public static int commonPrefixLength(String string, String string2, int n) {
        return StringTools.commonPrefixLength(string.toCharArray(), string2.toCharArray());
    }

    public static int commonPrefixLength(char[] cArray, char[] cArray2, int n) {
        return StringTools.commonPrefixLengthInternal(cArray, cArray2, Math.min(n, Math.min(cArray.length, cArray2.length)));
    }

    private static int commonPrefixLengthInternal(char[] cArray, char[] cArray2, int n) {
        for (int i = 0; i < n; ++i) {
            if (cArray[i] == cArray2[i]) continue;
            return i;
        }
        return n;
    }

    private static char[] capitalizeInternal(char[] cArray) {
        cArray[0] = Character.toUpperCase(cArray[0]);
        return cArray;
    }

    public static char[] capitalize(char[] cArray) {
        if (cArray.length == 0 || Character.isUpperCase(cArray[0])) {
            return cArray;
        }
        return StringTools.capitalizeInternal(cArray);
    }

    public static String capitalize(String string) {
        if (string.length() == 0 || Character.isUpperCase(string.charAt(0))) {
            return string;
        }
        return new String(StringTools.capitalizeInternal(string.toCharArray()));
    }

    private static void capitalizeOnInternal(char[] cArray, StringBuffer stringBuffer) {
        stringBuffer.append(Character.toUpperCase(cArray[0]));
        stringBuffer.append(cArray, 1, cArray.length - 1);
    }

    public static void capitalizeOn(char[] cArray, StringBuffer stringBuffer) {
        if (cArray.length == 0) {
            return;
        }
        if (Character.isUpperCase(cArray[0])) {
            stringBuffer.append(cArray);
        } else {
            StringTools.capitalizeOnInternal(cArray, stringBuffer);
        }
    }

    public static void capitalizeOn(String string, StringBuffer stringBuffer) {
        if (string.length() == 0) {
            return;
        }
        if (Character.isUpperCase(string.charAt(0))) {
            stringBuffer.append(string);
        } else {
            StringTools.capitalizeOnInternal(string.toCharArray(), stringBuffer);
        }
    }

    private static void capitalizeOnInternal(char[] cArray, Writer writer) {
        try {
            writer.write(Character.toUpperCase(cArray[0]));
            writer.write(cArray, 1, cArray.length - 1);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    private static void writeStringOn(char[] cArray, Writer writer) {
        try {
            writer.write(cArray);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public static void capitalizeOn(char[] cArray, Writer writer) {
        if (cArray.length == 0) {
            return;
        }
        if (Character.isUpperCase(cArray[0])) {
            StringTools.writeStringOn(cArray, writer);
        } else {
            StringTools.capitalizeOnInternal(cArray, writer);
        }
    }

    private static void writeStringOn(String string, Writer writer) {
        try {
            writer.write(string);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public static void capitalizeOn(String string, Writer writer) {
        if (string.length() == 0) {
            return;
        }
        if (Character.isUpperCase(string.charAt(0))) {
            StringTools.writeStringOn(string, writer);
        } else {
            StringTools.capitalizeOnInternal(string.toCharArray(), writer);
        }
    }

    private static char[] uncapitalizeInternal(char[] cArray) {
        cArray[0] = Character.toLowerCase(cArray[0]);
        return cArray;
    }

    private static boolean stringNeedNotBeUncapitalized(char[] cArray) {
        if (cArray.length == 0) {
            return true;
        }
        return Character.isLowerCase(cArray[0]);
    }

    private static boolean stringNeedNotBeUncapitalizedJavaBean(char[] cArray) {
        if (StringTools.stringNeedNotBeUncapitalized(cArray)) {
            return true;
        }
        return cArray.length > 1 && Character.isUpperCase(cArray[1]) && Character.isUpperCase(cArray[0]);
    }

    public static char[] uncapitalizeJavaBean(char[] cArray) {
        if (StringTools.stringNeedNotBeUncapitalizedJavaBean(cArray)) {
            return cArray;
        }
        return StringTools.uncapitalizeInternal(cArray);
    }

    public static char[] uncapitalize(char[] cArray) {
        if (StringTools.stringNeedNotBeUncapitalized(cArray)) {
            return cArray;
        }
        return StringTools.uncapitalizeInternal(cArray);
    }

    private static boolean stringNeedNotBeUncapitalized(String string) {
        if (string.length() == 0) {
            return true;
        }
        return Character.isLowerCase(string.charAt(0));
    }

    private static boolean stringNeedNotBeUncapitalizedJavaBean(String string) {
        if (StringTools.stringNeedNotBeUncapitalized(string)) {
            return true;
        }
        return string.length() > 1 && Character.isUpperCase(string.charAt(1)) && Character.isUpperCase(string.charAt(0));
    }

    public static String uncapitalizeJavaBean(String string) {
        if (StringTools.stringNeedNotBeUncapitalizedJavaBean(string)) {
            return string;
        }
        return new String(StringTools.uncapitalizeInternal(string.toCharArray()));
    }

    public static String uncapitalize(String string) {
        if (StringTools.stringNeedNotBeUncapitalized(string)) {
            return string;
        }
        return new String(StringTools.uncapitalizeInternal(string.toCharArray()));
    }

    private static void uncapitalizeOnInternal(char[] cArray, StringBuffer stringBuffer) {
        stringBuffer.append(Character.toLowerCase(cArray[0]));
        stringBuffer.append(cArray, 1, cArray.length - 1);
    }

    public static void uncapitalizeOn(char[] cArray, StringBuffer stringBuffer) {
        if (StringTools.stringNeedNotBeUncapitalized(cArray)) {
            stringBuffer.append(cArray);
        } else {
            StringTools.uncapitalizeOnInternal(cArray, stringBuffer);
        }
    }

    public static void uncapitalizeOn(String string, StringBuffer stringBuffer) {
        if (StringTools.stringNeedNotBeUncapitalized(string)) {
            stringBuffer.append(string);
        } else {
            StringTools.uncapitalizeOnInternal(string.toCharArray(), stringBuffer);
        }
    }

    private static void uncapitalizeOnInternal(char[] cArray, Writer writer) {
        try {
            writer.write(Character.toLowerCase(cArray[0]));
            writer.write(cArray, 1, cArray.length - 1);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public static void uncapitalizeOn(char[] cArray, Writer writer) {
        if (StringTools.stringNeedNotBeUncapitalized(cArray)) {
            StringTools.writeStringOn(cArray, writer);
        } else {
            StringTools.uncapitalizeOnInternal(cArray, writer);
        }
    }

    public static void uncapitalizeOn(String string, Writer writer) {
        if (StringTools.stringNeedNotBeUncapitalized(string)) {
            StringTools.writeStringOn(string, writer);
        } else {
            StringTools.uncapitalizeOnInternal(string.toCharArray(), writer);
        }
    }

    public static String buildToStringFor(Object object, Object object2) {
        StringBuffer stringBuffer = new StringBuffer();
        StringTools.buildSimpleToStringOn(object, stringBuffer);
        stringBuffer.append(" (");
        stringBuffer.append(object2);
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    public static String buildToStringFor(Object object) {
        StringBuffer stringBuffer = new StringBuffer();
        StringTools.buildSimpleToStringOn(object, stringBuffer);
        return stringBuffer.toString();
    }

    public static void buildSimpleToStringOn(Object object, StringBuffer stringBuffer) {
        stringBuffer.append(ClassTools.toStringClassNameForObject(object));
        stringBuffer.append('[');
        stringBuffer.append(StringTools.zeroPad(Integer.toHexString(System.identityHashCode(object)).toUpperCase(), 8));
        stringBuffer.append(']');
    }

    public static boolean stringIsEmpty(String string) {
        if (string == null || string.length() == 0) {
            return true;
        }
        int n = string.length();
        while (n-- > 0) {
            if (Character.isWhitespace(string.charAt(n))) continue;
            return false;
        }
        return true;
    }

    public static boolean stringsAreEqualIgnoreCase(String string, String string2) {
        if (string == null && string2 == null) {
            return true;
        }
        if (string == null || string2 == null) {
            return false;
        }
        return string.equalsIgnoreCase(string2);
    }

    public static boolean stringsAreEqual(String string, String string2) {
        if (string == null && string2 == null) {
            return true;
        }
        if (string == null || string2 == null) {
            return false;
        }
        return string.equals(string2);
    }

    public static boolean charIsVowel(char c) {
        return CollectionTools.contains(VOWELS, Character.toLowerCase(c));
    }

    public static String replaceHTMLBreaks(String string) {
        return string.replaceAll("<br>", CR).replaceAll("<BR>", CR);
    }

    public static String convertCamelBackToAllCaps(String string) {
        int n = string.length();
        if (n == 0) {
            return "";
        }
        char c = '\u0000';
        char c2 = '\u0000';
        char c3 = string.charAt(0);
        StringBuffer stringBuffer = new StringBuffer(n * 2);
        for (int i = 1; i <= n; ++i) {
            c2 = c3;
            char c4 = c3 = i == n ? (char)'\u0000' : string.charAt(i);
            if (StringTools.camelBackWordBreak(c, c2, c3)) {
                stringBuffer.append('_');
            }
            stringBuffer.append(Character.toUpperCase(c2));
            c = c2;
        }
        return stringBuffer.toString();
    }

    public static String convertCamelBackToAllCaps(String string, int n) {
        int n2 = string.length();
        if (n2 == 0 || n == 0) {
            return "";
        }
        char c = '\u0000';
        char c2 = '\u0000';
        char c3 = string.charAt(0);
        StringBuffer stringBuffer = new StringBuffer(n);
        for (int i = 1; i <= n2; ++i) {
            c2 = c3;
            char c4 = c3 = i == n2 ? (char)'\u0000' : string.charAt(i);
            if (StringTools.camelBackWordBreak(c, c2, c3)) {
                stringBuffer.append('_');
                if (stringBuffer.length() == n) {
                    return stringBuffer.toString();
                }
            }
            stringBuffer.append(Character.toUpperCase(c2));
            if (stringBuffer.length() == n) {
                return stringBuffer.toString();
            }
            c = c2;
        }
        return stringBuffer.toString();
    }

    private static boolean camelBackWordBreak(char c, char c2, char c3) {
        if (c == '\u0000') {
            return false;
        }
        if (Character.isLowerCase(c2)) {
            return false;
        }
        if (Character.isLowerCase(c)) {
            return true;
        }
        if (c3 == '\u0000') {
            return false;
        }
        return Character.isLowerCase(c3);
    }

    public static String convertAllCapsToCamelBack(String string) {
        return StringTools.convertAllCapsToCamelBack(string, true);
    }

    public static String convertAllCapsToCamelBack(String string, boolean bl) {
        int n = string.length();
        if (n == 0) {
            return "";
        }
        char c = '\u0000';
        char c2 = '\u0000';
        StringBuffer stringBuffer = new StringBuffer(n);
        for (int i = 0; i < n; ++i) {
            c = c2;
            c2 = string.charAt(i);
            if (c2 == '_') continue;
            if (stringBuffer.length() == 0) {
                if (bl) {
                    stringBuffer.append(Character.toUpperCase(c2));
                    continue;
                }
                stringBuffer.append(Character.toLowerCase(c2));
                continue;
            }
            if (c == '_') {
                stringBuffer.append(Character.toUpperCase(c2));
                continue;
            }
            stringBuffer.append(Character.toLowerCase(c2));
        }
        return stringBuffer.toString();
    }

    private StringTools() {
        throw new UnsupportedOperationException();
    }

    public static double calculateHighestMatchWeight(String string, String string2) {
        return StringTools.calculateHighestMatchWeight(string, string2, new char[0], 2);
    }

    public static double calculateHighestMatchWeight(String string, String string2, char c) {
        return StringTools.calculateHighestMatchWeight(string, string2, new char[]{c}, 2);
    }

    public static double calculateHighestMatchWeight(String string, String string2, char c, int n) {
        return StringTools.calculateHighestMatchWeight(string, string2, new char[]{c}, n);
    }

    public static double calculateHighestMatchWeight(String string, String string2, char[] cArray) {
        return StringTools.calculateHighestMatchWeight(string, string2, cArray, 2);
    }

    public static double calculateHighestMatchWeight(String string, String string2, char[] cArray, int n) {
        if (string == null || string2 == null) {
            return 0.0;
        }
        if (string.equals(string2)) {
            return 1.0;
        }
        if (StringTools.equals(string, string2, cArray)) {
            double d = string2.length();
            double d2 = string.length();
            return d / d2;
        }
        if (string.indexOf(string2) > -1) {
            double d = string2.length();
            double d3 = string.length();
            return d / d3;
        }
        int n2 = StringTools.weightContainsPartContinuous(string, string2, cArray, n);
        if (n2 >= n) {
            double d = (double)n2 / (double)string.length();
            double d4 = (double)n2 / (double)string2.length();
            return (d + d4) / 2.0;
        }
        n2 = StringTools.weightContainsPart(string, string2, cArray, n);
        if (n2 >= n) {
            double d = (double)n2 / (double)string.length();
            double d5 = (double)n2 / (double)string2.length();
            return (d + d5) / 2.0;
        }
        return 0.0;
    }

    public static double calculateHighestMatchWeight(String string, String string2, int n) {
        return StringTools.calculateHighestMatchWeight(string, string2, new char[0], n);
    }

    public static int calculateMatchWeight(String string, String string2) {
        return StringTools.calculateMatchWeight(string, string2, new char[0], 2);
    }

    public static int calculateMatchWeight(String string, String string2, char c) {
        return StringTools.calculateMatchWeight(string, string2, new char[]{c}, 2);
    }

    public static int calculateMatchWeight(String string, String string2, char c, int n) {
        return StringTools.calculateMatchWeight(string, string2, new char[]{c}, n);
    }

    public static int calculateMatchWeight(String string, String string2, char[] cArray) {
        return StringTools.calculateMatchWeight(string, string2, cArray, 2);
    }

    public static int calculateMatchWeight(String string, String string2, char[] cArray, int n) {
        if (string == null || string2 == null) {
            return 0;
        }
        if (string.equals(string2)) {
            return 10;
        }
        if (StringTools.equals(string, string2, cArray)) {
            return 8;
        }
        if (string.indexOf(string2) > -1) {
            return 6;
        }
        if (StringTools.containsPartContinuous(string, string2, cArray, n)) {
            return 4;
        }
        if (StringTools.containsPart(string, string2, cArray, n)) {
            return 2;
        }
        return 0;
    }

    public static int calculateMatchWeight(String string, String string2, int n) {
        return StringTools.calculateMatchWeight(string, string2, new char[0], n);
    }

    public static int calculateMatchWeightIgnoreCase(String string, String string2) {
        return StringTools.calculateMatchWeightIgnoreCase(string, string2, new char[0], 2);
    }

    public static int calculateMatchWeightIgnoreCase(String string, String string2, char c) {
        return StringTools.calculateMatchWeightIgnoreCase(string, string2, new char[]{c}, 2);
    }

    public static int calculateMatchWeightIgnoreCase(String string, String string2, char[] cArray) {
        return StringTools.calculateMatchWeightIgnoreCase(string, string2, cArray, 2);
    }

    public static int calculateMatchWeightIgnoreCase(String string, String string2, char[] cArray, int n) {
        if (string == null || string2 == null) {
            return 0;
        }
        return StringTools.calculateMatchWeight(string.toLowerCase(), string2.toLowerCase(), cArray, n);
    }

    public static int calculateMatchWeightIgnoreCase(String string, String string2, int n) {
        return StringTools.calculateMatchWeightIgnoreCase(string, string2, new char[0], n);
    }

    public static boolean equals(String string, String string2) {
        return string != null && string.equals(string2) || string2 != null && string2.equals(string);
    }

    public static boolean equals(String string, String string2, char c) {
        return StringTools.equals(string, string2, new char[]{c});
    }

    public static boolean equals(String string, String string2, char[] cArray) {
        if (string == null || string2 == null) {
            return false;
        }
        for (int i = 0; i < cArray.length; ++i) {
            String string3 = String.valueOf(cArray[i]);
            string = string.replaceAll(string3, "");
            string2 = string2.replaceAll(string3, "");
        }
        return string.equals(string2);
    }

    public static boolean equalsIgnoreCase(String string, String string2) {
        return string != null && string.equalsIgnoreCase(string2) || string2 != null && string2.equalsIgnoreCase(string);
    }

    public static boolean equalsIgnoreCase(String string, String string2, char c) {
        if (string == null || string2 == null) {
            return false;
        }
        return StringTools.equals(string.toLowerCase(), string2.toLowerCase(), new char[]{c});
    }

    public static boolean equalsIgnoreCase(String string, String string2, char[] cArray) {
        if (string == null || string2 == null) {
            return false;
        }
        return StringTools.equals(string.toLowerCase(), string2.toLowerCase(), cArray);
    }

    public static int weightContainsPart(String string, String string2) {
        return StringTools.weightContainsPart(string, string2, new char[0], 2);
    }

    public static int weightContainsPart(String string, String string2, char c) {
        return StringTools.weightContainsPart(string, string2, new char[]{c}, 2);
    }

    public static int weightContainsPart(String string, String string2, char c, int n) {
        return StringTools.weightContainsPart(string, string2, new char[]{c}, n);
    }

    public static int weightContainsPart(String string, String string2, char[] cArray) {
        return StringTools.weightContainsPart(string, string2, cArray, 2);
    }

    public static int weightContainsPart(String string, String string2, char[] cArray, int n) {
        if (string == null || string2 == null || n < 2) {
            return 0;
        }
        if (string.length() < n) {
            n = string.length();
        }
        string = StringTools.removeIgnoreCharacters(string, cArray);
        string2 = StringTools.removeIgnoreCharacters(string2, cArray);
        Position[] positionArray = string.length() < string2.length() ? StringTools.weightContainsPartImp(string2, string) : StringTools.weightContainsPartImp(string, string2);
        int n2 = 0;
        int n3 = positionArray.length;
        while (--n3 >= 0) {
            if (Position.canAddWeight(positionArray, n3)) {
                n2 += positionArray[n3].length;
                continue;
            }
            if (n3 <= 0) continue;
            Position[] positionArray2 = positionArray;
            positionArray = new Position[positionArray.length - 1];
            System.arraycopy(positionArray2, 0, positionArray, 0, n3);
            System.arraycopy(positionArray2, n3, positionArray, n3, positionArray2.length - n3 - 1);
        }
        if (n2 < n) {
            return 0;
        }
        return n2;
    }

    public static int weightContainsPart(String string, String string2, int n) {
        return StringTools.weightContainsPart(string, string2, new char[0], n);
    }

    public static int weightContainsPartContinuous(String string, String string2) {
        return StringTools.weightContainsPartContinuous(string, string2, new char[0], 2);
    }

    public static int weightContainsPartContinuous(String string, String string2, char c) {
        return StringTools.weightContainsPartContinuous(string, string2, new char[]{c}, 2);
    }

    public static int weightContainsPartContinuous(String string, String string2, char c, int n) {
        return StringTools.weightContainsPartContinuous(string, string2, new char[]{c}, n);
    }

    public static int weightContainsPartContinuous(String string, String string2, char[] cArray) {
        return StringTools.weightContainsPartContinuous(string, string2, cArray, 2);
    }

    public static int weightContainsPartContinuous(String string, String string2, char[] cArray, int n) {
        if (string == null || string2 == null || n < 2) {
            return 0;
        }
        string = StringTools.removeIgnoreCharacters(string, cArray);
        string2 = StringTools.removeIgnoreCharacters(string2, cArray);
        return StringTools.weightContainsPartContinuousImp(string, string2, n);
    }

    public static int weightContainsPartContinuous(String string, String string2, int n) {
        return StringTools.weightContainsPartContinuous(string, string2, new char[0], n);
    }

    private static int weightContainsPartContinuousImp(String string, String string2, int n) {
        int n2 = string2.length();
        if (n2 < n) {
            return 0;
        }
        if (string.indexOf(string2) > -1) {
            return n2;
        }
        int n3 = StringTools.weightContainsPartContinuousImp(string, string2.substring(1, n2), n);
        int n4 = StringTools.weightContainsPartContinuousImp(string, string2.substring(0, n2 - 1), n);
        return Math.max(n3, n4);
    }

    private static Position[] weightContainsPartImp(String string, String string2) {
        int n = string2.length();
        if (n == 0) {
            return new Position[0];
        }
        int n2 = string.indexOf(string2);
        if (n2 > -1) {
            Position position = new Position(n2, n);
            int n3 = string.length();
            while (n2 > -1 && n3 - n2 - 2 * n >= 0) {
                if ((n2 = string.indexOf(string2, n2 + n)) <= -1) continue;
                position.add(n2);
            }
            return new Position[]{position};
        }
        if (n > 1) {
            String string3 = string2.substring(1, n);
            Position[] positionArray = StringTools.weightContainsPartImp(string, string3);
            String string4 = string2.substring(0, n - 1);
            Position[] positionArray2 = StringTools.weightContainsPartImp(string, string4);
            return Position.merge(positionArray, positionArray2);
        }
        return new Position[0];
    }

    public static boolean contains(String string, String string2, char c) {
        return StringTools.contains(string, string2, new char[]{c});
    }

    public static boolean contains(String string, String string2, char[] cArray) {
        if (string == null || string2 == null) {
            return false;
        }
        return (string = StringTools.removeIgnoreCharacters(string, cArray)).indexOf(string2 = StringTools.removeIgnoreCharacters(string2, cArray)) > -1;
    }

    public static boolean containsIgnoreCase(Collection collection, String string) {
        return StringTools.containsIgnoreCase(collection.iterator(), string);
    }

    public static boolean containsIgnoreCase(Iterator iterator, String string) {
        if (string == null) {
            return false;
        }
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (e == null || !string.equalsIgnoreCase(e.toString())) continue;
            return true;
        }
        return false;
    }

    public static boolean containsPart(String string, String string2) {
        return StringTools.containsPart(string, string2, new char[0], 2);
    }

    public static boolean containsPart(String string, String string2, char c) {
        return StringTools.containsPart(string, string2, new char[]{c}, 2);
    }

    public static boolean containsPart(String string, String string2, char c, int n) {
        return StringTools.containsPart(string, string2, new char[]{c}, n);
    }

    public static boolean containsPart(String string, String string2, char[] cArray) {
        return StringTools.containsPart(string, string2, cArray, 2);
    }

    public static boolean containsPart(String string, String string2, char[] cArray, int n) {
        return StringTools.weightContainsPart(string, string2, cArray, n) >= n;
    }

    public static boolean containsPart(String string, String string2, int n) {
        return StringTools.containsPart(string, string2, new char[0], n);
    }

    public static boolean containsPartContinuous(String string, String string2) {
        return StringTools.containsPartContinuous(string, string2, new char[0], 2);
    }

    public static boolean containsPartContinuous(String string, String string2, char c) {
        return StringTools.containsPartContinuous(string, string2, new char[]{c}, 2);
    }

    public static boolean containsPartContinuous(String string, String string2, char c, int n) {
        return StringTools.containsPartContinuous(string, string2, new char[0], n);
    }

    public static boolean containsPartContinuous(String string, String string2, char[] cArray) {
        return StringTools.containsPartContinuous(string, string2, cArray, 2);
    }

    public static boolean containsPartContinuous(String string, String string2, char[] cArray, int n) {
        return StringTools.weightContainsPartContinuous(string, string2, cArray, n) >= n;
    }

    public static boolean containsPartContinuous(String string, String string2, int n) {
        return StringTools.containsPartContinuous(string, string2, new char[0], n);
    }

    public static String removeIgnoreCharacters(String string, char[] cArray) {
        if (string == null || string.length() == 0 || cArray.length == 0) {
            return string;
        }
        for (int i = 0; i < cArray.length; ++i) {
            String string2 = String.valueOf(cArray[i]);
            string = string.replaceAll(string2, "");
        }
        return string;
    }

    private static class Position {
        int[] indices = new int[1];
        int length;

        Position() {
            this.indices[0] = -1;
        }

        Position(int n, int n2) {
            this();
            this.indices[0] = n;
            this.length = n2;
        }

        private static List asList(Position[] positionArray) {
            ArrayList<Position> arrayList = new ArrayList<Position>(positionArray.length);
            for (int i = 0; i < positionArray.length; ++i) {
                arrayList.add(positionArray[i]);
            }
            return arrayList;
        }

        private static boolean canAddWeight(Position[] positionArray, int n) {
            if (n + 1 == positionArray.length) {
                return true;
            }
            Position position = positionArray[n];
            Position position2 = positionArray[n + 1];
            for (int i = 0; i < position.indices.length; ++i) {
                for (int j = 0; j < position2.indices.length; ++j) {
                    int n2 = position.indices[i];
                    int n3 = position2.indices[j];
                    if (n2 <= n3) continue;
                    return true;
                }
            }
            return false;
        }

        static Position[] merge(Position[] positionArray, Position[] positionArray2) {
            Position[] positionArray3;
            List list = Position.asList(positionArray);
            List list2 = Position.asList(positionArray2);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                positionArray3 = (Position[])iterator.next();
                Iterator iterator2 = list2.iterator();
                while (iterator2.hasNext()) {
                    Position position = (Position)iterator2.next();
                    if (positionArray3.inside(position)) {
                        iterator2.remove();
                        continue;
                    }
                    if (!position.inside((Position)positionArray3)) continue;
                    iterator.remove();
                }
            }
            positionArray3 = new Position[list.size() + list2.size()];
            System.arraycopy(list.toArray(), 0, positionArray3, 0, list.size());
            System.arraycopy(list2.toArray(), 0, positionArray3, list.size(), list2.size());
            return positionArray3;
        }

        void add(int n) {
            this.ensureCapacity();
            this.indices[this.indices.length - 1] = n;
        }

        private void ensureCapacity() {
            int[] nArray = this.indices;
            this.indices = new int[nArray.length + 1];
            System.arraycopy(nArray, 0, this.indices, 0, nArray.length);
        }

        boolean inside(Position position) {
            for (int i = 0; i < this.indices.length; ++i) {
                for (int j = 0; j < position.indices.length; ++j) {
                    if (this.indices[i] + this.length < position.indices[j] + position.length || this.indices[i] + this.length < position.length || this.indices[i] > position.indices[j]) continue;
                    return true;
                }
            }
            return false;
        }
    }
}

