/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.framework.action;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.persistence.tools.workbench.framework.action.AbstractEnablableFrameworkAction;
import org.eclipse.persistence.tools.workbench.framework.action.ToggleFrameworkAction;
import org.eclipse.persistence.tools.workbench.framework.app.AbstractApplicationNode;
import org.eclipse.persistence.tools.workbench.framework.app.ApplicationNode;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;

public abstract class AbstractToggleFrameworkAction
extends AbstractEnablableFrameworkAction
implements ToggleFrameworkAction {
    private boolean selectionState;
    private PropertyChangeListener selectionStateListener;
    protected static final String[] DEFAULT_SELECTED_PROPERTY_NAMES = new String[0];

    protected AbstractToggleFrameworkAction(WorkbenchContext workbenchContext) {
        super(workbenchContext);
    }

    public void setUp() {
        super.setUp();
        this.updateSelectionState();
    }

    protected void updateSelectionState() {
        ApplicationNode[] applicationNodeArray = this.selectedNodes();
        for (int i = 0; i < applicationNodeArray.length; ++i) {
            ApplicationNode applicationNode = applicationNodeArray[i];
            if (this.shouldBeSelected(applicationNode)) continue;
            this.setSelected(false);
            return;
        }
        this.setSelected(true);
    }

    protected abstract boolean shouldBeSelected(ApplicationNode var1);

    public void setSelected(boolean bl) {
        boolean bl2 = this.selectionState;
        this.selectionState = bl;
        this.firePropertyChange("toggleStateProperty", bl2, this.selectionState);
    }

    public boolean isSelected() {
        return this.selectionState;
    }

    protected void engageListeners(AbstractApplicationNode abstractApplicationNode) {
        super.engageListeners(abstractApplicationNode);
        this.engageValueSelected(abstractApplicationNode);
    }

    protected void engageValueSelected(AbstractApplicationNode abstractApplicationNode) {
        this.engageValue(abstractApplicationNode, this.selectedPropertyNames(), this.getSelectionStateListener());
    }

    protected void disengageListeners(AbstractApplicationNode abstractApplicationNode) {
        super.disengageListeners(abstractApplicationNode);
        this.disengageValueSelected(abstractApplicationNode);
    }

    protected void disengageValueSelected(AbstractApplicationNode abstractApplicationNode) {
        this.disengageValue(abstractApplicationNode, this.selectedPropertyNames(), this.getSelectionStateListener());
    }

    protected PropertyChangeListener getSelectionStateListener() {
        if (this.selectionStateListener == null) {
            this.selectionStateListener = this.buildSelectionStateListener();
        }
        return this.selectionStateListener;
    }

    protected PropertyChangeListener buildSelectionStateListener() {
        return new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                AbstractToggleFrameworkAction.this.updateSelectionState();
            }
        };
    }

    protected String[] selectedPropertyNames() {
        return DEFAULT_SELECTED_PROPERTY_NAMES;
    }
}

