/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.framework.internal;

import java.awt.Component;
import java.awt.Dimension;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;
import org.eclipse.persistence.tools.workbench.framework.app.AbstractPreferencesNode;
import org.eclipse.persistence.tools.workbench.framework.app.PreferencesNode;
import org.eclipse.persistence.tools.workbench.framework.internal.PreferencesEditorView;
import org.eclipse.persistence.tools.workbench.framework.internal.PreferencesNavigatorView;
import org.eclipse.persistence.tools.workbench.framework.uitools.OSplitPane;
import org.eclipse.persistence.tools.workbench.framework.uitools.SwingTools;
import org.eclipse.persistence.tools.workbench.uitools.app.BufferedPropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.SimplePropertyValueModel;

final class PreferencesView {
    private Preferences rootPreferences;
    private BufferedPropertyValueModel.Trigger bufferTrigger;
    private JSplitPane splitPane;
    private PreferencesNavigatorView navigatorView;
    private PreferencesEditorView editorView;
    private PropertyValueModel selectedNodeHolder;
    private PreferencesNode emptySelectionNode;

    PreferencesView(AbstractPreferencesNode abstractPreferencesNode, BufferedPropertyValueModel.Trigger trigger) {
        this.initialize(abstractPreferencesNode, trigger);
    }

    private void initialize(AbstractPreferencesNode abstractPreferencesNode, BufferedPropertyValueModel.Trigger trigger) {
        this.rootPreferences = abstractPreferencesNode.getPreferences();
        this.bufferTrigger = trigger;
        this.emptySelectionNode = new PreferencesEmptySelectionPseudoNode();
        this.selectedNodeHolder = new SimplePropertyValueModel(this.emptySelectionNode);
        this.navigatorView = new PreferencesNavigatorView(abstractPreferencesNode);
        this.navigatorView.addTreeSelectionListener(this.buildTreeSelectionListener());
        this.editorView = new PreferencesEditorView(this.selectedNodeHolder);
        this.splitPane = this.buildSplitPane();
        this.navigatorView.selectFirstChild();
    }

    private TreeSelectionListener buildTreeSelectionListener() {
        return new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                PreferencesView.this.selectedNodeChanged(treeSelectionEvent.getNewLeadSelectionPath());
            }
        };
    }

    private JSplitPane buildSplitPane() {
        OSplitPane oSplitPane = new OSplitPane();
        oSplitPane.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        oSplitPane.setDoubleBuffered(false);
        oSplitPane.setSize(new Dimension(750, 550));
        oSplitPane.setDividerLocation(0.2);
        SwingTools.setSplitPaneDividerBorder(oSplitPane, BorderFactory.createEmptyBorder());
        oSplitPane.setDividerSize(3);
        oSplitPane.setContinuousLayout(false);
        ((JSplitPane)oSplitPane).setLeftComponent(this.navigatorView.getComponent());
        ((JSplitPane)oSplitPane).setRightComponent(this.editorView.getComponent());
        return oSplitPane;
    }

    Component getComponent() {
        return this.splitPane;
    }

    PreferencesNavigatorView getView() {
        return this.navigatorView;
    }

    Component initialFocusComponent() {
        return this.navigatorView.initialFocusComponent();
    }

    private void selectedNodeChanged(TreePath treePath) {
        if (treePath == null) {
            this.selectedNodeHolder.setValue(this.emptySelectionNode);
        } else {
            this.selectedNodeHolder.setValue(treePath.getLastPathComponent());
        }
    }

    void triggerAccept() {
        this.bufferTrigger.accept();
    }

    void triggerReset() {
        this.bufferTrigger.reset();
    }

    void exportPreferences(File file) {
        BufferedOutputStream bufferedOutputStream;
        try {
            bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file), 2048);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new RuntimeException(fileNotFoundException);
        }
        try {
            this.rootPreferences.exportSubtree(bufferedOutputStream);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        finally {
            try {
                ((OutputStream)bufferedOutputStream).close();
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
    }

    void importPreferences(File file) {
        BufferedInputStream bufferedInputStream;
        try {
            bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new RuntimeException(fileNotFoundException);
        }
        try {
            Preferences.importPreferences(bufferedInputStream);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        finally {
            try {
                ((InputStream)bufferedInputStream).close();
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
    }

    private static final class PreferencesEmptySelectionPseudoNode
    extends AbstractPreferencesNode {
        PreferencesEmptySelectionPseudoNode() {
            super(null);
        }

        protected Component buildPropertiesPage() {
            return new JPanel();
        }

        protected String buildDisplayString() {
            return " ";
        }

        public String helpTopicId() {
            return "preferences";
        }
    }
}

