/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.framework.internal;

import java.awt.Component;
import java.util.prefs.Preferences;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JSplitPane;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import org.eclipse.persistence.tools.workbench.framework.app.ApplicationNode;
import org.eclipse.persistence.tools.workbench.framework.app.NavigatorSelectionModel;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.internal.EditorView;
import org.eclipse.persistence.tools.workbench.framework.internal.EmptySelectionPseudoNode;
import org.eclipse.persistence.tools.workbench.framework.internal.MultiSelectionPseudoNode;
import org.eclipse.persistence.tools.workbench.framework.internal.NavigatorView;
import org.eclipse.persistence.tools.workbench.framework.internal.ProblemsView;
import org.eclipse.persistence.tools.workbench.framework.uitools.OSplitPane;
import org.eclipse.persistence.tools.workbench.framework.uitools.SwingTools;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.SimplePropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModel;

final class WorkspaceView {
    private JSplitPane splitPane;
    private JSplitPane topSplitPane;
    private TreeSelectionListener treeSelectionListener;
    private NavigatorView navigatorView;
    private EditorView editorView;
    private ProblemsView problemsView;
    private PropertyValueModel selectedNodeHolder;
    private MultiSelectionPseudoNode multiSelectionNode;
    private ApplicationNode emptySelectionNode;

    WorkspaceView(WorkbenchContext workbenchContext, ValueModel valueModel) {
        this.multiSelectionNode = new MultiSelectionPseudoNode(workbenchContext.getApplicationContext());
        this.emptySelectionNode = new EmptySelectionPseudoNode(workbenchContext.getApplicationContext());
        this.selectedNodeHolder = new SimplePropertyValueModel(this.emptySelectionNode);
        this.navigatorView = new NavigatorView(workbenchContext.getApplicationContext(), valueModel);
        this.treeSelectionListener = this.buildTreeSelectionListener();
        this.navigatorView.addTreeSelectionListener(this.treeSelectionListener);
        this.editorView = new EditorView(this.selectedNodeHolder, workbenchContext);
        this.problemsView = new ProblemsView(this.selectedNodeHolder, this.navigatorSelectionModel(), workbenchContext);
        this.topSplitPane = this.buildTopSplitPane();
        this.splitPane = this.buildSplitPane();
    }

    private TreeSelectionListener buildTreeSelectionListener() {
        return new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                ApplicationNode[] applicationNodeArray = ((NavigatorSelectionModel)treeSelectionEvent.getSource()).getSelectedNodes();
                WorkspaceView.this.selectedNodesChanged(applicationNodeArray);
            }
        };
    }

    private JSplitPane buildSplitPane() {
        JSplitPane jSplitPane = new JSplitPane(0);
        jSplitPane.setBorder(BorderFactory.createEmptyBorder(3, 0, 0, 0));
        jSplitPane.setDoubleBuffered(false);
        SwingTools.setSplitPaneDividerBorder(jSplitPane, BorderFactory.createEmptyBorder());
        jSplitPane.setDividerSize(3);
        jSplitPane.setResizeWeight(1.0);
        jSplitPane.setContinuousLayout(false);
        jSplitPane.setTopComponent(this.topSplitPane);
        jSplitPane.setBottomComponent(this.problemsView.getComponent());
        jSplitPane.setDividerLocation(475);
        return jSplitPane;
    }

    private JSplitPane buildTopSplitPane() {
        OSplitPane oSplitPane = new OSplitPane(1);
        oSplitPane.setBorder(BorderFactory.createEmptyBorder());
        oSplitPane.setDoubleBuffered(false);
        SwingTools.setSplitPaneDividerBorder(oSplitPane, BorderFactory.createEmptyBorder());
        oSplitPane.setDividerSize(3);
        oSplitPane.setResizeWeight(0.0);
        oSplitPane.setContinuousLayout(false);
        ((JSplitPane)oSplitPane).setLeftComponent(this.navigatorView.getComponent());
        ((JSplitPane)oSplitPane).setRightComponent(this.editorView.getComponent());
        oSplitPane.setDividerLocation(250);
        return oSplitPane;
    }

    Component getComponent() {
        return this.splitPane;
    }

    NavigatorSelectionModel navigatorSelectionModel() {
        return this.navigatorView.getSelectionModel();
    }

    boolean problemsAreVisible() {
        return this.splitPane.getBottomComponent() != null;
    }

    Action problemReportAction() {
        return this.problemsView.getProblemReportAction();
    }

    Component getPropertiesPage() {
        return this.editorView.getPropertiesPage();
    }

    void selectedNodesChanged(ApplicationNode[] applicationNodeArray) {
        ApplicationNode applicationNode;
        this.multiSelectionNode.setSelectedNodes(applicationNodeArray);
        switch (applicationNodeArray.length) {
            case 0: {
                applicationNode = this.emptySelectionNode;
                break;
            }
            case 1: {
                applicationNode = applicationNodeArray[0];
                break;
            }
            default: {
                applicationNode = this.multiSelectionNode;
            }
        }
        this.selectedNodeHolder.setValue(applicationNode);
    }

    boolean toggleShowProblems() {
        if (this.problemsAreVisible()) {
            this.splitPane.setBottomComponent(null);
            return false;
        }
        this.splitPane.setBottomComponent(this.problemsView.getComponent());
        this.splitPane.setDividerLocation(0.8);
        return true;
    }

    void addNavigatorTreeSelectionListener(TreeSelectionListener treeSelectionListener) {
        this.navigatorView.addTreeSelectionListener(treeSelectionListener);
    }

    void removeNavigatorTreeSelectionListener(TreeSelectionListener treeSelectionListener) {
        this.navigatorView.removeTreeSelectionListener(treeSelectionListener);
    }

    void copySettingsFrom(WorkspaceView workspaceView) {
        this.splitPane.setDividerLocation(workspaceView.splitPane.getDividerLocation());
        this.topSplitPane.setDividerLocation(workspaceView.topSplitPane.getDividerLocation());
        if (!workspaceView.problemsAreVisible()) {
            this.toggleShowProblems();
        }
    }

    void saveState(Preferences preferences) {
        preferences.putInt("split pane divider location", this.splitPane.getDividerLocation());
        preferences.putInt("top split pane divider location", this.topSplitPane.getDividerLocation());
    }

    void restoreState(Preferences preferences) {
        int n = preferences.getInt("split pane divider location", this.splitPane.getDividerLocation());
        this.splitPane.setDividerLocation(n);
        int n2 = preferences.getInt("top split pane divider location", this.topSplitPane.getDividerLocation());
        this.topSplitPane.setDividerLocation(n2);
    }

    void saveTreeExpansionState(Preferences preferences) {
        this.navigatorView.saveTreeExpansionState(preferences);
    }

    void restoreTreeExpansionState(Preferences preferences) {
        this.navigatorView.restoreTreeExpansionState(preferences);
    }

    void close() {
        this.navigatorView.close();
        this.editorView.close();
        this.problemsView.close();
        this.navigatorView.removeTreeSelectionListener(this.treeSelectionListener);
    }
}

