/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.framework.uitools;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellEditor;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import org.eclipse.persistence.tools.workbench.framework.action.AbstractFrameworkAction;
import org.eclipse.persistence.tools.workbench.framework.context.ApplicationContext;
import org.eclipse.persistence.tools.workbench.framework.ui.view.AbstractPanel;
import org.eclipse.persistence.tools.workbench.framework.uitools.AccessibleTitledPanel;
import org.eclipse.persistence.tools.workbench.framework.uitools.FileChooser;
import org.eclipse.persistence.tools.workbench.framework.uitools.SwingComponentFactory;
import org.eclipse.persistence.tools.workbench.framework.uitools.UIToolsResourceBundle;
import org.eclipse.persistence.tools.workbench.uitools.app.ListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.SimplePropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.PrimitiveListTreeModel;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.string.StringTools;

public final class ClasspathPanel
extends AbstractPanel {
    private ListValueModel classpathEntriesHolder;
    private ValueModel rootFolderHolder;
    private DefaultClasspathDirectoryHolder defaultClasspathDirectoryHolder;
    private JTree classpathTree;
    private TreeModel classpathModel;
    private TreeSelectionModel classpathSelectionModel;
    private boolean editable;
    private boolean convertToRelativePath;
    private Action addEntryAction;
    private Action browseAction;
    private Action removeAction;
    private Action upAction;
    private Action downAction;
    public static final String MOST_RECENT_CLASSPATH_DIRECTORY_PREFERENCE = "recent classpath directory";

    public ClasspathPanel(ApplicationContext applicationContext, ListValueModel listValueModel, ValueModel valueModel) {
        this(applicationContext, listValueModel, valueModel, true, "CLASSPATH_PANEL_TITLE");
    }

    public ClasspathPanel(ApplicationContext applicationContext, ListValueModel listValueModel, boolean bl) {
        this(applicationContext, listValueModel, bl, "CLASSPATH_PANEL_TITLE");
    }

    public ClasspathPanel(ApplicationContext applicationContext, ListValueModel listValueModel, boolean bl, String string) {
        this(applicationContext, listValueModel, new SimplePropertyValueModel(), bl, string);
    }

    public ClasspathPanel(ApplicationContext applicationContext, ListValueModel listValueModel, ValueModel valueModel, boolean bl) {
        this(applicationContext, listValueModel, valueModel, bl, "CLASSPATH_PANEL_TITLE");
    }

    public ClasspathPanel(ApplicationContext applicationContext, ListValueModel listValueModel, ValueModel valueModel, boolean bl, String string) {
        super(applicationContext);
        this.initialize(listValueModel, valueModel, bl);
        this.initializeLayout(string);
    }

    private void initialize(ListValueModel listValueModel, ValueModel valueModel, boolean bl) {
        this.classpathEntriesHolder = listValueModel;
        this.rootFolderHolder = valueModel;
        this.defaultClasspathDirectoryHolder = DefaultClasspathDirectoryHolder.NULL_INSTANCE;
        this.classpathModel = this.buildClasspathModel(listValueModel);
        this.classpathSelectionModel = this.buildClasspathSelectionModel();
        this.addEntryAction = this.buildAddEntryAction();
        this.browseAction = this.buildBrowseAction();
        this.removeAction = this.buildRemoveAction();
        this.upAction = this.buildUpAction();
        this.downAction = this.buildDownAction();
        this.editable = bl;
        ((DefaultMutableTreeNode)this.classpathModel.getRoot()).setUserObject("");
    }

    protected ApplicationContext initializeContext(ApplicationContext applicationContext) {
        return applicationContext.buildExpandedResourceRepositoryContext(UIToolsResourceBundle.class);
    }

    private TreeModel buildClasspathModel(ListValueModel listValueModel) {
        return new PrimitiveListTreeModel(listValueModel){

            protected void primitiveChanged(int n, Object object) {
                ClasspathPanel.this.replaceEntry(n, object);
            }
        };
    }

    private TreeModelListener buildTreeModelListener(final JTree jTree) {
        return new TreeModelListener(){

            public void treeNodesChanged(TreeModelEvent treeModelEvent) {
            }

            public void treeNodesInserted(TreeModelEvent treeModelEvent) {
                TreeModel treeModel = (TreeModel)treeModelEvent.getSource();
                ExpandPathRunner expandPathRunner = new ExpandPathRunner(jTree, treeModel.getRoot());
                EventQueue.invokeLater(expandPathRunner);
            }

            public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
            }

            public void treeStructureChanged(TreeModelEvent treeModelEvent) {
            }
        };
    }

    private TreeSelectionModel buildClasspathSelectionModel() {
        DefaultTreeSelectionModel defaultTreeSelectionModel = new DefaultTreeSelectionModel();
        defaultTreeSelectionModel.setSelectionMode(4);
        return defaultTreeSelectionModel;
    }

    private Action buildAddEntryAction() {
        AbstractFrameworkAction abstractFrameworkAction = new AbstractFrameworkAction(this.getApplicationContext()){

            protected void initialize() {
                this.setText(this.resourceRepository().getString("ADD_ENTRY_BUTTON_TEXT"));
                this.setMnemonic(this.resourceRepository().getMnemonic("ADD_ENTRY_BUTTON_TEXT"));
            }

            public void actionPerformed(ActionEvent actionEvent) {
                ClasspathPanel.this.addEntry();
            }
        };
        abstractFrameworkAction.setEnabled(true);
        return abstractFrameworkAction;
    }

    private Action buildBrowseAction() {
        AbstractFrameworkAction abstractFrameworkAction = new AbstractFrameworkAction(this.getApplicationContext()){

            protected void initialize() {
                this.initializeTextAndMnemonic("BROWSE_BUTTON_1");
            }

            public void actionPerformed(ActionEvent actionEvent) {
                ClasspathPanel.this.promptToAddEntries();
            }
        };
        abstractFrameworkAction.setEnabled(true);
        return abstractFrameworkAction;
    }

    private Action buildRemoveAction() {
        AbstractFrameworkAction abstractFrameworkAction = new AbstractFrameworkAction(this.getApplicationContext()){

            protected void initialize() {
                this.setText(this.resourceRepository().getString("REMOVE_BUTTON_TEXT"));
                this.setMnemonic(this.resourceRepository().getMnemonic("REMOVE_BUTTON_TEXT"));
            }

            public void actionPerformed(ActionEvent actionEvent) {
                ClasspathPanel.this.removeEntries();
            }
        };
        abstractFrameworkAction.setEnabled(false);
        return abstractFrameworkAction;
    }

    private Action buildUpAction() {
        AbstractFrameworkAction abstractFrameworkAction = new AbstractFrameworkAction(this.getApplicationContext()){

            protected void initialize() {
                this.setText(this.resourceRepository().getString("UP_BUTTON_TEXT"));
                this.setMnemonic(this.resourceRepository().getMnemonic("UP_BUTTON_TEXT"));
            }

            public void actionPerformed(ActionEvent actionEvent) {
                ClasspathPanel.this.moveSelectedEntriesUp();
            }
        };
        abstractFrameworkAction.setEnabled(false);
        return abstractFrameworkAction;
    }

    private Action buildDownAction() {
        AbstractFrameworkAction abstractFrameworkAction = new AbstractFrameworkAction(this.getApplicationContext()){

            protected void initialize() {
                this.setText(this.resourceRepository().getString("DOWN_BUTTON_TEXT"));
                this.setMnemonic(this.resourceRepository().getMnemonic("DOWN_BUTTON_TEXT"));
            }

            public void actionPerformed(ActionEvent actionEvent) {
                ClasspathPanel.this.moveSelectedEntriesDown();
            }
        };
        abstractFrameworkAction.setEnabled(false);
        return abstractFrameworkAction;
    }

    protected void initializeLayout(String string) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setBorder(BorderFactory.createCompoundBorder(this.buildTitledBorder(string), BorderFactory.createEmptyBorder(0, 5, 5, 5)));
        this.classpathTree = this.buildClasspathTree();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(1, 0, 0, 0);
        JScrollPane jScrollPane = new JScrollPane(this.classpathTree);
        jScrollPane.setMinimumSize(new Dimension(1, 1));
        jScrollPane.setPreferredSize(new Dimension(1, 1));
        this.add((Component)jScrollPane, gridBagConstraints);
        AccessibleTitledPanel accessibleTitledPanel = new AccessibleTitledPanel(new GridLayout(5, 1, 0, 5));
        accessibleTitledPanel.add(new JButton(this.addEntryAction));
        accessibleTitledPanel.add(new JButton(this.browseAction));
        accessibleTitledPanel.add(new JButton(this.removeAction));
        accessibleTitledPanel.add(new JButton(this.upAction));
        accessibleTitledPanel.add(new JButton(this.downAction));
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 19;
        gridBagConstraints.insets = new Insets(1, 5, 0, 0);
        this.add((Component)accessibleTitledPanel, gridBagConstraints);
        this.addAlignRight(accessibleTitledPanel);
    }

    private JTree buildClasspathTree() {
        SwingComponentFactory.AccessibleTree accessibleTree = new SwingComponentFactory.AccessibleTree(this.classpathModel){

            public void cancelEditing() {
                if (this.isEditing()) {
                    TreePath treePath = this.getEditingPath();
                    DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
                    String string = (String)defaultMutableTreeNode.getUserObject();
                    super.cancelEditing();
                    if (StringTools.stringIsEmpty((String)string)) {
                        super.cancelEditing();
                        int n = this.getRowForPath(treePath);
                        ClasspathPanel.this.classpathEntriesHolder().removeItems(n, 1);
                    }
                }
            }
        };
        accessibleTree.setSelectionModel(this.classpathSelectionModel);
        accessibleTree.addTreeSelectionListener(this.buildClasspathSelectionListener());
        DefaultTreeCellRenderer defaultTreeCellRenderer = this.buildTreeCellRenderer();
        accessibleTree.setCellRenderer(defaultTreeCellRenderer);
        accessibleTree.setCellEditor(this.buildTreeCellEditor(accessibleTree, defaultTreeCellRenderer));
        accessibleTree.setRootVisible(false);
        accessibleTree.expandPath(new TreePath(this.classpathModel.getRoot()));
        accessibleTree.setEditable(this.editable);
        accessibleTree.setRowHeight(0);
        accessibleTree.setExpandsSelectedPaths(true);
        accessibleTree.setDoubleBuffered(true);
        this.classpathModel.addTreeModelListener(this.buildTreeModelListener(accessibleTree));
        return accessibleTree;
    }

    private TreeSelectionListener buildClasspathSelectionListener() {
        return new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                ClasspathPanel.this.classpathSelectionChanged();
            }
        };
    }

    File getRootFolder() {
        return (File)this.rootFolderHolder.getValue();
    }

    private DefaultTreeCellRenderer buildTreeCellRenderer() {
        return new DefaultTreeCellRenderer(){

            public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
                super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
                if (bl3) {
                    DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
                    Icon icon = this.buildIconForFile(new File((String)defaultMutableTreeNode.getUserObject()));
                    this.setLeafIcon(icon);
                    this.setIcon(icon);
                }
                return this;
            }

            private Icon buildIconForFile(File file) {
                File file2;
                if (!file.isAbsolute() && (file2 = ClasspathPanel.this.getRootFolder()) != null) {
                    file = new File(file2, file.getPath());
                }
                return ClasspathPanel.this.resourceRepository().getIcon(this.buildIconKeyForFile(file));
            }

            private String buildIconKeyForFile(File file) {
                if (!file.isAbsolute()) {
                    return "folder";
                }
                if (file.exists()) {
                    return file.isDirectory() ? "folder" : "file";
                }
                return "warning";
            }
        };
    }

    private TreeCellEditor buildTreeCellEditor(JTree jTree, DefaultTreeCellRenderer defaultTreeCellRenderer) {
        return new DefaultTreeCellEditor(jTree, defaultTreeCellRenderer);
    }

    public String getTopicID() {
        return "project.classpath";
    }

    private ListValueModel classpathEntriesHolder() {
        return this.classpathEntriesHolder;
    }

    private int lastEntryIndex() {
        return this.classpathEntriesHolder().size() - 1;
    }

    private void classpathSelectionChanged() {
        this.enableActions();
    }

    private void enableActions() {
        boolean bl = !this.classpathSelectionModel.isSelectionEmpty();
        boolean bl2 = this.classpathSelectionModel.getMinSelectionRow() == 0;
        boolean bl3 = this.classpathSelectionModel.getMaxSelectionRow() == this.lastEntryIndex();
        this.removeAction.setEnabled(bl);
        this.upAction.setEnabled(bl && !bl2);
        this.downAction.setEnabled(bl && !bl3);
    }

    private void removeEntries() {
        this.classpathEntriesHolder().removeItems(this.classpathSelectionModel.getMinSelectionRow(), this.classpathSelectionModel.getSelectionCount());
    }

    private void replaceEntry(int n, Object object) {
        if (!object.equals("")) {
            this.classpathEntriesHolder().replaceItem(n, object);
        }
    }

    private void moveSelectedEntriesUp() {
        Object object = this.classpathEntriesHolder().removeItem(this.classpathSelectionModel.getMinSelectionRow() - 1);
        this.classpathEntriesHolder().addItem(this.classpathSelectionModel.getMaxSelectionRow() + 1, object);
        this.enableActions();
    }

    private void moveSelectedEntriesDown() {
        Object object = this.classpathEntriesHolder().removeItem(this.classpathSelectionModel.getMaxSelectionRow() + 1);
        this.classpathEntriesHolder().addItem(this.classpathSelectionModel.getMinSelectionRow(), object);
        this.enableActions();
    }

    private void addEntry() {
        if (this.classpathTree.isEditing()) {
            this.classpathTree.cancelEditing();
        }
        TreeNode treeNode = (TreeNode)this.classpathModel.getRoot();
        int n = treeNode.getChildCount();
        int[] nArray = this.classpathTree.getSelectionRows();
        if (nArray != null && nArray.length > 0) {
            n = nArray[nArray.length - 1];
        }
        this.classpathEntriesHolder().addItems(n, Collections.singletonList(""));
        TreeNode treeNode2 = treeNode.getChildAt(n);
        this.classpathTree.startEditingAtPath(new TreePath(new Object[]{treeNode, treeNode2}));
    }

    void promptToAddEntries() {
        File[] fileArray;
        int n;
        if (this.classpathTree.isEditing()) {
            this.classpathTree.cancelEditing();
        }
        if ((n = (fileArray = this.promptToAddFiles()).length) == 0) {
            return;
        }
        ArrayList<String> arrayList = new ArrayList<String>(n);
        for (int i = 0; i < n; ++i) {
            arrayList.add(fileArray[i].getPath());
        }
        CollectionTools.removeAll(arrayList, (Iterator)((Iterator)this.classpathEntriesHolder().getValue()));
        if (arrayList.isEmpty()) {
            return;
        }
        TreeNode treeNode = (TreeNode)this.classpathModel.getRoot();
        this.classpathSelectionModel.clearSelection();
        int n2 = this.classpathEntriesHolder().size();
        this.classpathEntriesHolder().addItems(n2, arrayList);
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            this.classpathSelectionModel.addSelectionPath(this.pathFor(treeNode, iterator.next()));
        }
        this.enableActions();
    }

    private TreePath pathFor(TreeNode treeNode, Object object) {
        Enumeration<? extends TreeNode> enumeration = treeNode.children();
        while (enumeration.hasMoreElements()) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)enumeration.nextElement();
            if (!defaultMutableTreeNode.getUserObject().equals(object)) continue;
            return new TreePath(defaultMutableTreeNode.getPath());
        }
        throw new IllegalArgumentException("missing entry");
    }

    private File[] promptToAddFiles() {
        JFileChooser jFileChooser = this.buildFileChooser();
        int n = jFileChooser.showDialog(SwingUtilities.windowForComponent(this), this.resourceRepository().getString("DIALOG.OK_BUTTON_TEXT"));
        if (n == 0) {
            this.defaultClasspathDirectoryHolder.setDefaultClasspathDirectory(jFileChooser.getCurrentDirectory());
            return jFileChooser.getSelectedFiles();
        }
        return new File[0];
    }

    private JFileChooser buildFileChooser() {
        FileChooser fileChooser = new FileChooser(this.getDefaultClasspathDirectory(), this.getRootFolder());
        fileChooser.setFileSelectionMode(2);
        fileChooser.setDialogTitle(this.resourceRepository().getString("ADD_CLASSPATH_ENTRY_DIALOG.TITLE"));
        fileChooser.setMultiSelectionEnabled(true);
        fileChooser.setFileFilter(this.buildFileFilter());
        return fileChooser;
    }

    private FileFilter buildFileFilter() {
        return new FileFilter(){

            public boolean accept(File file) {
                String string = file.getName().toLowerCase();
                return string.endsWith(".jar") || string.endsWith(".zip") || file.isDirectory();
            }

            public String getDescription() {
                return ClasspathPanel.this.resourceRepository().getString(".jar.zip");
            }
        };
    }

    private File getDefaultClasspathDirectory() {
        return this.defaultClasspathDirectoryHolder.getDefaultClasspathDirectory();
    }

    public void setDefaultClasspathDirectoryHolder(DefaultClasspathDirectoryHolder defaultClasspathDirectoryHolder) {
        this.defaultClasspathDirectoryHolder = defaultClasspathDirectoryHolder;
    }

    public static interface DefaultClasspathDirectoryHolder {
        public static final DefaultClasspathDirectoryHolder NULL_INSTANCE = new DefaultClasspathDirectoryHolder(){

            public File getDefaultClasspathDirectory() {
                return null;
            }

            public void setDefaultClasspathDirectory(File file) {
            }

            public String toString() {
                return "NullDefaultClasspathDirectoryHolder";
            }
        };

        public File getDefaultClasspathDirectory();

        public void setDefaultClasspathDirectory(File var1);
    }

    private class ExpandPathRunner
    implements Runnable {
        private final JTree classpathTree;
        private final Object rootNode;

        ExpandPathRunner(JTree jTree, Object object) {
            this.classpathTree = jTree;
            this.rootNode = object;
        }

        public void run() {
            TreePath treePath = new TreePath(this.rootNode);
            if (!this.classpathTree.isExpanded(treePath)) {
                this.classpathTree.expandPath(treePath);
            }
        }
    }
}

