/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin;

import java.awt.EventQueue;
import java.awt.Frame;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Set;
import javax.swing.Action;
import javax.swing.JOptionPane;
import org.eclipse.persistence.tools.workbench.framework.action.AbstractFrameworkAction;
import org.eclipse.persistence.tools.workbench.framework.app.ApplicationNode;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.resources.ResourceRepository;
import org.eclipse.persistence.tools.workbench.framework.ui.chooser.MultipleClassChooserDialog;
import org.eclipse.persistence.tools.workbench.framework.ui.dialog.WaitDialog;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.DescriptorCreationFailureContainer;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.DescriptorCreationFailureListener;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.ExternalClassLoadFailureContainer;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClassRepository;
import org.eclipse.persistence.tools.workbench.mappingsmodel.project.MWProject;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.common.StatusDialog;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.common.cell.ProjectCellRendererAdapter;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor.DescriptorCreationFailuresDialog;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.meta.ExternalClassDescriptionClassDesciptionAdapter;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.meta.ExternalClassDescriptionClassDescriptionRepository;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.meta.ExternalClassLoadFailuresDialog;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.project.ProjectNode;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.project.UiProjectBundle;
import org.eclipse.persistence.tools.workbench.uitools.cell.CellRendererAdapter;
import org.eclipse.persistence.tools.workbench.utility.Classpath;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;

public final class AddOrRefreshClassesAction
extends AbstractFrameworkAction {
    public static final String EJB_JAR_XML_EXCEPTION_ERROR = "EJB_JAR_XML_EXCEPTION_ERROR";
    public static final String EJB_JAR_XML_PROJECT_NOT_UPDATED_ERROR = "EJB_JAR_XML_PROJECT_NOT_UPDATED_ERROR";
    public static final String INVALID_DOC_TYPE_ERROR = "INVALID_DOC_TYPE_ERROR";

    AddOrRefreshClassesAction(WorkbenchContext workbenchContext) {
        super(workbenchContext.buildExpandedResourceRepositoryContext(UiProjectBundle.class));
    }

    protected void initialize() {
        super.initialize();
        this.initializeIcon("descriptor.refresh");
        this.initializeTextAndMnemonic("ADD_OR_REFRESH_CLASSES_ACTION");
        this.initializeToolTipText("ADD_OR_REFRESH_CLASSES_ACTION.toolTipText");
        this.initializeAccelerator("ADD_OR_REFRESH_CLASSES_ACTION.accelerator");
    }

    protected void execute() {
        ApplicationNode[] applicationNodeArray = this.selectedProjectNodes();
        for (int i = 0; i < applicationNodeArray.length; ++i) {
            this.execute((ProjectNode)applicationNodeArray[i]);
        }
    }

    protected void execute(ProjectNode projectNode) {
        MWProject mWProject = projectNode.getProject();
        MultipleClassChooserDialog multipleClassChooserDialog = this.buildDialog(mWProject.getRepository());
        multipleClassChooserDialog.show();
        if (multipleClassChooserDialog.wasConfirmed()) {
            this.startClassImporter(mWProject, CollectionTools.collection((Iterator)multipleClassChooserDialog.selectedClassDescriptions()));
        }
        multipleClassChooserDialog = null;
        MultipleClassChooserDialog.gc();
    }

    private MultipleClassChooserDialog buildDialog(MWClassRepository mWClassRepository) {
        return new MultipleClassChooserDialog(this.getWorkbenchContext(), new LocalClassDescriptionRepository(mWClassRepository), ExternalClassDescriptionClassDesciptionAdapter.instance());
    }

    private void startClassImporter(MWProject mWProject, Collection collection) {
        Thread thread = new Thread((Runnable)new ClassImporter(mWProject, collection), "Class Import");
        thread.setPriority(5);
        thread.start();
    }

    private class LocalStatusDialog
    extends StatusDialog {
        private LocalStatusDialog(Collection collection) {
            super(AddOrRefreshClassesAction.this.getWorkbenchContext(), collection, "PROJECT_EJB_UPDATE_STATUS_DIALOG_TITLE", "PROJECT_UPDATE_STATUS_DIALOG_MESSAGE", "project.export.ejb-jar.xml");
        }

        protected Action buildOKAction() {
            Action action = super.buildOKAction();
            action.putValue("Name", this.resourceRepository().getString("EJB_JAR_XML_VALIDATOR_STATUS_DIALOG_YES_BUTTON"));
            action.putValue("MnemonicKey", new Integer(this.resourceRepository().getMnemonic("EJB_JAR_XML_VALIDATOR_STATUS_DIALOG_YES_BUTTON")));
            return action;
        }

        protected Action buildCancelAction() {
            Action action = super.buildCancelAction();
            action.putValue("Name", this.resourceRepository().getString("EJB_JAR_XML_VALIDATOR_STATUS_DIALOG_NO_BUTTON"));
            action.putValue("MnemonicKey", new Integer(this.resourceRepository().getMnemonic("EJB_JAR_XML_VALIDATOR_STATUS_DIALOG_NO_BUTTON")));
            return action;
        }

        protected boolean cancelButtonIsVisible() {
            return true;
        }

        protected CellRendererAdapter buildNodeRenderer(Object object) {
            if (object instanceof MWProject) {
                return new ProjectCellRendererAdapter(this.resourceRepository());
            }
            return super.buildNodeRenderer(object);
        }
    }

    private class ClassImporter
    implements Runnable {
        private MWProject project;
        private Collection selectedClassDescriptions;

        ClassImporter(MWProject mWProject, Collection collection) {
            this.project = mWProject;
            this.selectedClassDescriptions = collection;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            ExternalClassLoadFailureContainer externalClassLoadFailureContainer;
            WaitDialog waitDialog = this.buildWaitDialog();
            AbstractFrameworkAction.launchLater(waitDialog);
            DescriptorCreationFailureContainer descriptorCreationFailureContainer = new DescriptorCreationFailureContainer();
            this.project.getValidator().pause();
            try {
                externalClassLoadFailureContainer = this.project.addDescriptorsForExternalClassDescriptions(this.selectedClassDescriptions.iterator(), (DescriptorCreationFailureListener)descriptorCreationFailureContainer);
            }
            finally {
                this.project.getValidator().resume();
                waitDialog.dispose();
            }
            if (externalClassLoadFailureContainer.containsFailures()) {
                AbstractFrameworkAction.launchAndWait(new ExternalClassLoadFailuresDialog(this.workbenchContext(), externalClassLoadFailureContainer));
            }
            if (descriptorCreationFailureContainer.containsFailures()) {
                AbstractFrameworkAction.launchAndWait(new DescriptorCreationFailuresDialog(descriptorCreationFailureContainer, this.workbenchContext()));
            }
        }

        private WaitDialog buildWaitDialog() {
            return new WaitDialog((Frame)this.workbenchContext().getCurrentWindow(), this.resourceRepository().getIcon("class.default"), this.resourceRepository().getString("CLASS_IMPORT_WAIT_DIALOG.TITLE"), this.resourceRepository().getString("CLASS_IMPORT_WAIT_MESSAGE"));
        }

        private boolean promptUserToUpdateProjectFromEjbJarXml() {
            class Prompt
            implements Runnable {
                int option = 0;

                Prompt() {
                }

                public void run() {
                    this.option = JOptionPane.showConfirmDialog(ClassImporter.this.workbenchContext().getCurrentWindow(), ClassImporter.this.resourceRepository().getString("UPDATE_PROJECT_FROM_EJB_JAR"), ClassImporter.this.resourceRepository().getString("UPDATE_PROJECT_FROM_EJB_JAR.title"), 0);
                }
            }
            Prompt prompt = new Prompt();
            try {
                EventQueue.invokeAndWait(prompt);
            }
            catch (Throwable throwable) {
                throw new RuntimeException(throwable);
            }
            return prompt.option == 0;
        }

        private boolean canReadWithProblems(LinkedHashMap linkedHashMap) {
            StatusDialog.Status status = StatusDialog.createStatus((Object)this.project, linkedHashMap);
            LocalStatusDialog localStatusDialog = new LocalStatusDialog(Collections.singleton(status));
            AbstractFrameworkAction.launchAndWait(localStatusDialog);
            return localStatusDialog.wasConfirmed();
        }

        private void showEJBResult(Collection collection) {
            if (collection.isEmpty()) {
                return;
            }
            StatusDialog statusDialog = new StatusDialog(this.workbenchContext(), collection, "PROJECT_EJB_UPDATE_STATUS_DIALOG_TITLE", "PROJECT_EJB_UPDATE_STATUS_DIALOG_MESSAGE", "project.export.ejb-jar.xml"){

                protected CellRendererAdapter buildNodeRenderer(Object object) {
                    if (object instanceof MWProject) {
                        return new ProjectCellRendererAdapter(ClassImporter.this.resourceRepository());
                    }
                    return super.buildNodeRenderer(object);
                }
            };
            AbstractFrameworkAction.launchAndWait(statusDialog);
        }

        WorkbenchContext workbenchContext() {
            return AddOrRefreshClassesAction.this.getWorkbenchContext();
        }

        ResourceRepository resourceRepository() {
            return AddOrRefreshClassesAction.this.resourceRepository();
        }
    }

    private class LocalClassDescriptionRepository
    extends ExternalClassDescriptionClassDescriptionRepository {
        Set userClassNames;

        LocalClassDescriptionRepository(MWClassRepository mWClassRepository) {
            super(mWClassRepository);
            Classpath classpath = new Classpath(CollectionTools.list((Iterator)mWClassRepository.fullyQualifiedClasspathEntries()));
            this.userClassNames = new HashSet(1000);
            classpath.addClassNamesTo((Collection)this.userClassNames);
        }

        protected boolean accept(String string) {
            return super.accept(string) && this.userClassNames.contains(string);
        }
    }
}

