/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.Document;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.ui.dialog.AbstractDialog;
import org.eclipse.persistence.tools.workbench.framework.uitools.RegexpDocument;
import org.eclipse.persistence.tools.workbench.framework.uitools.SwingComponentFactory;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.SimplePropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.DocumentAdapter;
import org.eclipse.persistence.tools.workbench.utility.io.FileTools;

public final class JaxbProjectCreationDialog
extends AbstractDialog {
    private PropertyValueModel inputSchemaFileValue;
    private PropertyValueModel inputCustomizationFileValue;
    private PropertyValueModel outputMasterDirectoryValue;
    private PropertyValueModel outputSourceDirectoryValue;
    private PropertyValueModel outputWorkbenchProjectDirectoryValue;
    private PropertyValueModel outputInterfacePackageNameValue;
    private PropertyValueModel outputImplClassPackageNameValue;

    JaxbProjectCreationDialog(WorkbenchContext workbenchContext) {
        super(workbenchContext);
    }

    protected void initialize() {
        super.initialize();
        this.inputSchemaFileValue = this.buildInputSchemaFileValue();
        this.inputCustomizationFileValue = this.buildInputCustomizationFileValue();
        this.outputMasterDirectoryValue = this.buildOutputMasterDirectoryValue();
        this.outputSourceDirectoryValue = this.buildOutputSourceDirectoryValue();
        this.outputWorkbenchProjectDirectoryValue = this.buildOutputWorkbenchProjectDirectoryValue();
        this.outputInterfacePackageNameValue = this.buildOutputInterfacePackageNameValue();
        this.outputImplClassPackageNameValue = this.buildOutputImplClassPackageNameValue();
        this.getOKAction().setEnabled(false);
    }

    private PropertyValueModel buildInputSchemaFileValue() {
        SimplePropertyValueModel simplePropertyValueModel = new SimplePropertyValueModel("");
        simplePropertyValueModel.addPropertyChangeListener("value", this.buildGeneralSettingChangeListener());
        return simplePropertyValueModel;
    }

    private PropertyValueModel buildInputCustomizationFileValue() {
        return new SimplePropertyValueModel("");
    }

    private PropertyValueModel buildOutputMasterDirectoryValue() {
        SimplePropertyValueModel simplePropertyValueModel = new SimplePropertyValueModel("");
        simplePropertyValueModel.addPropertyChangeListener("value", this.buildGeneralSettingChangeListener());
        return simplePropertyValueModel;
    }

    private PropertyValueModel buildOutputSourceDirectoryValue() {
        SimplePropertyValueModel simplePropertyValueModel = new SimplePropertyValueModel("." + File.separator + "source");
        simplePropertyValueModel.addPropertyChangeListener("value", this.buildGeneralSettingChangeListener());
        return simplePropertyValueModel;
    }

    private PropertyValueModel buildOutputWorkbenchProjectDirectoryValue() {
        SimplePropertyValueModel simplePropertyValueModel = new SimplePropertyValueModel("." + File.separator + "mw");
        simplePropertyValueModel.addPropertyChangeListener("value", this.buildGeneralSettingChangeListener());
        return simplePropertyValueModel;
    }

    private PropertyValueModel buildOutputInterfacePackageNameValue() {
        SimplePropertyValueModel simplePropertyValueModel = new SimplePropertyValueModel("");
        return simplePropertyValueModel;
    }

    private PropertyValueModel buildOutputImplClassPackageNameValue() {
        SimplePropertyValueModel simplePropertyValueModel = new SimplePropertyValueModel("");
        this.outputInterfacePackageNameValue.addPropertyChangeListener("value", this.buildInterfacePackageNameListener());
        return simplePropertyValueModel;
    }

    private PropertyChangeListener buildInterfacePackageNameListener() {
        return new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                String string = (String)propertyChangeEvent.getOldValue();
                String string2 = (String)propertyChangeEvent.getNewValue();
                String string3 = JaxbProjectCreationDialog.this.getOutputImplClassPackageName();
                if (string3.equals(string)) {
                    JaxbProjectCreationDialog.this.outputImplClassPackageNameValue.setValue(string2);
                }
            }
        };
    }

    private PropertyChangeListener buildGeneralSettingChangeListener() {
        return new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                JaxbProjectCreationDialog.this.updateOKAction();
            }
        };
    }

    protected String helpTopicId() {
        return "dialog.newJaxbProjectDialog";
    }

    protected Component buildMainPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setTitle(this.resourceRepository().getString("JAXB_PROJECT_DIALOG_TITLE"));
        JPanel jPanel2 = this.buildFromPanel();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel.add((Component)jPanel2, gridBagConstraints);
        JPanel jPanel3 = this.buildToPanel();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 19;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        jPanel.add((Component)jPanel3, gridBagConstraints);
        return jPanel;
    }

    private JPanel buildFromPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(this.resourceRepository().getString("FROM")), BorderFactory.createEmptyBorder(0, 5, 5, 5)));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JLabel jLabel = this.buildInputSchemaFileLabel();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel.add((Component)jLabel, gridBagConstraints);
        JTextField jTextField = this.buildInputSchemaFileTextField();
        jLabel.setLabelFor(jTextField);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel.add((Component)jTextField, gridBagConstraints);
        JButton jButton = this.buildInputSchemaFileButton();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 22;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        jPanel.add((Component)jButton, gridBagConstraints);
        JLabel jLabel2 = this.buildInputCustomizationFileLabel();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        jPanel.add((Component)jLabel2, gridBagConstraints);
        JTextField jTextField2 = this.buildInputCustomizationFileTextField();
        jLabel2.setLabelFor(jTextField2);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(1, 0, 0, 0);
        jPanel.add((Component)jTextField2, gridBagConstraints);
        JButton jButton2 = this.buildInputCustomizationFileButton();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(1, 5, 0, 0);
        jPanel.add((Component)jButton2, gridBagConstraints);
        this.helpManager().addTopicID(jPanel, this.helpTopicId() + ".From");
        return jPanel;
    }

    private JLabel buildInputSchemaFileLabel() {
        JLabel jLabel = SwingComponentFactory.buildLabel("INPUT_SCHEMA_FILE_LABEL", this.resourceRepository());
        this.helpManager().addTopicID(jLabel, this.helpTopicId() + ".inputSchema");
        return jLabel;
    }

    private JTextField buildInputSchemaFileTextField() {
        JTextField jTextField = new JTextField(60);
        jTextField.setDocument(this.buildInputSchemaFileDocument());
        this.helpManager().addTopicID(jTextField, this.helpTopicId() + ".inputSchema");
        return jTextField;
    }

    private Document buildInputSchemaFileDocument() {
        return new DocumentAdapter(this.inputSchemaFileValue);
    }

    private JButton buildInputSchemaFileButton() {
        JButton jButton = SwingComponentFactory.buildButton("BROWSE_BUTTON_1", this.resourceRepository());
        jButton.addActionListener(this.buildFileBrowseAction(this.inputSchemaFileValue, this.buildXsdFileFilter()));
        this.helpManager().addTopicID(jButton, this.helpTopicId() + ".inputSchema");
        return jButton;
    }

    private FileFilter buildXsdFileFilter() {
        return new FileFilter(){

            public boolean accept(File file) {
                return file.isDirectory() || this.validSchemaExtension(file);
            }

            public String getDescription() {
                return JaxbProjectCreationDialog.this.resourceRepository().getString("XSD_FILE_FILTER");
            }

            private boolean validSchemaExtension(File file) {
                return FileTools.extension((File)file).equalsIgnoreCase(".xsd");
            }
        };
    }

    private JLabel buildInputCustomizationFileLabel() {
        JLabel jLabel = SwingComponentFactory.buildLabel("INPUT_CUSTOMIZATION_FILE_LABEL", this.resourceRepository());
        this.helpManager().addTopicID(jLabel, this.helpTopicId() + ".customizationFile");
        return jLabel;
    }

    private JTextField buildInputCustomizationFileTextField() {
        JTextField jTextField = new JTextField(60);
        jTextField.setDocument(this.buildInputCustomizationFileDocument());
        this.helpManager().addTopicID(jTextField, this.helpTopicId() + ".customizationFile");
        return jTextField;
    }

    private Document buildInputCustomizationFileDocument() {
        return new DocumentAdapter(this.inputCustomizationFileValue);
    }

    private JButton buildInputCustomizationFileButton() {
        JButton jButton = SwingComponentFactory.buildButton("BROWSE_BUTTON_2", this.resourceRepository());
        jButton.addActionListener(this.buildFileBrowseAction(this.inputCustomizationFileValue, this.buildXmlFileFilter()));
        this.helpManager().addTopicID(jButton, this.helpTopicId() + ".customizationFile");
        return jButton;
    }

    private FileFilter buildXmlFileFilter() {
        return new FileFilter(){

            public boolean accept(File file) {
                return file.isDirectory() || this.validXmlExtension(file);
            }

            public String getDescription() {
                return JaxbProjectCreationDialog.this.resourceRepository().getString("XML_FILE_FILTER");
            }

            private boolean validXmlExtension(File file) {
                return FileTools.extension((File)file).equalsIgnoreCase(".xml");
            }
        };
    }

    protected ActionListener buildFileBrowseAction(final PropertyValueModel propertyValueModel, final FileFilter fileFilter) {
        return new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JFileChooser jFileChooser = new JFileChooser();
                jFileChooser.setFileFilter(fileFilter);
                jFileChooser.setFileSelectionMode(0);
                jFileChooser.setDialogTitle(JaxbProjectCreationDialog.this.resourceRepository().getString("JAXB_FILE_CHOOSER_TITLE"));
                int n = jFileChooser.showDialog(JaxbProjectCreationDialog.this.getWorkbenchContext().getCurrentWindow(), JaxbProjectCreationDialog.this.resourceRepository().getString("SELECT"));
                if (n != 0) {
                    return;
                }
                propertyValueModel.setValue(jFileChooser.getSelectedFile().getAbsolutePath());
            }
        };
    }

    private JPanel buildToPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(this.resourceRepository().getString("TO")), BorderFactory.createEmptyBorder(0, 5, 5, 5)));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JLabel jLabel = this.buildOutputMasterDirectoryLabel();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel.add((Component)jLabel, gridBagConstraints);
        JTextField jTextField = this.buildOutputMasterDirectoryTextField();
        jLabel.setLabelFor(jTextField);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel.add((Component)jTextField, gridBagConstraints);
        JButton jButton = this.buildOutputMasterDirectoryButton();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 22;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        jPanel.add((Component)jButton, gridBagConstraints);
        JLabel jLabel2 = this.buildOutputSourceDirectoryLabel();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(5, 25, 0, 0);
        jPanel.add((Component)jLabel2, gridBagConstraints);
        JTextField jTextField2 = this.buildOutputSourceDirectoryTextField();
        jLabel2.setLabelFor(jTextField2);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(0, 25, 0, 0);
        jPanel.add((Component)jTextField2, gridBagConstraints);
        JButton jButton2 = this.buildOutputSourceDirectoryButton();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 22;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        jPanel.add((Component)jButton2, gridBagConstraints);
        JLabel jLabel3 = this.buildOutputWorkbenchProjectDirectoryLabel();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(5, 25, 0, 0);
        jPanel.add((Component)jLabel3, gridBagConstraints);
        JTextField jTextField3 = this.buildOutputWorkbenchProjectDirectoryTextField();
        jLabel3.setLabelFor(jTextField3);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(0, 25, 0, 0);
        jPanel.add((Component)jTextField3, gridBagConstraints);
        JButton jButton3 = this.buildOutputWorkbenchProjectDirectoryButton();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 22;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        jPanel.add((Component)jButton3, gridBagConstraints);
        JLabel jLabel4 = this.buildOutputInterfacePackageNameLabel();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(15, 0, 0, 0);
        jPanel.add((Component)jLabel4, gridBagConstraints);
        JTextField jTextField4 = this.buildOutputInterfacePackageNameTextField();
        jLabel4.setLabelFor(jTextField4);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(1, 0, 0, 0);
        jPanel.add((Component)jTextField4, gridBagConstraints);
        JLabel jLabel5 = this.buildOutputImplClassPackageNameLabel();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        jPanel.add((Component)jLabel5, gridBagConstraints);
        JTextField jTextField5 = this.buildOutputImplClassPackageNameTextField();
        jLabel5.setLabelFor(jTextField5);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(1, 0, 0, 0);
        jPanel.add((Component)jTextField5, gridBagConstraints);
        this.helpManager().addTopicID(jPanel, this.helpTopicId() + ".To");
        return jPanel;
    }

    private JLabel buildOutputMasterDirectoryLabel() {
        JLabel jLabel = SwingComponentFactory.buildLabel("OUTPUT_MASTER_DIRECTORY_LABEL", this.resourceRepository());
        this.helpManager().addTopicID(jLabel, this.helpTopicId() + ".outputDirectory");
        return jLabel;
    }

    private JTextField buildOutputMasterDirectoryTextField() {
        JTextField jTextField = new JTextField(60);
        jTextField.setDocument(this.buildOutputMasterDirectoryDocument());
        this.helpManager().addTopicID(jTextField, this.helpTopicId() + ".outputDirectory");
        return jTextField;
    }

    private Document buildOutputMasterDirectoryDocument() {
        return new DocumentAdapter(this.outputMasterDirectoryValue);
    }

    private JButton buildOutputMasterDirectoryButton() {
        JButton jButton = SwingComponentFactory.buildButton("BROWSE_BUTTON_3", this.resourceRepository());
        jButton.addActionListener(this.buildDirectoryBrowseAction(this.outputMasterDirectoryValue));
        this.helpManager().addTopicID(jButton, this.helpTopicId() + ".outputDirectory");
        return jButton;
    }

    private JLabel buildOutputSourceDirectoryLabel() {
        JLabel jLabel = SwingComponentFactory.buildLabel("OUTPUT_SOURCE_DIRECTORY_LABEL", this.resourceRepository());
        this.helpManager().addTopicID(jLabel, this.helpTopicId() + ".outputSourceDirectory");
        return jLabel;
    }

    private JTextField buildOutputSourceDirectoryTextField() {
        JTextField jTextField = new JTextField(60);
        jTextField.setDocument(this.buildOutputSourceDirectoryDocument());
        this.helpManager().addTopicID(jTextField, this.helpTopicId() + ".outputSourceDirectory");
        return jTextField;
    }

    private Document buildOutputSourceDirectoryDocument() {
        return new DocumentAdapter(this.outputSourceDirectoryValue);
    }

    private JButton buildOutputSourceDirectoryButton() {
        JButton jButton = SwingComponentFactory.buildButton("BROWSE_BUTTON_4", this.resourceRepository());
        jButton.addActionListener(this.buildDirectoryBrowseAction(this.outputSourceDirectoryValue));
        this.helpManager().addTopicID(jButton, this.helpTopicId() + ".outputSourceDirectory");
        return jButton;
    }

    private JLabel buildOutputWorkbenchProjectDirectoryLabel() {
        JLabel jLabel = SwingComponentFactory.buildLabel("OUTPUT_WORKBENCH_PROJECT_DIRECTORY_LABEL", this.resourceRepository());
        this.helpManager().addTopicID(jLabel, this.helpTopicId() + ".outputWorkbenchProjectDirectory");
        return jLabel;
    }

    private JTextField buildOutputWorkbenchProjectDirectoryTextField() {
        JTextField jTextField = new JTextField(60);
        jTextField.setDocument(this.buildOutputWorkbenchProjectDirectoryDocument());
        this.helpManager().addTopicID(jTextField, this.helpTopicId() + ".outputWorkbenchProjectDirectory");
        return jTextField;
    }

    private Document buildOutputWorkbenchProjectDirectoryDocument() {
        return new DocumentAdapter(this.outputWorkbenchProjectDirectoryValue);
    }

    private JButton buildOutputWorkbenchProjectDirectoryButton() {
        JButton jButton = SwingComponentFactory.buildButton("BROWSE_BUTTON_6", this.resourceRepository());
        jButton.addActionListener(this.buildDirectoryBrowseAction(this.outputWorkbenchProjectDirectoryValue));
        this.helpManager().addTopicID(jButton, this.helpTopicId() + ".outputWorkbenchProjectDirectory");
        return jButton;
    }

    private JLabel buildOutputInterfacePackageNameLabel() {
        JLabel jLabel = SwingComponentFactory.buildLabel("OUTPUT_INTERFACE_PACKAGE_NAME_LABEL", this.resourceRepository());
        this.helpManager().addTopicID(jLabel, this.helpTopicId() + ".interfacePackageName");
        return jLabel;
    }

    private JTextField buildOutputInterfacePackageNameTextField() {
        JTextField jTextField = new JTextField(60);
        jTextField.setDocument(this.buildOutputInterfacePackageNameDocument());
        this.helpManager().addTopicID(jTextField, this.helpTopicId() + ".interfacePackageName");
        return jTextField;
    }

    private Document buildOutputInterfacePackageNameDocument() {
        return new DocumentAdapter(this.outputInterfacePackageNameValue, new RegexpDocument(1));
    }

    private JLabel buildOutputImplClassPackageNameLabel() {
        JLabel jLabel = SwingComponentFactory.buildLabel("OUTPUT_IMPL_CLASS_PACKAGE_NAME_LABEL", this.resourceRepository());
        this.helpManager().addTopicID(jLabel, this.helpTopicId() + ".implClassPackageName");
        return jLabel;
    }

    private JTextField buildOutputImplClassPackageNameTextField() {
        JTextField jTextField = new JTextField(60);
        jTextField.setDocument(this.buildOutputImplClassPackageNameDocument());
        this.helpManager().addTopicID(jTextField, this.helpTopicId() + ".implClassPackageName");
        return jTextField;
    }

    private Document buildOutputImplClassPackageNameDocument() {
        return new DocumentAdapter(this.outputImplClassPackageNameValue, new RegexpDocument(1));
    }

    private ActionListener buildDirectoryBrowseAction(final PropertyValueModel propertyValueModel) {
        return new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JFileChooser jFileChooser = new JFileChooser();
                jFileChooser.setFileSelectionMode(1);
                jFileChooser.setDialogTitle(JaxbProjectCreationDialog.this.resourceRepository().getString("JAXB_DIRECTORY_CHOOSER_TITLE"));
                int n = jFileChooser.showDialog(JaxbProjectCreationDialog.this.getWorkbenchContext().getCurrentWindow(), JaxbProjectCreationDialog.this.resourceRepository().getString("SELECT"));
                if (n != 0) {
                    return;
                }
                propertyValueModel.setValue(jFileChooser.getSelectedFile().getAbsolutePath());
            }
        };
    }

    protected void updateOKAction() {
        boolean bl = this.getInputSchemaFile().length() > 0 && this.getOutputSourceDirectory().length() > 0 && this.getOutputWorkbenchProjectDirectory().length() > 0 && this.getOutputMasterDirectory().length() > 0;
        this.getOKAction().setEnabled(bl);
    }

    protected boolean preConfirm() {
        if (!new File(this.getInputSchemaFile()).exists()) {
            JOptionPane.showMessageDialog(this, this.resourceRepository().getString("SCHEMA_FILE_DOES_NOT_EXIST"), this.resourceRepository().getString("WARNING"), 0);
            return false;
        }
        String string = this.getInputCustomizationFile();
        if (string != "" && !new File(string).exists()) {
            JOptionPane.showMessageDialog(this, this.resourceRepository().getString("CUSTOMIZATION_FILE_DOES_NOT_EXIST"), this.resourceRepository().getString("WARNING"), 0);
            return false;
        }
        File file = new File(this.getAbsoluteOutputSourceDirectory());
        String string2 = null;
        try {
            string2 = file.getCanonicalPath();
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(this, this.resourceRepository().getString("OUTPUT_SOURCE_DIRECTORY_COULD_NOT_BE_RESOLVED"), this.resourceRepository().getString("WARNING"), 0);
            return false;
        }
        if (!file.isDirectory() && !file.mkdirs()) {
            JOptionPane.showMessageDialog(this, this.resourceRepository().getString("OUTPUT_SOURCE_DIRECTORY_COULD_NOT_BE_CREATED", string2), this.resourceRepository().getString("WARNING"), 0);
            return false;
        }
        File file2 = new File(this.getAbsoluteOutputWorkbenchProjectDirectory());
        String string3 = null;
        try {
            string3 = file2.getCanonicalPath();
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(this, this.resourceRepository().getString("OUTPUT_WORKBENCH_PROJECT_DIRECTORY_COULD_NOT_BE_RESOLVED"), this.resourceRepository().getString("WARNING"), 0);
            return false;
        }
        if (file2.isDirectory()) {
            if (this.directoryHasExistingWorkbenchProject(file2)) {
                JOptionPane.showMessageDialog(this, this.resourceRepository().getString("OUTPUT_WORKBENCH_PROJECT_DIRECTORY_INVALID", string3), this.resourceRepository().getString("WARNING"), 0);
                return false;
            }
        } else if (!file2.mkdirs()) {
            JOptionPane.showMessageDialog(this, this.resourceRepository().getString("OUTPUT_WORKBENCH_PROJECT_DIRECTORY_COULD_NOT_BE_CREATED", string3), this.resourceRepository().getString("WARNING"), 0);
            return false;
        }
        return true;
    }

    private boolean directoryHasExistingWorkbenchProject(File file) {
        File[] fileArray = file.listFiles();
        if (fileArray == null || fileArray.length == 0) {
            return false;
        }
        int n = fileArray.length;
        while (n-- > 0) {
            File file2 = fileArray[n];
            if (file2.isDirectory() || !".mwp".equals(FileTools.extension((String)file2.getName()))) continue;
            return true;
        }
        return false;
    }

    public String getInputSchemaFile() {
        return (String)this.inputSchemaFileValue.getValue();
    }

    public String getInputCustomizationFile() {
        return (String)this.inputCustomizationFileValue.getValue();
    }

    private String getOutputMasterDirectory() {
        return (String)this.outputMasterDirectoryValue.getValue();
    }

    private String getOutputSourceDirectory() {
        return (String)this.outputSourceDirectoryValue.getValue();
    }

    public String getAbsoluteOutputSourceDirectory() {
        return FileTools.convertToAbsoluteFile((File)new File(this.getOutputSourceDirectory()), (File)new File(this.getOutputMasterDirectory())).getPath();
    }

    private String getOutputWorkbenchProjectDirectory() {
        return (String)this.outputWorkbenchProjectDirectoryValue.getValue();
    }

    public String getAbsoluteOutputWorkbenchProjectDirectory() {
        return FileTools.convertToAbsoluteFile((File)new File(this.getOutputWorkbenchProjectDirectory()), (File)new File(this.getOutputMasterDirectory())).getPath();
    }

    public String getOutputInterfacePackageName() {
        return (String)this.outputInterfacePackageNameValue.getValue();
    }

    public String getOutputImplClassPackageName() {
        return (String)this.outputImplClassPackageNameValue.getValue();
    }
}

