/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.ui.dialog.AbstractDialog;
import org.eclipse.persistence.tools.workbench.uitools.LabelArea;

public final class LegacyProjectMigrationDialog
extends AbstractDialog {
    private boolean saveLater;

    LegacyProjectMigrationDialog(WorkbenchContext workbenchContext) {
        super(workbenchContext);
    }

    protected void initialize() {
        super.initialize();
        this.saveLater = false;
    }

    protected Component buildMainPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setTitle(this.resourceRepository().getString("PROJECT_LEGACY_MIGRATION_DIALOG_TITLE"));
        JLabel jLabel = new JLabel(this.resourceRepository().getIcon("warning.large"));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        jPanel.add((Component)jLabel, gridBagConstraints);
        LabelArea labelArea = new LabelArea(this.resourceRepository().getString("PROJECT_LEGACY_MIGRATION_DIALOG_WARNING"));
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.insets = new Insets(10, 10, 0, 10);
        jPanel.add((Component)labelArea, gridBagConstraints);
        return jPanel;
    }

    protected String helpTopicId() {
        return "dialog.projectLegacyMigration";
    }

    protected Component initialFocusComponent() {
        return this.getButtonFor(this.getOKAction());
    }

    protected Iterator buildCustomActions() {
        ArrayList<Action> arrayList = new ArrayList<Action>();
        arrayList.add(this.buildSaveLaterAction());
        return arrayList.iterator();
    }

    protected String buildOKText() {
        return this.resourceRepository().getString("PROJECT_LEGACY_MIGRATION_DIALOG_SAVE_NOW");
    }

    protected Action buildSaveLaterAction() {
        return new AbstractAction(this.buildSaveLaterText()){

            public void actionPerformed(ActionEvent actionEvent) {
                LegacyProjectMigrationDialog.this.saveLaterPressed();
            }
        };
    }

    protected String buildSaveLaterText() {
        return this.resourceRepository().getString("PROJECT_LEGACY_MIGRATION_DIALOG_SAVE_LATER");
    }

    protected void saveLaterPressed() {
        this.saveLater = true;
        this.dispose();
    }

    public boolean wasConfirmed() {
        return super.wasConfirmed() || this.saveLater;
    }

    public boolean saveLater() {
        return this.saveLater;
    }
}

