/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.ui.chooser.ClassDescriptionRepository;
import org.eclipse.persistence.tools.workbench.framework.ui.chooser.MultipleClassChooserDialog;
import org.eclipse.persistence.tools.workbench.framework.ui.dialog.AbstractDialog;
import org.eclipse.persistence.tools.workbench.framework.uitools.SwingComponentFactory;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.ExternalClassLoadFailureContainer;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClass;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClassRepository;
import org.eclipse.persistence.tools.workbench.mappingsmodel.project.MWProject;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.common.cell.ClassCellRendererAdapter;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.meta.ExternalClassDescriptionClassDesciptionAdapter;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.meta.ExternalClassDescriptionClassDescriptionRepository;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.meta.ExternalClassLoadFailuresDialog;
import org.eclipse.persistence.tools.workbench.uitools.LabelArea;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ObjectListSelectionModel;
import org.eclipse.persistence.tools.workbench.uitools.cell.AdaptableListCellRenderer;
import org.eclipse.persistence.tools.workbench.utility.Classpath;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.iterators.TransformationIterator;
import org.eclipse.persistence.tools.workbench.utility.string.StringTools;

public final class NonDescriptorClassManagementDialog
extends AbstractDialog {
    private MWProject project;
    private DefaultListModel classesListModel;
    ObjectListSelectionModel classesListSelectionModel;

    public NonDescriptorClassManagementDialog(WorkbenchContext workbenchContext, MWProject mWProject) {
        super(workbenchContext);
        this.project = mWProject;
        this.buildModels();
    }

    protected void initialize() {
        super.initialize();
        String string = "";
        if (System.getProperty("user.name", "").equalsIgnoreCase("dmahar")) {
            string = "Denise's ";
        }
        this.setTitle(this.resourceRepository().getString("NON_DESCRIPTOR_CLASS_MANAGEMENT_DIALOG.TITLE", string));
    }

    private void buildModels() {
        this.classesListModel = new DefaultListModel();
        this.rebuildClassesListModel();
        this.classesListSelectionModel = this.buildClassesListSelectionModel();
    }

    private void rebuildClassesListModel() {
        Set set = CollectionTools.set((Iterator)this.descriptorClasses());
        ArrayList arrayList = new ArrayList(this.project.getClassRepository().userTypesSize());
        Iterator iterator = this.project.getClassRepository().userTypes();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (set.contains(e)) continue;
            arrayList.add(e);
        }
        Collections.sort(arrayList);
        this.classesListModel.clear();
        iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            this.classesListModel.addElement(iterator.next());
        }
    }

    private ObjectListSelectionModel buildClassesListSelectionModel() {
        return new ObjectListSelectionModel(this.classesListModel);
    }

    protected Component buildMainPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        LabelArea labelArea = new LabelArea();
        labelArea.setText(this.resourceRepository().getString("NON_DESCRIPTOR_CLASS_MANAGEMENT_DIALOG.EXPLANATION", StringTools.CR));
        labelArea.setBorder(BorderFactory.createEmptyBorder(3, 3, 5, 3));
        jPanel.add((Component)labelArea, "North");
        JList jList = SwingComponentFactory.buildList(this.classesListModel);
        jList.setSelectionModel(this.classesListSelectionModel);
        jList.setCellRenderer(this.buildCellRenderer());
        JScrollPane jScrollPane = new JScrollPane(jList);
        jScrollPane.setPreferredSize(new Dimension(500, 400));
        jPanel.add((Component)jScrollPane, "Center");
        return jPanel;
    }

    private ListCellRenderer buildCellRenderer() {
        ClassCellRendererAdapter classCellRendererAdapter = new ClassCellRendererAdapter(this.resourceRepository()){

            public boolean showDetailedIcon() {
                return false;
            }
        };
        return new AdaptableListCellRenderer(classCellRendererAdapter);
    }

    protected Iterator buildCustomActions() {
        ArrayList<Action> arrayList = new ArrayList<Action>();
        arrayList.add(this.buildAddAction());
        arrayList.add(this.buildRemoveAction());
        arrayList.add(this.buildRefreshAction());
        return arrayList.iterator();
    }

    private Action buildAddAction() {
        return new AbstractAction(this.resourceRepository().getString("NON_DESCRIPTOR_CLASS_MANAGEMENT_DIALOG.ADD_ACTION")){

            public void actionPerformed(ActionEvent actionEvent) {
                NonDescriptorClassManagementDialog.this.addClasses();
            }
        };
    }

    void addClasses() {
        this.repository().refreshExternalClassDescriptions();
        MultipleClassChooserDialog multipleClassChooserDialog = new MultipleClassChooserDialog(this.getWorkbenchContext(), this.buildMultiClassChooserDialogClassDescriptionRepository(), ExternalClassDescriptionClassDesciptionAdapter.instance(), this);
        multipleClassChooserDialog.show();
        if (multipleClassChooserDialog.wasCanceled()) {
            multipleClassChooserDialog = null;
            MultipleClassChooserDialog.gc();
            return;
        }
        ExternalClassLoadFailureContainer externalClassLoadFailureContainer = this.repository().refreshTypesFor(multipleClassChooserDialog.selectedClassDescriptions());
        multipleClassChooserDialog = null;
        MultipleClassChooserDialog.gc();
        if (externalClassLoadFailureContainer.containsFailures()) {
            new ExternalClassLoadFailuresDialog(this.getWorkbenchContext(), this, externalClassLoadFailureContainer).show();
        }
        this.rebuildClassesListModel();
    }

    private ClassDescriptionRepository buildMultiClassChooserDialogClassDescriptionRepository() {
        return new NonDescriptorExternalClassDescriptionClassDescriptionRepository(this.project.getClassRepository());
    }

    private Action buildRemoveAction() {
        final AbstractAction abstractAction = new AbstractAction(this.resourceRepository().getString("NON_DESCRIPTOR_CLASS_MANAGEMENT_DIALOG.REMOVE_ACTION")){

            public void actionPerformed(ActionEvent actionEvent) {
                NonDescriptorClassManagementDialog.this.removeSelectedClasses();
            }
        };
        abstractAction.setEnabled(false);
        this.classesListSelectionModel.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!listSelectionEvent.getValueIsAdjusting()) {
                    abstractAction.setEnabled(!NonDescriptorClassManagementDialog.this.classesListSelectionModel.isSelectionEmpty());
                }
            }
        });
        return abstractAction;
    }

    void removeSelectedClasses() {
        Iterator iterator = CollectionTools.iterator((Object[])this.classesListSelectionModel.getSelectedValues());
        while (iterator.hasNext()) {
            MWClass mWClass = (MWClass)iterator.next();
            this.classesListModel.removeElement(mWClass);
            mWClass.clear();
        }
    }

    private Action buildRefreshAction() {
        final AbstractAction abstractAction = new AbstractAction(this.resourceRepository().getString("NON_DESCRIPTOR_CLASS_MANAGEMENT_DIALOG.REFRESH_ACTION")){

            public void actionPerformed(ActionEvent actionEvent) {
                NonDescriptorClassManagementDialog.this.refreshSelectedClasses();
            }
        };
        abstractAction.setEnabled(false);
        this.classesListSelectionModel.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!listSelectionEvent.getValueIsAdjusting()) {
                    abstractAction.setEnabled(!NonDescriptorClassManagementDialog.this.classesListSelectionModel.isSelectionEmpty());
                }
            }
        });
        return abstractAction;
    }

    void refreshSelectedClasses() {
        this.repository().refreshExternalClassDescriptions();
        ExternalClassLoadFailureContainer externalClassLoadFailureContainer = this.repository().refreshTypes(CollectionTools.iterator((Object[])this.classesListSelectionModel.getSelectedValues()));
        if (externalClassLoadFailureContainer.containsFailures()) {
            new ExternalClassLoadFailuresDialog(this.getWorkbenchContext(), this, externalClassLoadFailureContainer).show();
        }
    }

    private MWClassRepository repository() {
        return this.project.getClassRepository();
    }

    Iterator descriptorClasses() {
        return new TransformationIterator(this.project.descriptors()){

            protected Object transform(Object object) {
                return ((MWDescriptor)object).getMWClass();
            }
        };
    }

    protected boolean cancelButtonIsVisible() {
        return false;
    }

    protected String helpTopicId() {
        return "dialog.nonDescriptorManagement";
    }

    private class NonDescriptorExternalClassDescriptionClassDescriptionRepository
    extends ExternalClassDescriptionClassDescriptionRepository {
        Collection descriptorClassNames;
        Collection userClassNames;

        private NonDescriptorExternalClassDescriptionClassDescriptionRepository(MWClassRepository mWClassRepository) {
            super(mWClassRepository);
            this.descriptorClassNames = this.buildDescriptorClassNames();
            this.userClassNames = this.buildUserClassNames();
        }

        private Collection buildDescriptorClassNames() {
            return CollectionTools.set((Iterator)this.allDescriptorClassNames());
        }

        private Iterator allDescriptorClassNames() {
            return new TransformationIterator(NonDescriptorClassManagementDialog.this.descriptorClasses()){

                protected Object transform(Object object) {
                    return ((MWClass)object).getName();
                }
            };
        }

        private Collection buildUserClassNames() {
            Classpath classpath = new Classpath(CollectionTools.list((Iterator)this.repository.fullyQualifiedClasspathEntries()));
            HashSet hashSet = new HashSet(1000);
            classpath.addClassNamesTo(hashSet);
            return hashSet;
        }

        protected boolean accept(String string) {
            return super.accept(string) && this.userClassNames.contains(string) && !this.descriptorClassNames.contains(string);
        }
    }
}

