/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.io.IOException;
import java.util.prefs.Preferences;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.resources.ResourceRepository;
import org.eclipse.persistence.tools.workbench.framework.ui.dialog.AbstractDialog;
import org.eclipse.persistence.tools.workbench.framework.uitools.FileChooser;
import org.eclipse.persistence.tools.workbench.framework.uitools.RegexpDocument;
import org.eclipse.persistence.tools.workbench.mappingsmodel.project.MWProject;
import org.eclipse.persistence.tools.workbench.mappingsplugin.MappingsPlugin;
import org.eclipse.persistence.tools.workbench.uitools.CancelException;
import org.eclipse.persistence.tools.workbench.uitools.LabelArea;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.SimplePropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.DocumentAdapter;
import org.eclipse.persistence.tools.workbench.utility.string.StringTools;

public final class ProjectSourceGenerationCoordinator {
    private WorkbenchContext context;

    ProjectSourceGenerationCoordinator(WorkbenchContext workbenchContext) {
        this.context = workbenchContext;
    }

    private ResourceRepository resourceRepository() {
        return this.context.getApplicationContext().getResourceRepository();
    }

    void exportProjectSource(MWProject mWProject) {
        try {
            this.validateProjectClassName(mWProject);
            this.validateProjectSourceRootDirectory(mWProject);
            this.validateProjectProblems(mWProject);
            this.validateOverwriteProject(mWProject);
        }
        catch (CancelException cancelException) {
            return;
        }
        mWProject.exportProjectSource();
        this.showSuccessDialog(mWProject);
    }

    private void validateProjectClassName(MWProject mWProject) {
        String string = mWProject.getProjectSourceClassName();
        if (!string.equals("") && !string.endsWith(".")) {
            return;
        }
        ProjectClassNameDialog projectClassNameDialog = new ProjectClassNameDialog(this.context, this.buildProjectClassNameHolder(string), mWProject.getName());
        projectClassNameDialog.show();
        if (projectClassNameDialog.wasCanceled()) {
            throw new CancelException();
        }
        mWProject.setProjectSourceClassName(projectClassNameDialog.getProjectClassName());
    }

    private PropertyValueModel buildProjectClassNameHolder(String string) {
        return new SimplePropertyValueModel(string);
    }

    private void validateProjectSourceRootDirectory(MWProject mWProject) {
        if (mWProject.getProjectSourceDirectoryName().equals("")) {
            this.promptForProjectSourceRootDirectory(mWProject);
        }
        if (mWProject.absoluteProjectSourceDirectory().isFile()) {
            this.promptForNonFileProjectSourceRootDirectory(mWProject);
        }
        if (!mWProject.absoluteProjectSourceDirectory().exists()) {
            this.promptToCreateProjectSourceRootDirectory(mWProject);
        }
    }

    private void promptForProjectSourceRootDirectory(MWProject mWProject) {
        String string = this.resourceRepository().getString("PROJECT_SOURCE_ROOT_DIRECTORY_DIALOG_NO_DIRECTORY_CHOSEN.message");
        this.promptForDirectory(mWProject, string);
    }

    private void promptForNonFileProjectSourceRootDirectory(MWProject mWProject) {
        String string = this.resourceRepository().getString("PROJECT_SOURCE_ROOT_DIRECTORY_DIALOG_CHOSEN_DIRECTORY_IS_A_FILE.message", new Object[]{mWProject.absoluteProjectSourceDirectory()});
        this.promptForDirectory(mWProject, string);
    }

    private void promptForValidProjectSourceRootDirectory(MWProject mWProject) {
        String string = this.resourceRepository().getString("PROJECT_SOURCE_ROOT_DIRECTORY_DIALOG_CHOSEN_DIRECTORY_IS_INVALID.message", new Object[]{mWProject.absoluteProjectSourceDirectory()});
        this.promptForDirectory(mWProject, string);
    }

    private void promptForCreatableProjectSourceRootDirectory(MWProject mWProject) {
        String string = this.resourceRepository().getString("PROJECT_SOURCE_ROOT_DIRECTORY_DIALOG_CHOSEN_DIRECTORY_COULD_NOT_BE_CREATED.message", new Object[]{mWProject.absoluteProjectSourceDirectory()});
        this.promptForDirectory(mWProject, string);
    }

    private Preferences preferences() {
        return this.context.getApplicationContext().getPreferences();
    }

    private void promptForDirectory(MWProject mWProject, String string) {
        File file = MappingsPlugin.buildExportDirectory(mWProject, mWProject.getProjectSourceDirectoryName(), this.preferences());
        FileChooser fileChooser = new FileChooser(file, mWProject.getSaveDirectory());
        fileChooser.setDialogTitle(this.resourceRepository().getString("PROJECT_SOURCE_ROOT_DIRECTORY_DIALOG.title", mWProject.getName()));
        fileChooser.setFileSelectionMode(1);
        fileChooser.setApproveButtonText(this.resourceRepository().getString("PROJECT_SOURCE_ROOT_DIRECTORY_DIALOG_SELECT_BUTTON"));
        fileChooser.setApproveButtonMnemonic(this.resourceRepository().getMnemonic("PROJECT_SOURCE_ROOT_DIRECTORY_DIALOG_SELECT_BUTTON"));
        int n = fileChooser.showOpenDialog(this.context.getCurrentWindow());
        if (n == 1) {
            throw new CancelException();
        }
        File file2 = ((JFileChooser)fileChooser).getSelectedFile();
        mWProject.setProjectSourceDirectoryName(file2.getPath());
        if (file2 != null && file2.isAbsolute() && !file2.equals(mWProject.getSaveDirectory())) {
            this.preferences().put("export location", file2.getPath());
        }
    }

    private void promptToCreateProjectSourceRootDirectory(MWProject mWProject) {
        File file;
        try {
            file = mWProject.absoluteProjectSourceDirectory().getCanonicalFile();
        }
        catch (IOException iOException) {
            this.promptForValidProjectSourceRootDirectory(mWProject);
            return;
        }
        int n = JOptionPane.showConfirmDialog(this.context.getCurrentWindow(), this.resourceRepository().getString("CREATE_PROJECT_SOURCE_ROOT_DIRECTORY_DIALOG.message", new Object[]{file}), this.resourceRepository().getString("CREATE_PROJECT_SOURCE_ROOT_DIRECTORY_DIALOG.title"), 0, 3);
        if (n != 0) {
            throw new CancelException();
        }
        if (!mWProject.absoluteProjectSourceDirectory().mkdirs()) {
            this.promptForCreatableProjectSourceRootDirectory(mWProject);
        }
    }

    private void validateProjectProblems(MWProject mWProject) {
        if (!mWProject.hasBranchProblems()) {
            return;
        }
        int n = JOptionPane.showConfirmDialog(this.context.getCurrentWindow(), new LabelArea(this.resourceRepository().getString("exportingProjectJavaSource", StringTools.CR)), this.resourceRepository().getString("exportProjectJavaSource", mWProject.getName()), 0, 2);
        if (n != 0) {
            throw new CancelException();
        }
    }

    private void validateOverwriteProject(MWProject mWProject) {
        File file = mWProject.projectSourceFile();
        String string = file.getAbsolutePath();
        try {
            string = file.getCanonicalPath();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (!file.exists()) {
            return;
        }
        int n = JOptionPane.showConfirmDialog(this.context.getCurrentWindow(), this.resourceRepository().getString("PROJECT_FILE_EXISTS_DIALOG.message", string), this.resourceRepository().getString("PROJECT_FILE_EXISTS_DIALOG.title"), 0, 3);
        if (n != 0) {
            throw new CancelException();
        }
    }

    private void showSuccessDialog(MWProject mWProject) {
        JOptionPane.showMessageDialog(this.context.getCurrentWindow(), this.resourceRepository().getString("EXPORT_PROJECT_SOURCE_SUCCESS_DIALOG.message"), this.resourceRepository().getString("EXPORT_PROJECT_SOURCE_SUCCESS_DIALOG.title", mWProject.getName()), 1);
    }

    private class ProjectClassNameDialog
    extends AbstractDialog {
        private JTextField projectClassNameTextField;
        private PropertyValueModel projectClassNameHolder;
        private static final long serialVersionUID = 1L;

        private ProjectClassNameDialog(WorkbenchContext workbenchContext, PropertyValueModel propertyValueModel, String string) {
            super(workbenchContext);
            this.projectClassNameHolder = propertyValueModel;
            this.initialize(string);
        }

        protected void initialize(String string) {
            super.initialize();
            this.setTitle(this.resourceRepository().getString("PROJECT_CLASS_NAME_DIALOG.title", string));
            this.getOKAction().setEnabled(false);
        }

        protected String helpTopicId() {
            return "dialog.projectSourceClassName";
        }

        protected Component buildMainPanel() {
            JPanel jPanel = new JPanel(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            JLabel jLabel = new JLabel();
            jLabel.setText(this.resourceRepository().getString("PROJECT_CLASS_NAME_DIALOG.message"));
            jLabel.setDisplayedMnemonic(this.resourceRepository().getMnemonic("PROJECT_CLASS_NAME_DIALOG.message"));
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 21;
            gridBagConstraints.insets = new Insets(5, 5, 0, 5);
            jPanel.add((Component)jLabel, gridBagConstraints);
            this.projectClassNameTextField = this.buildProjectClassNameTextField();
            this.helpManager().addTopicID(this.projectClassNameTextField, this.helpTopicId() + ".name");
            jLabel.setLabelFor(this.projectClassNameTextField);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 10;
            gridBagConstraints.insets = new Insets(5, 5, 5, 5);
            jPanel.add((Component)this.projectClassNameTextField, gridBagConstraints);
            return jPanel;
        }

        protected Component initialFocusComponent() {
            return this.projectClassNameTextField;
        }

        private JTextField buildProjectClassNameTextField() {
            JTextField jTextField = new JTextField();
            jTextField.setDocument(this.buildProjectClassNameDocumentAdapter());
            return jTextField;
        }

        private Document buildProjectClassNameDocumentAdapter() {
            DocumentAdapter documentAdapter = new DocumentAdapter(this.projectClassNameHolder, new RegexpDocument(3));
            documentAdapter.addDocumentListener(this.buildProjectClassNameDocumentListener());
            return documentAdapter;
        }

        private DocumentListener buildProjectClassNameDocumentListener() {
            return new DocumentListener(){

                public void insertUpdate(DocumentEvent documentEvent) {
                    ProjectClassNameDialog.this.projectClassNameChange();
                }

                public void removeUpdate(DocumentEvent documentEvent) {
                    ProjectClassNameDialog.this.projectClassNameChange();
                }

                public void changedUpdate(DocumentEvent documentEvent) {
                    ProjectClassNameDialog.this.projectClassNameChange();
                }
            };
        }

        void projectClassNameChange() {
            String string = this.getProjectClassName();
            this.getOKAction().setEnabled(!string.equals("") && !string.endsWith("."));
        }

        String getProjectClassName() {
            return (String)this.projectClassNameHolder.getValue();
        }
    }
}

