/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.sourcegen;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.persistence.tools.workbench.framework.context.ApplicationContext;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClass;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClassAttribute;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClassCodeGenPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWDefaultMethodCodeGenPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWMethod;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWMethodCodeGenPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWZeroArgumentConstructorCodeGenPolicy;
import org.eclipse.persistence.tools.workbench.mappingsplugin.sourcegen.AbstractClassCodeGenPolicy;

abstract class DescriptorClassCodeGenPolicy
extends AbstractClassCodeGenPolicy {
    private MWDescriptor descriptor;
    private Map accessorCodeGenPolicies;

    protected DescriptorClassCodeGenPolicy(MWDescriptor mWDescriptor, ApplicationContext applicationContext) {
        super(applicationContext);
        this.descriptor = mWDescriptor;
        this.accessorCodeGenPolicies = new HashMap();
        this.initialize();
    }

    protected MWClass getMWClass() {
        return this.getDescriptor().getMWClass();
    }

    public MWMethodCodeGenPolicy getMethodCodeGenPolicy(MWMethod mWMethod) {
        if (mWMethod.isZeroArgumentConstructor()) {
            return new MWZeroArgumentConstructorCodeGenPolicy(mWMethod, this.getDescriptor(), (MWClassCodeGenPolicy)this);
        }
        if (this.accessorCodeGenPolicies.get(mWMethod) != null) {
            return (MWMethodCodeGenPolicy)this.accessorCodeGenPolicies.get(mWMethod);
        }
        return new MWDefaultMethodCodeGenPolicy(mWMethod, (MWClassCodeGenPolicy)this);
    }

    protected MWDescriptor getDescriptor() {
        return this.descriptor;
    }

    protected void initialize() {
        Iterator iterator = this.getDescriptor().getMWClass().attributes();
        while (iterator.hasNext()) {
            ((MWClassAttribute)iterator.next()).addAccessorCodeGenPoliciesTo((MWClassCodeGenPolicy)this);
        }
        iterator = this.getDescriptor().mappings();
        while (iterator.hasNext()) {
            MWMapping mWMapping = (MWMapping)iterator.next();
            mWMapping.getInstanceVariable().addAccessorCodeGenPoliciesTo((MWClassCodeGenPolicy)this, mWMapping);
        }
    }

    public void addAccessorCodeGenPolicy(MWMethod mWMethod, MWMethodCodeGenPolicy mWMethodCodeGenPolicy) {
        this.accessorCodeGenPolicies.put(mWMethod, mWMethodCodeGenPolicy);
    }
}

