/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.db;

import java.util.Iterator;
import javax.swing.JOptionPane;
import org.eclipse.persistence.tools.workbench.framework.action.AbstractFrameworkAction;
import org.eclipse.persistence.tools.workbench.framework.app.ApplicationNode;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWDatabase;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWTable;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.db.DatabaseNode;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.db.TableNameDialog;
import org.eclipse.persistence.tools.workbench.utility.NameTools;
import org.eclipse.persistence.tools.workbench.utility.node.Node;

final class AddNewTableAction
extends AbstractFrameworkAction {
    AddNewTableAction(WorkbenchContext workbenchContext) {
        super(workbenchContext);
    }

    protected void initialize() {
        super.initialize();
        this.initializeIcon("table.add");
        this.initializeTextAndMnemonic("ADD_NEW_TABLE_ACTION");
        this.initializeToolTipText("ADD_NEW_TABLE_ACTION.toolTipText");
    }

    protected void execute(ApplicationNode applicationNode) {
        DatabaseNode databaseNode = (DatabaseNode)applicationNode;
        MWTable mWTable = this.promptToCreateNewTableFor(databaseNode.getDatabase());
        if (mWTable != null) {
            databaseNode.selectDescendantNodeForValue((Node)mWTable, this.navigatorSelectionModel());
        }
    }

    private MWTable promptToCreateNewTableFor(MWDatabase mWDatabase) {
        String string = null;
        String string2 = null;
        String string3 = NameTools.uniqueNameForIgnoreCase((String)this.resourceRepository().getString("NEW_TABLE_DEFAULT_NAME"), (Iterator)mWDatabase.tableNames());
        while (true) {
            TableNameDialog tableNameDialog = new TableNameDialog(this.getWorkbenchContext(), this.resourceRepository().getString("ADD_NEW_TABLE_DAILOG.title"), this.resourceRepository().getString("ADD_NEW_TABLE_DAILOG.message"), string, string2, string3);
            tableNameDialog.show();
            if (tableNameDialog.wasCanceled()) {
                return null;
            }
            string = tableNameDialog.catalog();
            string2 = tableNameDialog.schema();
            string3 = tableNameDialog.shortName();
            try {
                return mWDatabase.addTable(string, string2, string3);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                int n;
                String string4 = NameTools.buildQualifiedDatabaseObjectName((String)string, (String)string2, (String)string3);
                if ((n = JOptionPane.showConfirmDialog(this.getWorkbenchContext().getCurrentWindow(), this.resourceRepository().getString("ADD_NEW_TABLE_DUPLICATE_TABLE_NAME_MESSAGE", string4), this.resourceRepository().getString("ADD_NEW_TABLE_DUPLICATE_TABLE_NAME_TITLE"), 2, 3)) != 2) continue;
                return null;
            }
            break;
        }
    }
}

