/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.db;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.Collator;
import java.util.Iterator;
import java.util.List;
import javax.swing.ButtonModel;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.ui.dialog.AbstractValidatingDialog;
import org.eclipse.persistence.tools.workbench.framework.uitools.RegexpDocument;
import org.eclipse.persistence.tools.workbench.framework.uitools.SwingComponentFactory;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWReference;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWTable;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.common.cell.TableCellRendererAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.SimplePropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.CheckBoxModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.cell.AdaptableListCellRenderer;
import org.eclipse.persistence.tools.workbench.uitools.chooser.ListChooser;

public class NewTableReferenceDialog
extends AbstractValidatingDialog {
    private JTextField referenceNameTextField;
    private PropertyValueModel onDatabaseHolder;
    private ComboBoxModel sourceTablesModel;
    private ComboBoxModel targetTablesModel;
    private boolean allowSourceTableSelection;
    private boolean allowTargetTableSelection;

    public static NewTableReferenceDialog buildReferenceDialogAllowSourceAndTargetSelection(WorkbenchContext workbenchContext, List list, List list2) {
        return new NewTableReferenceDialog(workbenchContext, list, list2);
    }

    public static NewTableReferenceDialog buildReferenceDialogDisallowSourceTableSelection(WorkbenchContext workbenchContext, List list, List list2) {
        return new NewTableReferenceDialog(workbenchContext, list, list2, false);
    }

    public static NewTableReferenceDialog buildReferenceDialogDisallowTargetTableSelection(WorkbenchContext workbenchContext, List list, List list2) {
        return new NewTableReferenceDialog(workbenchContext, list, list2, true, false);
    }

    private NewTableReferenceDialog(WorkbenchContext workbenchContext, List list, List list2) {
        this(workbenchContext, list, list2, true);
    }

    private NewTableReferenceDialog(WorkbenchContext workbenchContext, List list, List list2, boolean bl) {
        this(workbenchContext, list, list2, bl, true);
    }

    private NewTableReferenceDialog(WorkbenchContext workbenchContext, List list, List list2, boolean bl, boolean bl2) {
        super(workbenchContext);
        this.sourceTablesModel = new DefaultComboBoxModel<Object>(list.toArray());
        this.targetTablesModel = new DefaultComboBoxModel<Object>(list2.toArray());
        this.allowSourceTableSelection = bl;
        this.allowTargetTableSelection = bl2;
    }

    protected void initialize() {
        super.initialize();
        this.setTitle(this.resourceRepository().getString("NEW_REFERENCE_DIALOG.title"));
        this.getOKAction().setEnabled(false);
    }

    protected Component initialFocusComponent() {
        return this.referenceNameTextField;
    }

    protected String helpTopicId() {
        return "dialog.newReference";
    }

    protected Component buildMainPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JLabel jLabel = SwingComponentFactory.buildLabel("enterNameOfNewReference", this.resourceRepository());
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel.add((Component)jLabel, gridBagConstraints);
        this.referenceNameTextField = this.buildReferenceNameTextField();
        this.helpManager().addTopicID(this.referenceNameTextField, this.helpTopicId() + ".name");
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(1, 0, 0, 0);
        jPanel.add((Component)this.referenceNameTextField, gridBagConstraints);
        jLabel.setLabelFor(this.referenceNameTextField);
        JLabel jLabel2 = SwingComponentFactory.buildLabel("selectTheSourceTable", this.resourceRepository());
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        jPanel.add((Component)jLabel2, gridBagConstraints);
        JComboBox jComboBox = this.buildSourceTableComboBox();
        this.helpManager().addTopicID(jComboBox, this.helpTopicId() + ".sourceTable");
        jLabel2.setLabelFor(jComboBox);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(1, 0, 0, 0);
        jPanel.add((Component)jComboBox, gridBagConstraints);
        JLabel jLabel3 = SwingComponentFactory.buildLabel("selectTheTargetTable", this.resourceRepository());
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        jPanel.add((Component)jLabel3, gridBagConstraints);
        JComboBox jComboBox2 = this.buildTargetTableComboBox();
        this.helpManager().addTopicID(jComboBox2, this.helpTopicId() + ".targetTable");
        jLabel3.setLabelFor(jComboBox2);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(1, 0, 0, 0);
        jPanel.add((Component)jComboBox2, gridBagConstraints);
        JCheckBox jCheckBox = this.buildOnDatabaseCheckBox();
        this.helpManager().addTopicID(jCheckBox, this.helpTopicId() + ".onDatabase");
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        jPanel.add((Component)jCheckBox, gridBagConstraints);
        return jPanel;
    }

    private JTextField buildReferenceNameTextField() {
        JTextField jTextField = new JTextField();
        RegexpDocument regexpDocument = new RegexpDocument(13);
        regexpDocument.addDocumentListener(this.buildReferenceNameDocumentListener());
        jTextField.setDocument(regexpDocument);
        return jTextField;
    }

    private DocumentListener buildReferenceNameDocumentListener() {
        return new DocumentListener(){

            public void changedUpdate(DocumentEvent documentEvent) {
                NewTableReferenceDialog.this.updateOKButton();
                NewTableReferenceDialog.this.updateErrorMessage();
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                this.changedUpdate(documentEvent);
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                this.changedUpdate(documentEvent);
            }
        };
    }

    private JComboBox buildSourceTableComboBox() {
        ListChooser listChooser = new ListChooser(this.sourceTablesModel);
        listChooser.setRenderer(this.buildTableListCellRenderer());
        listChooser.addActionListener(this.buildTableListener());
        listChooser.setEnabled(this.allowSourceTableSelection);
        return listChooser;
    }

    private ActionListener buildTableListener() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NewTableReferenceDialog.this.updateReferenceName();
                NewTableReferenceDialog.this.updateOKButton();
            }
        };
    }

    private JComboBox buildTargetTableComboBox() {
        ListChooser listChooser = new ListChooser(this.targetTablesModel);
        listChooser.setRenderer(this.buildTableListCellRenderer());
        listChooser.addActionListener(this.buildTableListener());
        listChooser.setEnabled(this.allowTargetTableSelection);
        return listChooser;
    }

    private ListCellRenderer buildTableListCellRenderer() {
        return new AdaptableListCellRenderer(new TableCellRendererAdapter(this.resourceRepository()));
    }

    private JCheckBox buildOnDatabaseCheckBox() {
        JCheckBox jCheckBox = new JCheckBox();
        jCheckBox.setModel(this.buildOnDatabaseCheckBoxModel());
        jCheckBox.setText(this.resourceRepository().getString("onDatabase"));
        jCheckBox.setMnemonic(this.resourceRepository().getMnemonic("onDatabase"));
        return jCheckBox;
    }

    private ButtonModel buildOnDatabaseCheckBoxModel() {
        return new CheckBoxModelAdapter(this.buildOnDatabaseHolder());
    }

    private PropertyValueModel buildOnDatabaseHolder() {
        this.onDatabaseHolder = new SimplePropertyValueModel(Boolean.FALSE);
        return this.onDatabaseHolder;
    }

    public String getReferenceName() {
        return this.referenceNameTextField.getText();
    }

    public MWTable getSourceTable() {
        return (MWTable)this.sourceTablesModel.getSelectedItem();
    }

    public void setSourceTable(MWTable mWTable) {
        this.sourceTablesModel.setSelectedItem(mWTable);
    }

    public MWTable getTargetTable() {
        return (MWTable)this.targetTablesModel.getSelectedItem();
    }

    public void setTargetTable(MWTable mWTable) {
        this.targetTablesModel.setSelectedItem(mWTable);
    }

    public boolean isOnDatabase() {
        return (Boolean)this.onDatabaseHolder.getValue();
    }

    void updateOKButton() {
        boolean bl = this.referenceNameIsSpecified() && this.referenceNameIsValid() && this.getTargetTable() != null && this.getSourceTable() != null;
        this.getOKAction().setEnabled(bl);
    }

    void updateErrorMessage() {
        if (this.referenceNameIsValid()) {
            this.clearErrorMessage();
        } else {
            this.setErrorMessageKey("REFERENCE_NAME_MUST_BE_UNIQUE_ERROR");
        }
    }

    void updateReferenceName() {
        String string = this.getReferenceName();
        MWTable mWTable = this.getSourceTable();
        MWTable mWTable2 = this.getTargetTable();
        if (mWTable != null) {
            string = mWTable.getShortName() + "_";
            if (mWTable2 != null) {
                string = string + mWTable2.getShortName();
            }
        } else if (mWTable2 != null) {
            string = "_" + mWTable2.getShortName();
        }
        this.referenceNameTextField.setText(string);
        this.referenceNameTextField.selectAll();
        this.referenceNameTextField.requestFocus();
    }

    private boolean referenceNameIsSpecified() {
        return this.getReferenceName() != null && this.getReferenceName().length() != 0;
    }

    private boolean referenceNameIsValid() {
        if (this.getSourceTable() == null) {
            return true;
        }
        Iterator iterator = this.getSourceTable().references();
        while (iterator.hasNext()) {
            MWReference mWReference = (MWReference)iterator.next();
            String string = mWReference.getName();
            Collator collator = Collator.getInstance();
            collator.setStrength(0);
            if (collator.compare(string, this.getReferenceName()) != 0) continue;
            return false;
        }
        return true;
    }

    protected void prepareToShow() {
        this.updateReferenceName();
        super.prepareToShow();
    }
}

