/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.db;

import javax.swing.JOptionPane;
import org.eclipse.persistence.tools.workbench.framework.action.AbstractFrameworkAction;
import org.eclipse.persistence.tools.workbench.framework.app.ApplicationNode;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWTable;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.db.TableNameDialog;
import org.eclipse.persistence.tools.workbench.utility.NameTools;

class RenameTableAction
extends AbstractFrameworkAction {
    RenameTableAction(WorkbenchContext workbenchContext) {
        super(workbenchContext);
    }

    protected void initialize() {
        super.initialize();
        this.initializeIcon("rename");
        this.initializeTextAndMnemonic("RENAME");
        this.initializeToolTipText("RENAME");
    }

    protected void execute(ApplicationNode applicationNode) {
        this.promptToRenameTable((MWTable)applicationNode.getValue());
        this.navigatorSelectionModel().setSelectedNode(applicationNode);
    }

    private void promptToRenameTable(MWTable mWTable) {
        String string = mWTable.getCatalog();
        String string2 = mWTable.getSchema();
        String string3 = mWTable.getShortName();
        while (true) {
            TableNameDialog tableNameDialog = new TableNameDialog(this.getWorkbenchContext(), this.resourceRepository().getString("RENAME_TABLE_DIALOG.title", mWTable.getName()), this.resourceRepository().getString("RENAME_TABLE_DIALOG.message"), string, string2, string3);
            tableNameDialog.show();
            if (tableNameDialog.wasCanceled()) {
                return;
            }
            string = tableNameDialog.catalog();
            string2 = tableNameDialog.schema();
            string3 = tableNameDialog.shortName();
            try {
                mWTable.rename(string, string2, string3);
                return;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                int n;
                String string4 = NameTools.buildQualifiedDatabaseObjectName((String)string, (String)string2, (String)string3);
                if ((n = JOptionPane.showConfirmDialog(this.getWorkbenchContext().getCurrentWindow(), this.resourceRepository().getString("ADD_NEW_TABLE_DUPLICATE_TABLE_NAME_MESSAGE", string4), this.resourceRepository().getString("ADD_NEW_TABLE_DUPLICATE_TABLE_NAME_TITLE"), 2, 3)) != 2) continue;
                return;
            }
            break;
        }
    }
}

