/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.db;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.lang.reflect.InvocationTargetException;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ButtonModel;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.text.Document;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.ui.dialog.AbstractDialog;
import org.eclipse.persistence.tools.workbench.framework.ui.dialog.WaitDialog;
import org.eclipse.persistence.tools.workbench.framework.uitools.CursorConstants;
import org.eclipse.persistence.tools.workbench.framework.uitools.DualListSelectorPanel;
import org.eclipse.persistence.tools.workbench.framework.uitools.SwingComponentFactory;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWDatabase;
import org.eclipse.persistence.tools.workbench.mappingsmodel.spi.db.ExternalTableDescription;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ReadOnlyListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.SimpleCollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.SimplePropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.SortedListValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.CheckBoxModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ComboBoxModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.DocumentAdapter;
import org.eclipse.persistence.tools.workbench.uitools.cell.SimpleListCellRenderer;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;

final class TableImporterDialog
extends AbstractDialog {
    MWDatabase database;
    private static final String DEFAULT_TABLE_NAME_PATTERN = "%";
    private PropertyValueModel tableNamePatternHolder;
    private Document tableNamePatternDocument;
    private JTextField tableNamePatternTextField;
    private JButton tablesButton;
    private String noCatalog;
    private String ignoreCatalog;
    private PropertyValueModel catalogHolder;
    private ComboBoxModel catalogComboBoxModel;
    private String noSchema;
    private String ignoreSchema;
    private PropertyValueModel schemaPatternHolder;
    private ComboBoxModel schemaPatternComboBoxModel;
    private static final String DEFAULT_TABLE_TYPE = "TABLE";
    private String allTableTypes;
    private PropertyValueModel tableTypeHolder;
    private ComboBoxModel tableTypeComboBoxModel;
    private PropertyValueModel fullyQualifiedHolder;
    private ButtonModel fullyQualifiedCheckBoxModel;
    SimpleCollectionValueModel availableExternalTableDescriptionsHolder;
    SimpleCollectionValueModel selectedExternalTableDescriptionsHolder;
    private static final Comparator EXTERNAL_TABLE_DESCRIPTION_COMPARATOR = new Comparator(){

        public int compare(Object object, Object object2) {
            return Collator.getInstance().compare(((ExternalTableDescription)object).getQualifiedName(), ((ExternalTableDescription)object2).getQualifiedName());
        }
    };

    TableImporterDialog(WorkbenchContext workbenchContext, MWDatabase mWDatabase) {
        super(workbenchContext);
        this.initialize(mWDatabase);
    }

    protected void initialize() {
        super.initialize();
        this.setTitle(this.resourceRepository().getString("IMPORT_TABLES_FROM_DATABASE_DIALOG.title"));
    }

    protected void prepareToShow() {
        this.setSize(700, 500);
        this.setLocationRelativeTo(this.getParent());
        this.getRootPane().setDefaultButton(this.tablesButton);
    }

    private void initialize(MWDatabase mWDatabase) {
        if (!mWDatabase.isConnected()) {
            throw new IllegalStateException("database not connected");
        }
        this.database = mWDatabase;
        this.tableNamePatternHolder = new SimplePropertyValueModel(DEFAULT_TABLE_NAME_PATTERN);
        this.tableNamePatternDocument = new DocumentAdapter(this.tableNamePatternHolder);
        this.tableNamePatternTextField = new JTextField(this.tableNamePatternDocument, null, 0);
        this.ignoreCatalog = this.resourceRepository().getString("IGNORE");
        this.noCatalog = this.resourceRepository().getString("NO_CATALOG");
        this.catalogHolder = new SimplePropertyValueModel(this.ignoreCatalog);
        this.catalogComboBoxModel = new ComboBoxModelAdapter(new ReadOnlyListValueModel(this.buildCatalogs()), this.catalogHolder);
        this.ignoreSchema = this.resourceRepository().getString("IGNORE");
        this.noSchema = this.resourceRepository().getString("NO_SCHEMA");
        this.schemaPatternHolder = new SimplePropertyValueModel(this.ignoreSchema);
        this.schemaPatternComboBoxModel = new ComboBoxModelAdapter(new ReadOnlyListValueModel(this.buildSchemas()), this.schemaPatternHolder);
        this.allTableTypes = this.resourceRepository().getString("ALL_TYPES");
        List list = this.buildTableTypes();
        this.tableTypeHolder = new SimplePropertyValueModel(list.contains(DEFAULT_TABLE_TYPE) ? DEFAULT_TABLE_TYPE : this.allTableTypes);
        this.tableTypeComboBoxModel = new ComboBoxModelAdapter(new ReadOnlyListValueModel(list), this.tableTypeHolder);
        this.fullyQualifiedHolder = new SimplePropertyValueModel(Boolean.FALSE);
        this.fullyQualifiedCheckBoxModel = new CheckBoxModelAdapter(this.fullyQualifiedHolder);
        this.availableExternalTableDescriptionsHolder = new SimpleCollectionValueModel();
        this.selectedExternalTableDescriptionsHolder = new SimpleCollectionValueModel();
    }

    private List buildCatalogs() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(this.ignoreCatalog);
        arrayList.add(this.noCatalog);
        arrayList.addAll(CollectionTools.sortedSet((Iterator)this.database.catalogNames()));
        return arrayList;
    }

    private List buildSchemas() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(this.ignoreSchema);
        arrayList.add(this.noSchema);
        arrayList.addAll(CollectionTools.sortedSet((Iterator)this.database.schemaNames()));
        return arrayList;
    }

    private List buildTableTypes() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(this.allTableTypes);
        arrayList.addAll(CollectionTools.sortedSet((Iterator)this.database.tableTypeNames()));
        return arrayList;
    }

    protected String helpTopicId() {
        return "dialog.importingTables";
    }

    protected Component initialFocusComponent() {
        return this.tableNamePatternTextField;
    }

    protected Component buildMainPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel2 = this.buildSearchCriteriaPanel();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        jPanel.add((Component)jPanel2, gridBagConstraints);
        JPanel jPanel3 = this.buildTableSelectionPanel();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        jPanel.add((Component)jPanel3, gridBagConstraints);
        JCheckBox jCheckBox = this.buildFullyQualifiedCheckBox();
        this.helpManager().addTopicID(jCheckBox, this.helpTopicId() + ".fullyQualified");
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(10, 0, 5, 0);
        jPanel.add((Component)jCheckBox, gridBagConstraints);
        return jPanel;
    }

    private JPanel buildSearchCriteriaPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JLabel jLabel = new JLabel(this.resourceRepository().getString("TABLE_NAME_PATTERN_TEXT_FIELD_LABEL"));
        jLabel.setDisplayedMnemonic(this.resourceRepository().getMnemonic("TABLE_NAME_PATTERN_TEXT_FIELD_LABEL"));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel.add((Component)jLabel, gridBagConstraints);
        this.helpManager().addTopicID(this.tableNamePatternTextField, this.helpTopicId() + ".namePattern");
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        jPanel.add((Component)this.tableNamePatternTextField, gridBagConstraints);
        jLabel.setLabelFor(this.tableNamePatternTextField);
        JLabel jLabel2 = new JLabel(this.resourceRepository().getString("CATALOG_COMBO_BOX_LABEL"));
        jLabel2.setDisplayedMnemonic(this.resourceRepository().getMnemonic("CATALOG_COMBO_BOX_LABEL"));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        jPanel.add((Component)jLabel2, gridBagConstraints);
        JComboBox jComboBox = new JComboBox(this.catalogComboBoxModel);
        this.helpManager().addTopicID(jComboBox, this.helpTopicId() + ".catalog");
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        jPanel.add(jComboBox, gridBagConstraints);
        jLabel2.setLabelFor(jComboBox);
        JLabel jLabel3 = new JLabel(this.resourceRepository().getString("SCHEMA_PATTERN_COMBO_BOX_LABEL"));
        jLabel3.setDisplayedMnemonic(this.resourceRepository().getMnemonic("SCHEMA_PATTERN_COMBO_BOX_LABEL"));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        jPanel.add((Component)jLabel3, gridBagConstraints);
        JComboBox jComboBox2 = new JComboBox(this.schemaPatternComboBoxModel);
        jComboBox2.setEditable(true);
        this.helpManager().addTopicID(jComboBox2, this.helpTopicId() + ".schemaPattern");
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        jPanel.add(jComboBox2, gridBagConstraints);
        jLabel3.setLabelFor(jComboBox2);
        JLabel jLabel4 = new JLabel(this.resourceRepository().getString("TABLE_TYPE_COMBO_BOX_LABEL"));
        jLabel4.setDisplayedMnemonic(this.resourceRepository().getMnemonic("TABLE_TYPE_COMBO_BOX_LABEL"));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        jPanel.add((Component)jLabel4, gridBagConstraints);
        JComboBox jComboBox3 = new JComboBox(this.tableTypeComboBoxModel);
        this.helpManager().addTopicID(jComboBox3, this.helpTopicId() + ".type");
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        jPanel.add(jComboBox3, gridBagConstraints);
        jLabel4.setLabelFor(jComboBox3);
        this.tablesButton = new JButton(this.buildGetTableNamesAction());
        this.tablesButton.setMnemonic(this.resourceRepository().getMnemonic("GET_TABLE_NAMES_BUTTON_TEXT"));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 0, 5, 0);
        jPanel.add((Component)this.tablesButton, gridBagConstraints);
        return jPanel;
    }

    private Action buildGetTableNamesAction() {
        return new AbstractAction(this.resourceRepository().getString("GET_TABLE_NAMES_BUTTON_TEXT")){

            public void actionPerformed(ActionEvent actionEvent) {
                TableImporterDialog.this.getTableNamesPressed();
            }
        };
    }

    private JCheckBox buildFullyQualifiedCheckBox() {
        return SwingComponentFactory.buildCheckBox("FULLY_QUALIFIED_CHECK_BOX", this.fullyQualifiedCheckBoxModel, this.resourceRepository());
    }

    private JPanel buildTableSelectionPanel() {
        DualListSelectorPanel.Builder builder = new DualListSelectorPanel.Builder();
        builder.setAvailableLVM(this.buildSortedExternalTableDescriptionsHolderAdapter(this.availableExternalTableDescriptionsHolder));
        builder.setSelectedLVM(this.buildSortedExternalTableDescriptionsHolderAdapter(this.selectedExternalTableDescriptionsHolder));
        builder.setAdapter(this.buildExternalTableDescriptionSelectionAdapter());
        builder.setListCellRenderer(this.buildExternalTableDescriptionRenderer());
        builder.setContext(this.getApplicationContext());
        builder.setAvailableListBoxLabelKey("AVAILABLE_TABLES_LIST_BOX_LABEL");
        builder.setSelectedListBoxLabelKey("SELECTED_TABLES_LIST_BOX_LABEL");
        builder.setSelectButtonToolTipKey("ADD_SELECTED_TABLES_BUTTON.toolTipText");
        builder.setDeselectButtonToolTipKey("REMOVE_SELECTED_TABLES_BUTTON.toolTipText");
        builder.setHelpTopicID(this.helpTopicId());
        return builder.buildPanel();
    }

    private ListValueModel buildSortedExternalTableDescriptionsHolderAdapter(CollectionValueModel collectionValueModel) {
        return new SortedListValueModelAdapter(collectionValueModel, EXTERNAL_TABLE_DESCRIPTION_COMPARATOR);
    }

    private DualListSelectorPanel.Adapter buildExternalTableDescriptionSelectionAdapter() {
        return new DualListSelectorPanel.Adapter(){

            public void select(Object object) {
                TableImporterDialog.this.availableExternalTableDescriptionsHolder.removeItem(object);
                TableImporterDialog.this.selectedExternalTableDescriptionsHolder.addItem(object);
            }

            public void deselect(Object object) {
                TableImporterDialog.this.selectedExternalTableDescriptionsHolder.removeItem(object);
                TableImporterDialog.this.availableExternalTableDescriptionsHolder.addItem(object);
            }
        };
    }

    private ListCellRenderer buildExternalTableDescriptionRenderer() {
        return new SimpleListCellRenderer(){

            protected String buildText(Object object) {
                return ((ExternalTableDescription)object).getQualifiedName();
            }
        };
    }

    String catalog() {
        String string = (String)this.catalogHolder.getValue();
        if (string == this.ignoreCatalog) {
            return null;
        }
        if (string == this.noCatalog) {
            return "";
        }
        return string;
    }

    String schemaPattern() {
        String string = (String)this.schemaPatternHolder.getValue();
        if (string == this.ignoreSchema) {
            return null;
        }
        if (string == this.noSchema) {
            return "";
        }
        return string;
    }

    String tableNamePattern() {
        return (String)this.tableNamePatternHolder.getValue();
    }

    String[] tableTypes() {
        String string = (String)this.tableTypeHolder.getValue();
        if (string == this.allTableTypes) {
            return null;
        }
        return new String[]{string};
    }

    public boolean importsTablesFullyQualified() {
        return (Boolean)this.fullyQualifiedHolder.getValue();
    }

    public Collection selectedTables() {
        return CollectionTools.list((Iterator)((Iterator)this.selectedExternalTableDescriptionsHolder.getValue()));
    }

    void getTableNamesPressed() {
        Thread thread = new Thread((Runnable)new TableNameQuery(), "Database Table Name Query");
        thread.setPriority(5);
        thread.start();
    }

    void addTableNamesCallback(final Collection collection) throws InterruptedException, InvocationTargetException {
        EventQueue.invokeAndWait(new Runnable(){

            public void run() {
                TableImporterDialog.this.availableExternalTableDescriptionsHolder.clear();
                TableImporterDialog.this.availableExternalTableDescriptionsHolder.addItems(collection);
            }
        });
    }

    private class TableNameQuery
    implements Runnable {
        TableNameQuery() {
        }

        public void run() {
            this.setCursor(CursorConstants.WAIT_CURSOR);
            WaitDialog waitDialog = this.buildWaitDialog();
            AbstractDialog.launchLater(waitDialog);
            ArrayList arrayList = new ArrayList(1000);
            try {
                Iterator iterator = this.externalTableDescriptions();
                while (iterator.hasNext()) {
                    arrayList.add(iterator.next());
                }
                TableImporterDialog.this.addTableNamesCallback(arrayList);
            }
            catch (Throwable throwable) {
                throw new RuntimeException(throwable);
            }
            finally {
                waitDialog.dispose();
                this.setCursor(CursorConstants.DEFAULT_CURSOR);
            }
        }

        private void setCursor(Cursor cursor) {
            TableImporterDialog.this.getWorkbenchContext().getCurrentWindow().setCursor(cursor);
        }

        private WaitDialog buildWaitDialog() {
            return new WaitDialog((Dialog)TableImporterDialog.this, TableImporterDialog.this.resourceRepository().getIcon("database.large"), TableImporterDialog.this.resourceRepository().getString("GET_TABLE_NAMES_DIALOG.TITLE"), TableImporterDialog.this.resourceRepository().getString("GET_TABLE_NAMES_DIALOG_MESSAGE"));
        }

        private Iterator externalTableDescriptions() {
            return TableImporterDialog.this.database.externalTableDescriptions(TableImporterDialog.this.catalog(), TableImporterDialog.this.schemaPattern(), TableImporterDialog.this.tableNamePattern(), TableImporterDialog.this.tableTypes());
        }
    }
}

