/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JSpinner;
import javax.swing.SpinnerModel;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.ui.chooser.ClassChooserPanel;
import org.eclipse.persistence.tools.workbench.framework.ui.view.AbstractPanel;
import org.eclipse.persistence.tools.workbench.framework.uitools.SwingComponentFactory;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClass;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClassAttribute;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClassRepository;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.meta.ClassChooserTools;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.meta.ClassRepositoryHolder;
import org.eclipse.persistence.tools.workbench.uitools.ComponentEnabler;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.TransformationPropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValuePropertyPropertyValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.NumberSpinnerModelAdapter;

final class ClassAttributeTypesPanel
extends AbstractPanel {
    private ValueModel attributeHolder;
    private PropertyValueModel attributeTypeHolder;
    private PropertyValueModel attributeTypeDimensionalityHolder;
    private PropertyValueModel attributeValueTypeHolder;
    private PropertyValueModel attributeKetTypeHolder;
    private PropertyValueModel attributeItemTypeHolder;
    private ClassRepositoryHolder classRepositoryHolder;
    private JLabel valueTypeLabel;
    private ClassChooserPanel valueTypeClassChooserPanel;
    private JLabel keyTypeLabel;
    private ClassChooserPanel keyTypeClassChooserPanel;
    private JLabel itemTypeLabel;
    private ClassChooserPanel itemTypeClassChooserPanel;

    ClassAttributeTypesPanel(ValueModel valueModel, WorkbenchContextHolder workbenchContextHolder) {
        super(workbenchContextHolder);
        this.attributeHolder = valueModel;
        this.attributeTypeHolder = this.buildAttributeTypeAdapter();
        this.attributeTypeDimensionalityHolder = this.buildAttributeTypeDimensionalityAdapter();
        this.attributeValueTypeHolder = this.buildAttributeValueTypeHolder();
        this.attributeKetTypeHolder = this.buildAttributeKeyTypeHolder();
        this.attributeItemTypeHolder = this.buildAttributeItemTypeHolder();
        this.classRepositoryHolder = this.buildClassRepositoryHolder();
        this.initializeLayout();
    }

    private PropertyValueModel buildAttributeTypeAdapter() {
        PropertyAspectAdapter propertyAspectAdapter = new PropertyAspectAdapter(this.attributeHolder, "type"){

            protected Object getValueFromSubject() {
                return ((MWClassAttribute)this.subject).getType();
            }

            protected void setValueOnSubject(Object object) {
                ((MWClassAttribute)this.subject).setType((MWClass)object);
            }
        };
        propertyAspectAdapter.addPropertyChangeListener("value", this.buildAttributeListener());
        return new ValuePropertyPropertyValueModelAdapter((PropertyValueModel)propertyAspectAdapter, "name");
    }

    private PropertyValueModel buildAttributeTypeDimensionalityAdapter() {
        PropertyAspectAdapter propertyAspectAdapter = new PropertyAspectAdapter(this.attributeHolder, "dimensionality"){

            protected Object getValueFromSubject() {
                return new Integer(((MWClassAttribute)this.subject).getDimensionality());
            }

            protected void setValueOnSubject(Object object) {
                ((MWClassAttribute)this.subject).setDimensionality(((Integer)object).intValue());
            }
        };
        propertyAspectAdapter.addPropertyChangeListener("value", this.buildAttributeListener());
        return propertyAspectAdapter;
    }

    private PropertyChangeListener buildAttributeListener() {
        return new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                ClassAttributeTypesPanel.this.updateAllTypeComponents();
            }
        };
    }

    private PropertyValueModel buildAttributeValueTypeHolder() {
        PropertyAspectAdapter propertyAspectAdapter = new PropertyAspectAdapter(this.attributeHolder, "valueType"){

            protected Object getValueFromSubject() {
                return ((MWClassAttribute)this.subject).getValueType();
            }

            protected void setValueOnSubject(Object object) {
                ((MWClassAttribute)this.subject).setValueType((MWClass)object);
            }
        };
        propertyAspectAdapter.addPropertyChangeListener("value", this.buildAttributeValueTypeListener());
        return propertyAspectAdapter;
    }

    private PropertyChangeListener buildAttributeValueTypeListener() {
        return new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                ClassAttributeTypesPanel.this.updateAllTypeComponents();
            }
        };
    }

    private PropertyValueModel buildAttributeKeyTypeHolder() {
        return new PropertyAspectAdapter(this.attributeHolder, "keyType"){

            protected Object getValueFromSubject() {
                return ((MWClassAttribute)this.subject).getKeyType();
            }

            protected void setValueOnSubject(Object object) {
                ((MWClassAttribute)this.subject).setKeyType((MWClass)object);
            }
        };
    }

    private PropertyValueModel buildAttributeItemTypeHolder() {
        return new PropertyAspectAdapter(this.attributeHolder, "itemType"){

            protected Object getValueFromSubject() {
                return ((MWClassAttribute)this.subject).getItemType();
            }

            protected void setValueOnSubject(Object object) {
                ((MWClassAttribute)this.subject).setItemType((MWClass)object);
            }
        };
    }

    private ClassRepositoryHolder buildClassRepositoryHolder() {
        return new ClassRepositoryHolder(){

            public MWClassRepository getClassRepository() {
                return ClassAttributeTypesPanel.this.getAttribute().getRepository();
            }
        };
    }

    private void initializeLayout() {
        this.setBorder(BorderFactory.createTitledBorder(this.resourceRepository().getString("TYPE_PANEL_TITLE")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        ArrayList<JComponent> arrayList = new ArrayList<JComponent>();
        JLabel jLabel = SwingComponentFactory.buildLabel("TYPE_LABEL", this.resourceRepository());
        arrayList.add(jLabel);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.add((Component)jLabel, gridBagConstraints);
        ClassChooserPanel classChooserPanel = ClassChooserTools.buildPanel(this.attributeTypeHolder, this.classRepositoryHolder, ClassChooserTools.buildDeclarableNonVoidFilter(), jLabel, this.getWorkbenchContextHolder());
        arrayList.add(classChooserPanel);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.add((Component)classChooserPanel, gridBagConstraints);
        JLabel jLabel2 = SwingComponentFactory.buildLabel("DIMENSIONALITY_LABEL", this.resourceRepository());
        arrayList.add(jLabel2);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(5, 5, 5, 0);
        this.add((Component)jLabel2, gridBagConstraints);
        JSpinner jSpinner = this.buildDimensionalitySpinner();
        arrayList.add(jSpinner);
        jLabel2.setLabelFor(jSpinner);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)jSpinner, gridBagConstraints);
        this.valueTypeLabel = SwingComponentFactory.buildLabel("VALUE_TYPE_LABEL", this.resourceRepository());
        this.valueTypeLabel.setVisible(false);
        arrayList.add(this.valueTypeLabel);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(0, 5, 5, 5);
        this.add((Component)this.valueTypeLabel, gridBagConstraints);
        this.valueTypeClassChooserPanel = ClassChooserTools.buildPanel(this.attributeValueTypeHolder, this.classRepositoryHolder, ClassChooserTools.buildDeclarableReferenceFilter(), this.valueTypeLabel, this.getWorkbenchContextHolder());
        this.valueTypeClassChooserPanel.setVisible(false);
        arrayList.add(this.valueTypeClassChooserPanel);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(0, 5, 5, 5);
        this.add((Component)this.valueTypeClassChooserPanel, gridBagConstraints);
        this.keyTypeLabel = SwingComponentFactory.buildLabel("MAP_KEY_TYPE_LABEL", this.resourceRepository());
        this.keyTypeLabel.setVisible(false);
        arrayList.add(this.keyTypeLabel);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(0, 5, 5, 5);
        this.add((Component)this.keyTypeLabel, gridBagConstraints);
        this.keyTypeClassChooserPanel = ClassChooserTools.buildPanel(this.attributeKetTypeHolder, this.classRepositoryHolder, ClassChooserTools.buildDeclarableReferenceFilter(), this.keyTypeLabel, this.getWorkbenchContextHolder());
        this.keyTypeClassChooserPanel.setVisible(false);
        arrayList.add(this.keyTypeClassChooserPanel);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(0, 5, 5, 5);
        this.add((Component)this.keyTypeClassChooserPanel, gridBagConstraints);
        this.itemTypeLabel = SwingComponentFactory.buildLabel("ELEMENT_TYPE_LABEL", this.resourceRepository());
        this.itemTypeLabel.setVisible(false);
        arrayList.add(this.itemTypeLabel);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(0, 5, 5, 5);
        this.add((Component)this.itemTypeLabel, gridBagConstraints);
        this.itemTypeClassChooserPanel = ClassChooserTools.buildPanel(this.attributeItemTypeHolder, this.classRepositoryHolder, ClassChooserTools.buildDeclarableReferenceFilter(), this.itemTypeLabel, this.getWorkbenchContextHolder());
        this.itemTypeClassChooserPanel.setVisible(false);
        arrayList.add(this.itemTypeClassChooserPanel);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(0, 5, 5, 5);
        this.add((Component)this.itemTypeClassChooserPanel, gridBagConstraints);
        new ComponentEnabler(this.buildAttributeTypeBooleanHolder(), arrayList);
        this.addHelpTopicId(this, this.helpTopicId());
    }

    private ValueModel buildAttributeTypeBooleanHolder() {
        return new TransformationPropertyValueModel(this.attributeTypeHolder){

            protected Object transform(Object object) {
                return object == null ? Boolean.FALSE : Boolean.TRUE;
            }
        };
    }

    private String helpTopicId() {
        return "descriptor.classInfo.attributes.general.typeInfo";
    }

    private JSpinner buildDimensionalitySpinner() {
        JSpinner jSpinner = new JSpinner(this.buildDimensionalitySpinnerModel());
        jSpinner.setPreferredSize(new Dimension(50, jSpinner.getPreferredSize().height));
        return jSpinner;
    }

    private SpinnerModel buildDimensionalitySpinnerModel() {
        return new NumberSpinnerModelAdapter(this.attributeTypeDimensionalityHolder, new Integer(0), null, new Integer(1), new Integer(0));
    }

    void updateAllTypeComponents() {
        this.updateValueTypeComponents();
        this.updateItemTypeComponents();
        this.updateKeyTypeComponents();
    }

    private void updateValueTypeComponents() {
        boolean bl = this.getAttribute() != null && this.getAttribute().canHaveValueType();
        this.valueTypeLabel.setVisible(bl);
        this.valueTypeClassChooserPanel.setVisible(bl);
    }

    private void updateItemTypeComponents() {
        MWClassAttribute mWClassAttribute = this.getAttribute();
        boolean bl = mWClassAttribute != null && mWClassAttribute.canHaveItemType();
        this.itemTypeLabel.setVisible(bl);
        this.itemTypeClassChooserPanel.setVisible(bl);
        if (mWClassAttribute != null && mWClassAttribute.canHaveMapKeyAndValueTypes()) {
            this.itemTypeLabel.setText(this.resourceRepository().getString("MAP_VALUE_TYPE_LABEL"));
            this.itemTypeLabel.setDisplayedMnemonic(this.resourceRepository().getMnemonic("MAP_VALUE_TYPE_LABEL"));
        } else {
            this.itemTypeLabel.setText(this.resourceRepository().getString("ELEMENT_TYPE_LABEL"));
            this.itemTypeLabel.setDisplayedMnemonic(this.resourceRepository().getMnemonic("ELEMENT_TYPE_LABEL"));
        }
    }

    private void updateKeyTypeComponents() {
        boolean bl = this.getAttribute() != null && this.getAttribute().canHaveKeyType();
        this.keyTypeLabel.setVisible(bl);
        this.keyTypeClassChooserPanel.setVisible(bl);
    }

    MWClassAttribute getAttribute() {
        return (MWClassAttribute)this.attributeHolder.getValue();
    }
}

