/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Modifier;
import java.util.Iterator;
import org.eclipse.persistence.tools.workbench.framework.action.FrameworkAction;
import org.eclipse.persistence.tools.workbench.framework.app.GroupContainerDescription;
import org.eclipse.persistence.tools.workbench.framework.app.MenuDescription;
import org.eclipse.persistence.tools.workbench.framework.app.MenuGroupDescription;
import org.eclipse.persistence.tools.workbench.framework.app.NavigatorSelectionModel;
import org.eclipse.persistence.tools.workbench.framework.app.ToolBarDescription;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWMappingDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClass;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClassAttribute;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWMethod;
import org.eclipse.persistence.tools.workbench.mappingsplugin.AutomapAction;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor.DescriptorNode;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor.DescriptorPackageNode;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor.MapInheritedAttributesToRootMinusOneAction;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor.MapInheritedAttributesToSelectedClassAction;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor.MapInheritedAttributesToSuperclassAction;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor.MappingDescriptorTabbedPropertiesPage;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor.RemoveInheritedAttributesAction;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor.UnmapAllDescriptorsInPackageAction;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor.UnmapDescriptorAction;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.mapping.MappingNode;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.CompositeCollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ItemPropertyListValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.ListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.SimpleCollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.SortedListValueModelAdapter;
import org.eclipse.persistence.tools.workbench.utility.Transformer;
import org.eclipse.persistence.tools.workbench.utility.events.CollectionChangeEvent;
import org.eclipse.persistence.tools.workbench.utility.events.CollectionChangeListener;
import org.eclipse.persistence.tools.workbench.utility.iterators.FilteringIterator;
import org.eclipse.persistence.tools.workbench.utility.iterators.TransformationIterator;
import org.eclipse.persistence.tools.workbench.utility.node.Node;

public abstract class MappingDescriptorNode
extends DescriptorNode {
    private ListValueModel childrenModel;
    private SimpleCollectionValueModel mappingNodesHolder;
    private SimpleCollectionValueModel unmappedMappingNodesHolder;
    private CollectionChangeListener mappingsListener;
    private CollectionChangeListener attributesListener;
    private PropertyChangeListener attributeModifierListener;
    private PropertyChangeListener unknownPrimaryKeyListener;

    protected MappingDescriptorNode(MWDescriptor mWDescriptor, DescriptorPackageNode descriptorPackageNode) {
        super(mWDescriptor, descriptorPackageNode);
    }

    protected void initialize() {
        super.initialize();
        this.mappingsListener = this.buildMappingsListener();
        this.attributesListener = this.buildAttributesListener();
        this.attributeModifierListener = this.buildAttributeModifierListener();
        this.unknownPrimaryKeyListener = this.buildUnknownPrimaryKeyListener();
        this.mappingNodesHolder = new SimpleCollectionValueModel();
        this.unmappedMappingNodesHolder = new SimpleCollectionValueModel();
        this.childrenModel = this.buildChildrenModel();
    }

    private CollectionChangeListener buildMappingsListener() {
        return new CollectionChangeListener(){

            public void itemsAdded(CollectionChangeEvent collectionChangeEvent) {
                MappingDescriptorNode.this.mappingsAdded(collectionChangeEvent);
            }

            public void itemsRemoved(CollectionChangeEvent collectionChangeEvent) {
                MappingDescriptorNode.this.mappingsRemoved(collectionChangeEvent);
            }

            public void collectionChanged(CollectionChangeEvent collectionChangeEvent) {
                MappingDescriptorNode.this.mappingsChanged(collectionChangeEvent);
            }

            public String toString() {
                return "mappings listener";
            }
        };
    }

    private CollectionChangeListener buildAttributesListener() {
        return new CollectionChangeListener(){

            public void itemsAdded(CollectionChangeEvent collectionChangeEvent) {
                MappingDescriptorNode.this.attributesAdded(collectionChangeEvent);
            }

            public void itemsRemoved(CollectionChangeEvent collectionChangeEvent) {
                MappingDescriptorNode.this.attributesRemoved(collectionChangeEvent);
            }

            public void collectionChanged(CollectionChangeEvent collectionChangeEvent) {
                throw new UnsupportedOperationException();
            }

            public String toString() {
                return "attributes listener";
            }
        };
    }

    private PropertyChangeListener buildAttributeModifierListener() {
        return new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                MappingDescriptorNode.this.attributeModifierChanged(propertyChangeEvent);
            }

            public String toString() {
                return "attribute modifier listener";
            }
        };
    }

    private PropertyChangeListener buildUnknownPrimaryKeyListener() {
        return new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                MappingDescriptorNode.this.unknownPrimaryKeyChanged(propertyChangeEvent);
            }

            public String toString() {
                return "unknown primary key listener";
            }
        };
    }

    protected ListValueModel buildChildrenModel() {
        return new SortedListValueModelAdapter(this.buildDisplayStringAdapter());
    }

    protected ListValueModel buildDisplayStringAdapter() {
        return new ItemPropertyListValueModelAdapter(this.buildUnsortedChildrenModel(), "displayString");
    }

    private CollectionValueModel buildUnsortedChildrenModel() {
        SimpleCollectionValueModel simpleCollectionValueModel = new SimpleCollectionValueModel();
        simpleCollectionValueModel.addItem(this.mappingNodesHolder);
        simpleCollectionValueModel.addItem(this.unmappedMappingNodesHolder);
        return new CompositeCollectionValueModel(simpleCollectionValueModel, Transformer.NULL_INSTANCE);
    }

    public MWMappingDescriptor getMappingDescriptor() {
        return (MWMappingDescriptor)this.getDescriptor();
    }

    private Iterator mappingNodes() {
        return (Iterator)this.mappingNodesHolder.getValue();
    }

    private MappingNode mappingNodeFor(MWMapping mWMapping) {
        Iterator iterator = this.mappingNodes();
        while (iterator.hasNext()) {
            MappingNode mappingNode = (MappingNode)iterator.next();
            if (mappingNode.getValue() != mWMapping) continue;
            return mappingNode;
        }
        return null;
    }

    private MappingNode mappingNodeFor(MWClassAttribute mWClassAttribute) {
        Iterator iterator = this.mappingNodes();
        while (iterator.hasNext()) {
            MappingNode mappingNode = (MappingNode)iterator.next();
            if (mappingNode.instanceVariable() != mWClassAttribute) continue;
            return mappingNode;
        }
        return null;
    }

    private Iterator unmappedMappingNodes() {
        return (Iterator)this.unmappedMappingNodesHolder.getValue();
    }

    private MappingNode unmappedMappingNodeFor(MWClassAttribute mWClassAttribute) {
        Iterator iterator = this.unmappedMappingNodes();
        while (iterator.hasNext()) {
            MappingNode mappingNode = (MappingNode)iterator.next();
            if (mappingNode.instanceVariable() != mWClassAttribute) continue;
            return mappingNode;
        }
        return null;
    }

    private Iterator unmappedAttributes(Iterator iterator) {
        return new FilteringIterator(iterator){

            protected boolean accept(Object object) {
                MWMappingDescriptor mWMappingDescriptor = MappingDescriptorNode.this.getMappingDescriptor();
                return mWMappingDescriptor.mappingForAttribute((MWClassAttribute)object) == null;
            }
        };
    }

    public abstract String mappingHelpTopicPrefix();

    void mappingsAdded(CollectionChangeEvent collectionChangeEvent) {
        this.removeUnmappedMappingNodesFor(this.attributes(collectionChangeEvent.items()));
        this.addMappingNodesFor(collectionChangeEvent.items());
    }

    private void removeUnmappedMappingNodesFor(Iterator iterator) {
        while (iterator.hasNext()) {
            this.removeUnmappedMappingNodeFor((MWClassAttribute)iterator.next());
        }
    }

    private void removeUnmappedMappingNodeFor(MWClassAttribute mWClassAttribute) {
        this.unmappedMappingNodesHolder.removeItem(this.unmappedMappingNodeFor(mWClassAttribute));
    }

    private void addMappingNodesFor(Iterator iterator) {
        while (iterator.hasNext()) {
            this.addMappingNodeFor((MWMapping)iterator.next());
        }
    }

    private void addMappingNodeFor(MWMapping mWMapping) {
        this.mappingNodesHolder.addItem(this.buildMappingNode(mWMapping));
    }

    void mappingsRemoved(CollectionChangeEvent collectionChangeEvent) {
        this.removeMappingNodesFor(collectionChangeEvent.items());
        Iterator iterator = this.attributes(collectionChangeEvent.items());
        while (iterator.hasNext()) {
            MWClassAttribute mWClassAttribute = (MWClassAttribute)iterator.next();
            String string = mWClassAttribute.getName();
            if (!this.type().containsCombinedAttributeNamed(string) && !this.getMappingDescriptor().containsInheritedAttributeNamed(string)) continue;
            this.addUnmappedMappingNodeFor(mWClassAttribute);
        }
    }

    private void removeMappingNodesFor(Iterator iterator) {
        while (iterator.hasNext()) {
            this.removeMappingNodeFor((MWMapping)iterator.next());
        }
    }

    private void removeMappingNodeFor(MWMapping mWMapping) {
        this.mappingNodesHolder.removeItem(this.mappingNodeFor(mWMapping));
    }

    private void addUnmappedMappingNodeFor(MWClassAttribute mWClassAttribute) {
        this.unmappedMappingNodesHolder.addItem(this.buildUnmappedMappingNode(mWClassAttribute));
    }

    private Iterator attributes(Iterator iterator) {
        return new TransformationIterator(iterator){

            protected Object transform(Object object) {
                return ((MWMapping)object).getInstanceVariable();
            }
        };
    }

    void mappingsChanged(CollectionChangeEvent collectionChangeEvent) {
        this.rebuildAllMappingNodes();
    }

    void attributesAdded(CollectionChangeEvent collectionChangeEvent) {
        this.engageAttributes(collectionChangeEvent.items());
        this.addUnmappedMappingNodesFor(collectionChangeEvent.items());
    }

    private void addUnmappedMappingNodesFor(Iterator iterator) {
        while (iterator.hasNext()) {
            this.addUnmappedMappingNodeFor((MWClassAttribute)iterator.next());
        }
    }

    void attributesRemoved(CollectionChangeEvent collectionChangeEvent) {
        this.removeUnmappedMappingNodesFor(collectionChangeEvent.items());
        this.disengageAttributes(collectionChangeEvent.items());
    }

    private void rebuildAllMappingNodes() {
        this.clearAllMappingNodes();
        this.addAllMappingNodes();
    }

    private void clearAllMappingNodes() {
        this.mappingNodesHolder.clear();
        this.unmappedMappingNodesHolder.clear();
    }

    private void addAllMappingNodes() {
        MWMappingDescriptor mWMappingDescriptor = this.getMappingDescriptor();
        MWClass mWClass = mWMappingDescriptor.getMWClass();
        this.addMappingNodesFor(mWMappingDescriptor.mappings());
        this.addUnmappedMappingNodesFor(this.unmappedAttributes(mWClass.attributes()));
        this.addUnmappedMappingNodesFor(this.unmappedAttributes(mWClass.ejb20Attributes()));
        this.addUnmappedMappingNodesFor(this.unmappedAttributes(mWMappingDescriptor.inheritedAttributes()));
    }

    void attributeModifierChanged(PropertyChangeEvent propertyChangeEvent) {
        MWClassAttribute mWClassAttribute = (MWClassAttribute)propertyChangeEvent.getSource();
        if (this.mappingNodeFor(mWClassAttribute) != null) {
            return;
        }
        int n = (Integer)propertyChangeEvent.getOldValue();
        int n2 = (Integer)propertyChangeEvent.getNewValue();
        this.checkModifier(mWClassAttribute, Modifier.isStatic(n), Modifier.isStatic(n2));
        this.checkModifier(mWClassAttribute, Modifier.isFinal(n), Modifier.isFinal(n2));
    }

    private void checkModifier(MWClassAttribute mWClassAttribute, boolean bl, boolean bl2) {
        if (bl) {
            if (!bl2 && this.unmappedMappingNodeFor(mWClassAttribute) == null) {
                this.addUnmappedMappingNodeFor(mWClassAttribute);
            }
        } else if (bl2) {
            this.removeUnmappedMappingNodeFor(mWClassAttribute);
        }
    }

    void unknownPrimaryKeyChanged(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getNewValue() == null) {
            this.removeUnmappedMappingNodeFor((MWClassAttribute)propertyChangeEvent.getOldValue());
        }
    }

    public void selectMethod(MWMethod mWMethod, WorkbenchContext workbenchContext) {
        ((MappingDescriptorTabbedPropertiesPage)workbenchContext.getPropertiesPage()).selectMethod(mWMethod);
    }

    public void selectMappingNodeFor(MWClassAttribute mWClassAttribute, NavigatorSelectionModel navigatorSelectionModel) {
        MWMapping mWMapping = this.getMappingDescriptor().mappingForAttribute(mWClassAttribute);
        this.selectMappingNodeFor(mWMapping, navigatorSelectionModel);
    }

    public void selectMappingNodeFor(MWMapping mWMapping, NavigatorSelectionModel navigatorSelectionModel) {
        this.selectDescendantNodeForValue((Node)mWMapping, navigatorSelectionModel);
    }

    protected abstract MappingNode buildMappingNode(MWMapping var1);

    protected abstract MappingNode buildUnmappedMappingNode(MWClassAttribute var1);

    public ListValueModel getChildrenModel() {
        return this.childrenModel;
    }

    protected void engageValue() {
        super.engageValue();
        MWMappingDescriptor mWMappingDescriptor = this.getMappingDescriptor();
        MWClass mWClass = mWMappingDescriptor.getMWClass();
        mWMappingDescriptor.addCollectionChangeListener("mappings", this.mappingsListener);
        mWMappingDescriptor.addCollectionChangeListener("inheritedAttributes", this.attributesListener);
        mWClass.addCollectionChangeListener("attributes", this.attributesListener);
        mWClass.addCollectionChangeListener("ejb20Attributes", this.attributesListener);
        mWClass.addPropertyChangeListener("unknownPKAttribute", this.unknownPrimaryKeyListener);
        this.engageAttributes(mWClass.combinedAttributes());
        this.engageAttributes(mWMappingDescriptor.inheritedAttributes());
        this.addAllMappingNodes();
    }

    protected void engageAttributes(Iterator iterator) {
        while (iterator.hasNext()) {
            this.engageAttribute((MWClassAttribute)iterator.next());
        }
    }

    protected void engageAttribute(MWClassAttribute mWClassAttribute) {
        mWClassAttribute.addPropertyChangeListener("modifierCode", this.attributeModifierListener);
    }

    protected void disengageValue() {
        MWMappingDescriptor mWMappingDescriptor = this.getMappingDescriptor();
        MWClass mWClass = mWMappingDescriptor.getMWClass();
        this.clearAllMappingNodes();
        this.disengageAttributes(mWMappingDescriptor.inheritedAttributes());
        this.disengageAttributes(mWClass.combinedAttributes());
        mWClass.removePropertyChangeListener("unknownPKAttribute", this.unknownPrimaryKeyListener);
        mWClass.removeCollectionChangeListener("ejb20Attributes", this.attributesListener);
        mWClass.removeCollectionChangeListener("attributes", this.attributesListener);
        mWMappingDescriptor.removeCollectionChangeListener("inheritedAttributes", this.attributesListener);
        mWMappingDescriptor.removeCollectionChangeListener("mappings", this.mappingsListener);
        super.disengageValue();
    }

    protected void disengageAttributes(Iterator iterator) {
        while (iterator.hasNext()) {
            this.disengageAttribute((MWClassAttribute)iterator.next());
        }
    }

    protected void disengageAttribute(MWClassAttribute mWClassAttribute) {
        mWClassAttribute.removePropertyChangeListener("modifierCode", this.attributeModifierListener);
    }

    protected boolean supportsAdvancedProperties() {
        return true;
    }

    public GroupContainerDescription buildToolBarDescription(WorkbenchContext workbenchContext) {
        return new ToolBarDescription();
    }

    protected MenuDescription buildMapInheritedAttributesMenuDescription(WorkbenchContext workbenchContext) {
        MenuDescription menuDescription = new MenuDescription(this.resourceRepository().getString("MAP_INHERITED_ATTRIBUTES_MENU_ITEM"), this.resourceRepository().getString("MAP_INHERITED_ATTRIBUTES_MENU_ITEM"), this.resourceRepository().getMnemonic("MAP_INHERITED_ATTRIBUTES_MENU_ITEM"), EMPTY_ICON);
        MenuGroupDescription menuGroupDescription = new MenuGroupDescription();
        menuGroupDescription.add(this.getMapInheritedAttributesToSuperClassAction(workbenchContext));
        menuGroupDescription.add(this.getMapInheritedAttributesToRootMinusOneAction(workbenchContext));
        menuGroupDescription.add(this.getMapInheritedAttributesToSelectedClassAction(workbenchContext));
        menuDescription.add(menuGroupDescription);
        MenuGroupDescription menuGroupDescription2 = new MenuGroupDescription();
        menuGroupDescription2.add(this.getRemoveInheritedAttributesAction(workbenchContext));
        menuDescription.add(menuGroupDescription2);
        return menuDescription;
    }

    protected MenuDescription buildUnmapMenuDescription(WorkbenchContext workbenchContext) {
        MenuDescription menuDescription = new MenuDescription(this.resourceRepository().getString("UNMAP_MENU"), this.resourceRepository().getString("UNMAP_MENU"), this.resourceRepository().getMnemonic("UNMAP_MENU"), EMPTY_ICON);
        MenuGroupDescription menuGroupDescription = new MenuGroupDescription();
        menuGroupDescription.add(this.getUnmapDescriptorAction(workbenchContext));
        menuGroupDescription.add(this.getUnmapAllDescriptorsInPackageAction(workbenchContext));
        menuDescription.add(menuGroupDescription);
        return menuDescription;
    }

    protected AutomapAction getAutomapAction(WorkbenchContext workbenchContext) {
        return this.getMappingsPlugin().getAutomapAction(workbenchContext);
    }

    private FrameworkAction getMapInheritedAttributesToSuperClassAction(WorkbenchContext workbenchContext) {
        return new MapInheritedAttributesToSuperclassAction(workbenchContext);
    }

    private FrameworkAction getMapInheritedAttributesToRootMinusOneAction(WorkbenchContext workbenchContext) {
        return new MapInheritedAttributesToRootMinusOneAction(workbenchContext);
    }

    private FrameworkAction getMapInheritedAttributesToSelectedClassAction(WorkbenchContext workbenchContext) {
        return new MapInheritedAttributesToSelectedClassAction(workbenchContext);
    }

    protected FrameworkAction getRemoveInheritedAttributesAction(WorkbenchContext workbenchContext) {
        return new RemoveInheritedAttributesAction(workbenchContext);
    }

    private FrameworkAction getUnmapAllDescriptorsInPackageAction(WorkbenchContext workbenchContext) {
        return new UnmapAllDescriptorsInPackageAction(workbenchContext);
    }

    private FrameworkAction getUnmapDescriptorAction(WorkbenchContext workbenchContext) {
        return new UnmapDescriptorAction(workbenchContext);
    }
}

